/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dom.attrs;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.base.CommentTrackingXmlPullParser;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.StyleableDefinition;
import com.android.tools.dom.attrs.StyleableDefinitionImpl;
import com.android.tools.environment.Logger;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AttributeDefinitionsImpl
implements AttributeDefinitions {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl");
    private static final Splitter PIPE_SPLITTER = Splitter.on('|').trimResults();
    private final Map<ResourceReference, AttributeDefinition> myAttrs = new HashMap<ResourceReference, AttributeDefinition>();
    private final Map<ResourceReference, StyleableDefinitionImpl> myStyleables = new HashMap<ResourceReference, StyleableDefinitionImpl>();
    private final AttributeDefinitions myFrameworkAttributeDefinitions;

    private AttributeDefinitionsImpl(AttributeDefinitions frameworkAttributeDefinitions) {
        this.myFrameworkAttributeDefinitions = frameworkAttributeDefinitions;
    }

    public static AttributeDefinitions parseFrameworkFiles(File ... files2) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(null);
        for (File file2 : files2) {
            attributeDefinitions.addAttrsFromFile(file2);
        }
        return attributeDefinitions;
    }

    public static AttributeDefinitions create(AttributeDefinitions frameworkAttributeDefinitions, ResourceRepository resources) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(frameworkAttributeDefinitions);
        attributeDefinitions.initializeFromResourceRepository(resources);
        return attributeDefinitions;
    }

    private void initializeFromResourceRepository(ResourceRepository resources) {
        ResourceValue resourceValue;
        Collection items;
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items = resources.getResources(namespace, ResourceType.ATTR).values();
            for (ResourceItem item : items) {
                resourceValue = item.getResourceValue();
                if (!(resourceValue instanceof AttrResourceValue)) continue;
                this.createOrUpdateAttributeDefinition((AttrResourceValue)resourceValue, null);
            }
        }
        for (ResourceNamespace namespace : resources.getNamespaces()) {
            items = resources.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item : items) {
                resourceValue = item.getResourceValue();
                if (!(resourceValue instanceof StyleableResourceValue)) continue;
                StyleableResourceValue styleableValue = (StyleableResourceValue)resourceValue;
                ResourceReference reference = styleableValue.asReference();
                StyleableDefinitionImpl styleable = this.myStyleables.computeIfAbsent(reference, ref -> new StyleableDefinitionImpl(namespace, styleableValue.getName()));
                for (AttrResourceValue attrValue : styleableValue.getAllAttributes()) {
                    this.createOrUpdateAttributeDefinition(attrValue, styleable);
                }
            }
        }
    }

    private void createOrUpdateAttributeDefinition(AttrResourceValue attrValue, StyleableDefinitionImpl parentStyleable) {
        String groupName;
        String description;
        ResourceReference attrRef = attrValue.asReference();
        AttributeDefinition attr = this.myAttrs.get(attrRef);
        if (attr == null) {
            if (this.myFrameworkAttributeDefinitions != null && attrValue.getNamespace().equals(ResourceNamespace.ANDROID) && (attr = this.myFrameworkAttributeDefinitions.getAttrDefinition(attrRef)) != null) {
                attr = new AttributeDefinition(attr);
            }
            if (attr == null) {
                attr = new AttributeDefinition(attrValue.getNamespace(), attrValue.getName(), attrValue.getLibraryName(), null);
            }
            this.myAttrs.put(attrRef, attr);
        }
        attr.addFormats(attrValue.getFormats());
        Map<String, Integer> valueMappings = attrValue.getAttributeValues();
        if (!valueMappings.isEmpty()) {
            attr.setValueMappings(valueMappings);
            HashMap<String, String> valueDescriptions = Maps.newHashMapWithExpectedSize(valueMappings.size());
            for (String value : valueMappings.keySet()) {
                String description2 = attrValue.getValueDescription(value);
                if (description2 == null) continue;
                valueDescriptions.put(value, description2);
            }
            if (!valueDescriptions.isEmpty()) {
                attr.setValueDescriptions(valueDescriptions);
            }
        }
        if ((description = attrValue.getDescription()) != null) {
            attr.setDescription(description, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if ((groupName = attrValue.getGroupName()) != null) {
            attr.setGroupName(groupName);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attr);
        }
    }

    private void addAttrsFromFile(File file2) {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file2));){
            int event;
            CommentTrackingXmlPullParser parser = new CommentTrackingXmlPullParser();
            parser.setInput(stream, null);
            StyleableDefinitionImpl styleable = null;
            do {
                event = parser.nextToken();
                int depth = parser.getDepth();
                block4 : switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if (depth == 1) {
                            if (tagName.equals("resources")) break;
                            return;
                        }
                        if (depth <= 1) break;
                        switch (tagName) {
                            case "attr": {
                                this.processAttrTag(parser, file2, parser.getLastComment(), parser.getAttrGroupComment(), styleable);
                                break block4;
                            }
                            case "declare-styleable": {
                                if (styleable != null) {
                                    LOG.info("Found nested declare-styleable tag at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
                                    break block4;
                                }
                                String styleableName = parser.getAttributeValue(null, "name");
                                if (styleableName == null) {
                                    LOG.info("Found declare-styleable tag with no name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
                                    break block4;
                                }
                                styleable = new StyleableDefinitionImpl(ResourceNamespace.ANDROID, styleableName);
                                this.myStyleables.put(styleable.getResourceReference(), styleable);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("declare-styleable")) break;
                        styleable = null;
                    }
                }
            } while (event != 1);
        }
        catch (IOException | XmlPullParserException e2) {
            LOG.warn("Failed to parse " + file2.getAbsolutePath(), e2);
        }
    }

    private void processAttrTag(XmlPullParser parser, File file2, String precedingComment, String attrGroup, StyleableDefinitionImpl parentStyleable) throws IOException, XmlPullParserException {
        int event;
        String attrName = parser.getAttributeValue(null, "name");
        if (attrName == null) {
            LOG.info("Found attr tag with no name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        if (attrName.startsWith("android:")) {
            attrName = attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
        }
        if (attrName.indexOf(58) >= 0) {
            LOG.info("Found attr tag with an invalid name at " + file2.getAbsolutePath() + " line " + parser.getLineNumber());
            return;
        }
        AttributeDefinition attrDef = this.myAttrs.get(ResourceReference.attr(ResourceNamespace.ANDROID, attrName));
        if (attrDef == null) {
            attrDef = new AttributeDefinition(ResourceNamespace.ANDROID, attrName, null, null);
            attrDef.setGroupName(attrGroup);
            this.myAttrs.put(attrDef.getResourceReference(), attrDef);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attrDef);
        }
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String format = parser.getAttributeValue(null, "format");
        if (format != null) {
            formats.addAll(AttributeDefinitionsImpl.parseAttrFormat(format));
        }
        HashMap<String, Integer> valueMappings = null;
        HashMap<String, String> valueDescriptions = null;
        String lastComment = null;
        int attrTagDepth = parser.getDepth();
        do {
            event = parser.nextToken();
            switch (event) {
                case 2: {
                    Integer intValue;
                    String tagName = parser.getName();
                    if (tagName.equals("enum") && !formats.contains((Object)AttributeFormat.FLAGS)) {
                        formats.add(AttributeFormat.ENUM);
                    } else if (tagName.equals("flag") && !formats.contains((Object)AttributeFormat.ENUM)) {
                        formats.add(AttributeFormat.FLAGS);
                    }
                    String valueName = parser.getAttributeValue(null, "name");
                    if (valueName == null) {
                        LOG.info("Unknown value for tag: " + tagName);
                        break;
                    }
                    String strIntValue = parser.getAttributeValue(null, "value");
                    Integer n2 = intValue = strIntValue == null ? null : AttributeDefinitionsImpl.decodeIntegerValue(strIntValue);
                    if (valueMappings == null) {
                        valueMappings = new HashMap<String, Integer>();
                    }
                    valueMappings.putIfAbsent(valueName, intValue);
                    if (lastComment != null) {
                        if (valueDescriptions == null) {
                            valueDescriptions = new HashMap<String, String>();
                        }
                        valueDescriptions.putIfAbsent(valueName, lastComment);
                    }
                    lastComment = null;
                    break;
                }
                case 9: {
                    String commentText = parser.getText().trim();
                    if (AttributeDefinitionsImpl.isEmptyOrAsciiArt(commentText)) break;
                    lastComment = commentText;
                    break;
                }
            }
        } while (event != 3 || parser.getDepth() > attrTagDepth);
        attrDef.addFormats(formats);
        if (precedingComment != null) {
            attrDef.setDescription(precedingComment, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if (valueMappings != null) {
            attrDef.setValueMappings(valueMappings);
        }
        if (valueDescriptions != null) {
            attrDef.setValueDescriptions(valueDescriptions);
        }
    }

    private static Integer decodeIntegerValue(String value) {
        try {
            return Long.decode(value).intValue();
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    private static boolean isEmptyOrAsciiArt(String commentText) {
        return commentText.isEmpty() || commentText.charAt(0) == '*' || commentText.charAt(0) == '=';
    }

    private static Set<AttributeFormat> parseAttrFormat(String formatString) {
        List<String> formats = PIPE_SPLITTER.splitToList(formatString);
        EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
        for (String format : formats) {
            AttributeFormat attributeFormat = AttributeFormat.fromXmlName(format);
            if (attributeFormat == null) continue;
            result2.add(attributeFormat);
        }
        return result2;
    }

    @Override
    public StyleableDefinition getStyleableDefinition(ResourceReference styleable) {
        if (this.myFrameworkAttributeDefinitions != null && styleable.getNamespace().equals(ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getStyleableDefinition(styleable);
        }
        return this.myStyleables.get(styleable);
    }

    @Override
    @Deprecated
    public StyleableDefinition getStyleableByName(String name2) {
        StyleableDefinition styleable = this.getStyleableDefinition(ResourceReference.styleable(ResourceNamespace.TODO(), name2));
        if (styleable == null) {
            styleable = this.getStyleableDefinition(ResourceReference.styleable(ResourceNamespace.ANDROID, name2));
        }
        return styleable;
    }

    @Override
    public Set<ResourceReference> getAttrs() {
        return this.myAttrs.keySet();
    }

    @Override
    public AttributeDefinition getAttrDefinition(ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.myAttrs.get(attr);
        if (attributeDefinition == null && this.myFrameworkAttributeDefinitions != null && attr.getNamespace().equals(ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getAttrDefinition(attr);
        }
        return attributeDefinition;
    }

    @Override
    @Deprecated
    public AttributeDefinition getAttrDefByName(String name2) {
        ResourceReference attr = name2.startsWith("android:") ? ResourceReference.attr(ResourceNamespace.ANDROID, name2.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN)) : (this.myFrameworkAttributeDefinitions == null ? ResourceReference.attr(ResourceNamespace.ANDROID, name2) : ResourceReference.attr(ResourceNamespace.TODO(), name2));
        return this.getAttrDefinition(attr);
    }

    @Override
    public String getAttrGroup(ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.getAttrDefinition(attr);
        return attributeDefinition == null ? null : attributeDefinition.getGroupName();
    }
}

