/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fonts;

import com.android.annotations.TestOnly;
import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontsFolderProvider;
import com.android.ide.common.fonts.SdkFontsFolderProvider;
import com.android.tools.environment.Logger;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.FontDirectoryDownloader;
import com.android.tools.fonts.FontDownloader;
import com.android.tools.fonts.Fonts;
import com.android.tools.fonts.SystemFonts;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;

public class DownloadableFontCacheServiceImpl
extends FontLoader
implements DownloadableFontCacheService {
    private static final String FONTS = "fonts";
    private static final String FONT = "font";
    private static final String V1 = "v1";
    private final SystemFonts mySystemFonts;
    private final Map<String, FontDirectoryDownloader> myDownloadServiceMap = new HashMap<String, FontDirectoryDownloader>();
    private final FontDownloader myFontDownloader;
    private final FontsFolderProvider myFontsFolderProvider;

    @Override
    public List<FontFamily> getSystemFontFamilies() {
        return new ArrayList<FontFamily>(this.mySystemFonts.getFontFamilies());
    }

    @Override
    public FontFamily getSystemFont(String name2) {
        return this.mySystemFonts.getFont(name2);
    }

    @Override
    public FontFamily getDefaultSystemFont() {
        return this.mySystemFonts.getFontFamilies().iterator().next();
    }

    @Override
    public File getCachedMenuFile(FontFamily family) {
        String menu = family.getMenu();
        if (menu.isEmpty()) {
            return null;
        }
        if (menu.startsWith("file://")) {
            return new File(menu.substring("file://".length()));
        }
        return this.getCachedFont(family.getProvider().getAuthority(), menu);
    }

    public File getRelativeCachedMenuFile(FontFamily family) {
        String menu = family.getMenu();
        if (!menu.startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(family.getProvider().getAuthority(), menu);
    }

    @Override
    public File getCachedFontFile(FontDetail font) {
        String fontUrl = font.getFontUrl();
        if (fontUrl.isEmpty()) {
            return null;
        }
        if (fontUrl.startsWith("file://")) {
            return new File(fontUrl.substring("file://".length()));
        }
        return this.getCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    public File getRelativeFontFile(FontDetail font) {
        String fontUrl = font.getFontUrl();
        if (!fontUrl.startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    @Override
    @Language(value="XML")
    public String toXml(FontFamily family) {
        StringBuilder output = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\">");
        boolean hasAnyDownloadedFonts = false;
        for (FontDetail detail : family.getFonts()) {
            int weight;
            File cachedFile = this.getCachedFontFile(detail);
            if (cachedFile == null || !cachedFile.exists()) continue;
            hasAnyDownloadedFonts = true;
            output.append(String.format("<font android:font=\"%s\"", cachedFile.getAbsolutePath()));
            if (detail.getHasExplicitStyle()) {
                output.append(String.format(" android:fontStyle=\"%s\"", detail.getFontStyle()));
            }
            if ((weight = detail.getWeight()) != -1) {
                output.append(String.format(Locale.US, " android:fontWeight=\"%d\"", weight));
            }
            output.append(" />");
        }
        if (!hasAnyDownloadedFonts) {
            return null;
        }
        output.append("</font-family>");
        return output.toString();
    }

    @Override
    public CompletableFuture<Boolean> download(FontFamily family) {
        CompletableFuture<Boolean> success = new CompletableFuture<Boolean>();
        this.myFontDownloader.download(Collections.singletonList(family), false, () -> success.complete(true), () -> success.complete(false));
        return success;
    }

    @Override
    public Font loadMenuFont(FontFamily fontFamily) {
        File file2 = this.getCachedMenuFile(fontFamily);
        if (file2 != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontFamily.getName(), ex);
            }
        }
        return null;
    }

    @Override
    public Font loadDetailFont(FontDetail fontDetail) {
        File file2 = this.getCachedFontFile(fontDetail);
        if (file2 != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontDetail.getFamily().getName(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Runnable success, Runnable failure) {
        Collection<FontDirectoryDownloader> services;
        Iterator<FontDirectoryDownloader> iterator2 = this.getLock();
        synchronized (iterator2) {
            if (this.updateFontsFolder()) {
                this.updateDownloadServices();
            }
            services = this.myDownloadServiceMap.values();
        }
        for (FontDirectoryDownloader service : services) {
            service.refreshFonts(success, failure);
        }
    }

    @Override
    public File getFontCachePath() {
        return super.getFontPath();
    }

    protected DownloadableFontCacheServiceImpl(FontDownloader fontDownloader, FontsFolderProvider fontsFolderProvider) {
        this.myFontDownloader = fontDownloader;
        this.myFontsFolderProvider = fontsFolderProvider;
        this.init();
        this.mySystemFonts = new SystemFonts(this);
        instance = this;
    }

    protected DownloadableFontCacheServiceImpl(FontDownloader fontDownloader, Supplier<File> sdkHomeProvider) {
        this(fontDownloader, new SdkFontsFolderProvider(sdkHomeProvider));
    }

    @TestOnly
    public SystemFonts getSystemFonts() {
        return this.mySystemFonts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File fontFolder = this.myFontsFolderProvider.getFontsFolder();
        Object object = this.getLock();
        synchronized (object) {
            this.setFontPath(fontFolder);
            this.fontsLoaded();
            this.updateDownloadServices();
        }
    }

    @Override
    protected void loadFonts() {
        super.loadFonts();
        if (this.getFontFamilies().isEmpty()) {
            this.loadDirectory(FontProvider.GOOGLE_PROVIDER, Fonts.getFallbackResourceUrl(FontProvider.GOOGLE_PROVIDER));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFontsFolder() {
        Object object = this.getLock();
        synchronized (object) {
            File newFontsFolder = this.myFontsFolderProvider.getFontsFolder();
            File oldFontsFolder = this.getFontPath();
            if (Objects.equals(newFontsFolder, oldFontsFolder)) {
                return false;
            }
            this.setFontPath(newFontsFolder);
            return true;
        }
    }

    private File getCachedFont(String authority, String url) {
        File cachePath = this.getFontPath();
        if (cachePath == null) {
            return null;
        }
        return new File(cachePath, DownloadableFontCacheServiceImpl.getRelativeCachedFont(authority, url).getPath());
    }

    private static File getRelativeCachedFont(String authority, String menu) {
        File providerPath = new File(authority);
        File fontsPath = new File(providerPath, FONTS);
        File fontPath = new File(fontsPath, DownloadableFontCacheServiceImpl.getChildName(menu, 2, FONT));
        File versionPath = new File(fontPath, DownloadableFontCacheServiceImpl.getChildName(menu, 1, V1));
        return new File(versionPath, DownloadableFontCacheServiceImpl.getChildName(menu, 0, menu));
    }

    private static String getChildName(String menu, int fromLast, String defaultName) {
        int lastIndex = menu.length();
        int prevIndex = menu.lastIndexOf(47, lastIndex - 1);
        while (fromLast > 0) {
            lastIndex = prevIndex;
            prevIndex = menu.lastIndexOf(47, lastIndex - 1);
            --fromLast;
        }
        if (prevIndex < 0) {
            return defaultName;
        }
        return menu.substring(prevIndex + 1, lastIndex);
    }

    public static String convertNameToFilename(String name2) {
        StringBuilder builder = new StringBuilder();
        boolean previousUnderscore = true;
        for (char character : name2.toCharArray()) {
            if (Character.isUpperCase(character)) {
                builder.append(Character.toLowerCase(character));
                previousUnderscore = false;
                continue;
            }
            if (Character.isLowerCase(character) || Character.isDigit(character)) {
                builder.append(character);
                previousUnderscore = false;
                continue;
            }
            if (previousUnderscore) continue;
            builder.append('_');
            previousUnderscore = true;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDownloadServices() {
        Object object = this.getLock();
        synchronized (object) {
            this.myDownloadServiceMap.clear();
            File fontPath = this.getFontPath();
            if (fontPath != null) {
                for (FontProvider provider : this.getProviders().values()) {
                    this.myDownloadServiceMap.put(provider.getAuthority(), this.myFontDownloader.createFontDirectoryDownloader(this, provider, fontPath));
                }
            }
        }
    }
}

