/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.Bridge;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.environment.Logger;
import com.android.tools.idea.layoutlib.BufferingFileWrapper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.LogWrapper;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.utils.ComputerArchUtilsKt;
import com.android.utils.CpuArchitecture;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class LayoutLibraryLoader {
    protected static final Logger LOG = Logger.getInstance("#org.jetbrains.android.uipreview.LayoutLibraryLoader");
    private static final Map<IAndroidTarget, SoftReference<LayoutLibrary>> ourLibraryCache = new WeakHashMap<IAndroidTarget, SoftReference<LayoutLibrary>>();

    private LayoutLibraryLoader() {
    }

    private static LayoutLibrary loadImpl(IAndroidTarget target, Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        Path fontFolderPath = target.getPath(12);
        if (!Files.exists(fontFolderPath, new LinkOption[0]) || !Files.isDirectory(fontFolderPath, new LinkOption[0])) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", fontFolderPath), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", platformFolderPath), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", buildProp.getPath()), new Throwable[0]);
        }
        LogWrapper logger = new LogWrapper(LOG);
        Map<String, String> buildPropMap = ProjectProperties.parsePropertyFile(new BufferingFileWrapper(buildProp), logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        String dataPath = target.getPath(7).toString().replace('\\', '/');
        String[] keyboardPaths = new String[]{dataPath + "/keyboards/Generic.kcm"};
        LayoutLibrary library = LayoutLibraryLoader.getLayoutLibraryProvider().map(LayoutLibraryProvider::getLibrary).orElse(null);
        if (library == null || !library.init(buildPropMap != null ? buildPropMap : Collections.emptyMap(), fontFolderPath.toFile(), LayoutLibraryLoader.getNativeLibraryPath(dataPath), dataPath + "/icu/icudt72l.dat", keyboardPaths, enumMap, layoutLog)) {
            throw new RenderingException(LayoutlibBundle.message("layoutlib.init.failed", new Object[0]), new Throwable[0]);
        }
        return library;
    }

    private static String getNativeLibraryPath(String dataPath) {
        return dataPath + "/" + LayoutLibraryLoader.getPlatformName() + "/lib64/";
    }

    private static String getPlatformName() {
        return switch (SdkConstants.currentPlatform()) {
            case 2 -> "win";
            case 3 -> {
                if (ComputerArchUtilsKt.getJvmArchitecture() == CpuArchitecture.ARM) {
                    yield "mac-arm";
                }
                yield "mac";
            }
            case 1 -> "linux";
            default -> "";
        };
    }

    public static synchronized LayoutLibrary load(IAndroidTarget target, Map<String, Map<String, Integer>> enumMap, Supplier<Boolean> hasExternalCrash) throws RenderingException {
        LayoutLibrary library;
        if (Bridge.hasNativeCrash()) {
            throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
        }
        SoftReference<LayoutLibrary> libraryRef = ourLibraryCache.get(target);
        LayoutLibrary layoutLibrary = library = libraryRef != null ? libraryRef.get() : null;
        if (library == null || library.isDisposed()) {
            if (hasExternalCrash.get().booleanValue()) {
                Bridge.setNativeCrash(true);
                throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
            }
            library = LayoutLibraryLoader.loadImpl(target, enumMap);
            ourLibraryCache.put(target, new SoftReference<LayoutLibrary>(library));
        }
        return library;
    }

    public static Optional<LayoutLibraryProvider> getLayoutLibraryProvider() {
        return ServiceLoader.load(LayoutLibraryProvider.class, LayoutLibraryProvider.class.getClassLoader()).findFirst();
    }

    public static interface LayoutLibraryProvider {
        public LayoutLibrary getLibrary();

        public Class<?> getFrameworkRClass();
    }
}

