/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.sdklib.devices.Device;
import com.android.tools.preview.config.AndroidDimension;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.DeviceSpecDimensionUtilKt;
import com.android.tools.preview.config.DeviceUtilsKt;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.MutableDeviceConfig;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.Preview;
import com.android.tools.preview.config.Shape;
import com.android.utils.HashCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 22\u00020\u0001:\u00012Bc\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010*\u001a\u00020\u0003J\u0013\u0010+\u001a\u00020 2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020/*\u000600j\u0002`1H\u0002R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013R\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016\u00a8\u00063"}, d2={"Lcom/android/tools/preview/config/DeviceConfig;", "", "deviceId", "", "width", "", "height", "dimUnit", "Lcom/android/tools/preview/config/DimUnit;", "dpi", "", "shape", "Lcom/android/tools/preview/config/Shape;", "chinSize", "orientation", "Lcom/android/tools/preview/config/Orientation;", "parentDeviceId", "(Ljava/lang/String;FFLcom/android/tools/preview/config/DimUnit;ILcom/android/tools/preview/config/Shape;FLcom/android/tools/preview/config/Orientation;Ljava/lang/String;)V", "getChinSize", "()F", "chinSizeString", "getChinSizeString", "()Ljava/lang/String;", "getDeviceId", "getDimUnit", "()Lcom/android/tools/preview/config/DimUnit;", "getDpi", "()I", "getHeight", "heightString", "getHeightString", "isRound", "", "()Z", "getOrientation", "()Lcom/android/tools/preview/config/Orientation;", "getParentDeviceId", "getShape", "()Lcom/android/tools/preview/config/Shape;", "getWidth", "widthString", "getWidthString", "deviceSpec", "equals", "other", "hashCode", "addOrientationIfNeeded", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "unnamed"})
@SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,532:1\n288#2,2:533\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig\n*L\n134#1:533,2\n*E\n"})
public class DeviceConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String deviceId;
    private final float width;
    private final float height;
    @NotNull
    private final DimUnit dimUnit;
    private final int dpi;
    @NotNull
    private final Shape shape;
    private final float chinSize;
    @NotNull
    private final Orientation orientation;
    @Nullable
    private final String parentDeviceId;

    public DeviceConfig(@Nullable String deviceId, float width, float height, @NotNull DimUnit dimUnit, int dpi, @NotNull Shape shape, float chinSize, @NotNull Orientation orientation, @Nullable String parentDeviceId) {
        Intrinsics.checkNotNullParameter((Object)dimUnit, "dimUnit");
        Intrinsics.checkNotNullParameter((Object)shape, "shape");
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        this.deviceId = deviceId;
        this.width = width;
        this.height = height;
        this.dimUnit = dimUnit;
        this.dpi = dpi;
        this.shape = shape;
        this.chinSize = chinSize;
        this.orientation = orientation;
        this.parentDeviceId = parentDeviceId;
    }

    public /* synthetic */ DeviceConfig(String string2, float f2, float f3, DimUnit dimUnit, int n2, Shape shape, float f4, Orientation orientation, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string2 = null;
        }
        if ((n3 & 2) != 0) {
            f2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_WIDTH_DP();
        }
        if ((n3 & 4) != 0) {
            f3 = Preview.DeviceSpec.INSTANCE.getDEFAULT_HEIGHT_DP();
        }
        if ((n3 & 8) != 0) {
            dimUnit = Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT();
        }
        if ((n3 & 0x10) != 0) {
            n2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI();
        }
        if ((n3 & 0x20) != 0) {
            shape = Preview.DeviceSpec.INSTANCE.getDEFAULT_SHAPE();
        }
        if ((n3 & 0x40) != 0) {
            f4 = 0.0f;
        }
        if ((n3 & 0x80) != 0) {
            orientation = Preview.DeviceSpec.INSTANCE.getDEFAULT_ORIENTATION();
        }
        if ((n3 & 0x100) != 0) {
            string3 = null;
        }
        this(string2, f2, f3, dimUnit, n2, shape, f4, orientation, string3);
    }

    @Nullable
    public final String getDeviceId() {
        return this.deviceId;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @NotNull
    public DimUnit getDimUnit() {
        return this.dimUnit;
    }

    public int getDpi() {
        return this.dpi;
    }

    @NotNull
    public Shape getShape() {
        return this.shape;
    }

    public float getChinSize() {
        return this.chinSize;
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Nullable
    public String getParentDeviceId() {
        return this.parentDeviceId;
    }

    @NotNull
    public final String getWidthString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getWidth()).toString();
    }

    @NotNull
    public final String getHeightString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getHeight()).toString();
    }

    @NotNull
    public final String getChinSizeString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getChinSize()).toString();
    }

    public boolean isRound() {
        return this.getShape() == Shape.Round || this.getShape() == Shape.Chin;
    }

    @NotNull
    public final String deviceSpec() {
        if (this.deviceId != null) {
            String string2;
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = DeviceConfigKt.getReferenceDeviceIds().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    String deviceClassId = (String)entry.getValue();
                    if (!Intrinsics.areEqual(deviceClassId, this.deviceId)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null && (string2 = (String)entry.getKey()) != null) {
                String referenceString = string2;
                boolean bl3 = false;
                return referenceString;
            }
        }
        StringBuilder builder = new StringBuilder("spec:");
        if (this.getParentDeviceId() != null) {
            DeviceConfigKt.access$appendParamValue(builder, "parent", String.valueOf(this.getParentDeviceId()));
            this.addOrientationIfNeeded(builder);
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "builder.toString()");
            return string3;
        }
        DeviceConfigKt.access$appendParamValue(builder, "width", this.getWidthString() + this.getDimUnit().name());
        DeviceConfigKt.access$appendSeparator(builder);
        DeviceConfigKt.access$appendParamValue(builder, "height", this.getHeightString() + this.getDimUnit().name());
        if (this.getDpi() != Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI()) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "dpi", String.valueOf(this.getDpi()));
        }
        if (this.isRound()) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "isRound", String.valueOf(this.isRound()));
            if (MathKt.roundToInt(this.getChinSize()) != 0) {
                DeviceConfigKt.access$appendSeparator(builder);
                DeviceConfigKt.access$appendParamValue(builder, "chinSize", this.getChinSizeString() + this.getDimUnit().name());
            }
        }
        this.addOrientationIfNeeded(builder);
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "builder.toString()");
        return string4;
    }

    private final void addOrientationIfNeeded(StringBuilder $this$addOrientationIfNeeded) {
        if (this.getHeight() > this.getWidth() && this.getOrientation() == Orientation.landscape || this.getWidth() > this.getHeight() && this.getOrientation() == Orientation.portrait) {
            DeviceConfigKt.access$appendSeparator($this$addOrientationIfNeeded);
            DeviceConfigKt.access$appendParamValue($this$addOrientationIfNeeded, "orientation", this.getOrientation().name());
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DeviceConfig)) {
            return false;
        }
        return Intrinsics.areEqual(this.deviceSpec(), ((DeviceConfig)other).deviceSpec());
    }

    public int hashCode() {
        String string2 = this.getParentDeviceId();
        return HashCodes.mix(Float.hashCode(this.getWidth()), Float.hashCode(this.getHeight()), this.getDpi(), this.getShape().hashCode(), this.getDimUnit().hashCode(), Float.hashCode(this.getChinSize()), Boolean.hashCode(this.isRound()), this.getOrientation().hashCode(), string2 != null ? string2.hashCode() : 0);
    }

    public DeviceConfig() {
        this(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, 511, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J&\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J \u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/preview/config/DeviceConfig$Companion;", "", "()V", "parseDeviceSpecLanguage", "Lcom/android/tools/preview/config/DeviceConfig;", "params", "", "", "availableDevices", "", "Lcom/android/sdklib/devices/Device;", "parseFromCustomDeviceSpecLanguage", "parseFromExistingDeviceWithDeviceSpecLanguage", "device", "toDeviceConfigOrNull", "serialized", "toMutableDeviceConfigOrNull", "Lcom/android/tools/preview/config/MutableDeviceConfig;", "unnamed"})
    @SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EnumUtils.kt\ncom/android/ide/common/util/EnumUtilsKt\n*L\n1#1,532:1\n1#2:533\n766#3:534\n857#3,2:535\n1179#3,2:537\n1253#3,4:539\n288#3,2:553\n27#4,5:543\n27#4,5:548\n27#4,5:555\n27#4,5:560\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig$Companion\n*L\n239#1:534\n239#1:535,2\n240#1:537,2\n240#1:539,4\n301#1:553,2\n256#1:543,5\n260#1:548,5\n316#1:555,5\n372#1:560,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MutableDeviceConfig toMutableDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            Intrinsics.checkNotNullParameter(availableDevices, "availableDevices");
            DeviceConfig deviceConfig = this.toDeviceConfigOrNull(serialized, availableDevices);
            return deviceConfig != null ? DeviceConfigKt.toMutableConfig(deviceConfig) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DeviceConfig toDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            int n2;
            Enum enum_;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object;
            String referenceDeviceId;
            String configString;
            block20: {
                block19: {
                    Intrinsics.checkNotNullParameter(availableDevices, "availableDevices");
                    if (serialized == null || !StringsKt.startsWith$default(serialized, "spec:", false, 2, null)) {
                        return null;
                    }
                    configString = StringsKt.substringAfter$default(serialized, "spec:", null, 2, null);
                    referenceDeviceId = DeviceConfigKt.getReferenceDeviceIds().get(serialized);
                    object = referenceDeviceId;
                    if (object == null) break block19;
                    String it = object;
                    boolean bl2 = false;
                    Map<String, String> map2 = MapsKt.mapOf(TuplesKt.to("id", it));
                    object = map2;
                    if (map2 != null) break block20;
                }
                object = MapsKt.emptyMap();
            }
            Map<String, String> deviceIdMap = object;
            Object object2 = new char[]{','};
            object2 = StringsKt.split$default((CharSequence)configString, object2, false, 0, 6, null);
            Map<String, String> map3 = deviceIdMap;
            boolean $i$f$filter = false;
            void bl2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(it.length() >= 3 && StringsKt.contains$default((CharSequence)it, '=', false, 2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map bl3 = destination$iv$iv2;
                String paramString = (String)element$iv$iv;
                boolean bl4 = false;
                Pair<String, String> pair = new Pair<String, String>(((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default(paramString, '=', null, 2, null))).toString(), ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default(paramString, '=', null, 2, null))).toString());
                bl3.put(pair.getFirst(), pair.getSecond());
            }
            Map<String, String> paramsMap = MapsKt.plus(map3, destination$iv$iv2);
            if (!paramsMap.containsKey("shape")) {
                return this.parseDeviceSpecLanguage(paramsMap, availableDevices);
            }
            String value$iv = paramsMap.getOrDefault("shape", "");
            boolean $i$f$enumValueOfOrNull = false;
            try {
                destination$iv$iv2 = Shape.valueOf(value$iv);
            }
            catch (Exception _$iv) {
                destination$iv$iv2 = null;
            }
            Shape shape = (Shape)((Object)destination$iv$iv2);
            if (shape == null) {
                return null;
            }
            Shape shape2 = shape;
            Integer n3 = StringsKt.toIntOrNull(paramsMap.getOrDefault("width", ""));
            if (n3 == null) {
                return null;
            }
            int width = n3;
            Integer n4 = StringsKt.toIntOrNull(paramsMap.getOrDefault("height", ""));
            if (n4 == null) {
                return null;
            }
            int height = n4;
            String string2 = paramsMap.getOrDefault("unit", "").toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String value$iv2 = string2;
            boolean $i$f$enumValueOfOrNull2 = false;
            try {
                enum_ = DimUnit.valueOf(value$iv2);
            }
            catch (Exception _$iv) {
                enum_ = null;
            }
            DimUnit dimUnit = (DimUnit)enum_;
            if (dimUnit == null) {
                return null;
            }
            DimUnit dimUnit2 = dimUnit;
            if (referenceDeviceId != null) {
                Object v2 = DeviceConfigKt.access$getReferenceDeviceRealDensities$p().get(referenceDeviceId);
                Intrinsics.checkNotNull(v2);
                n2 = ((Number)v2).intValue();
            } else {
                Integer n5 = StringsKt.toIntOrNull(paramsMap.getOrDefault("dpi", ""));
                if (n5 != null) {
                    n2 = n5;
                } else {
                    return null;
                }
            }
            int dpi = n2;
            return new DeviceConfig(referenceDeviceId, width, height, dimUnit2, dpi, shape2, 0.0f, width > height ? Orientation.landscape : Orientation.portrait, null, 320, null);
        }

        private final DeviceConfig parseDeviceSpecLanguage(Map<String, String> params, Collection<Device> availableDevices) {
            String parentId = params.get("parent");
            if (parentId != null) {
                Object v0;
                block3: {
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getId(), parentId)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Device device = v0;
                if (device == null) {
                    return null;
                }
                Device matchingDevice = device;
                return this.parseFromExistingDeviceWithDeviceSpecLanguage(matchingDevice, params);
            }
            return this.parseFromCustomDeviceSpecLanguage(params);
        }

        private final DeviceConfig parseFromExistingDeviceWithDeviceSpecLanguage(Device device, Map<String, String> params) {
            DeviceConfig initialConfig = DeviceUtilsKt.toDeviceConfig(device);
            if (params.get("orientation") != null) {
                MutableDeviceConfig mutableDeviceConfig;
                Enum enum_;
                String value$iv = params.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception _$iv) {
                    enum_ = null;
                }
                Orientation orientation = (Orientation)enum_;
                if (orientation == null) {
                    return null;
                }
                Orientation orientation2 = orientation;
                MutableDeviceConfig $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u244 = mutableDeviceConfig = DeviceConfigKt.toMutableConfig(initialConfig);
                boolean bl2 = false;
                $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u244.setOrientation(orientation2);
                return DeviceConfigKt.toImmutableConfig(mutableDeviceConfig);
            }
            return initialConfig;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final DeviceConfig parseFromCustomDeviceSpecLanguage(Map<String, String> params) {
            Orientation orientation;
            float chinSizeValue;
            float f2;
            boolean isRound;
            boolean bl2;
            int dpi;
            int n2;
            AndroidDimension androidDimension = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("width"));
            if (androidDimension == null) {
                return null;
            }
            AndroidDimension width = androidDimension;
            AndroidDimension androidDimension2 = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("height"));
            if (androidDimension2 == null) {
                return null;
            }
            AndroidDimension height = androidDimension2;
            AndroidDimension chinSize = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("chinSize"));
            if (width.getUnit() != height.getUnit()) {
                return null;
            }
            if (params.get("chinSize") != null && (chinSize == null || chinSize.getUnit() != width.getUnit())) {
                return null;
            }
            DimUnit dimUnit = width.getUnit();
            if (params.get("dpi") != null) {
                Object object = params.get("dpi");
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) return null;
                n2 = (Integer)object;
            } else {
                n2 = dpi = Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI();
            }
            if (params.get("isRound") != null) {
                Object object = params.get("isRound");
                if (object == null || (object = StringsKt.toBooleanStrictOrNull((String)object)) == null) return null;
                bl2 = (Boolean)object;
            } else {
                bl2 = isRound = Preview.DeviceSpec.INSTANCE.getDEFAULT_IS_ROUND();
            }
            if (params.get("chinSize") != null) {
                AndroidDimension androidDimension3 = chinSize;
                if (androidDimension3 == null) return null;
                f2 = androidDimension3.getValue();
            } else {
                f2 = chinSizeValue = 0.0f;
            }
            if (params.get("orientation") != null) {
                Enum enum_;
                String value$iv = params.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception _$iv) {
                    enum_ = null;
                }
                if ((orientation = (Orientation)enum_) == null) {
                    return null;
                }
            } else {
                orientation = width.getValue() > height.getValue() ? Orientation.landscape : Orientation.portrait;
            }
            Orientation orientation2 = orientation;
            return new DeviceConfig(params.get("id"), width.getValue(), height.getValue(), dimUnit, dpi, isRound || chinSizeValue > 0.0f ? Shape.Round : Shape.Normal, chinSizeValue, orientation2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

