/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.IImageFactory;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public class CachingImageFactory
implements IImageFactory {
    private SoftReference<BufferedImage> myCachedImageReference;
    private final IImageFactory myDelegate;
    private int myCachedWidth;
    private int myCachedHeight;

    public CachingImageFactory(IImageFactory delegate2) {
        this.myDelegate = delegate2;
    }

    @Override
    @NotNull
    public BufferedImage getImage(int width, int height) {
        BufferedImage cached2;
        BufferedImage bufferedImage = cached2 = this.myCachedImageReference != null ? this.myCachedImageReference.get() : null;
        if (cached2 == null || this.myCachedWidth != width || this.myCachedHeight != height) {
            cached2 = this.myDelegate.getImage(width, height);
            this.myCachedWidth = width;
            this.myCachedHeight = height;
            this.myCachedImageReference = new SoftReference<BufferedImage>(cached2);
        }
        return cached2;
    }
}

