/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.AndroidXConstants;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.support.AndroidxName;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.ProjectFonts;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.rendering.ActionBarHandler;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.LayoutMetadata;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.ViewLoader;
import com.android.tools.rendering.api.NavGraphResolver;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import com.android.tools.rendering.parsers.AaptAttrParser;
import com.android.tools.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.rendering.parsers.LayoutFilePullParser;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.res.FileResourceReader;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ids.ResourceIdManagerHelper;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutlibCallbackImpl
extends LayoutlibCallback {
    private static final Logger LOG = Logger.getInstance(LayoutlibCallback.class);
    private static final int MAX_PARSER_INCLUDES = 50;
    private static final AndroidxName CLASS_WINDOW_DECOR_ACTION_BAR = new AndroidxName("android.support.v7.internal.app.WindowDecorActionBar", "androidx.appcompat.internal.app.WindowDecorActionBar");
    private static final Set<String> NOT_VIEW = ImmutableSet.of(AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.oldName(), AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.newName(), AndroidXConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.oldName(), AndroidXConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.newName(), CLASS_WINDOW_DECOR_ACTION_BAR.oldName(), CLASS_WINDOW_DECOR_ACTION_BAR.newName(), new String[0]);
    public static final String FD_LAYOUTLIB = "layoutlib";
    public static final String BUILD_CACHE = "build-cache";
    @NotNull
    private final RenderModelModule myRenderModule;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @Nullable
    private final Object myCredential;
    private final boolean myHasLegacyAppCompat;
    private final boolean myHasAndroidXAppCompat;
    private final boolean myShouldUseCustomInflater;
    private final ResourceNamespacing myNamespacing;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ViewLoader myViewLoader;
    @Nullable
    private String myLayoutName;
    @Nullable
    private ILayoutPullParser myLayoutEmbeddedParser;
    @Nullable
    private final ActionBarHandler myActionBarHandler;
    @NotNull
    private final RenderContext myRenderContext;
    @NotNull
    private final DownloadableFontCacheService myFontCacheService;
    private boolean myUsed;
    private Set<PathString> myParserFiles;
    private int myParserCount;
    @NotNull
    public ImmutableMap<String, TagSnapshot> myAaptDeclaredResources = ImmutableMap.of();
    private final Map<String, ResourceValue> myFontFamilies;
    private ProjectFonts myProjectFonts;
    @Nullable
    private final ILayoutPullParserFactory myLayoutPullParserFactory;
    @NotNull
    private final ResourceNamespace.Resolver myImplicitNamespaces;
    private final Map<String, AtomicInteger> myLayoutCounterForSampleData = new HashMap<String, AtomicInteger>();

    public LayoutlibCallbackImpl(@NotNull RenderTask renderTask2, @NotNull LayoutLibrary layoutLib, @NotNull RenderModelModule renderModule, @NotNull IRenderLogger logger, @Nullable Object credential, @Nullable ActionBarHandler actionBarHandler, @Nullable ILayoutPullParserFactory parserFactory, @NotNull ModuleClassLoader moduleClassLoader, boolean shouldUseCustomInflater) {
        this.myRenderContext = renderTask2.getContext();
        this.myLayoutLib = layoutLib;
        this.myRenderModule = renderModule;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myViewLoader = new ViewLoader(this.myLayoutLib, renderModule, logger, credential, moduleClassLoader);
        this.myActionBarHandler = actionBarHandler;
        this.myLayoutPullParserFactory = parserFactory;
        this.myHasLegacyAppCompat = renderModule.getDependencies().dependsOn(GoogleMavenArtifactId.APP_COMPAT_V7);
        this.myHasAndroidXAppCompat = renderModule.getDependencies().dependsOn(GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
        this.myShouldUseCustomInflater = shouldUseCustomInflater;
        this.myNamespacing = renderModule.getResourceRepositoryManager().getNamespacing();
        this.myImplicitNamespaces = this.myNamespacing == ResourceNamespacing.DISABLED ? ResourceNamespace.Resolver.TOOLS_ONLY : ResourceNamespace.Resolver.EMPTY_RESOLVER;
        this.myFontCacheService = renderModule.getEnvironment().getDownloadableFontCacheService();
        final ImmutableMap.Builder fontBuilder = ImmutableMap.builder();
        renderModule.getResourceRepositoryManager().getAppResources().accept(new ResourceVisitor(){

            @Override
            @NotNull
            public ResourceVisitor.VisitResult visit(@NotNull ResourceItem resourceItem) {
                String rawXml;
                ResourceValue resourceValue = resourceItem.getResourceValue();
                if (resourceValue != null && (rawXml = resourceValue.getRawXmlValue()) != null && rawXml.endsWith(".xml")) {
                    fontBuilder.put(rawXml, resourceValue);
                }
                return ResourceVisitor.VisitResult.CONTINUE;
            }

            @Override
            public boolean shouldVisitResourceType(@NotNull ResourceType resourceType) {
                return resourceType == ResourceType.FONT;
            }
        });
        this.myFontFamilies = fontBuilder.build();
    }

    void reset() {
        this.myParserCount = 0;
        this.myParserFiles = null;
        this.myLayoutName = null;
        this.myLayoutEmbeddedParser = null;
        this.myAaptDeclaredResources = ImmutableMap.of();
    }

    public void setLogger(@NotNull IRenderLogger logger) {
        this.myLogger = logger;
        this.myViewLoader.setLogger(logger);
    }

    @NotNull
    public ILayoutLog getLogger() {
        return this.myLogger;
    }

    @Override
    @Nullable
    public Object loadView(@NotNull String className, @NotNull Class[] constructorSignature, @NotNull Object[] constructorParameters) throws ClassNotFoundException {
        this.myUsed = true;
        if (NOT_VIEW.contains(className)) {
            return this.myViewLoader.loadClass(className, constructorSignature, constructorParameters);
        }
        return this.myViewLoader.loadView(className, constructorSignature, constructorParameters);
    }

    @Override
    public Object loadClass(@NotNull String name2, @Nullable Class[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        this.myUsed = true;
        return this.myViewLoader.loadClass(name2, constructorSignature, constructorArgs);
    }

    @Override
    @Nullable
    public ResourceReference resolveResourceId(int id2) {
        return this.myRenderModule.getResourceIdManager().findById(id2);
    }

    @Override
    public int getOrGenerateResourceId(@NotNull ResourceReference resource) {
        return this.myRenderModule.getResourceIdManager().getOrGenerateId(resource);
    }

    public boolean isUsed() {
        return this.myUsed;
    }

    @Nullable
    private static XmlPullParser getParserFromText(String fileName, @NotNull String text) {
        try {
            NamedXmlParser parser = new NamedXmlParser(fileName);
            parser.setInput(new StringReader(text));
            return parser;
        }
        catch (XmlPullParserException e2) {
            LOG.warn("Could not create parser for " + fileName);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public XmlPullParser createXmlParserForPsiFile(@NotNull String fileName) {
        if (fileName.contains("exploded-aar") || fileName.contains(FD_LAYOUTLIB) || fileName.contains(BUILD_CACHE)) {
            return null;
        }
        boolean token2 = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            ResourceValue resourceValue = this.myFontFamilies.get(fileName);
            if (resourceValue != null) {
                FontFamily family;
                String fontFamilyXml;
                if (this.myProjectFonts == null) {
                    this.myProjectFonts = new ProjectFonts(this.myRenderModule.getEnvironment().getDownloadableFontCacheService(), this.myRenderModule.getResourceRepositoryManager(), ResourceIdManagerHelper.getResolver(this.myRenderModule.getResourceIdManager()));
                }
                if ((fontFamilyXml = this.myFontCacheService.toXml(family = this.myProjectFonts.getFont(resourceValue.getResourceUrl().toString()))) == null) {
                    try {
                        CompletableFuture refreshFuture = new CompletableFuture();
                        this.myFontCacheService.refresh(() -> refreshFuture.complete(null), () -> refreshFuture.complete(null));
                        boolean success = (Boolean)((CompletableFuture)refreshFuture.thenCompose(unused -> this.myFontCacheService.download(family))).get(1L, TimeUnit.SECONDS);
                        if (success) {
                            fontFamilyXml = this.myFontCacheService.toXml(family);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e2) {
                        XmlPullParser xmlPullParser = null;
                        RenderSecurityManager.exitSafeRegion(token2);
                        return xmlPullParser;
                    }
                }
                XmlPullParser xmlPullParser = fontFamilyXml != null ? LayoutlibCallbackImpl.getParserFromText(fileName, fontFamilyXml) : null;
                return xmlPullParser;
            }
            String fileText = this.myRenderModule.getEnvironment().getFileText(fileName);
            if (fileText != null) {
                XmlPullParser xmlPullParser = LayoutlibCallbackImpl.getParserFromText(fileName, fileText);
                return xmlPullParser;
            }
            XmlPullParser xmlPullParser = null;
            return xmlPullParser;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token2);
        }
    }

    @Override
    @Nullable
    public XmlPullParser createXmlParserForFile(@NotNull String fileName) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(FileResourceReader.readBytes(fileName));
            XmlPullParser parser = XmlUtils.isProtoXml(stream) ? new NamedProtoXmlParser(fileName) : new NamedXmlParser(fileName);
            parser.setInput(stream, null);
            return parser;
        }
        catch (IOException | XmlPullParserException e2) {
            return null;
        }
    }

    @Override
    @NotNull
    public XmlPullParser createXmlParser() {
        return new NamedXmlParser(null);
    }

    public void setLayoutParser(@Nullable String layoutName, @Nullable ILayoutPullParser layoutParser) {
        this.myLayoutName = layoutName;
        this.myLayoutEmbeddedParser = layoutParser;
    }

    public void setAaptDeclaredResources(@NotNull Map<String, TagSnapshot> resources) {
        this.myAaptDeclaredResources = ImmutableMap.copyOf(resources);
    }

    @Nullable
    public ILayoutPullParser getLayoutEmbeddedParser() {
        return this.myLayoutEmbeddedParser;
    }

    @Override
    @Nullable
    public ILayoutPullParser getParser(@NotNull ResourceValue layoutResource) {
        ImmutableMap<String, TagSnapshot> declared;
        ILayoutPullParser parser;
        String value = layoutResource.getValue();
        if (value == null) {
            return null;
        }
        if (!this.myAaptDeclaredResources.isEmpty() && layoutResource.getResourceType() == ResourceType.AAPT) {
            TagSnapshot aaptResource = this.myAaptDeclaredResources.get(layoutResource.getValue());
            if (aaptResource == null) {
                return null;
            }
            parser = LayoutRenderPullParser.create(aaptResource, ResourceNamespace.TODO(), this.myLogger);
        } else {
            PathString pathString = ResourcesUtil.toFileResourcePathString(value);
            if (pathString == null) {
                return null;
            }
            parser = this.getParser(layoutResource.getName(), layoutResource.getNamespace(), pathString);
        }
        if (parser instanceof AaptAttrParser && !(declared = ((AaptAttrParser)((Object)parser)).getAaptDeclaredAttrs()).isEmpty()) {
            this.myAaptDeclaredResources = ImmutableMap.builder().putAll(((AaptAttrParser)((Object)parser)).getAaptDeclaredAttrs()).putAll(this.myAaptDeclaredResources).build();
        }
        return parser;
    }

    @Nullable
    private ILayoutPullParser getParser(@NotNull String layoutName, @NotNull ResourceNamespace namespace, @NotNull PathString xml) {
        ILayoutPullParser parser;
        if (this.myParserFiles != null && this.myParserFiles.contains(xml)) {
            if (this.myParserCount > 50) {
                if (this.findCycles()) {
                    throw new RuntimeException(String.format("Cycle found (count=%3$d) evaluating '%1$s' with path '%2$s' (parserFiles=%4$s)", layoutName, xml.toDebugString(), this.myParserCount, StringUtil.join(this.myParserFiles, ", ")));
                }
                this.myParserCount = 0;
            }
        } else {
            if (this.myParserFiles == null) {
                this.myParserFiles = new HashSet<PathString>();
            }
            this.myParserFiles.add(xml);
        }
        ++this.myParserCount;
        if (this.myLayoutPullParserFactory != null && (parser = this.myLayoutPullParserFactory.create(this.myRenderModule.getProject(), this.myLogger, xml, this, this.myRenderModule.getResourceRepositoryManager())) != null) {
            return parser;
        }
        if (layoutName.equals(this.myLayoutName) && namespace != ResourceNamespace.ANDROID) {
            parser = this.myLayoutEmbeddedParser;
            this.myLayoutEmbeddedParser = null;
            return parser;
        }
        if (xml.getFilesystemUri().getScheme().equals("file")) {
            RenderXmlFile xmlFile;
            AtomicInteger sampleDataCounter = this.myLayoutCounterForSampleData.get(layoutName);
            if (sampleDataCounter == null) {
                sampleDataCounter = new AtomicInteger(0);
                this.myLayoutCounterForSampleData.put(layoutName, sampleDataCounter);
            }
            String parentName = xml.getParentFileName();
            String path = xml.getRawPath();
            if (parentName != null && !path.contains("exploded-aar") && !path.contains(FD_LAYOUTLIB) && !path.contains(BUILD_CACHE) && (parentName.startsWith("layout") || parentName.startsWith("drawable") || parentName.startsWith("menu")) && (xmlFile = this.myRenderModule.getEnvironment().getXmlFile(xml)) != null) {
                ResourceResolver resourceResolver = this.myRenderContext.getConfiguration().getResourceResolver();
                NavGraphResolver navGraphResolver = this.myRenderContext.getModule().getEnvironment().getNavGraphResolver(resourceResolver);
                LayoutRenderPullParser parser2 = LayoutRenderPullParser.create(xmlFile, this.myLogger, false, navGraphResolver, this.myRenderModule.getResourceRepositoryManager(), sampleDataCounter.getAndIncrement());
                parser2.setUseSrcCompat(this.myHasLegacyAppCompat || this.myHasAndroidXAppCompat);
                return parser2;
            }
        }
        return LayoutFilePullParser.create(xml, namespace, this.myRenderModule.getResourceIdManager());
    }

    private boolean findCycles() {
        if (this.myParserFiles.size() == 1) {
            return true;
        }
        HashMap<String, File> layoutToFile = new HashMap<String, File>();
        ArrayListMultimap<String, String> includeMap = ArrayListMultimap.create();
        for (PathString path : this.myParserFiles) {
            File file2 = path.toFile();
            if (file2 == null || !file2.exists()) continue;
            String layoutName = SdkUtils.getLayoutName(file2);
            layoutToFile.put(layoutName, file2);
            try {
                String xml = Files.asCharSource(file2, StandardCharsets.UTF_8).read();
                Document document = XmlUtils.parseDocumentSilently(xml, true);
                if (document == null) continue;
                NodeList includeNodeList = document.getElementsByTagName("include");
                int n2 = includeNodeList.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Element include = (Element)includeNodeList.item(i2);
                    String included = include.getAttribute("layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put(layoutName, resource);
                }
                NodeList fragmentNodeList = document.getElementsByTagName("androidx.fragment.app.FragmentContainerView");
                if (fragmentNodeList.getLength() == 0) {
                    fragmentNodeList = document.getElementsByTagName("fragment");
                }
                int n3 = fragmentNodeList.getLength();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Element fragment = (Element)fragmentNodeList.item(i3);
                    String included = fragment.getAttributeNS("http://schemas.android.com/tools", "layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put(layoutName, resource);
                }
            }
            catch (IOException e2) {
                LOG.warn("Could not check file " + file2 + " for cyclic dependencies", e2);
            }
        }
        if (!includeMap.isEmpty()) {
            for (String from2 : includeMap.keySet()) {
                HashSet<String> visiting;
                List<String> chain = LayoutlibCallbackImpl.dfs(from2, visiting = Sets.newHashSetWithExpectedSize(includeMap.size()), includeMap);
                if (chain == null) continue;
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                HtmlBuilder builder = problem.getHtmlBuilder();
                builder.add("Found cyclical <include> chain: ");
                boolean first2 = true;
                Collections.reverse(chain);
                for (String layout : chain) {
                    if (first2) {
                        first2 = false;
                    } else {
                        builder.add(" includes ");
                    }
                    File file3 = (File)layoutToFile.get(layout);
                    if (file3 != null) {
                        try {
                            String url = SdkUtils.fileToUrlString(file3);
                            builder.addLink(layout, url);
                        }
                        catch (MalformedURLException e3) {
                            builder.add(layout);
                        }
                        continue;
                    }
                    builder.add(layout);
                }
                this.myLogger.addMessage(problem);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<String> dfs(String from2, Set<String> visiting, Multimap<String, String> includeMap) {
        visiting.add(from2);
        Collection<String> includes = includeMap.get(from2);
        if (!includes.isEmpty()) {
            for (String include : includes) {
                if (visiting.contains(include)) {
                    LinkedList<String> list2 = Lists.newLinkedList();
                    list2.add(include);
                    list2.add(from2);
                    return list2;
                }
                List<String> chain = LayoutlibCallbackImpl.dfs(include, visiting, includeMap);
                if (chain == null) continue;
                chain.add(from2);
                return chain;
            }
        }
        visiting.remove(from2);
        return null;
    }

    @Override
    @Nullable
    public Object getAdapterItemValue(ResourceReference adapterView, Object adapterCookie, ResourceReference itemRef, int fullPosition, int typePosition, int fullChildPosition, int typeChildPosition, ResourceReference viewRef, LayoutlibCallback.ViewAttribute viewAttribute, Object defaultValue) {
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && adapterView.getName().startsWith("android_widget_")) {
            String name2 = adapterView.getName();
            if (viewRef.getName().equals("text2")) {
                return "Sub Item";
            }
            if (fullPosition == 0) {
                String viewName = name2.substring("android_widget_".length());
                if (viewName.equals("ExpandableListView")) {
                    return "ExpandableList";
                }
                return viewName;
            }
            return "Next Item";
        }
        if (itemRef.getNamespace() == ResourceNamespace.ANDROID && viewRef.getName().equals("text2")) {
            return "Sub Item " + (fullPosition + 1);
        }
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && ((String)defaultValue).isEmpty()) {
            return "Item " + (fullPosition + 1);
        }
        return null;
    }

    private boolean isWithinIllegalParent(@NotNull Object viewObject, int depth) {
        Object parent;
        Result result2;
        String fqcn = viewObject.getClass().getName();
        if (fqcn.endsWith("CalendarView") || !fqcn.startsWith("android.") && !fqcn.startsWith("androidx.") && !fqcn.startsWith("com.android.internal.widget.")) {
            return true;
        }
        if (depth > 0 && (result2 = this.myLayoutLib.getViewParent(viewObject)).isSuccess() && (parent = result2.getData()) != null) {
            return this.isWithinIllegalParent(parent, depth - 1);
        }
        return false;
    }

    @Override
    @Nullable
    public AdapterBinding getAdapterBinding(Object viewObject, Map<String, String> attributes) {
        AdapterBinding binding = LayoutMetadata.getNodeBinding(viewObject, attributes);
        if (binding != null) {
            return binding;
        }
        if (viewObject == null) {
            return null;
        }
        String listFqcn = LayoutMetadata.getListAdapterViewFqcn(viewObject.getClass());
        if (listFqcn == null) {
            return null;
        }
        if (this.isWithinIllegalParent(viewObject, 2)) {
            return null;
        }
        int count2 = listFqcn.endsWith("GridView") ? 24 : 12;
        binding = new AdapterBinding(count2);
        if (listFqcn.endsWith("ExpandableListView")) {
            binding.addItem(new DataBindingItem("simple_expandable_list_item_2", true, 1));
        } else if (listFqcn.equals("android.widget.Spinner")) {
            binding.addItem(new DataBindingItem("simple_spinner_item", true, 1));
        } else {
            binding.addItem(new DataBindingItem("simple_list_item_2", true, 1));
        }
        return binding;
    }

    public void loadAndParseRClass() {
        this.myViewLoader.loadAndParseRClassSilently();
    }

    @Override
    public ActionBarCallback getActionBarCallback() {
        return this.myActionBarHandler;
    }

    @Override
    @Nullable
    public String getResourcePackage() {
        return this.myRenderModule.getResourcePackage();
    }

    @Override
    @Nullable
    public String getApplicationId() {
        try {
            return RenderSecurityManager.runInSafeRegion(this.myCredential, () -> {
                AndroidModuleInfo info = this.myRenderModule.getInfo();
                if (info == null) {
                    return null;
                }
                return info.getPackageName();
            });
        }
        catch (Exception e2) {
            LOG.warn(e2);
            return null;
        }
    }

    @Override
    @NotNull
    public Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        Class<?> aClass = this.myViewLoader.loadClass(name2, false);
        if (aClass != null) {
            return aClass;
        }
        throw new ClassNotFoundException(name2 + " not found.");
    }

    @Override
    public boolean isClassLoaded(String name2) {
        return this.myViewLoader.isClassLoaded(name2);
    }

    @Override
    @NotNull
    public ResourceNamespace.Resolver getImplicitNamespaces() {
        return this.myImplicitNamespaces;
    }

    @Override
    public boolean hasLegacyAppCompat() {
        return this.myHasLegacyAppCompat;
    }

    @Override
    public boolean hasAndroidXAppCompat() {
        return this.myHasAndroidXAppCompat;
    }

    @Override
    public boolean isResourceNamespacingRequired() {
        return this.myNamespacing == ResourceNamespacing.REQUIRED;
    }

    @Override
    public boolean shouldUseCustomInflater() {
        return this.myShouldUseCustomInflater;
    }

    @Override
    public void error(@NotNull String message2, String ... details) {
        LOG.error(message2, details);
    }

    @Override
    public void error(@NotNull String message2, @Nullable Throwable t2) {
        LOG.error(message2, t2);
    }

    @Override
    public void error(@NotNull Throwable t2) {
        LOG.error(t2);
    }

    @TestOnly
    public void setProjectFonts(@Nullable ProjectFonts projectFonts) {
        this.myProjectFonts = projectFonts;
    }

    public void setMenuResource(String resourceName) {
        if (this.myActionBarHandler != null) {
            ResourceReference menuResource = new ResourceReference(this.myRenderModule.getResourceRepositoryManager().getNamespace(), ResourceType.MENU, SdkUtils.fileNameToResourceName(resourceName));
            this.myActionBarHandler.setMenuIds(Collections.singletonList(menuResource));
        }
    }

    private static class NamedXmlParser
    extends KXmlParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        NamedXmlParser(@Nullable String name2) {
            this.myName = name2;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e2) {
                throw new Error("Internal error", e2);
            }
        }

        @Override
        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        @Override
        public String getAttributeValue(@Nullable String namespace, @NotNull String name2) {
            String toolsValue;
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name2)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name2);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }

    private static class NamedProtoXmlParser
    extends ProtoXmlPullParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        NamedProtoXmlParser(@Nullable String name2) {
            this.myName = name2;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e2) {
                throw new Error(e2);
            }
        }

        @Override
        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        @Override
        public String getAttributeValue(@Nullable String namespace, @NotNull String name2) {
            String toolsValue;
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name2)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name2);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }
}

