/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.AndroidXConstants;
import com.android.support.AndroidxName;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class RecyclerViewHelper {
    private static final String SUPPORT_PACKAGE_NAME = "com.android.layoutlib.bridge.android.support";
    public static final String CN_SUPPORT_CUSTOM_ADAPTER = "com.android.layoutlib.bridge.android.support.Adapter";
    private static final String CN_SUPPORT_CUSTOM_VIEW_HOLDER = "com.android.layoutlib.bridge.android.support.Adapter$ViewHolder";
    private static final String CN_SUPPORT_CUSTOM_TEXT_VIEW = "com.android.layoutlib.bridge.android.support.Adapter$MyTextView";
    private static final String ANDROIDX_PACKAGE_NAME = "com.android.layoutlib.bridge.android.androidx";
    public static final String CN_ANDROIDX_CUSTOM_ADAPTER = "com.android.layoutlib.bridge.android.androidx.Adapter";
    private static final String CN_ANDROIDX_CUSTOM_VIEW_HOLDER = "com.android.layoutlib.bridge.android.androidx.Adapter$ViewHolder";
    private static final String CN_ANDROIDX_CUSTOM_TEXT_VIEW = "com.android.layoutlib.bridge.android.androidx.Adapter$MyTextView";
    private static final Map<String, byte[]> ourClassesCache = new HashMap<String, byte[]>();

    @NotNull
    private static String nameToBinaryRepresentation(@NotNull Function<AndroidxName, String> nameFunction, @NotNull AndroidxName androidxName) {
        return nameFunction.apply(androidxName).replaceAll("\\.", "/");
    }

    public static byte[] getAdapterHelperClass(@NotNull String name2) {
        byte[] clazz = null;
        switch (name2) {
            case "com.android.layoutlib.bridge.android.androidx.Adapter": {
                clazz = RecyclerViewHelper.getAdapterClass(CN_ANDROIDX_CUSTOM_ADAPTER, AdapterNamespace.ANDROIDX);
                break;
            }
            case "com.android.layoutlib.bridge.android.androidx.Adapter$ViewHolder": {
                clazz = RecyclerViewHelper.getViewHolder(CN_ANDROIDX_CUSTOM_ADAPTER, AdapterNamespace.ANDROIDX);
                break;
            }
            case "com.android.layoutlib.bridge.android.androidx.Adapter$MyTextView": {
                clazz = RecyclerViewHelper.getMyTextView(CN_ANDROIDX_CUSTOM_ADAPTER, AdapterNamespace.ANDROIDX);
                break;
            }
            case "com.android.layoutlib.bridge.android.support.Adapter": {
                clazz = RecyclerViewHelper.getAdapterClass(CN_SUPPORT_CUSTOM_ADAPTER, AdapterNamespace.SUPPORT);
                break;
            }
            case "com.android.layoutlib.bridge.android.support.Adapter$ViewHolder": {
                clazz = RecyclerViewHelper.getViewHolder(CN_SUPPORT_CUSTOM_ADAPTER, AdapterNamespace.SUPPORT);
                break;
            }
            case "com.android.layoutlib.bridge.android.support.Adapter$MyTextView": {
                clazz = RecyclerViewHelper.getMyTextView(CN_SUPPORT_CUSTOM_ADAPTER, AdapterNamespace.SUPPORT);
            }
        }
        return clazz;
    }

    private static byte[] getAdapterClass(@NotNull String customAdapterName, @NotNull AdapterNamespace adapterNamespace) {
        return ourClassesCache.computeIfAbsent(customAdapterName, adapterClassName -> {
            Function<AndroidxName, String> nameFunction = adapterNamespace == AdapterNamespace.ANDROIDX ? AndroidxName::newName : AndroidxName::oldName;
            String recyclerViewName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_V7);
            String viewHolderName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER);
            String adapterName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER);
            return RecyclerViewHelper.getAdapterClassDump(adapterClassName.replaceAll("\\.", "/"), recyclerViewName, viewHolderName, adapterName);
        });
    }

    private static byte[] getViewHolder(@NotNull String customAdapterName, @NotNull AdapterNamespace adapterNamespace) {
        return ourClassesCache.computeIfAbsent(customAdapterName + "$ViewHolder", ignore -> {
            Function<AndroidxName, String> nameFunction = adapterNamespace == AdapterNamespace.ANDROIDX ? AndroidxName::newName : AndroidxName::oldName;
            String recyclerViewName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_V7);
            String viewHolderName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER);
            String adapterName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER);
            return RecyclerViewHelper.getViewHolderDump(customAdapterName.replaceAll("\\.", "/"), recyclerViewName, viewHolderName, adapterName);
        });
    }

    private static byte[] getMyTextView(@NotNull String customAdapterName, @NotNull AdapterNamespace adapterNamespace) {
        return ourClassesCache.computeIfAbsent(customAdapterName + "$MyTextView", ignore -> {
            Function<AndroidxName, String> nameFunction = adapterNamespace == AdapterNamespace.ANDROIDX ? AndroidxName::newName : AndroidxName::oldName;
            String recyclerViewName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_V7);
            String viewHolderName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER);
            String adapterName = RecyclerViewHelper.nameToBinaryRepresentation(nameFunction, AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER);
            return RecyclerViewHelper.getMyTextViewDump(customAdapterName.replaceAll("\\.", "/"), recyclerViewName, viewHolderName, adapterName);
        });
    }

    private static byte[] getAdapterClassDump(@NotNull String customAdapterName, @NotNull String recyclerViewName, @NotNull String viewHolderName, @NotNull String adapterName) {
        ClassWriter cw = new ClassWriter(0);
        String signature = String.format("L%1$s<L%2$s;>;", adapterName, viewHolderName);
        cw.visit(52, 33, customAdapterName, signature, adapterName, null);
        cw.visitInnerClass(customAdapterName + "$MyTextView", customAdapterName, "MyTextView", 10);
        cw.visitInnerClass(customAdapterName + "$ViewHolder", customAdapterName, "ViewHolder", 10);
        cw.visitInnerClass(viewHolderName, recyclerViewName, "ViewHolder", 1033);
        cw.visitInnerClass(adapterName, recyclerViewName, "Adapter", 1033);
        FieldVisitor fv = cw.visitField(2, "mItemCount", "I", null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "mId", "I", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, adapterName, "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, 10);
        mv.visitFieldInsn(181, customAdapterName, "mItemCount", "I");
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        String desc = String.format("(Landroid/view/ViewGroup;I)L%1$s;", viewHolderName);
        mv = cw.visitMethod(1, "onCreateViewHolder", desc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, customAdapterName, "mId", "I");
        Label l0 = new Label();
        mv.visitJumpInsn(158, l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "android/view/ViewGroup", "getContext", "()Landroid/content/Context;", false);
        mv.visitMethodInsn(184, "android/view/LayoutInflater", "from", "(Landroid/content/Context;)Landroid/view/LayoutInflater;", false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, customAdapterName, "mId", "I");
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "android/view/LayoutInflater", "inflate", "(ILandroid/view/ViewGroup;Z)Landroid/view/View;", false);
        mv.visitVarInsn(58, 3);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitTypeInsn(187, customAdapterName + "$MyTextView");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "android/view/ViewGroup", "getContext", "()Landroid/content/Context;", false);
        mv.visitMethodInsn(183, customAdapterName + "$MyTextView", "<init>", "(Landroid/content/Context;)V", false);
        mv.visitVarInsn(58, 3);
        mv.visitLabel(l1);
        mv.visitFrame(1, 1, new Object[]{"android/view/View"}, 0, null);
        mv.visitTypeInsn(187, customAdapterName + "$ViewHolder");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, customAdapterName + "$ViewHolder", "<init>", "(Landroid/view/View;)V", false);
        mv.visitInsn(176);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        desc = String.format("(L%1$s;I)V", viewHolderName);
        mv = cw.visitMethod(1, "onBindViewHolder", desc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(180, viewHolderName, "itemView", "Landroid/view/View;");
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 3);
        mv.visitTypeInsn(193, customAdapterName + "$MyTextView");
        l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitVarInsn(25, 3);
        mv.visitTypeInsn(192, customAdapterName + "$MyTextView");
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitLdcInsn("Item ");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, customAdapterName + "$MyTextView", "setText", "(Ljava/lang/CharSequence;)V", false);
        mv.visitLabel(l0);
        mv.visitFrame(1, 1, new Object[]{"android/view/View"}, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(3, 4);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getItemCount", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, customAdapterName, "mItemCount", "I");
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setLayoutId", "(I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitFieldInsn(181, customAdapterName, "mId", "I");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setItemCount", "(I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitFieldInsn(181, customAdapterName, "mItemCount", "I");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] getViewHolderDump(@NotNull String customAdapterName, @NotNull String recyclerViewClass, @NotNull String viewHolderClass, @NotNull String viewAdapterClass) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 32, customAdapterName + "$ViewHolder", null, viewHolderClass, null);
        cw.visitInnerClass(customAdapterName + "$ViewHolder", customAdapterName, "ViewHolder", 10);
        cw.visitInnerClass(viewHolderClass, recyclerViewClass, "ViewHolder", 1033);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Landroid/view/View;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, viewHolderClass, "<init>", "(Landroid/view/View;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] getMyTextViewDump(@NotNull String customAdapterName, @NotNull String recyclerViewClass, @NotNull String viewHolderClass, @NotNull String viewAdapterClass) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 32, customAdapterName + "$MyTextView", null, "android/widget/TextView", null);
        cw.visitInnerClass(customAdapterName + "$MyTextView", customAdapterName, "MyTextView", 10);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Landroid/content/Context;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "android/widget/TextView", "<init>", "(Landroid/content/Context;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static enum AdapterNamespace {
        ANDROIDX,
        SUPPORT;

    }
}

