/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
implements IRenderLogger {
    public static final RenderLogger NOP_RENDER_LOGGER = new RenderLogger(){

        @Override
        public void addMessage(@NotNull RenderProblem message2) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void setHasLoadedClasses() {
        }

        @Override
        public void setMissingResourceClass() {
        }

        @Override
        public void setResourceClass(@NotNull String resourceClass) {
        }

        @Override
        public void addMissingClass(@NotNull String className) {
        }

        @Override
        public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        }

        @Override
        public void logAndroidFramework(int priority, String tag, @NotNull String message2) {
        }
    };
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    public static final String TAG_STILL_BUILDING = "project.building";
    private static final Logger LOG = Logger.getInstance("#com.android.tools.idea.rendering.RenderLogger");
    @VisibleForTesting
    static final int RENDER_PROBLEMS_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.RENDER_PROBLEMS_LIMIT", 100);
    @VisibleForTesting
    static final int STACK_OVERFLOW_TRACE_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.STACK_OVERFLOW_TRACE_LIMIT", 100);
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final String myProjectBasePath;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Multiset<String> myTags;
    private final List<RenderProblem> myMessages = new ArrayList<RenderProblem>();
    private int myMessagesOverflowCounter;
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;
    private final boolean myLogFramework;
    private final RenderProblemBuilder myRenderProblemBuilder;
    private final Supplier<HtmlLinkManager> myHtmlLinkManagerFactory;
    private static final int ANDROID_LOG_VERBOSE = 0;
    private static final int ANDROID_LOG_DEBUG = 1;
    private static final int ANDROID_LOG_INFO = 2;
    private static final int ANDROID_LOG_WARN = 3;
    private static final int ANDROID_LOG_ERROR = 4;
    private static final int ANDROID_LOG_FATAL_WITHOUT_ABORT = 5;
    private static final int ANDROID_LOG_FATAL = 6;

    public RenderLogger(@Nullable Project project, @Nullable Object credential, boolean logFramework, @NotNull RenderProblem.ActionFixFactory fixFactory, @NotNull Supplier<HtmlLinkManager> linkManagerFactory) {
        this.myProjectBasePath = project == null ? null : project.getBasePath();
        this.myCredential = credential;
        this.myLogFramework = logFramework;
        this.myHtmlLinkManagerFactory = linkManagerFactory;
        this.myRenderProblemBuilder = (throwable, tag, description) -> {
            if (project == null) {
                return RenderProblem.createPlain(ProblemSeverity.ERROR, description).tag(tag).throwable(throwable);
            }
            return RenderProblem.createHtml(ProblemSeverity.ERROR, description, project, this.getLinkManager(), throwable, fixFactory).tag(tag);
        };
    }

    public RenderLogger(@Nullable Project project) {
        this(project, null, false, RenderProblem.NOOP_ACTION_FIX_FACTORY, () -> HtmlLinkManager.NOOP_LINK_MANAGER);
    }

    @VisibleForTesting
    public RenderLogger() {
        this(null);
    }

    @VisibleForTesting
    public static void resetFidelityErrorsFilters() {
        ourIgnoreAllFidelityWarnings = false;
        if (ourIgnoredFidelityWarnings != null) {
            ourIgnoredFidelityWarnings.clear();
        }
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new HashSet<String>();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message2, @Nullable Throwable throwable) {
        if (StringUtil.isEmptyOrSpaces(message2)) {
            return throwable != null && throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        return message2;
    }

    public static boolean isIssue164378(@Nullable Throwable throwable) {
        StackTraceElement[] stackTrace;
        return throwable instanceof NoSuchFieldError && (stackTrace = throwable.getStackTrace()).length >= 1 && stackTrace[0].getClassName().startsWith("android.support");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageToIdeaLog(@NotNull String message2, @Nullable Throwable t2) {
        Object logMessage2;
        if (t2 == null) {
            logMessage2 = message2;
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            writer.println(t2.getMessage());
            t2.printStackTrace(writer);
            logMessage2 = message2 + "\n" + stringWriter.toString();
        }
        boolean token2 = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            LOG.debug((String)logMessage2);
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token2);
        }
    }

    private void logMessageToIdeaLog(@NotNull String message2) {
        this.logMessageToIdeaLog(message2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(@NotNull RenderProblem message2) {
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            if (this.myMessages.size() < RENDER_PROBLEMS_LIMIT) {
                this.myMessages.add(message2);
            } else {
                ++this.myMessagesOverflowCounter;
            }
        }
        this.logMessageToIdeaLog(XmlUtils.fromXmlAttributeValue(message2.getHtml()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RenderProblem> getMessages() {
        int overflowCounter;
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            builder.addAll(this.myMessages);
            overflowCounter = this.myMessagesOverflowCounter;
        }
        if (overflowCounter > 0) {
            builder.add(RenderProblem.createPlain(ProblemSeverity.WARNING, String.format(Locale.US, "Too many errors (%d more errors not displayed)", overflowCounter)));
        }
        return builder.build();
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.myFidelityWarnings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean hasErrorMessage;
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            hasErrorMessage = this.myMessages.stream().anyMatch(message2 -> message2.getSeverity().compareTo(ProblemSeverity.ERROR) >= 0);
        }
        return this.myHaveExceptions || hasErrorMessage || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<RenderProblem> getFidelityWarnings() {
        return this.myFidelityWarnings != null ? this.myFidelityWarnings : Collections.emptyList();
    }

    @Override
    public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        String description = RenderLogger.describe(message2, null);
        if (tag == null && message2 != null && (message2.startsWith("Failed to find style ") || message2.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, description).tag(tag));
    }

    @NotNull
    private static StackOverflowError summarizeStackOverFlowException(@NotNull StackOverflowError stackOverflowError) {
        StackTraceElement[] stackTraceElements = stackOverflowError.getStackTrace();
        int traceSize = stackTraceElements.length;
        if (traceSize < STACK_OVERFLOW_TRACE_LIMIT) {
            return stackOverflowError;
        }
        int elementsToCopy = STACK_OVERFLOW_TRACE_LIMIT / 2;
        StackTraceElement[] newStackTraceElements = new StackTraceElement[elementsToCopy * 2 + 1];
        newStackTraceElements[elementsToCopy] = new StackTraceElement("omitted", "omitted", "omitted", -1);
        System.arraycopy(stackTraceElements, 0, newStackTraceElements, 0, elementsToCopy);
        System.arraycopy(stackTraceElements, stackTraceElements.length - elementsToCopy, newStackTraceElements, elementsToCopy + 1, elementsToCopy);
        stackOverflowError.setStackTrace(newStackTraceElements);
        return stackOverflowError;
    }

    @Override
    public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        Object description = RenderLogger.describe(message2, throwable);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (RenderLogger.isIssue164378(throwable)) {
                return;
            }
            if ("Unable to find the layout for Action Bar.".equals(description)) {
                description = (String)description + "\nConsider updating to a more recent version of appcompat, or switch the rendering library in the IDE down to API 21";
            }
            if (((String)description).isEmpty()) {
                description = "Exception raised during rendering";
            } else if (((String)description).equals(throwable.getLocalizedMessage()) || ((String)description).equals(throwable.getMessage())) {
                description = "Exception raised during rendering: " + (String)description;
            } else if (message2 != null && message2.startsWith("Failed to configure parser for ") && message2.endsWith(".png")) {
                StackTraceElement[] frames;
                for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                    if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                        String basePath;
                        String path = message2.substring("Failed to configure parser for ".length());
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        problem.tag("bitmapAsColor");
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        builder.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                        builder.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                        builder.newline().newline();
                        path = FileUtil.toSystemIndependentName(path);
                        String string2 = basePath = this.myProjectBasePath == null ? null : FileUtil.toSystemIndependentName(this.myProjectBasePath);
                        if (basePath != null && path.startsWith(basePath)) {
                            path = path.substring(basePath.length());
                            path = StringUtil.trimStart(path, File.separator);
                        }
                        path = FileUtil.toSystemDependentName(path);
                        builder.add("The relevant image is ").add(path);
                        HashSet<String> widgets = Sets.newHashSet();
                        for (StackTraceElement f2 : frames) {
                            String className;
                            if (!f2.getMethodName().equals("<init>") || !(className = f2.getClassName()).startsWith("android.widget.")) continue;
                            widgets.add(className.substring(className.lastIndexOf(46) + 1));
                        }
                        if (!widgets.isEmpty()) {
                            ArrayList sorted2 = Lists.newArrayList(widgets);
                            Collections.sort(sorted2);
                            builder.newline().newline().add("Widgets possibly involved: ").add(Joiner.on(", ").join(sorted2));
                        }
                        this.addMessage(problem);
                        return;
                    }
                    if (!frame.getClassName().startsWith("com.android.tools.")) {
                        continue;
                    }
                    break;
                }
            } else {
                if (message2 != null && message2.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                    int end;
                    int index2;
                    XmlPullParserException e2 = (XmlPullParserException)throwable;
                    Object msg = e2.getMessage();
                    if (((String)msg).startsWith("Binary XML file ") && (index2 = ((String)msg).indexOf(58)) != -1 && index2 < ((String)msg).length() - 1) {
                        msg = ((String)msg).substring(index2 + 1).trim();
                    }
                    int lineNumber = e2.getLineNumber();
                    int column = e2.getColumnNumber();
                    String reader = " in java.io.InputStreamReader@";
                    int index3 = ((String)msg).indexOf(reader);
                    if (index3 != -1 && (end = ((String)msg).indexOf(41, index3 + 1)) != -1) {
                        msg = ((String)msg).substring(0, index3) + ((String)msg).substring(end);
                    }
                    String path = message2.substring("Failed to parse file ".length());
                    RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                    problem.tag("xmlParse");
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    if (lineNumber != -1) {
                        builder.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                    }
                    builder.add((String)msg);
                    if (lineNumber != -1) {
                        builder.add(" (");
                        File file2 = new File(path);
                        String url = HtmlLinkManager.createFilePositionUrl(file2, lineNumber, column);
                        if (url != null) {
                            builder.addLink("Show", url);
                            builder.add(")");
                        }
                    }
                    this.addMessage(problem);
                    return;
                }
                if (throwable instanceof StackOverflowError) {
                    throwable = RenderLogger.summarizeStackOverFlowException((StackOverflowError)throwable);
                }
            }
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        this.addMessage(this.myRenderProblemBuilder.build(throwable, tag, (String)description));
    }

    @Override
    public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        String description = RenderLogger.describe(message2, null);
        if ("info".equals(tag)) {
            Logger.getInstance(this.getClass()).info(description);
            return;
        }
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description.equals("You must supply a layout_width attribute.") || description.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value = matcher.group(1);
                problem.setClientData(new String[]{attribute, value});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value = matcher.group(1);
                problem.setClientData(new String[]{attribute, value});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else {
            if (TAG_MISSING_FRAGMENT.equals(tag)) {
                if (!ourIgnoreFragments) {
                    if (this.myMissingFragments == null) {
                        this.myMissingFragments = new ArrayList<String>();
                    }
                    String name2 = data instanceof String ? (String)data : null;
                    this.myMissingFragments.add(name2);
                }
                return;
            }
            if ("thread-creation".equals(tag)) {
                this.addTag(tag);
                RenderProblem problem = RenderProblem.createPlain(ProblemSeverity.WARNING, description).tag(tag);
                if (data instanceof Throwable) {
                    problem.throwable((Throwable)data);
                }
                this.addMessage(problem);
                return;
            }
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.WARNING, description).tag(tag));
    }

    @Override
    public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message2)) {
            return;
        }
        String description = RenderLogger.describe(message2, throwable);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description)) {
            return;
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem error = RenderProblem.createDeferred(ProblemSeverity.ERROR, tag, description, throwable);
        error.setClientData(description);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = Sets.newHashSet();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description);
        this.addTag(tag);
    }

    private void addTag(@Nullable String tag) {
        if (tag == null) {
            return;
        }
        if (this.myTags == null) {
            this.myTags = HashMultiset.create();
        }
        this.myTags.add(tag);
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (this.myTags == null) {
            return false;
        }
        return this.myTags.stream().anyMatch(s2 -> s2.startsWith(prefix));
    }

    @Override
    @NotNull
    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = this.myHtmlLinkManagerFactory.get();
        }
        return this.myLinkManager;
    }

    @Override
    public void setHasLoadedClasses() {
        this.myHasLoadedClasses = true;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Override
    public void setMissingResourceClass() {
        this.myMissingResourceClass = true;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Override
    public void setResourceClass(@NotNull String resourceClass) {
        this.myResourceClass = resourceClass;
    }

    @NotNull
    public Map<String, Throwable> getBrokenClasses() {
        return this.myBrokenClasses != null ? this.myBrokenClasses : Collections.emptyMap();
    }

    @NotNull
    public Set<String> getMissingClasses() {
        return this.myMissingClasses != null ? this.myMissingClasses : Collections.emptySet();
    }

    @Override
    public void addMissingClass(@NotNull String className) {
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
            this.logMessageToIdeaLog("Class not found " + className);
        }
    }

    @Override
    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (exception instanceof StackOverflowError) {
            exception = RenderLogger.summarizeStackOverFlowException((StackOverflowError)exception);
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
        this.logMessageToIdeaLog("Broken class " + className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logAndroidFramework(int priority, String tag, @NotNull String message2) {
        if (!this.myLogFramework) return;
        boolean token2 = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            String fullMessage = tag + ": " + message2;
            switch (priority) {
                case 0: 
                case 1: {
                    LOG.debug(fullMessage);
                    return;
                }
                case 2: {
                    LOG.info(fullMessage);
                    return;
                }
                case 3: 
                case 4: {
                    LOG.warn(fullMessage);
                    return;
                }
                case 5: 
                case 6: {
                    LOG.error(fullMessage);
                    return;
                }
            }
            return;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token2);
        }
    }

    private static interface RenderProblemBuilder {
        public RenderProblem build(Throwable var1, String var2, String var3);
    }
}

