/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0011R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/rendering/RenderingBundle;", "", "()V", "BUNDLE_NAME", "", "bundle", "Ljava/util/ResourceBundle;", "getBundle", "()Ljava/util/ResourceBundle;", "ourBundle", "Ljava/lang/ref/Reference;", "message", "key", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "readFromBundleAndFormat", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "unnamed"})
public final class RenderingBundle {
    @NotNull
    public static final RenderingBundle INSTANCE = new RenderingBundle();
    @NonNls
    @NotNull
    private static final String BUNDLE_NAME = "messages.RenderingBundle";
    @Nullable
    private static Reference<ResourceBundle> ourBundle;

    private RenderingBundle() {
    }

    private final ResourceBundle getBundle() {
        ResourceBundle bundle;
        Reference<ResourceBundle> reference = ourBundle;
        ResourceBundle resourceBundle = bundle = reference != null ? reference.get() : null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @JvmStatic
    @NotNull
    public static final String message(@PropertyKey(resourceBundle="messages.RenderingBundle") @NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        ResourceBundle resourceBundle = INSTANCE.getBundle();
        Intrinsics.checkNotNull(resourceBundle);
        return INSTANCE.readFromBundleAndFormat(resourceBundle, key, Arrays.copyOf(params, params.length));
    }

    private final String readFromBundleAndFormat(ResourceBundle bundle, String key, Object ... params) {
        String rawValue = bundle.getString(key);
        Locale locale = bundle.getLocale();
        MessageFormat format = new MessageFormat(rawValue, locale);
        String string2 = format.format(params);
        Intrinsics.checkNotNullExpressionValue(string2, "format.format(params)");
        return string2;
    }
}

