/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading;

import com.android.tools.rendering.classloading.HierarchicalTimeCounter;
import com.android.tools.rendering.classloading.ModuleClassLoadedDiagnosticsImpl;
import com.android.tools.rendering.classloading.ModuleClassLoaderDiagnosticsWrite;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J \u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl;", "Lcom/android/tools/rendering/classloading/ModuleClassLoaderDiagnosticsWrite;", "()V", "accumulatedFindTimeMs", "", "getAccumulatedFindTimeMs", "()J", "accumulatedRewriteTimeMs", "getAccumulatedRewriteTimeMs", "classesFound", "getClassesFound", "foundClasses", "Ljava/util/PriorityQueue;", "Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl$ClassFoundReport;", "totalClassesFound", "Ljava/util/concurrent/atomic/LongAdder;", "totalFindTimeCounterMs", "Lcom/android/tools/rendering/classloading/HierarchicalTimeCounter;", "totalFindTimeMs", "totalLoadTimeCounterMs", "totalLoadTimeMs", "totalRewriteTimeMs", "classFindEnd", "", "fqn", "", "wasFoud", "", "timeMs", "classFindStart", "classLoadStart", "classLoadedEnd", "classRewritten", "length", "", "ClassFoundReport", "unnamed"})
@VisibleForTesting
public final class ModuleClassLoadedDiagnosticsImpl
implements ModuleClassLoaderDiagnosticsWrite {
    @NotNull
    private final HierarchicalTimeCounter totalLoadTimeCounterMs = new HierarchicalTimeCounter();
    @NotNull
    private final HierarchicalTimeCounter totalFindTimeCounterMs = new HierarchicalTimeCounter();
    @NotNull
    private final LongAdder totalLoadTimeMs = new LongAdder();
    @NotNull
    private final LongAdder totalFindTimeMs = new LongAdder();
    @NotNull
    private final LongAdder totalClassesFound = new LongAdder();
    @NotNull
    private final LongAdder totalRewriteTimeMs = new LongAdder();
    @NotNull
    private final PriorityQueue<ClassFoundReport> foundClasses = new PriorityQueue(100, Comparator.comparing(foundClasses.1.INSTANCE));

    @Override
    public void classLoadStart(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        this.totalLoadTimeCounterMs.start(fqn);
    }

    @Override
    public void classLoadedEnd(@NotNull String fqn, long timeMs) {
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        try {
            this.totalLoadTimeMs.add(this.totalLoadTimeCounterMs.end(fqn, timeMs));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void classFindStart(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        this.totalFindTimeCounterMs.start(fqn);
    }

    @Override
    public void classFindEnd(@NotNull String fqn, boolean wasFoud, long timeMs) {
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        try {
            this.totalFindTimeMs.add(this.totalFindTimeCounterMs.end(fqn, timeMs));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.totalClassesFound.increment();
        this.foundClasses.add(new ClassFoundReport(fqn, timeMs));
    }

    @Override
    public void classRewritten(@NotNull String fqn, int length, long timeMs) {
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        this.totalRewriteTimeMs.add(timeMs);
    }

    @Override
    public long getClassesFound() {
        return this.totalClassesFound.sum();
    }

    @Override
    public long getAccumulatedFindTimeMs() {
        return this.totalFindTimeMs.sum();
    }

    @Override
    public long getAccumulatedRewriteTimeMs() {
        return this.totalRewriteTimeMs.sum();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl$ClassFoundReport;", "", "fqn", "", "timeMs", "", "(Ljava/lang/String;J)V", "getFqn", "()Ljava/lang/String;", "getTimeMs", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "unnamed"})
    private static final class ClassFoundReport {
        @NotNull
        private final String fqn;
        private final long timeMs;

        public ClassFoundReport(@NotNull String fqn, long timeMs) {
            Intrinsics.checkNotNullParameter(fqn, "fqn");
            this.fqn = fqn;
            this.timeMs = timeMs;
        }

        @NotNull
        public final String getFqn() {
            return this.fqn;
        }

        public final long getTimeMs() {
            return this.timeMs;
        }

        @NotNull
        public final String component1() {
            return this.fqn;
        }

        public final long component2() {
            return this.timeMs;
        }

        @NotNull
        public final ClassFoundReport copy(@NotNull String fqn, long timeMs) {
            Intrinsics.checkNotNullParameter(fqn, "fqn");
            return new ClassFoundReport(fqn, timeMs);
        }

        public static /* synthetic */ ClassFoundReport copy$default(ClassFoundReport classFoundReport, String string2, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = classFoundReport.fqn;
            }
            if ((n2 & 2) != 0) {
                l2 = classFoundReport.timeMs;
            }
            return classFoundReport.copy(string2, l2);
        }

        @NotNull
        public String toString() {
            return "ClassFoundReport(fqn=" + this.fqn + ", timeMs=" + this.timeMs + ")";
        }

        public int hashCode() {
            int result2 = this.fqn.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassFoundReport)) {
                return false;
            }
            ClassFoundReport classFoundReport = (ClassFoundReport)other;
            if (!Intrinsics.areEqual(this.fqn, classFoundReport.fqn)) {
                return false;
            }
            return this.timeMs == classFoundReport.timeMs;
        }
    }
}

