/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.module.ModuleDependencies;
import com.android.tools.rendering.LayoutlibCallbackImpl;
import com.android.tools.rendering.parsers.DomPullParser;
import com.android.tools.rendering.parsers.LayoutPullParsers;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";

    private MenuLayoutParserFactory() {
    }

    @NotNull
    public static ILayoutPullParser create(@NotNull RenderXmlFile psiFile, @NotNull LayoutlibCallbackImpl layoutlibCallback) {
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently(FRAME_LAYOUT_XML, true);
        if (frameLayoutDocument == null) {
            return LayoutPullParsers.createEmptyParser();
        }
        layoutlibCallback.setMenuResource(psiFile.getName());
        return DomPullParser.createFromDocument(frameLayoutDocument, false);
    }

    @NotNull
    public static ILayoutPullParser createInNavigationView(@NotNull RenderXmlFile file2, @NotNull ModuleDependencies dependencies) {
        String navViewTag = dependencies.dependsOnAndroidx() ? AndroidXConstants.NAVIGATION_VIEW.newName() : AndroidXConstants.NAVIGATION_VIEW.oldName();
        String xml = "<" + navViewTag + " xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:layout_width=\"wrap_content\"\n    android:layout_height=\"match_parent\"\n    app:menu=\"@menu/" + SdkUtils.fileNameToResourceName(file2.getName()) + "\" />\n";
        Document document = XmlUtils.parseDocumentSilently(xml, true);
        return document == null ? LayoutPullParsers.createEmptyParser() : DomPullParser.createFromDocument(document);
    }
}

