/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MenuRenderPullParser
extends LayoutRenderPullParser.AttributeFilteredLayoutParser {
    private static final ImmutableSet<String> UNSUPPORTED_ATTRIBUTES = ImmutableSet.of("onClick", "actionViewClass");

    public MenuRenderPullParser(RenderXmlFile file2, ILayoutLog logger, ResourceRepositoryManager resourceRepositoryManager) {
        super(file2, logger, new RenderTask.AttributeFilter(){

            @Override
            @Nullable
            public String getAttribute(@NotNull RenderXmlTag node, @Nullable String namespace, @NotNull String localName) {
                if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
                    if (localName.equals("showAsAction")) {
                        return this.getShowAsActionValue(node);
                    }
                    if (localName.equals("actionLayout")) {
                        RenderXmlAttribute actionLayout = node.getAttribute("actionLayout", "http://schemas.android.com/apk/res-auto");
                        return actionLayout != null ? actionLayout.getValue() : null;
                    }
                    if (UNSUPPORTED_ATTRIBUTES.contains(localName)) {
                        return "";
                    }
                }
                return null;
            }

            @Nullable
            private String getShowAsActionValue(@NotNull RenderXmlTag node) {
                if (node.getAttribute("showAsAction", "http://schemas.android.com/apk/res/android") != null || node.getAttribute("showAsAction", "http://schemas.android.com/tools") != null) {
                    return null;
                }
                RenderXmlAttribute attr = node.getAttribute("showAsAction", "http://schemas.android.com/apk/res-auto");
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
        }, resourceRepositoryManager);
    }

    @Override
    @Nullable
    public Object getViewCookie() {
        TagSnapshot element;
        if (this.myProvideViewCookies && (element = this.getCurrentNode()) != null) {
            if (element.tagName.equals("menu")) {
                return this.getPreviousNode();
            }
            return element;
        }
        return null;
    }
}

