/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.XmlParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lcom/android/tools/rendering/parsers/RenderXmlFileSnapshot;", "Lcom/android/tools/rendering/parsers/RenderXmlFile;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "Lcom/android/ide/common/util/PathString;", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/util/PathString;)V", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "name", "folderType", "Lcom/android/resources/ResourceFolderType;", "fileContent", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/android/resources/ResourceFolderType;Ljava/lang/String;)V", "getFolderType", "()Lcom/android/resources/ResourceFolderType;", "isValid", "", "()Z", "getName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "relativePath", "getRelativePath", "resourceNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getResourceNamespace", "()Lcom/android/ide/common/rendering/api/ResourceNamespace;", "rootTag", "Lcom/android/tools/rendering/parsers/RenderXmlTag;", "getRootTag", "()Lcom/android/tools/rendering/parsers/RenderXmlTag;", "get", "Lcom/intellij/psi/PsiFile;", "getRootTagAttribute", "attribute", "namespace", "unnamed"})
@SourceDebugExtension(value={"SMAP\nRenderXmlFileSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderXmlFileSnapshot.kt\ncom/android/tools/rendering/parsers/RenderXmlFileSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class RenderXmlFileSnapshot
implements RenderXmlFile {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @Nullable
    private final ResourceFolderType folderType;
    @NotNull
    private final RenderXmlTag rootTag;
    private final boolean isValid;
    @NotNull
    private final String relativePath;
    @NotNull
    private final ResourceNamespace resourceNamespace;

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull String name2, @Nullable ResourceFolderType folderType, @NotNull String fileContent) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(fileContent, "fileContent");
        this.project = project;
        this.name = name2;
        this.folderType = folderType;
        this.rootTag = XmlParser.parseRootTag(fileContent);
        this.isValid = true;
        this.relativePath = this.getName();
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue(resourceNamespace, "RES_AUTO");
        this.resourceNamespace = resourceNamespace;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ResourceFolderType getFolderType() {
        return this.folderType;
    }

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull PathString filePath) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        String string2 = filePath.getFileName();
        String string3 = filePath.getParentFileName();
        Intrinsics.checkNotNull(string3);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType(string3);
        File file2 = filePath.toFile();
        Intrinsics.checkNotNull(file2);
        this(project, string2, resourceFolderType, new String(FilesKt.readBytes(file2), Charsets.UTF_8));
    }

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        this(project, new PathString(filePath));
    }

    @Override
    @NotNull
    public RenderXmlTag getRootTag() {
        return this.rootTag;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public ResourceNamespace getResourceNamespace() {
        return this.resourceNamespace;
    }

    @Override
    @Nullable
    public String getRootTagAttribute(@NotNull String attribute, @Nullable String namespace) {
        Object object;
        Object object2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(attribute, "attribute");
                object2 = namespace;
                if (object2 == null) break block2;
                String it = object2;
                boolean bl2 = false;
                RenderXmlAttribute renderXmlAttribute = this.getRootTag().getAttribute(namespace, attribute);
                object2 = renderXmlAttribute;
                if (renderXmlAttribute != null) break block3;
            }
            object2 = this.getRootTag().getAttribute(attribute);
        }
        return (object = object2) != null ? object.getValue() : null;
    }

    @Override
    @NotNull
    public PsiFile get() {
        throw new NotImplementedError("Getting PsiFile from XmlFileSnapshot is not supported.");
    }
}

