/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryLoader;
import com.android.tools.res.FolderResourceRepository;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016J&\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/res/FolderResourceRepository;", "Lcom/android/tools/res/LocalResourceRepository;", "Ljava/io/File;", "Lcom/android/resources/base/LoadableResourceRepository;", "resFolder", "(Ljava/io/File;)V", "resourcePathBase", "Lcom/android/ide/common/util/PathString;", "resourcePathPrefix", "", "resourceTable", "", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "Lcom/android/ide/common/resources/ResourceItem;", "accept", "Lcom/android/ide/common/resources/ResourceVisitor$VisitResult;", "visitor", "Lcom/android/ide/common/resources/ResourceVisitor;", "computeResourceDirs", "", "containsUserDefinedResources", "", "getLibraryName", "getMap", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "resourceType", "getNamespace", "getOrigin", "Ljava/nio/file/Path;", "getPackageName", "getResourceUrl", "relativeResourcePath", "getSourceFile", "forFileResource", "unnamed"})
public final class FolderResourceRepository
extends LocalResourceRepository<File>
implements LoadableResourceRepository {
    @NotNull
    private final File resFolder;
    @NotNull
    private final String resourcePathPrefix;
    @NotNull
    private final PathString resourcePathBase;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> resourceTable;

    public FolderResourceRepository(@NotNull File resFolder) {
        Intrinsics.checkNotNullParameter(resFolder, "resFolder");
        super("");
        this.resFolder = resFolder;
        this.resourcePathPrefix = RepositoryLoader.portableFileName(this.resFolder.getPath()) + "/";
        this.resourcePathBase = new PathString(this.resourcePathPrefix);
        this.resourceTable = new EnumMap(ResourceType.class);
        Path path = this.resFolder.toPath();
        ResourceNamespace resourceNamespace = this.getNamespace();
        RepositoryLoader<FolderResourceRepository> loader2 = new RepositoryLoader<FolderResourceRepository>(this, path, resourceNamespace){
            final /* synthetic */ FolderResourceRepository this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull FolderResourceRepository repository) {
                Intrinsics.checkNotNullParameter(item, "item");
                Intrinsics.checkNotNullParameter(repository, "repository");
                ((ListMultimap)FolderResourceRepository.access$getResourceTable$p(this.this$0).computeIfAbsent(item.getResourceType(), (Function)loader.addResourceItem.1.INSTANCE)).put(item.getName(), item);
            }
        };
        loader2.loadRepositoryContents((FolderResourceRepository)((LoadableResourceRepository)this));
    }

    @Override
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        if (visitor.shouldVisitNamespace(this.getNamespace())) {
            ResourceVisitor.VisitResult visitResult = LocalResourceRepository.acceptByResources(this.resourceTable, visitor);
            Intrinsics.checkNotNullExpressionValue((Object)visitResult, "acceptByResources(resourceTable, visitor)");
            return visitResult;
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue(resourceNamespace, "RES_AUTO");
        return resourceNamespace;
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.getNamespace().getPackageName();
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return null;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        Path path = this.resFolder.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "resFolder.toPath()");
        return path;
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        Intrinsics.checkNotNullParameter(relativeResourcePath, "relativeResourcePath");
        return this.resourcePathPrefix + relativeResourcePath;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        Intrinsics.checkNotNullParameter(relativeResourcePath, "relativeResourcePath");
        return this.resourcePathBase.resolve(relativeResourcePath);
    }

    @Override
    public boolean containsUserDefinedResources() {
        return true;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter((Object)resourceType, "resourceType");
        return Intrinsics.areEqual(namespace, this.getNamespace()) ? this.resourceTable.get((Object)resourceType) : null;
    }

    @Override
    @NotNull
    protected Set<File> computeResourceDirs() {
        File[] fileArray = new File[]{this.resFolder};
        return SetsKt.mutableSetOf(fileArray);
    }

    public static final /* synthetic */ Map access$getResourceTable$p(FolderResourceRepository $this) {
        return $this.resourceTable;
    }
}

