/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.MultiResourceRepository;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class LocalResourceRepository<T>
extends AbstractResourceRepositoryWithLocking
implements CacheableResourceRepository {
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    private List<MultiResourceRepository<T>> myParents;
    private volatile long myGeneration;
    private final Object RESOURCE_DIRS_LOCK = new Object();
    private Set<T> myResourceDirs;

    protected LocalResourceRepository(String displayName) {
        this.myDisplayName = displayName;
        this.setModificationCount(ourModificationCounter.incrementAndGet());
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(MultiResourceRepository<T> parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents == null) {
                this.myParents = new ArrayList<MultiResourceRepository<T>>(2);
            }
            this.myParents.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(MultiResourceRepository<T> parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                this.myParents.remove(parent);
            }
        }
    }

    protected void invalidateParentCaches() {
        if (this.myParents != null) {
            for (MultiResourceRepository<T> parent : this.myParents) {
                parent.invalidateCache();
            }
        }
    }

    protected void invalidateParentCaches(SingleNamespaceResourceRepository repository, ResourceType ... types) {
        if (this.myParents != null) {
            for (MultiResourceRepository<T> parent : this.myParents) {
                parent.invalidateCache(repository, types);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyParentsOfReset() {
        List<Object> parents2;
        Iterator iterator2 = ITEM_MAP_LOCK;
        synchronized (iterator2) {
            parents2 = this.myParents != null ? new ArrayList<MultiResourceRepository<T>>(this.myParents) : Collections.emptyList();
        }
        for (MultiResourceRepository parent : parents2) {
            parent.onChildReset();
        }
    }

    @Override
    public long getModificationCount() {
        return this.myGeneration;
    }

    protected void setModificationCount(long count2) {
        this.myGeneration = count2;
    }

    public void invokeAfterPendingUpdatesFinish(Executor executor, Runnable callback) {
        executor.execute(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<T> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            if (this.myResourceDirs != null) {
                return this.myResourceDirs;
            }
            this.myResourceDirs = this.computeResourceDirs();
            return this.myResourceDirs;
        }
    }

    protected abstract Set<T> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (LocalResourceRepository localResourceRepository : this.myParents) {
                    localResourceRepository.invalidateResourceDirs();
                }
            }
        }
    }

    @Override
    public Collection<ResourceItem> getPublicResources(ResourceNamespace namespace, ResourceType type) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    ListMultimap<String, ResourceItem> getMapPackageAccessible(ResourceNamespace namespace, ResourceType type) {
        return this.getMap(namespace, type);
    }

    @VisibleForTesting
    public int getFileRescans() {
        return 0;
    }

    public static final class EmptyRepository<T>
    extends LocalResourceRepository<T>
    implements SingleNamespaceResourceRepository {
        private final ResourceNamespace myNamespace;

        public EmptyRepository(ResourceNamespace namespace) {
            super("");
            this.myNamespace = namespace;
        }

        @Override
        protected Set<T> computeResourceDirs() {
            return Collections.emptySet();
        }

        @Override
        protected ListMultimap<String, ResourceItem> getMap(ResourceNamespace namespace, ResourceType type) {
            return null;
        }

        @Override
        public ResourceNamespace getNamespace() {
            return this.myNamespace;
        }

        @Override
        public String getPackageName() {
            return this.myNamespace.getPackageName();
        }

        @Override
        public ResourceVisitor.VisitResult accept(ResourceVisitor visitor) {
            return ResourceVisitor.VisitResult.CONTINUE;
        }
    }
}

