/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.environment.Logger;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class MultiResourceRepository<T>
extends LocalResourceRepository<T> {
    private static final Logger LOG = Logger.getInstance(MultiResourceRepository.class);
    private ImmutableList<LocalResourceRepository<T>> myLocalResources = ImmutableList.of();
    private ImmutableList<ResourceRepository> myChildren = ImmutableList.of();
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myLeafsByNamespace = ImmutableListMultimap.of();
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myRepositoriesByNamespace = ImmutableListMultimap.of();
    private ResourceItemComparator myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator(ImmutableList.of()));
    private long[] myModificationCounts;
    private final ResourceTable myCachedMaps = new ResourceTable();
    private final Table<SingleNamespaceResourceRepository, ResourceType, Set<String>> myResourceNames = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));
    private final Table<ResourceNamespace, ResourceType, Set<SingleNamespaceResourceRepository>> myUnreconciledResources = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));

    protected MultiResourceRepository(String displayName) {
        super(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(List<? extends LocalResourceRepository<T>> localResources, Collection<? extends AarResourceRepository> libraryResources, Collection<? extends ResourceRepository> otherResources) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.release();
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myLocalResources = ImmutableList.copyOf(localResources);
            int size = this.myLocalResources.size() + libraryResources.size() + otherResources.size();
            this.myChildren = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(size).addAll(this.myLocalResources)).addAll(libraryResources)).addAll(otherResources)).build();
            ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeLeafs(this, mapBuilder);
            this.myLeafsByNamespace = mapBuilder.build();
            mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeNamespaceMap(this, mapBuilder);
            this.myRepositoriesByNamespace = mapBuilder.build();
            this.myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator(this.myLeafsByNamespace.values()));
            this.myModificationCounts = new long[localResources.size()];
            if (localResources.size() == 1) {
                LocalResourceRepository<T> child = localResources.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i2 = 0;
            for (LocalResourceRepository localResourceRepository : this.myLocalResources) {
                localResourceRepository.addParent(this);
                this.myModificationCounts[i2++] = localResourceRepository.getModificationCount();
            }
            this.myCachedMaps.clear();
            this.invalidateParentCaches();
        }
    }

    protected abstract void refreshChildren();

    public void onChildReset() {
        this.refreshChildren();
    }

    private static <T> void computeLeafs(ResourceRepository repository, ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeLeafs(child, result2);
            }
        } else {
            for (SingleNamespaceResourceRepository resourceRepository : repository.getLeafResourceRepositories()) {
                result2.put((Object)resourceRepository.getNamespace(), (Object)resourceRepository);
            }
        }
    }

    private static <T> void computeNamespaceMap(ResourceRepository repository, ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository instanceof SingleNamespaceResourceRepository) {
            SingleNamespaceResourceRepository singleNamespaceRepository = (SingleNamespaceResourceRepository)repository;
            ResourceNamespace namespace = singleNamespaceRepository.getNamespace();
            result2.put((Object)namespace, (Object)singleNamespaceRepository);
        } else if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeNamespaceMap(child, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<LocalResourceRepository<T>> getLocalResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLocalResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<SingleNamespaceResourceRepository> getRepositoriesForNamespace(ResourceNamespace namespace) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.get((Object)namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources.size() == 1) {
                return ((LocalResourceRepository)this.myLocalResources.get(0)).getModificationCount();
            }
            boolean changed = false;
            for (int i2 = 0; i2 < this.myLocalResources.size(); ++i2) {
                LocalResourceRepository child = (LocalResourceRepository)this.myLocalResources.get(i2);
                long rev = child.getModificationCount();
                if (rev == this.myModificationCounts[i2]) continue;
                this.myModificationCounts[i2] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceVisitor.VisitResult accept(ResourceVisitor visitor) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceNamespace namespace : this.getNamespaces()) {
                if (!visitor.shouldVisitNamespace(namespace)) continue;
                for (ResourceType type : ResourceType.values()) {
                    ListMultimap<String, ResourceItem> map2;
                    if (!visitor.shouldVisitResourceType(type) || (map2 = this.getMap(namespace, type)) == null) continue;
                    for (ResourceItem item : map2.values()) {
                        if (visitor.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                        return ResourceVisitor.VisitResult.ABORT;
                    }
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    protected ListMultimap<String, ResourceItem> getMap(ResourceNamespace namespace, ResourceType type) {
        Stopwatch stopwatch;
        ImmutableCollection repositoriesForNamespace = this.myLeafsByNamespace.get((Object)namespace);
        if (repositoriesForNamespace.size() == 1) {
            SingleNamespaceResourceRepository repository = (SingleNamespaceResourceRepository)repositoriesForNamespace.get(0);
            return MultiResourceRepository.getResourcesUnderLock(repository, namespace, type);
        }
        ArrayListMultimap<String, ResourceItem> map2 = (ArrayListMultimap<String, ResourceItem>)this.myCachedMaps.get(namespace, (Object)type);
        Set<SingleNamespaceResourceRepository> unreconciledRepositories = null;
        if (map2 != null && (unreconciledRepositories = this.myUnreconciledResources.get(namespace, (Object)type)) == null) {
            return map2;
        }
        Stopwatch stopwatch2 = stopwatch = LOG.isDebugEnabled() ? Stopwatch.createStarted() : null;
        if (map2 == null) {
            for (SingleNamespaceResourceRepository repository : repositoriesForNamespace) {
                ListMultimap<String, ResourceItem> items = MultiResourceRepository.getResourcesUnderLock(repository, namespace, type);
                if (items.isEmpty()) continue;
                if (map2 == null) {
                    map2 = type == ResourceType.STYLEABLE || type == ResourceType.ID ? ArrayListMultimap.create() : new PerConfigResourceMap(this.myResourceComparator);
                    this.myCachedMaps.put(namespace, type, map2);
                }
                map2.putAll(items);
                if (!(repository instanceof LocalResourceRepository)) continue;
                this.myResourceNames.put(repository, type, ImmutableSet.copyOf(items.keySet()));
            }
        } else {
            for (SingleNamespaceResourceRepository unreconciledRepository : unreconciledRepositories) {
                Predicate<ResourceItem> filter2 = item -> item.getRepository().equals(unreconciledRepository);
                Set<String> names = this.myResourceNames.get(unreconciledRepository, (Object)type);
                if (names != null) {
                    PerConfigResourceMap perConfigMap = map2 instanceof PerConfigResourceMap ? (PerConfigResourceMap)((Object)map2) : null;
                    for (String name2 : names) {
                        if (perConfigMap != null) {
                            perConfigMap.removeIf(name2, filter2);
                            continue;
                        }
                        Collection items = map2.get((Object)name2);
                        items.removeIf(filter2);
                        if (!items.isEmpty()) continue;
                        map2.removeAll(name2);
                    }
                }
                ListMultimap<String, ResourceItem> unreconciledResources = MultiResourceRepository.getResourcesUnderLock(unreconciledRepository, namespace, type);
                map2.putAll(unreconciledResources);
                assert (unreconciledRepository instanceof LocalResourceRepository);
                this.myResourceNames.put(unreconciledRepository, type, ImmutableSet.copyOf(unreconciledResources.keySet()));
                if (!map2.isEmpty()) continue;
                this.myCachedMaps.remove(namespace, (Object)type);
            }
            this.myUnreconciledResources.remove(namespace, (Object)type);
        }
        if (stopwatch != null) {
            LOG.debug(String.format(Locale.US, "Merged %d resources of type %s in %s for %s.", new Object[]{map2 == null ? 0 : map2.size(), type, stopwatch, this.getClass().getSimpleName()}));
        }
        return map2;
    }

    private static <T> ListMultimap<String, ResourceItem> getResourcesUnderLock(SingleNamespaceResourceRepository repository, ResourceNamespace namespace, ResourceType type) {
        if (repository instanceof LocalResourceRepository) {
            ListMultimap<String, ResourceItem> map2 = ((LocalResourceRepository)((Object)repository)).getMapPackageAccessible(namespace, type);
            return map2 == null ? ImmutableListMultimap.of() : map2;
        }
        return repository.getResources(namespace, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void release() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository localResourceRepository : this.myLocalResources) {
                localResourceRepository.removeParent(this);
            }
        }
    }

    public void invalidateCache() {
        this.clearCachedData();
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches();
    }

    private void clearCachedData() {
        this.myCachedMaps.clear();
        this.myResourceNames.clear();
        this.myUnreconciledResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onLowMemory() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.clearCachedData();
        }
        LOG.warn(this.getDisplayName() + ": Cached data cleared due to low memory");
    }

    public void invalidateCache(SingleNamespaceResourceRepository repository, ResourceType ... types) {
        ResourceNamespace namespace = repository.getNamespace();
        ImmutableCollection leafs = this.myLeafsByNamespace.get((Object)namespace);
        if (((ImmutableList)leafs).contains(repository)) {
            if (leafs.size() != 1) {
                for (ResourceType type : types) {
                    if (this.myCachedMaps.get(namespace, (Object)type) == null) continue;
                    Set<SingleNamespaceResourceRepository> repositories = this.myUnreconciledResources.get(namespace, (Object)type);
                    if (repositories == null) {
                        repositories = new HashSet<SingleNamespaceResourceRepository>();
                        this.myUnreconciledResources.put(namespace, type, repositories);
                    }
                    repositories.add(repository);
                }
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            this.invalidateParentCaches(repository, types);
        }
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(Executor executor, Runnable callback) {
        ImmutableList<LocalResourceRepository<T>> repositories = this.getLocalResources();
        AtomicInteger count2 = new AtomicInteger(repositories.size());
        for (LocalResourceRepository localResourceRepository : repositories) {
            localResourceRepository.invokeAfterPendingUpdatesFinish(MoreExecutors.directExecutor(), () -> {
                if (count2.decrementAndGet() == 0) {
                    executor.execute(callback);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<T> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            HashSet result2 = new HashSet();
            for (LocalResourceRepository localResourceRepository : this.myLocalResources) {
                result2.addAll(localResourceRepository.computeResourceDirs());
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLeafsByNamespace.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int getFileRescans() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            int count2 = 0;
            for (LocalResourceRepository localResourceRepository : this.myLocalResources) {
                count2 += localResourceRepository.getFileRescans();
            }
            return count2;
        }
    }

    private static class ResourceItemComparator
    implements Comparator<ResourceItem> {
        private final Comparator<ResourceItem> myPriorityComparator;

        ResourceItemComparator(Comparator<ResourceItem> priorityComparator) {
            this.myPriorityComparator = priorityComparator;
        }

        @Override
        public int compare(ResourceItem item1, ResourceItem item2) {
            int c2 = item1.getConfiguration().compareTo(item2.getConfiguration());
            if (c2 != 0) {
                return c2;
            }
            return this.myPriorityComparator.compare(item1, item2);
        }
    }

    private static class ResourcePriorityComparator
    implements Comparator<ResourceItem> {
        private final Object2IntMap<SingleNamespaceResourceRepository> repositoryOrdering;

        ResourcePriorityComparator(Collection<SingleNamespaceResourceRepository> repositories) {
            this.repositoryOrdering = new Object2IntOpenHashMap<SingleNamespaceResourceRepository>(repositories.size());
            int i2 = 0;
            for (SingleNamespaceResourceRepository repository : repositories) {
                this.repositoryOrdering.put(repository, i2++);
            }
        }

        @Override
        public int compare(ResourceItem item1, ResourceItem item2) {
            return Integer.compare(this.getOrdering(item1), this.getOrdering(item2));
        }

        private int getOrdering(ResourceItem item) {
            int ordering = this.repositoryOrdering.getInt(item.getRepository());
            assert (ordering >= 0);
            return ordering;
        }
    }

    private static class PerConfigResourceMap
    implements ListMultimap<String, ResourceItem> {
        private final Map<String, List<ResourceItem>> myMap = new LinkedHashMap<String, List<ResourceItem>>();
        private int mySize = 0;
        private final ResourceItemComparator myComparator;
        private Values myValues;

        private PerConfigResourceMap(ResourceItemComparator comparator) {
            this.myComparator = comparator;
        }

        @Override
        public List<ResourceItem> get(String key) {
            List<ResourceItem> items = this.myMap.get(key);
            return items == null ? ImmutableList.of() : items;
        }

        @Override
        public Set<String> keySet() {
            return this.myMap.keySet();
        }

        @Override
        public Multiset<String> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<ResourceItem> values() {
            Values values2 = this.myValues;
            if (values2 == null) {
                this.myValues = values2 = new Values();
            }
            return values2;
        }

        @Override
        public Collection<Map.Entry<String, ResourceItem>> entries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ResourceItem> removeAll(Object key) {
            List<ResourceItem> removed = this.myMap.remove(key);
            if (removed != null) {
                this.mySize -= removed.size();
            }
            return removed == null ? ImmutableList.of() : removed;
        }

        boolean removeIf(String key, Predicate<? super ResourceItem> filter2) {
            List<ResourceItem> list2 = this.myMap.get(key);
            if (list2 == null) {
                return false;
            }
            int oldSize = list2.size();
            boolean removed = list2.removeIf(filter2);
            this.mySize += list2.size() - oldSize;
            if (list2.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }

        @Override
        public void clear() {
            this.myMap.clear();
            this.mySize = 0;
        }

        @Override
        public int size() {
            return this.mySize;
        }

        @Override
        public boolean isEmpty() {
            return this.mySize == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsEntry(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean put(String key, ResourceItem item) {
            List list2 = this.myMap.computeIfAbsent(key, k2 -> new PerConfigResourceList());
            int oldSize = list2.size();
            list2.add(item);
            this.mySize += list2.size() - oldSize;
            return true;
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(String key, Iterable<? extends ResourceItem> items) {
            if (items instanceof Collection) {
                if (((Collection)items).isEmpty()) {
                    return false;
                }
                List list2 = this.myMap.computeIfAbsent(key, k2 -> new PerConfigResourceList());
                int oldSize = list2.size();
                boolean added = list2.addAll((Collection)items);
                this.mySize += list2.size() - oldSize;
                return added;
            }
            boolean added = false;
            List list3 = null;
            int oldSize = 0;
            for (ResourceItem resourceItem : items) {
                if (list3 == null) {
                    list3 = this.myMap.computeIfAbsent(key, k2 -> new PerConfigResourceList());
                    oldSize = list3.size();
                }
                added = list3.add(resourceItem);
            }
            if (list3 != null) {
                this.mySize += list3.size() - oldSize;
            }
            return added;
        }

        @Override
        public boolean putAll(Multimap<? extends String, ? extends ResourceItem> multimap) {
            for (Map.Entry<? extends String, Collection<? extends ResourceItem>> entry : multimap.asMap().entrySet()) {
                String key = entry.getKey();
                Collection<? extends ResourceItem> items = entry.getValue();
                if (items.isEmpty()) continue;
                List list2 = this.myMap.computeIfAbsent(key, k2 -> new PerConfigResourceList());
                int oldSize = list2.size();
                list2.addAll(items);
                this.mySize += list2.size() - oldSize;
            }
            return !multimap.isEmpty();
        }

        @Override
        public List<ResourceItem> replaceValues(String key, Iterable<? extends ResourceItem> values2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Collection<ResourceItem>> asMap() {
            return this.myMap;
        }

        private class Values
        extends AbstractCollection<ResourceItem> {
            private Values() {
            }

            @Override
            public Iterator<ResourceItem> iterator() {
                return new ValuesIterator();
            }

            @Override
            public int size() {
                return PerConfigResourceMap.this.mySize;
            }

            private class ValuesIterator
            implements Iterator<ResourceItem> {
                private final Iterator<List<ResourceItem>> myOuterCursor;
                private List<ResourceItem> myCurrentList;
                private int myInnerCursor;

                private ValuesIterator() {
                    this.myOuterCursor = PerConfigResourceMap.this.myMap.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.myCurrentList != null || this.myOuterCursor.hasNext();
                }

                @Override
                public ResourceItem next() {
                    if (this.myCurrentList == null) {
                        this.myCurrentList = this.myOuterCursor.next();
                        this.myInnerCursor = 0;
                    }
                    try {
                        ResourceItem item = this.myCurrentList.get(this.myInnerCursor);
                        if (++this.myInnerCursor >= this.myCurrentList.size()) {
                            this.myCurrentList = null;
                        }
                        return item;
                    }
                    catch (IndexOutOfBoundsException e2) {
                        throw new NoSuchElementException();
                    }
                }
            }
        }

        private class PerConfigResourceList
        extends AbstractList<ResourceItem> {
            private final List<List<ResourceItem>> myResourceItems = new ArrayList<List<ResourceItem>>();

            private PerConfigResourceList() {
            }

            @Override
            public ResourceItem get(int index2) {
                return this.myResourceItems.get(index2).get(0);
            }

            @Override
            public int size() {
                return this.myResourceItems.size();
            }

            @Override
            public boolean add(ResourceItem item) {
                this.add(item, 0);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends ResourceItem> items) {
                if (items.isEmpty()) {
                    return false;
                }
                if (items.size() == 1) {
                    return this.add(items.iterator().next());
                }
                List<ResourceItem> sortedItems = this.sortedItems(items);
                int start = 0;
                for (ResourceItem item : sortedItems) {
                    start = this.add(item, start);
                }
                return true;
            }

            private int add(ResourceItem item, int start) {
                int index2 = this.findConfigIndex(item, start, this.myResourceItems.size());
                if (index2 < 0) {
                    this.myResourceItems.add(index2 ^= 0xFFFFFFFF, new SmartList<ResourceItem>(item));
                } else {
                    List<ResourceItem> nested = this.myResourceItems.get(index2);
                    int i2 = nested.size();
                    while (--i2 >= 0 && PerConfigResourceMap.this.myComparator.myPriorityComparator.compare(item, nested.get(i2)) <= 0) {
                    }
                    nested.add(i2 + 1, item);
                }
                return index2;
            }

            @Override
            public void clear() {
                this.myResourceItems.clear();
            }

            @Override
            public boolean remove(Object item) {
                assert (item != null);
                int index2 = this.remove((ResourceItem)item, this.myResourceItems.size());
                return index2 >= 0;
            }

            @Override
            public boolean removeAll(Collection<?> items) {
                if (items.isEmpty()) {
                    return false;
                }
                if (items.size() == 1) {
                    return this.remove(items.iterator().next());
                }
                List<ResourceItem> itemsToDelete = this.sortedItems(items);
                boolean modified = false;
                int end = this.myResourceItems.size();
                int i2 = itemsToDelete.size();
                while (--i2 >= 0) {
                    int index2 = this.remove(itemsToDelete.get(i2), end);
                    if (index2 > 0) {
                        modified = true;
                        end = index2;
                        continue;
                    }
                    end = ~index2;
                }
                return modified;
            }

            @Override
            public boolean removeIf(Predicate<? super ResourceItem> filter2) {
                boolean removed = false;
                int i2 = this.myResourceItems.size();
                while (--i2 >= 0) {
                    List<ResourceItem> nested = this.myResourceItems.get(i2);
                    int j2 = nested.size();
                    while (--j2 >= 0) {
                        ResourceItem item = nested.get(j2);
                        if (!filter2.test(item)) continue;
                        nested.remove(j2);
                        removed = true;
                    }
                    if (!nested.isEmpty()) continue;
                    this.myResourceItems.remove(i2);
                }
                return removed;
            }

            private int remove(ResourceItem item, int end) {
                int index2 = this.findConfigIndex(item, 0, end);
                if (index2 < 0) {
                    return index2;
                }
                List<ResourceItem> nested = this.myResourceItems.get(index2);
                if (!nested.remove(item)) {
                    return ~(index2 + 1);
                }
                if (nested.isEmpty()) {
                    this.myResourceItems.remove(index2);
                    return index2;
                }
                return index2 + 1;
            }

            private List<ResourceItem> sortedItems(Collection<? extends ResourceItem> items) {
                ArrayList<ResourceItem> sortedItems = new ArrayList<ResourceItem>(items);
                sortedItems.sort(PerConfigResourceMap.this.myComparator);
                return sortedItems;
            }

            private int findConfigIndex(ResourceItem item, int start, int end) {
                FolderConfiguration config = item.getConfiguration();
                int low = start;
                int high = end;
                while (low < high) {
                    int mid = low + high >>> 1;
                    FolderConfiguration value = this.myResourceItems.get(mid).get(0).getConfiguration();
                    int c2 = value.compareTo(config);
                    if (c2 < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (c2 > 0) {
                        high = mid;
                        continue;
                    }
                    return mid;
                }
                return ~low;
            }
        }
    }
}

