/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res.ids;

import com.android.resources.ResourceType;
import com.android.tools.res.ids.ResourceIdManagerBaseKt;
import com.android.tools.res.ids.SingleNamespaceIdMapping;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a&\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"FIRST_PACKAGE_ID", "", "buildResourceId", "", "packageId", "typeId", "entryId", "", "loadIdsFromResourceClass", "", "klass", "Ljava/lang/Class;", "into", "Lcom/android/tools/res/ids/SingleNamespaceIdMapping;", "lookForAttrsInStyleables", "", "unnamed"})
@SourceDebugExtension(value={"SMAP\nResourceIdManagerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceIdManagerBase.kt\ncom/android/tools/res/ids/ResourceIdManagerBaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,311:1\n1#2:312\n372#3,7:313\n372#3,7:320\n*S KotlinDebug\n*F\n+ 1 ResourceIdManagerBase.kt\ncom/android/tools/res/ids/ResourceIdManagerBaseKt\n*L\n85#1:313,7\n97#1:320,7\n*E\n"})
public final class ResourceIdManagerBaseKt {
    private static final byte FIRST_PACKAGE_ID = 2;

    @VisibleForTesting
    public static final int buildResourceId(byte packageId, byte typeId, short entryId) {
        return packageId << 24 | typeId << 16 | entryId & 0xFFFF;
    }

    private static final void loadIdsFromResourceClass(Class<?> klass, SingleNamespaceIdMapping into, boolean lookForAttrsInStyleables) {
        boolean bl2 = Intrinsics.areEqual(klass.getSimpleName(), "R");
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Numeric ids can only be loaded from top-level R classes.";
            throw new AssertionError((Object)string2);
        }
        Comparator fieldOrdering2 = loadIdsFromResourceClass.fieldOrdering.1.INSTANCE;
        Class<?>[] classArray = klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, "klass.declaredClasses");
        for (Class<?> innerClass : classArray) {
            Object object;
            Int2ObjectOpenHashMap<Pair<ResourceType, String>> fromIdMap;
            Object2IntOpenHashMap toIdMap;
            Map $this$getOrPut$iv;
            ResourceType type;
            if (ResourceType.fromClassName(innerClass.getSimpleName()) == null) continue;
            if (type != ResourceType.STYLEABLE) {
                Object object2;
                $this$getOrPut$iv = into.getToIdMap();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get((Object)type);
                if (value$iv == null) {
                    boolean bl4 = false;
                    Object2IntOpenHashMap answer$iv = new Object2IntOpenHashMap();
                    $this$getOrPut$iv.put(type, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                toIdMap = (Object2IntOpenHashMap)object2;
                fromIdMap = into.getFromIdMap();
                Intrinsics.checkNotNullExpressionValue(innerClass.getDeclaredFields(), "innerClass.declaredFields");
                for (Field field : $i$f$getOrPut) {
                    if (!Intrinsics.areEqual(field.getType(), Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                    int id2 = field.getInt(null);
                    String name2 = field.getName();
                    toIdMap.put(name2, id2);
                    fromIdMap.put(id2, new Pair<ResourceType, String>(type, name2));
                }
                continue;
            }
            if (type != ResourceType.STYLEABLE || !lookForAttrsInStyleables) continue;
            fromIdMap = (Int2ObjectOpenHashMap<Pair<ResourceType, String>>)((Object)into.getToIdMap());
            ResourceType key$iv = ResourceType.ATTR;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
            if (value$iv == null) {
                boolean bl5 = false;
                Object2IntOpenHashMap answer$iv = new Object2IntOpenHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            toIdMap = (Object2IntOpenHashMap)object;
            fromIdMap = into.getFromIdMap();
            int[] currentArray = new int[]{};
            String currentStyleable = "";
            Field[] fieldArray = innerClass.getFields();
            Intrinsics.checkNotNullExpressionValue(fieldArray, "innerClass.fields");
            for (Field field : (Field[])ArraysKt.sortedArrayWith((Object[])fieldArray, fieldOrdering2)) {
                String attrName;
                String string3;
                if (field.getType().isArray()) {
                    Object object3 = field.get(null);
                    Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.IntArray");
                    currentArray = (int[])object3;
                    Intrinsics.checkNotNullExpressionValue(field.getName(), "field.name");
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(field.getName(), "field.name");
                int n2 = currentStyleable.length() + 1;
                Intrinsics.checkNotNullExpressionValue(string3.substring(n2), "substring(...)");
                int attrId = currentArray[field.getInt(null)];
                toIdMap.put(attrName, attrId);
                fromIdMap.put(attrId, new Pair<ResourceType, String>(ResourceType.ATTR, attrName));
            }
        }
    }

    static /* synthetic */ void loadIdsFromResourceClass$default(Class clazz, SingleNamespaceIdMapping singleNamespaceIdMapping, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        ResourceIdManagerBaseKt.loadIdsFromResourceClass(clazz, singleNamespaceIdMapping, bl2);
    }

    public static final /* synthetic */ void access$loadIdsFromResourceClass(Class klass, SingleNamespaceIdMapping into, boolean lookForAttrsInStyleables) {
        ResourceIdManagerBaseKt.loadIdsFromResourceClass(klass, into, lookForAttrsInStyleables);
    }
}

