/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.Annotations;

public class AndroidPlatform {
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;

    public AndroidPlatform(AndroidSdkData sdkData, IAndroidTarget target) {
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AndroidPlatform platform = (AndroidPlatform)o2;
        if (!this.mySdkData.equals(platform.mySdkData)) {
            return false;
        }
        return this.myTarget.equals(platform.myTarget);
    }

    public int hashCode() {
        int result2 = this.mySdkData.hashCode();
        result2 = 31 * result2 + this.myTarget.hashCode();
        return result2;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return Annotations.needsAnnotationsJarInClasspath(this.myTarget);
    }

    public int getApiLevel() {
        return this.myTarget.getVersion().getApiLevel();
    }

    public AndroidVersion getApiVersion() {
        return this.myTarget.getVersion();
    }
}

