/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.sdk.AndroidSdkPath;
import com.android.tools.sdk.DeviceManagers;
import com.android.tools.sdk.LoggerProgressIndicator;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public class AndroidSdkData {
    private final DeviceManager myDeviceManager;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private final AndroidSdkHandler mySdkHandler;

    public static AndroidSdkData getSdkData(File sdkLocation) {
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    public static AndroidSdkData getSdkData(File sdkLocation, boolean forceReparse) {
        return AndroidSdkData.getSdkData(sdkLocation, forceReparse, true);
    }

    public static AndroidSdkData getSdkDataWithoutValidityCheck(File sdkLocation) {
        return Objects.requireNonNull(AndroidSdkData.getSdkData(sdkLocation, false, false));
    }

    private static AndroidSdkData getSdkData(File sdkLocation, boolean forceReparse, boolean checkValidity) {
        SoftReference cachedRef;
        String canonicalPath;
        try {
            canonicalPath = sdkLocation.getCanonicalPath();
        }
        catch (IOException ignore) {
            if (checkValidity) {
                return null;
            }
            canonicalPath = sdkLocation.getPath();
        }
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        File canonicalLocation = new File(canonicalPath);
        if (checkValidity && !AndroidSdkPath.isValid(canonicalLocation)) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, new SoftReference<AndroidSdkData>(sdkData));
        return sdkData;
    }

    public static AndroidSdkData getSdkData(String sdkPath) {
        return AndroidSdkData.getSdkData(new File(sdkPath));
    }

    private AndroidSdkData(File localSdk) {
        this.mySdkHandler = AndroidSdkHandler.getInstance(AndroidLocationsSingleton.INSTANCE, localSdk.toPath());
        this.myDeviceManager = DeviceManagers.getDeviceManager(this.mySdkHandler);
    }

    public Path getLocation() {
        Path location = this.mySdkHandler.getLocation();
        assert (location != null);
        return location;
    }

    public File getLocationFile() {
        return this.mySdkHandler.getLocation().toFile();
    }

    @Deprecated
    public String getPath() {
        return this.getLocation().toString();
    }

    public BuildToolInfo getLatestBuildTool(boolean allowPreview) {
        return this.mySdkHandler.getLatestBuildTool(new LoggerProgressIndicator(this.getClass()), allowPreview);
    }

    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        return targets.toArray(new IAndroidTarget[0]);
    }

    private Collection<IAndroidTarget> getTargetCollection() {
        LoggerProgressIndicator progress = new LoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager(progress).getTargets(progress);
    }

    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList<IAndroidTarget> result2 = new ArrayList<IAndroidTarget>();
        if (!includeAddOns) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform()) continue;
                result2.add(target);
            }
        } else {
            result2.addAll(targets);
        }
        return result2.toArray(new IAndroidTarget[0]);
    }

    private static boolean targetHasId(IAndroidTarget target, String id2) {
        return id2.equals(target.getVersion().getApiString()) || id2.equals(target.getVersionName());
    }

    public IAndroidTarget findTargetByApiLevel(String apiLevel) {
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkData.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    public IAndroidTarget findTargetByHashString(String hashString) {
        LoggerProgressIndicator progress = new LoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager(progress).getTargetFromHashString(hashString, progress);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return this.getLocation().normalize().toAbsolutePath().toString().equals(sdkData.getLocation().normalize().toAbsolutePath().toString());
    }

    public int hashCode() {
        return this.getLocation().normalize().toAbsolutePath().toString().hashCode();
    }

    public DeviceManager getDeviceManager() {
        return this.myDeviceManager;
    }

    public AndroidSdkHandler getSdkHandler() {
        return this.mySdkHandler;
    }
}

