/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.io.CancellableFileIo;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class SdkPaths {
    private SdkPaths() {
    }

    public static ValidationResult validateAndroidSdk(Path sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @Deprecated
    public static ValidationResult validateAndroidSdk(File sdkFile, boolean includePathInMessage) {
        return SdkPaths.validateAndroidSdk(sdkFile == null ? null : sdkFile.toPath(), includePathInMessage);
    }

    public static ValidationResult validatedSdkPath(Path sdkPath, String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkPath == null) {
            return ValidationResult.error("");
        }
        String cause = null;
        if (!CancellableFileIo.isDirectory(sdkPath, new LinkOption[0])) {
            cause = "does not belong to a directory.";
        } else if (!CancellableFileIo.isReadable(sdkPath)) {
            cause = "is not readable.";
        } else if (checkForWritable && !CancellableFileIo.isWritable(sdkPath)) {
            cause = "is not writable.";
        }
        if (!Strings.isNullOrEmpty(cause)) {
            String message2 = includePathInMessage ? String.format("The %1$s path\n'%2$s'\n%3$s", sdkName, sdkPath, cause) : String.format("The %1$s path %2$s", sdkName, cause);
            return ValidationResult.error(message2);
        }
        Path platformsDirPath = sdkPath.resolve("platforms");
        if (!CancellableFileIo.isDirectory(platformsDirPath, new LinkOption[0])) {
            String message3 = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath) : String.format("%1$s does not contain any platforms.", sdkName);
            return ValidationResult.error(message3);
        }
        return ValidationResult.SUCCESS;
    }

    public static class ValidationResult {
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        public final String message;

        public static ValidationResult error(String message2) {
            return new ValidationResult(false, message2);
        }

        private ValidationResult(boolean success, String message2) {
            this.success = success;
            this.message = message2;
        }
    }
}

