/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.XmlUtils;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u0004H\u0086\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0004\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0004\u001a\u001e\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010\u001a\u001e\u0010\u0012\u001a\u00020\u000e*\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0010\u00a8\u0006\u0013"}, d2={"childrenIterator", "", "Lorg/w3c/dom/Node;", "iterator", "Lorg/w3c/dom/Element;", "next", "tag", "", "subtag", "subtagCount", "", "subtags", "text", "visitAttributes", "", "visitor", "Lkotlin/Function1;", "Lorg/w3c/dom/Attr;", "visitElements", "common"})
@JvmName(name="DomExtensions")
public final class DomExtensions {
    @NotNull
    public static final Iterator<Element> iterator(@NotNull Element $this$iterator) {
        Intrinsics.checkNotNullParameter($this$iterator, "<this>");
        return new Iterator<Element>($this$iterator){
            @Nullable
            private Element next;
            {
                this.next = this.findNextElement($receiver.getFirstChild());
            }

            @Nullable
            public final Element getNext() {
                return this.next;
            }

            public final void setNext(@Nullable Element element) {
                this.next = element;
            }

            private final Element findNextElement(Node node) {
                for (Node curr = node; curr != null; curr = curr.getNextSibling()) {
                    if (!(curr instanceof Element)) continue;
                    return (Element)curr;
                }
                return null;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            @NotNull
            public Element next() {
                Element result2 = this.next;
                Element element = this.next;
                this.next = this.findNextElement(element != null ? element.getNextSibling() : null);
                Element element2 = result2;
                if (element2 == null) {
                    throw new IllegalStateException("hasNext is false".toString());
                }
                return element2;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public static final Iterator<Node> childrenIterator(@NotNull Node $this$childrenIterator) {
        Intrinsics.checkNotNullParameter($this$childrenIterator, "<this>");
        return new Iterator<Node>($this$childrenIterator){
            private Node current;
            {
                this.current = $receiver.getFirstChild();
            }

            public boolean hasNext() {
                return this.current != null;
            }

            @NotNull
            public Node next() {
                Node next = this.current;
                Node node = this.current;
                Intrinsics.checkNotNull(node);
                this.current = node.getNextSibling();
                Intrinsics.checkNotNullExpressionValue(next, "next");
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Nullable
    public static final Element subtag(@NotNull Element $this$subtag, @NotNull String tag) {
        Intrinsics.checkNotNullParameter($this$subtag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        return XmlUtils.getFirstSubTagByName($this$subtag, tag);
    }

    @Nullable
    public static final Element next(@NotNull Element $this$next) {
        Intrinsics.checkNotNullParameter($this$next, "<this>");
        return XmlUtils.getNextTag($this$next);
    }

    @Nullable
    public static final Element next(@NotNull Element $this$next, @NotNull String tag) {
        Intrinsics.checkNotNullParameter($this$next, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        return XmlUtils.getNextTagByName($this$next, tag);
    }

    @NotNull
    public static final Iterator<Element> subtags(@NotNull Element $this$subtags, @NotNull String tag) {
        Intrinsics.checkNotNullParameter($this$subtags, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        return XmlUtils.getSubTagsByName($this$subtags, tag).iterator();
    }

    public static final int subtagCount(@NotNull Element $this$subtagCount) {
        Intrinsics.checkNotNullParameter($this$subtagCount, "<this>");
        return XmlUtils.getSubTagCount($this$subtagCount);
    }

    @NotNull
    public static final String text(@NotNull Element $this$text) {
        Intrinsics.checkNotNullParameter($this$text, "<this>");
        String string2 = $this$text.getTextContent();
        Intrinsics.checkNotNullExpressionValue(string2, "textContent");
        return string2;
    }

    public static final boolean visitAttributes(@NotNull Element $this$visitAttributes, @NotNull Function1<? super Attr, Boolean> visitor) {
        Intrinsics.checkNotNullParameter($this$visitAttributes, "<this>");
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        NamedNodeMap attributes = $this$visitAttributes.getAttributes();
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node attr = attributes.item(i2);
            Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type org.w3c.dom.Attr");
            boolean done = visitor.invoke((Attr)attr);
            if (!done) continue;
            return true;
        }
        for (Node child = $this$visitAttributes.getFirstChild(); child != null; child = child.getNextSibling()) {
            boolean done;
            if (child.getNodeType() != 1 || !(done = DomExtensions.visitAttributes((Element)child, visitor))) continue;
            return true;
        }
        return false;
    }

    public static final boolean visitElements(@NotNull Element $this$visitElements, @NotNull Function1<? super Element, Boolean> visitor) {
        Intrinsics.checkNotNullParameter($this$visitElements, "<this>");
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        if (visitor.invoke($this$visitElements).booleanValue()) {
            return true;
        }
        for (Node child = $this$visitElements.getFirstChild(); child != null; child = child.getNextSibling()) {
            boolean done;
            if (child.getNodeType() != 1 || !(done = DomExtensions.visitElements((Element)child, visitor))) continue;
            return true;
        }
        return false;
    }
}

