/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.management.ManagementFactory;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class JvmWideVariable<T> {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[^\\s:=,]+");
    private static final ConcurrentMap<String, AtomicReference<Object>> variableTable = JvmWideVariable.createVariableTableIfNotExists();
    private final String fullName;
    private boolean unregistered;

    public JvmWideVariable(String group, String name2, String tag, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        String fullName = JvmWideVariable.getFullName(group, name2, tag);
        JvmWideVariable.verifyBootstrapLoadedType(typeToken.getType(), fullName);
        this.fullName = fullName;
        this.unregistered = false;
        variableTable.computeIfAbsent(fullName, any2 -> new AtomicReference(initialValueSupplier.get()));
    }

    public JvmWideVariable(Class<?> definingClass, String name2, Class<T> type, T initialValue) {
        this(definingClass.getName(), name2, type.getName(), TypeToken.of(type), () -> initialValue);
    }

    public JvmWideVariable(Class<?> definingClass, String name2, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        this(definingClass.getName(), name2, JvmWideVariable.collectComponentClasses(typeToken.getType()).stream().map(Class::getName).collect(Collectors.joining("-")), typeToken, initialValueSupplier);
    }

    public JvmWideVariable(String group, String name2, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        this(group, name2, JvmWideVariable.collectComponentClasses(typeToken.getType()).stream().map(Class::getName).collect(Collectors.joining("-")), typeToken, initialValueSupplier);
    }

    @VisibleForTesting
    static String getFullName(String group, String name2, String tag) {
        Preconditions.checkArgument(VALID_NAME_PATTERN.matcher(group).matches());
        Preconditions.checkArgument(VALID_NAME_PATTERN.matcher(name2).matches());
        Preconditions.checkArgument(VALID_NAME_PATTERN.matcher(tag).matches());
        return group + ":name=" + name2 + ",tag=" + tag;
    }

    private static void verifyBootstrapLoadedType(Type type, String variable) {
        for (Class<?> clazz : JvmWideVariable.collectComponentClasses(type)) {
            Verify.verify(clazz.getClassLoader() == null, "Type %s used to define JVM-wide variable %s must be loaded by the bootstrap class loader but is loaded by %s", clazz, (Object)variable, (Object)clazz.getClassLoader());
        }
    }

    @VisibleForTesting
    static Collection<Class<?>> collectComponentClasses(Type type) {
        ImmutableSet.Builder<Class<?>> builder = ImmutableSet.builder();
        JvmWideVariable.doCollectComponentClasses(type, builder);
        return builder.build();
    }

    private static void doCollectComponentClasses(Type type, ImmutableSet.Builder<Class<?>> builder) {
        if (type instanceof Class) {
            builder.add((Object)((Class)type));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JvmWideVariable.doCollectComponentClasses(parameterizedType.getRawType(), builder);
            if (parameterizedType.getOwnerType() != null) {
                JvmWideVariable.doCollectComponentClasses(parameterizedType.getOwnerType(), builder);
            }
            for (Type componentType : parameterizedType.getActualTypeArguments()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else if (type instanceof GenericArrayType) {
            JvmWideVariable.doCollectComponentClasses(((GenericArrayType)type).getGenericComponentType(), builder);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type componentType : wildcardType.getLowerBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
            for (Type componentType : wildcardType.getUpperBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " is not yet supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, AtomicReference<Object>> createVariableTableIfNotExists() {
        ConcurrentMap variableTable;
        ObjectName objectName;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Type type = new TypeToken<ConcurrentMap<String, AtomicReference<Object>>>(){}.getType();
        String tag = JvmWideVariable.collectComponentClasses(type).stream().map(Class::getName).collect(Collectors.joining("-"));
        try {
            objectName = new ObjectName(JvmWideVariable.getFullName("JvmWideVariable", "variableTable", tag));
        }
        catch (MalformedObjectNameException e2) {
            throw new RuntimeException(e2);
        }
        MBeanServer e2 = server;
        synchronized (e2) {
            if (!server.isRegistered(objectName)) {
                ValueWrapper valueWrapper = new ValueWrapper(new ConcurrentHashMap());
                try {
                    server.registerMBean(valueWrapper, objectName);
                }
                catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
        try {
            variableTable = (ConcurrentMap)server.getAttribute(objectName, "Value");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e4) {
            throw new RuntimeException(e4);
        }
        return Verify.verifyNotNull(variableTable);
    }

    private AtomicReference<T> getVariable() {
        Verify.verify(!this.unregistered, "This JwmWideVariable instance was used to access JVM-wide variable %s, but has already been unregistered", (Object)this.fullName);
        return Verify.verifyNotNull((AtomicReference)variableTable.get(this.fullName), "JVM-wide variable %s has already been unregistered", this.fullName);
    }

    public T get() {
        return this.getVariable().get();
    }

    public void set(T value) {
        this.getVariable().set(value);
    }

    public <V> V executeCallableSynchronously(Callable<V> action2) throws ExecutionException {
        AtomicReference<T> atomicReference = this.getVariable();
        synchronized (atomicReference) {
            try {
                return action2.call();
            }
            catch (Exception e2) {
                throw new ExecutionException(e2);
            }
        }
    }

    public <V> V executeSupplierSynchronously(Supplier<V> action2) {
        try {
            return (V)this.executeCallableSynchronously(action2::get);
        }
        catch (ExecutionException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void executeRunnableSynchronously(Runnable action2) {
        this.executeSupplierSynchronously(() -> {
            action2.run();
            return null;
        });
    }

    public void unregister() {
        Verify.verify(!this.unregistered, "This JwmWideVariable instance was used to access JVM-wide variable %s, but has already been unregistered", (Object)this.fullName);
        Verify.verifyNotNull((AtomicReference)variableTable.remove(this.fullName), "JVM-wide variable %s has already been unregistered", this.fullName);
        this.unregistered = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fullName", this.fullName).add("unregistered", this.unregistered).toString();
    }

    public static <K, V> V getJvmWideObjectPerKey(Class<?> definingClass, String variableName, TypeToken<K> keyType, TypeToken<V> valueType, K key, Supplier<V> newObjectSupplier) {
        ConcurrentMap keyToObjectMap = Verify.verifyNotNull(new JvmWideVariable<ConcurrentMap>(definingClass, variableName, new TypeToken<ConcurrentMap<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType), ConcurrentHashMap::new).get());
        return (V)keyToObjectMap.computeIfAbsent(key, any2 -> Verify.verifyNotNull(newObjectSupplier.get()));
    }

    private static final class ValueWrapper<T>
    implements ValueWrapperMBean<T> {
        private final T value;

        public ValueWrapper(T value) {
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static interface ValueWrapperMBean<T> {
        public static final String VALUE_PROPERTY = "Value";

        public T getValue();
    }
}

