/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.ProgressManagerAdapter;
import com.android.ide.common.blame.SourcePosition;
import com.android.utils.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class PositionXmlParser {
    private static final String UTF_16 = "UTF_16";
    private static final String UTF_16LE = "UTF_16LE";
    public static final String CONTENT_KEY = "contents";
    private static final String POS_KEY = "offsets";
    private static final int CDATA_PREFIX_LENGTH = "<![CDATA[".length();
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=['\"](\\S*)['\"]");
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final SAXParserFactory SAX_PARSER_FACTORY;
    private static final SAXParserFactory NAMESPACE_AWARE_SAX_PARSER_FACTORY;

    public static Document parse(InputStream input2, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        return PositionXmlParser.parse(PositionXmlParser.readAllBytes(input2), namespaceAware, DOCUMENT_BUILDER_FACTORY);
    }

    public static Document parse(InputStream input2, boolean namespaceAware, DocumentBuilderFactory factory) throws ParserConfigurationException, SAXException, IOException {
        return PositionXmlParser.parse(PositionXmlParser.readAllBytes(input2), namespaceAware, factory);
    }

    public static Document parse(InputStream input2, boolean namespaceAware, List<String> parseErrors) throws ParserConfigurationException, IOException {
        return PositionXmlParser.parse(PositionXmlParser.readAllBytes(input2), namespaceAware, parseErrors);
    }

    public static Document parse(InputStream input2) throws IOException, SAXException, ParserConfigurationException {
        return PositionXmlParser.parse(input2, true);
    }

    public static Document parse(InputStream input2, DocumentBuilderFactory factory) throws IOException, SAXException, ParserConfigurationException {
        return PositionXmlParser.parse(input2, true, factory);
    }

    public static Document parse(byte[] data) throws ParserConfigurationException, SAXException, IOException {
        return PositionXmlParser.parse(data, true, DOCUMENT_BUILDER_FACTORY);
    }

    public static Document parse(String xml) throws ParserConfigurationException, SAXException, IOException {
        return PositionXmlParser.parse(xml, true);
    }

    public static Document parse(byte[] data, boolean namespaceAware, DocumentBuilderFactory factory) throws ParserConfigurationException, SAXException, IOException {
        String xml = PositionXmlParser.getXmlString(data);
        xml = XmlUtils.stripBom(xml);
        return PositionXmlParser.parseInternal(xml, namespaceAware, factory);
    }

    public static Document parse(byte[] data, boolean namespaceAware, List<String> parseErrors) throws ParserConfigurationException, IOException {
        String xml = PositionXmlParser.getXmlString(data);
        xml = XmlUtils.stripBom(xml);
        return PositionXmlParser.parseInternal(xml, namespaceAware, parseErrors);
    }

    public static Document parse(String xml, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        xml = XmlUtils.stripBom(xml);
        return PositionXmlParser.parseInternal(xml, namespaceAware, DOCUMENT_BUILDER_FACTORY);
    }

    private static Document parseInternal(String xml, boolean namespaceAware, DocumentBuilderFactory factory) throws ParserConfigurationException, SAXException, IOException {
        DomBuilder domBuilder;
        boolean retry2 = false;
        while (true) {
            domBuilder = new DomBuilder(xml, factory);
            try {
                PositionXmlParser.parseInternal(xml, namespaceAware, domBuilder);
            }
            catch (SAXException e2) {
                if (retry2 || !e2.getMessage().contains("Content is not allowed in prolog")) {
                    throw e2;
                }
                xml = xml.replaceFirst("^([\\W]+)<", "<");
                retry2 = true;
                continue;
            }
            break;
        }
        return domBuilder.getDocument();
    }

    private static Document parseInternal(String xml, boolean namespaceAware, List<String> parseErrors) throws ParserConfigurationException, IOException {
        DomBuilder domBuilder;
        boolean retry2 = false;
        while (true) {
            domBuilder = new DomBuilder(xml, DOCUMENT_BUILDER_FACTORY);
            try {
                PositionXmlParser.parseInternal(xml, namespaceAware, domBuilder);
            }
            catch (SAXException e2) {
                if (retry2 || !e2.getMessage().contains("Content is not allowed in prolog")) {
                    parseErrors.add(e2.getLocalizedMessage());
                    domBuilder.closeUnfinishedElements();
                    break;
                }
                xml = xml.replaceFirst("^([\\W]+)<", "<");
                retry2 = true;
                continue;
            }
            break;
        }
        return domBuilder.getDocument();
    }

    private static void parseInternal(String xml, boolean namespaceAware, DefaultHandler handler) throws ParserConfigurationException, IOException, SAXException {
        SAXParserFactory factory = namespaceAware ? NAMESPACE_AWARE_SAX_PARSER_FACTORY : SAX_PARSER_FACTORY;
        SAXParser parser = XmlUtils.createSaxParser(factory, true);
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        parser.parse(PositionXmlParser.createSource(xml), handler);
    }

    private static byte[] readAllBytes(InputStream input2) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try (InputStream stream = input2;){
            while (true) {
                ProgressManagerAdapter.checkCanceled();
                int r2 = stream.read(buf);
                if (r2 == -1) {
                    break;
                }
                out.write(buf, 0, r2);
            }
        }
        return out.toByteArray();
    }

    private static InputSource createSource(String xml) {
        return new InputSource(new StringReader(xml));
    }

    public static String getXmlString(byte[] data) {
        return PositionXmlParser.getXmlString(data, "UTF-8");
    }

    public static String getXmlString(byte[] data, String defaultCharset) {
        int offset = 0;
        String charset = null;
        if (data.length > 4) {
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                charset = "UTF-8";
                defaultCharset = "UTF-8";
                offset += 3;
            } else if (data[0] == -2 && data[1] == -1) {
                charset = UTF_16;
                defaultCharset = UTF_16;
                offset += 2;
            } else if (data[0] == 0 && data[1] == 0 && data[2] == -2 && data[3] == -1) {
                charset = "UTF_32";
                defaultCharset = "UTF_32";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2 && data[2] == 0 && data[3] == 0) {
                charset = "UTF_32LE";
                defaultCharset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2) {
                charset = UTF_16LE;
                defaultCharset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        int prologueStart = -1;
        for (int lineEnd = offset; lineEnd < data.length; ++lineEnd) {
            Matcher matcher;
            if (data[lineEnd] == 0) {
                if ((lineEnd - offset) % 2 == 0) {
                    seenEvenZero = true;
                    continue;
                }
                seenOddZero = true;
                continue;
            }
            if (data[lineEnd] == 10 || data[lineEnd] == 13) break;
            if (data[lineEnd] == 60) {
                prologueStart = lineEnd;
                continue;
            }
            if (data[lineEnd] != 62) continue;
            for (int i2 = lineEnd - 4; i2 >= 0; --i2) {
                if (data[i2] != 117 && data[i2] != 85 || data[i2 + 1] != 116 && data[i2 + 1] != 84 || data[i2 + 2] != 102 && data[i2 + 2] != 70 || data[i2 + 3] != 45 && data[i2 + 3] != 95 || data[i2 + 4] != 56) continue;
                charset = "UTF-8";
                break;
            }
            if (charset != null) break;
            StringBuilder sb = new StringBuilder();
            for (int i3 = prologueStart; i3 <= lineEnd; ++i3) {
                if (data[i3] == 0) continue;
                sb.append((char)data[i3]);
            }
            String prologue = sb.toString();
            int encodingIndex = prologue.indexOf("encoding");
            if (encodingIndex == -1 || !(matcher = ENCODING_PATTERN.matcher(prologue)).find(encodingIndex)) break;
            charset = matcher.group(1);
            break;
        }
        if (charset == null) {
            charset = seenOddZero ? UTF_16LE : (seenEvenZero ? UTF_16 : defaultCharset);
        }
        String xml = null;
        try {
            xml = new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e2) {
            try {
                if (!charset.equals(defaultCharset)) {
                    xml = new String(data, offset, length, defaultCharset);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (xml == null) {
            xml = new String(data, offset, length);
        }
        return xml;
    }

    public static SourcePosition getPosition(Node node) {
        return PositionXmlParser.getPosition(node, -1, -1);
    }

    public static SourcePosition getPosition(Node node, int start, int end) {
        Position p2 = PositionXmlParser.getPositionHelper(node, start, end);
        return p2 == null ? SourcePosition.UNKNOWN : p2.toSourcePosition();
    }

    public static Node findNodeAt(Node node, int offset) {
        if (node instanceof Document) {
            Element root = ((Document)node).getDocumentElement();
            if (root != null) {
                return PositionXmlParser.findNodeAtOffset(root, offset);
            }
        } else {
            return PositionXmlParser.findNodeAtOffset(node, offset);
        }
        return null;
    }

    private static Node findNodeAtOffset(Node node, int offset) {
        Position p2 = PositionXmlParser.getPositionHelper(node, -1, -1);
        if (p2 != null) {
            if (offset < p2.getOffset()) {
                return null;
            }
            Position end = p2.getEnd();
            if (end != null && offset >= end.getOffset()) {
                return null;
            }
        } else {
            return null;
        }
        NodeList children2 = node.getChildNodes();
        int n2 = children2.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node item = children2.item(i2);
            Node match2 = PositionXmlParser.findNodeAtOffset(item, offset);
            if (match2 == null) continue;
            return match2;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n3 = attributes.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Node item = attributes.item(i3);
                Node match3 = PositionXmlParser.findNodeAtOffset(item, offset);
                if (match3 == null) continue;
                return match3;
            }
        }
        return node;
    }

    public static Node findNodeAtLineAndCol(Document document, int line, int column) {
        Element root = document.getDocumentElement();
        if (root != null) {
            return PositionXmlParser.findNodeAtLineAndCol(root, line, column);
        }
        return null;
    }

    private static Node findNodeAtLineAndCol(Node node, int line, int column) {
        Position p2 = PositionXmlParser.getPositionHelper(node, -1, -1);
        if (p2 != null) {
            if (line < p2.getLine() || line == p2.getLine() && column != -1 && column < p2.getColumn()) {
                return null;
            }
            Position end = p2.getEnd();
            if (end != null && (line > end.getLine() || line == end.getLine() && column != -1 && column >= end.getColumn())) {
                return null;
            }
        } else {
            return null;
        }
        NodeList children2 = node.getChildNodes();
        int n2 = children2.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node item = children2.item(i2);
            Node match2 = PositionXmlParser.findNodeAtLineAndCol(item, line, column);
            if (match2 == null) continue;
            return match2;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n3 = attributes.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Node item = attributes.item(i3);
                Node match3 = PositionXmlParser.findNodeAtLineAndCol(item, line, column);
                if (match3 == null) continue;
                return match3;
            }
        }
        return node;
    }

    private static Position getPositionHelper(Node node, int start, int end) {
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Position pos = (Position)attr.getOwnerElement().getUserData(POS_KEY);
            if (pos != null) {
                char c2;
                int curr;
                String contents;
                int startOffset = pos.getOffset();
                int endOffset = pos.getEnd().getOffset();
                if (start != -1) {
                    startOffset += start;
                    if (end != -1) {
                        endOffset = startOffset + (end - start);
                    }
                }
                if ((contents = (String)node.getOwnerDocument().getUserData(CONTENT_KEY)) == null) {
                    return null;
                }
                String name2 = attr.getName();
                int nameLength = name2.length();
                for (curr = startOffset; curr < endOffset && !Character.isWhitespace(c2 = contents.charAt(curr)) && c2 != '/' && c2 != '>'; ++curr) {
                }
                while (curr < endOffset) {
                    boolean match2;
                    while (curr < endOffset && Character.isWhitespace(contents.charAt(curr))) {
                        ++curr;
                    }
                    if (curr == endOffset || contents.charAt(curr) == '>' || contents.charAt(curr) == '/') break;
                    int attributeStart = curr;
                    int attributeEnd = -1;
                    while (curr < endOffset) {
                        char c3 = contents.charAt(curr);
                        if (c3 == '\"' || c3 == '\'') {
                            attributeEnd = contents.indexOf(c3, curr + 1);
                            break;
                        }
                        ++curr;
                    }
                    if (attributeEnd == -1) break;
                    ++attributeEnd;
                    boolean bl2 = match2 = contents.regionMatches(attributeStart, name2, 0, nameLength) && (Character.isWhitespace(contents.charAt(attributeStart + nameLength)) || contents.charAt(attributeStart + nameLength) == '=');
                    if (match2) {
                        int line = pos.getLine();
                        int column = pos.getColumn();
                        for (int offset = pos.getOffset(); offset < attributeStart; ++offset) {
                            char t2 = contents.charAt(offset);
                            if (t2 == '\n') {
                                ++line;
                                column = 0;
                                continue;
                            }
                            ++column;
                        }
                        Position attributePosition = new Position(line, column, attributeStart);
                        int attributeColumnEnd = column + attributeEnd - attributeStart;
                        attributePosition.setEnd(new Position(line, attributeColumnEnd, attributeEnd));
                        return attributePosition;
                    }
                    curr = attributeEnd + 1;
                }
                return pos;
            }
        } else if (node instanceof Text) {
            Position pos = null;
            if (node.getPreviousSibling() != null) {
                pos = (Position)node.getPreviousSibling().getUserData(POS_KEY);
            }
            if (pos == null) {
                pos = (Position)node.getParentNode().getUserData(POS_KEY);
            }
            if (pos != null) {
                int startOffset = pos.getOffset();
                int endOffset = pos.getEnd().getOffset();
                int line = pos.getLine();
                int column = pos.getColumn();
                String contents = (String)node.getOwnerDocument().getUserData(CONTENT_KEY);
                if (contents == null || contents.length() < endOffset) {
                    return null;
                }
                boolean inAttribute = false;
                for (int offset = startOffset; offset <= endOffset; ++offset) {
                    char c4 = contents.charAt(offset);
                    if (c4 == '>' && !inAttribute) {
                        char t3;
                        int textIndex;
                        ++offset;
                        ++column;
                        if (node instanceof CDATASection) {
                            c4 = contents.charAt(offset);
                            while (Character.isWhitespace(c4) || c4 == '\n') {
                                if (c4 == '\n') {
                                    ++line;
                                    column = 0;
                                }
                                c4 = contents.charAt(++offset);
                            }
                            if (contents.regionMatches(offset, "<![CDATA[", 0, CDATA_PREFIX_LENGTH)) {
                                offset += CDATA_PREFIX_LENGTH;
                                column += CDATA_PREFIX_LENGTH;
                            }
                        }
                        String text = node.getNodeValue();
                        int textLength = text.length();
                        int newLine = line;
                        int newColumn = column;
                        if (start != -1) {
                            textLength = Math.min(textLength, start);
                            for (textIndex = 0; textIndex < textLength; ++textIndex) {
                                t3 = text.charAt(textIndex);
                                if (t3 == '\n') {
                                    ++newLine;
                                    newColumn = 0;
                                    continue;
                                }
                                ++newColumn;
                            }
                        } else {
                            while (textIndex < textLength) {
                                t3 = text.charAt(textIndex);
                                if (t3 == '\n') {
                                    ++newLine;
                                    newColumn = 0;
                                } else {
                                    if (!Character.isWhitespace(t3)) break;
                                    ++newColumn;
                                }
                                ++textIndex;
                            }
                        }
                        if (textIndex == text.length()) {
                            textIndex = 0;
                        } else {
                            line = newLine;
                            column = newColumn;
                        }
                        Position attributePosition = new Position(line, column, offset + textIndex);
                        if (end != -1) {
                            attributePosition.setEnd(new Position(line, column, offset + end));
                        } else {
                            for (int i2 = textLength - 1; i2 >= 0; --i2) {
                                if (Character.isWhitespace(text.charAt(i2))) continue;
                                textLength = i2 + 1;
                                break;
                            }
                            endOffset = offset + textIndex;
                            int endLine = line;
                            int endColumn = column;
                            while (textIndex < textLength) {
                                char t4 = text.charAt(textIndex);
                                if (t4 == '\n') {
                                    ++endLine;
                                    endColumn = 0;
                                } else {
                                    ++endColumn;
                                }
                                ++endOffset;
                                ++textIndex;
                            }
                            attributePosition.setEnd(new Position(endLine, endColumn, endOffset));
                        }
                        return attributePosition;
                    }
                    if (c4 == '\"') {
                        inAttribute = !inAttribute;
                    } else if (c4 == '\n') {
                        ++line;
                        column = -1;
                    }
                    ++column;
                }
                return pos;
            }
        }
        return (Position)node.getUserData(POS_KEY);
    }

    private PositionXmlParser() {
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        DOCUMENT_BUILDER_FACTORY.setValidating(false);
        SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
        XmlUtils.configureSaxFactory(SAX_PARSER_FACTORY, false, false);
        NAMESPACE_AWARE_SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
        XmlUtils.configureSaxFactory(NAMESPACE_AWARE_SAX_PARSER_FACTORY, true, false);
    }

    private static final class DomBuilder
    extends DefaultHandler2 {
        private final String mXml;
        private final Document mDocument;
        private Locator mLocator;
        private int mCurrentLine = 0;
        private int mCurrentOffset;
        private int mCurrentColumn;
        private final List<Element> mStack = new ArrayList<Element>();
        private boolean mCdata;
        private final StringBuilder mPendingText = new StringBuilder();

        DomBuilder(String xml, DocumentBuilderFactory factory) throws ParserConfigurationException {
            this.mXml = xml;
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            this.mDocument = docBuilder.newDocument();
            this.mDocument.setUserData(PositionXmlParser.CONTENT_KEY, xml, null);
        }

        Document getDocument() {
            this.closeUnfinishedElements();
            return this.mDocument;
        }

        void closeUnfinishedElements() {
            this.flushText();
            while (!this.mStack.isEmpty()) {
                Element element = this.mStack.remove(this.mStack.size() - 1);
                Position pos = (Position)element.getUserData(PositionXmlParser.POS_KEY);
                assert (pos != null);
                pos.setEnd(this.getCurrentPosition());
                this.addNodeToParent(element);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mLocator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.flushText();
                Element element = this.mDocument.createElementNS(uri, qName);
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Attr attr;
                    if (attributes.getURI(i2) != null && !attributes.getURI(i2).isEmpty()) {
                        attr = this.mDocument.createAttributeNS(attributes.getURI(i2), attributes.getQName(i2));
                        attr.setValue(attributes.getValue(i2));
                        element.setAttributeNodeNS(attr);
                        assert (attr.getOwnerElement() == element);
                        continue;
                    }
                    attr = this.mDocument.createAttribute(attributes.getQName(i2));
                    attr.setValue(attributes.getValue(i2));
                    element.setAttributeNode(attr);
                    assert (attr.getOwnerElement() == element);
                }
                Position pos = this.getCurrentPosition();
                element.setUserData(PositionXmlParser.POS_KEY, this.findOpeningTag(pos), null);
                this.mStack.add(element);
            }
            catch (Exception t2) {
                throw new SAXException(t2);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.flushText();
            Element element = this.mStack.remove(this.mStack.size() - 1);
            Position pos = (Position)element.getUserData(PositionXmlParser.POS_KEY);
            assert (pos != null);
            pos.setEnd(this.getCurrentPosition());
            this.addNodeToParent(element);
        }

        @Override
        public void comment(char[] chars, int start, int length) throws SAXException {
            this.flushText();
            String comment = new String(chars, start, length);
            Comment domComment = this.mDocument.createComment(comment);
            Position currentPosition = this.getCurrentPosition();
            Position startPosition = this.findOpeningTag(currentPosition);
            startPosition.setEnd(currentPosition);
            domComment.setUserData(PositionXmlParser.POS_KEY, startPosition, null);
            this.addNodeToParent(domComment);
        }

        private void addNodeToParent(Node nodeToAdd) {
            if (this.mStack.isEmpty()) {
                this.mDocument.appendChild(nodeToAdd);
            } else {
                Element parent = this.mStack.get(this.mStack.size() - 1);
                parent.appendChild(nodeToAdd);
            }
        }

        private Position findOpeningTag(Position startingPosition) {
            for (int offset = startingPosition.getOffset() - 1; offset >= 0; --offset) {
                char c2 = this.mXml.charAt(offset);
                if (c2 != '<') continue;
                int line = startingPosition.getLine();
                int n2 = startingPosition.getOffset();
                for (int i2 = offset; i2 < n2; ++i2) {
                    if (this.mXml.charAt(i2) != '\n') continue;
                    --line;
                }
                int column = 0;
                int i3 = offset - 1;
                while (i3 >= 0 && this.mXml.charAt(i3) != '\n') {
                    --i3;
                    ++column;
                }
                return new Position(line, column, offset);
            }
            return startingPosition;
        }

        private Position getCurrentPosition() {
            char c2;
            int line = this.mLocator.getLineNumber() - 1;
            int column = this.mLocator.getColumnNumber() - 1;
            int xmlLength = this.mXml.length();
            while (this.mCurrentLine < line && this.mCurrentOffset < xmlLength) {
                char c3 = this.mXml.charAt(this.mCurrentOffset);
                if (c3 == '\r' && this.mCurrentOffset < xmlLength - 1) {
                    if (this.mXml.charAt(this.mCurrentOffset + 1) != '\n') {
                        ++this.mCurrentLine;
                        this.mCurrentColumn = 0;
                    }
                } else if (c3 == '\n') {
                    ++this.mCurrentLine;
                    this.mCurrentColumn = 0;
                } else {
                    ++this.mCurrentColumn;
                }
                ++this.mCurrentOffset;
            }
            for (int skip = this.mCurrentColumn; skip < column && this.mCurrentOffset != xmlLength && (c2 = this.mXml.charAt(this.mCurrentOffset)) != '\n'; ++skip) {
                ++this.mCurrentOffset;
            }
            if (this.mCurrentOffset >= xmlLength) {
                this.mCurrentOffset = xmlLength;
            }
            this.mCurrentColumn = column;
            return new Position(this.mCurrentLine, this.mCurrentColumn, this.mCurrentOffset);
        }

        @Override
        public void startCDATA() {
            this.flushText();
            this.mCdata = true;
        }

        @Override
        public void endCDATA() {
            this.flushText();
            this.mCdata = false;
        }

        @Override
        public void characters(char[] c2, int start, int length) throws SAXException {
            this.mPendingText.append(c2, start, length);
        }

        private void flushText() {
            if ((this.mPendingText.length() > 0 || this.mCdata) && !this.mStack.isEmpty()) {
                Element element = this.mStack.get(this.mStack.size() - 1);
                Text textNode = this.mCdata ? this.mDocument.createCDATASection(this.mPendingText.toString()) : this.mDocument.createTextNode(this.mPendingText.toString());
                element.appendChild(textNode);
                this.mPendingText.setLength(0);
            }
        }
    }

    private static class Position {
        private final int mLine;
        private final int mColumn;
        private final int mOffset;
        private Position mEnd;

        Position(int line, int column, int offset) {
            this.mLine = line;
            this.mColumn = column;
            this.mOffset = offset;
        }

        public int getLine() {
            return this.mLine;
        }

        public int getOffset() {
            return this.mOffset;
        }

        public int getColumn() {
            return this.mColumn;
        }

        public Position getEnd() {
            return this.mEnd;
        }

        public void setEnd(Position end) {
            this.mEnd = end;
        }

        public SourcePosition toSourcePosition() {
            int endLine = this.mLine;
            int endColumn = this.mColumn;
            int endOffset = this.mOffset;
            if (this.mEnd != null) {
                endLine = this.mEnd.getLine();
                endColumn = this.mEnd.getColumn();
                endOffset = this.mEnd.getOffset();
            }
            return new SourcePosition(this.mLine, this.mColumn, this.mOffset, endLine, endColumn, endOffset);
        }
    }
}

