/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.ArrayUtils;

public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        initialCapacity = ArrayUtils.idealIntArraySize(initialCapacity);
        this.mKeys = new int[initialCapacity];
        this.mValues = new Object[initialCapacity];
        this.mSize = 0;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 < 0 || this.mValues[i2] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i2];
    }

    public void delete(int key) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 >= 0 && this.mValues[i2] != DELETED) {
            this.mValues[i2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    private void gc() {
        int n2 = this.mSize;
        int o2 = 0;
        int[] keys2 = this.mKeys;
        Object[] values2 = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object val = values2[i2];
            if (val == DELETED) continue;
            if (i2 != o2) {
                keys2[o2] = keys2[i2];
                values2[o2] = val;
            }
            ++o2;
        }
        this.mGarbage = false;
        this.mSize = o2;
    }

    public void put(int key, E value) {
        int i2 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i2 >= 0) {
            this.mValues[i2] = value;
        } else {
            if ((i2 ^= 0xFFFFFFFF) < this.mSize && this.mValues[i2] == DELETED) {
                this.mKeys[i2] = key;
                this.mValues[i2] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i2 = ~SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n2 = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n2];
                Object[] nvalues = new Object[n2];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i2 != 0) {
                System.arraycopy(this.mKeys, i2, this.mKeys, i2 + 1, this.mSize - i2);
                System.arraycopy(this.mValues, i2, this.mValues, i2 + 1, this.mSize - i2);
            }
            this.mKeys[i2] = key;
            this.mValues[i2] = value;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index2) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index2];
    }

    public E valueAt(int index2) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index2];
    }

    public void setValueAt(int index2, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index2] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] values2 = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            values2[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n2 = ArrayUtils.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n2];
            Object[] nvalues = new Object[n2];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public SparseArray<E> getUnmodifiable() {
        final SparseArray mStorage = this;
        return new SparseArray<E>(){

            @Override
            public E get(int key) {
                return mStorage.get(key);
            }

            @Override
            public E get(int key, E valueIfKeyNotFound) {
                return mStorage.get(key, valueIfKeyNotFound);
            }

            @Override
            public void delete(int key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void put(int key, E value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return mStorage.size();
            }

            @Override
            public int keyAt(int index2) {
                return mStorage.keyAt(index2);
            }

            @Override
            public E valueAt(int index2) {
                return mStorage.valueAt(index2);
            }

            @Override
            public void setValueAt(int index2, E value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOfKey(int key) {
                return mStorage.indexOfKey(key);
            }

            @Override
            public int indexOfValue(E value) {
                return mStorage.indexOfValue(value);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void append(int key, E value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static int binarySearch(int[] a2, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a2[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a2[high] == key) {
            return high;
        }
        return ~high;
    }
}

