/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/utils/StringHelperWindows;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperWindows {
    @NotNull
    public static final StringHelperWindows INSTANCE = new StringHelperWindows();

    private StringHelperWindows() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        int i2 = 0;
        while (i2 < length) {
            char c2 = commandLine.charAt(i2);
            if (c2 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                ++i2;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c2 == '\\') {
                escapingQuotes = true;
                ++i2;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                ++i2;
                continue;
            }
            if (c2 == '^') {
                escapingOthers = true;
                ++i2;
                continue;
            }
            if (!quoting && commandLine.charAt(i2) == '&') {
                String string2 = commandLine.substring(commandStart, i2);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                commands.add(string2);
                if (commandLine.length() <= ++i2 || commandLine.charAt(i2) == '&') {
                    // empty if block
                }
                commandStart = ++i2;
            }
            ++i2;
        }
        if (commandStart < length) {
            String string3 = commandLine.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            commands.add(string3);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, false, 2, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, true, 2, null, 8, null).toTokenList();
    }
}

