/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.utils.DecimalUtils;
import com.android.utils.PositionXmlParser;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlUtils {
    public static final String XML_COMMENT_BEGIN = "<!--";
    public static final String XML_COMMENT_END = "-->";
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    public static final String CDATA_PREFIX = "<![CDATA[";
    public static final String CDATA_SUFFIX = "]]>";
    public static final String SAX_PARSER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    public static final char NS_SEPARATOR = ':';
    private static final String SOURCE_FILE_USER_DATA_KEY = "sourcefile";
    private static final String NAMESPACE_PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String PROVIDE_XMLNS_URIS = "http://xml.org/sax/features/xmlns-uris";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final byte PROTO_XML_LEAD_BYTE = 10;
    private static final int MAXIMUM_XML_DEPTH = 500;

    public static String lookupNamespacePrefix(Node node, String nsUri) {
        String defaultPrefix = "http://schemas.android.com/apk/res/android".equals(nsUri) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, nsUri, defaultPrefix, true);
    }

    public static String lookupNamespacePrefix(Node node, String nsUri, boolean create2) {
        String defaultPrefix = "http://schemas.android.com/apk/res/android".equals(nsUri) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, nsUri, defaultPrefix, create2);
    }

    public static String lookupNamespacePrefix(Node node, String nsUri, String defaultPrefix, boolean create2) {
        String nsPrefix;
        if (nsUri == null) {
            return null;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(nsUri)) {
            return "xmlns";
        }
        HashSet<String> visited = new HashSet<String>();
        Document doc = node == null ? null : node.getOwnerDocument();
        try {
            String string2 = nsPrefix = doc != null ? doc.lookupPrefix(nsUri) : null;
            if (nsPrefix != null) {
                return nsPrefix;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap attrs = node.getAttributes();
            for (int n2 = attrs.getLength() - 1; n2 >= 0; --n2) {
                String uri;
                Node attr = attrs.item(n2);
                if ("xmlns".equals(attr.getPrefix())) {
                    uri = attr.getNodeValue();
                    nsPrefix = attr.getLocalName();
                    if (nsUri.equals(uri)) {
                        return nsPrefix;
                    }
                    visited.add(nsPrefix);
                    continue;
                }
                if (attr.getPrefix() != null || !attr.getNodeName().startsWith("xmlns:")) continue;
                uri = attr.getNodeValue();
                nsPrefix = attr.getNodeName().substring("xmlns:".length());
                if (nsUri.equals(uri)) {
                    return nsPrefix;
                }
                visited.add(nsPrefix);
            }
            node = node.getParentNode();
        }
        if (defaultPrefix == null) {
            return null;
        }
        Object prefix = defaultPrefix;
        String base = prefix;
        int i2 = 1;
        while (visited.contains(prefix)) {
            prefix = base + Integer.toString(i2);
            ++i2;
        }
        if (doc != null) {
            for (node = doc.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (node != null && create2) {
                Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)prefix);
                attr.setValue(nsUri);
                node.getAttributes().setNamedItemNS(attr);
            }
        }
        return prefix;
    }

    public static String toXmlAttributeValue(String attrValue) {
        int n2 = attrValue.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = attrValue.charAt(i2);
            if (c2 != '\"' && c2 != '\'' && c2 != '<' && c2 != '>' && c2 != '&' && c2 != '\n') continue;
            StringBuilder sb = new StringBuilder(2 * attrValue.length());
            XmlUtils.appendXmlAttributeValue(sb, attrValue);
            return sb.toString();
        }
        return attrValue;
    }

    public static String fromXmlAttributeValue(String escapedAttrValue) {
        if (escapedAttrValue.indexOf(38) == -1) {
            return escapedAttrValue;
        }
        String workingString = escapedAttrValue.replace("&quot;", "\"");
        workingString = workingString.replace("&lt;", "<");
        workingString = workingString.replace("&apos;", "'");
        workingString = workingString.replace("&amp;", "&");
        workingString = workingString.replace("&gt;", ">");
        workingString = workingString.replace("&#xA;", "\n");
        return workingString;
    }

    public static String toXmlTextValue(String textValue) {
        int n2 = textValue.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = textValue.charAt(i2);
            if (c2 != '<' && c2 != '&') continue;
            StringBuilder sb = new StringBuilder(2 * textValue.length());
            XmlUtils.appendXmlTextValue(sb, textValue);
            return sb.toString();
        }
        return textValue;
    }

    public static void appendXmlAttributeValue(StringBuilder sb, String attrValue) {
        XmlUtils.appendXmlAttributeValue(sb, attrValue, 0, attrValue.length());
    }

    public static void appendXmlAttributeValue(StringBuilder sb, String attrValue, int start, int end) {
        char prev = '\u0000';
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = attrValue.charAt(i2);
            if (c2 == '\"') {
                sb.append("&quot;");
            } else if (c2 == '<') {
                sb.append("&lt;");
            } else if (c2 == '\'') {
                sb.append("&apos;");
            } else if (c2 == '&') {
                sb.append("&amp;");
            } else if (c2 == '\n') {
                sb.append("&#xA;");
            } else if (c2 == '>' && prev == ']') {
                sb.append("&gt;");
            } else {
                sb.append(c2);
            }
            prev = c2;
        }
    }

    public static void appendXmlTextValue(StringBuilder sb, String textValue) {
        XmlUtils.appendXmlTextValue(sb, textValue, 0, textValue.length());
    }

    public static void appendXmlTextValue(StringBuilder sb, String textValue, int start, int end) {
        int n2 = Math.min(textValue.length(), end);
        for (int i2 = start; i2 < n2; ++i2) {
            char c2 = textValue.charAt(i2);
            if (c2 == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c2 == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c2);
        }
    }

    public static boolean hasElementChildren(Node node) {
        NodeList children2 = node.getChildNodes();
        int n2 = children2.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (children2.item(i2).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Reader getUtfReader(File file2) throws IOException {
        return XmlUtils.getUtfReader(file2.toPath());
    }

    public static Reader getUtfReader(Path file2) throws IOException {
        byte[] bytes2 = Files.readAllBytes(file2);
        int length = bytes2.length;
        if (length == 0) {
            return new StringReader("");
        }
        switch (bytes2[0]) {
            case -17: {
                if (length < 3 || bytes2[1] != -69 || bytes2[2] != -65) break;
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2, 3, length - 3), Charsets.UTF_8);
            }
            case -2: {
                if (length < 2 || bytes2[1] != -1) break;
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2, 2, length - 2), Charsets.UTF_16BE);
            }
            case -1: {
                if (length < 2 || bytes2[1] != -2) break;
                if (length >= 4 && bytes2[2] == 0 && bytes2[3] == 0) {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2, 4, length - 4), "UTF-32LE");
                }
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2, 2, length - 2), Charsets.UTF_16LE);
            }
            case 0: {
                if (length < 4 || bytes2[0] != 0 || bytes2[1] != 0 || bytes2[2] != -2 || bytes2[3] != -1) break;
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2, 4, length - 4), "UTF-32BE");
            }
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes2), Charsets.UTF_8);
    }

    public static Document parseDocument(String xml, boolean namespaceAware) throws IOException, SAXException {
        xml = XmlUtils.stripBom(xml);
        return XmlUtils.parseDocument(new StringReader(xml), namespaceAware);
    }

    public static Document parseDocument(Reader xml, boolean namespaceAware) throws IOException, SAXException {
        InputSource is = new InputSource(xml);
        return XmlUtils.createDocumentBuilder(namespaceAware).parse(is);
    }

    public static Document parseUtfXmlFile(File file2, boolean namespaceAware) throws IOException, SAXException {
        try (Reader reader = XmlUtils.getUtfReader(file2);){
            Document document = XmlUtils.parseDocument(reader, namespaceAware);
            return document;
        }
    }

    public static Document createDocument(boolean namespaceAware) {
        return XmlUtils.createDocumentBuilder(namespaceAware).newDocument();
    }

    private static DocumentBuilder createDocumentBuilder(boolean namespaceAware) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(namespaceAware);
            factory.setValidating(false);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
            factory.setFeature(LOAD_EXTERNAL_DTD, false);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new Error(e2);
        }
    }

    public static String stripBom(String xml) {
        if (!xml.isEmpty() && xml.charAt(0) == '\ufeff') {
            return xml.substring(1);
        }
        return xml;
    }

    public static Document parseDocumentSilently(String xml, boolean namespaceAware) {
        try {
            return XmlUtils.parseDocument(xml, namespaceAware);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static SAXParserFactory configureSaxFactory(SAXParserFactory factory, boolean namespaceAware, boolean checkDtd) {
        try {
            factory.setXIncludeAware(false);
            factory.setNamespaceAware(namespaceAware);
            factory.setFeature(NAMESPACE_PREFIX_FEATURE, namespaceAware);
            factory.setFeature(PROVIDE_XMLNS_URIS, namespaceAware);
            factory.setValidating(checkDtd);
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return factory;
    }

    public static SAXParserFactory getConfiguredSaxFactory(boolean namespaceAware, boolean checkDtd) {
        SAXParserFactory factory = SAXParserFactory.newInstance(SAX_PARSER_FACTORY, null);
        return XmlUtils.configureSaxFactory(factory, namespaceAware, checkDtd);
    }

    public static SAXParser createSaxParser(SAXParserFactory factory) throws ParserConfigurationException, SAXException {
        return XmlUtils.createSaxParser(factory, false);
    }

    public static SAXParser createSaxParser(SAXParserFactory factory, boolean allowDocTypeDeclarations) throws ParserConfigurationException, SAXException {
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        if (!allowDocTypeDeclarations) {
            reader.setFeature(DISALLOW_DOCTYPE_DECL, true);
        } else {
            reader.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            reader.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
            reader.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        return parser;
    }

    public static String toXml(Node node) {
        return XmlUtils.toXml(node, null);
    }

    public static String toXml(Node node, Map<SourcePosition, SourceFilePosition> blame) {
        PositionAwareStringBuilder sb = new PositionAwareStringBuilder(1000);
        HashSet<Node> nodesInPath = Sets.newHashSet();
        XmlUtils.append(sb, node, blame, nodesInPath);
        return sb.toString();
    }

    private static void append(PositionAwareStringBuilder sb, Node node, Map<SourcePosition, SourceFilePosition> blame, Set<Node> nodesInPath) {
        if (!nodesInPath.add(node)) {
            throw new RuntimeException("Circular dependency in XML " + sb.toString());
        }
        if (nodesInPath.size() > 500) {
            throw new RuntimeException("Maximum XML depth reached " + sb.toString());
        }
        short nodeType = node.getNodeType();
        int currentLine = sb.line;
        int currentColumn = sb.column;
        int currentOffset = sb.getOffset();
        switch (nodeType) {
            case 9: 
            case 11: {
                sb.append(XML_PROLOG);
                NodeList children2 = node.getChildNodes();
                int n2 = children2.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node child = children2.item(i2);
                    XmlUtils.append(sb, child, blame, nodesInPath);
                }
                break;
            }
            case 8: {
                sb.append(XML_COMMENT_BEGIN);
                sb.append(node.getNodeValue());
                sb.append(XML_COMMENT_END);
                break;
            }
            case 3: {
                sb.append(XmlUtils.toXmlTextValue(node.getNodeValue()));
                break;
            }
            case 4: {
                sb.append(CDATA_PREFIX);
                sb.append(node.getNodeValue());
                sb.append(CDATA_SUFFIX);
                break;
            }
            case 1: {
                SourceFilePosition position;
                int i3;
                sb.append('<');
                Element element = (Element)node;
                sb.append(element.getTagName());
                NamedNodeMap attributes = element.getAttributes();
                NodeList children3 = element.getChildNodes();
                int childCount = children3.getLength();
                int attributeCount = attributes.getLength();
                if (attributeCount > 0) {
                    for (i3 = 0; i3 < attributeCount; ++i3) {
                        Node attribute = attributes.item(i3);
                        sb.append(' ');
                        sb.append(attribute.getNodeName());
                        sb.append('=').append('\"');
                        sb.append(XmlUtils.toXmlAttributeValue(attribute.getNodeValue()));
                        sb.append('\"');
                    }
                }
                if (childCount == 0) {
                    sb.append('/');
                }
                sb.append('>');
                if (childCount > 0) {
                    for (i3 = 0; i3 < childCount; ++i3) {
                        Node child = children3.item(i3);
                        XmlUtils.append(sb, child, blame, nodesInPath);
                    }
                    sb.append('<').append('/');
                    sb.append(element.getTagName());
                    sb.append('>');
                }
                if (blame == null || (position = XmlUtils.getSourceFilePosition(node)).equals(SourceFilePosition.UNKNOWN)) break;
                blame.put(new SourcePosition(currentLine, currentColumn, currentOffset, sb.line, sb.column, sb.getOffset()), position);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported node type " + nodeType + ": not yet implemented");
            }
        }
        nodesInPath.remove(node);
    }

    public static void attachSourceFile(Node node, SourceFile sourceFile) {
        node.setUserData(SOURCE_FILE_USER_DATA_KEY, sourceFile, null);
    }

    public static SourceFilePosition getSourceFilePosition(Node node) {
        SourceFile sourceFile = (SourceFile)node.getUserData(SOURCE_FILE_USER_DATA_KEY);
        if (sourceFile == null) {
            sourceFile = SourceFile.UNKNOWN;
        }
        return new SourceFilePosition(sourceFile, PositionXmlParser.getPosition(node));
    }

    public static String formatFloatValue(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Invalid number: " + value);
        }
        String result2 = Float.toString((float)value);
        return DecimalUtils.trimInsignificantZeros(result2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRootTagName(File xmlFile) {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(xmlFile));){
            int event;
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(stream);
            do {
                if (!xmlStreamReader.hasNext()) return null;
            } while ((event = xmlStreamReader.next()) != 1);
            String string2 = xmlStreamReader.getLocalName();
            return string2;
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRootTagName(String xmlText) {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try (StringReader reader = new StringReader(xmlText);){
            int event;
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(reader);
            do {
                if (!xmlStreamReader.hasNext()) return null;
            } while ((event = xmlStreamReader.next()) != 1);
            String string2 = xmlStreamReader.getLocalName();
            return string2;
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
        return null;
    }

    public static List<Element> getSubTagsAsList(Node parent) {
        NodeList childNodes = parent.getChildNodes();
        ArrayList<Element> children2 = new ArrayList<Element>(childNodes.getLength());
        int n2 = childNodes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node child = childNodes.item(i2);
            if (child.getNodeType() != 1) continue;
            children2.add((Element)child);
        }
        return children2;
    }

    public static Iterable<Element> getSubTags(Node parent) {
        return new SubTagIterator(parent);
    }

    public static Iterable<Element> getSubTagsByName(Node parent, String tagName) {
        return new NamedSubTagIterator(parent, tagName);
    }

    public static Element getFirstSubTag(Node parent) {
        if (parent == null) {
            return null;
        }
        for (Node curr = parent.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Element getNextTag(Node node) {
        if (node == null) {
            return null;
        }
        for (Node curr = node.getNextSibling(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Element getPreviousTag(Node node) {
        if (node == null) {
            return null;
        }
        for (Node curr = node.getPreviousSibling(); curr != null; curr = curr.getPreviousSibling()) {
            if (curr.getNodeType() != 1) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Element getFirstSubTagByName(Node parent, String name2) {
        if (parent == null) {
            return null;
        }
        for (Node curr = parent.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1) continue;
            String currName = curr.getLocalName();
            if (currName == null) {
                currName = curr.getNodeName();
            }
            if (!name2.equals(currName)) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Element getNextTagByName(Node node, String name2) {
        if (node == null) {
            return null;
        }
        for (Node curr = node.getNextSibling(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1) continue;
            String currName = curr.getLocalName();
            if (currName == null) {
                currName = curr.getNodeName();
            }
            if (!name2.equals(currName)) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Element getPreviousTagByName(Node node, String name2) {
        if (node == null) {
            return null;
        }
        for (Node curr = node.getPreviousSibling(); curr != null; curr = curr.getPreviousSibling()) {
            if (curr.getNodeType() != 1) continue;
            String currName = curr.getLocalName();
            if (currName == null) {
                currName = curr.getNodeName();
            }
            if (!name2.equals(currName)) continue;
            return (Element)curr;
        }
        return null;
    }

    public static Comment getPreviousComment(Node element) {
        Node node = element;
        do {
            if (!((node = node.getPreviousSibling()) instanceof Comment)) continue;
            return (Comment)node;
        } while (node instanceof Text && CharMatcher.whitespace().matchesAllOf(node.getNodeValue()));
        return null;
    }

    public static String getPreviousCommentText(Node element) {
        Comment comment = XmlUtils.getPreviousComment(element);
        if (comment != null) {
            String text = comment.getNodeValue();
            if (!CharMatcher.whitespace().matchesAllOf(text)) {
                return text.trim();
            }
        }
        return null;
    }

    public static int getSubTagCount(Node parent) {
        if (parent == null) {
            return 0;
        }
        NodeList childNodes = parent.getChildNodes();
        int childCount = 0;
        int n2 = childNodes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node child = childNodes.item(i2);
            if (child.getNodeType() != 1) continue;
            ++childCount;
        }
        return childCount;
    }

    public static boolean isProtoXml(byte[] bytes2) {
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            byte c2 = bytes2[i2];
            if (i2 == 0 && c2 != 10) {
                return false;
            }
            if (Character.isWhitespace(c2)) continue;
            return c2 != 60;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProtoXml(InputStream stream) {
        boolean isProto = false;
        int readLimit = 100;
        if (stream.markSupported()) {
            stream.mark(readLimit);
            try {
                try {
                    int c2;
                    for (int i2 = 0; i2 < readLimit && (c2 = stream.read()) >= 0; ++i2) {
                        if (i2 == 0 && c2 != 10) {
                        } else {
                            if (Character.isWhitespace(c2)) continue;
                            isProto = c2 != 60;
                        }
                        break;
                    }
                }
                finally {
                    stream.reset();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isProto;
    }

    private static class PositionAwareStringBuilder {
        private final StringBuilder sb;
        int line = 0;
        int column = 0;

        public PositionAwareStringBuilder(int size) {
            this.sb = new StringBuilder(size);
        }

        public PositionAwareStringBuilder append(String text) {
            this.sb.append(text);
            int lastNewLineIndex = text.lastIndexOf(10);
            if (lastNewLineIndex == -1) {
                this.column += text.length();
            } else {
                this.line += CharMatcher.is('\n').countIn(text);
                this.column = text.length() - lastNewLineIndex - 1;
            }
            return this;
        }

        public PositionAwareStringBuilder append(char character) {
            this.sb.append(character);
            if (character == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
            return this;
        }

        public int getOffset() {
            return this.sb.length();
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private static class SubTagIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private Element next;
        private boolean used;

        public SubTagIterator(Node parent) {
            this.next = XmlUtils.getFirstSubTag(parent);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element ret = this.next;
            this.next = XmlUtils.getNextTag(this.next);
            return ret;
        }

        @Override
        public Iterator<Element> iterator() {
            assert (!this.used);
            this.used = true;
            return this;
        }
    }

    private static class NamedSubTagIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private final String name;
        private Element next;
        private boolean used;

        public NamedSubTagIterator(Node parent, String name2) {
            this.name = name2;
            this.next = XmlUtils.getFirstSubTagByName(parent, name2);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element ret = this.next;
            this.next = XmlUtils.getNextTagByName(this.next, this.name);
            return ret;
        }

        @Override
        public Iterator<Element> iterator() {
            assert (!this.used);
            this.used = true;
            return this;
        }
    }
}

