/*
 * Decompiled with CFR 0.152.
 */
package com.android.xml;

public final class XmlBuilder {
    private final StringBuilder stringBuilder = new StringBuilder();
    private Construct lastAppendedConstruct = Construct.NULL;
    private int indentationLevel;

    public XmlBuilder startTag(String name2) {
        int length;
        if (!this.lastAppendedConstruct.equals((Object)Construct.END_TAG) && (length = this.stringBuilder.length()) > 0) {
            this.stringBuilder.replace(length - 1, length, ">\n");
        }
        if (this.indentationLevel != 0) {
            this.stringBuilder.append('\n');
        }
        this.indent();
        this.stringBuilder.append('<').append(name2).append('\n');
        ++this.indentationLevel;
        this.lastAppendedConstruct = Construct.START_TAG;
        return this;
    }

    public XmlBuilder androidAttribute(String name2, boolean value) {
        return this.androidAttribute(name2, Boolean.toString(value));
    }

    public XmlBuilder androidAttribute(String name2, int value) {
        return this.androidAttribute(name2, Integer.toString(value));
    }

    public XmlBuilder androidAttribute(String name2, String value) {
        return this.attribute("android", name2, value);
    }

    public XmlBuilder attribute(String name2, String value) {
        return this.attribute("", name2, value);
    }

    public XmlBuilder attribute(String namespacePrefix, String name2, String value) {
        this.indent();
        if (!namespacePrefix.isEmpty()) {
            this.stringBuilder.append(namespacePrefix).append(':');
        }
        this.stringBuilder.append(name2).append("=\"").append(value).append("\"\n");
        this.lastAppendedConstruct = Construct.ATTRIBUTE;
        return this;
    }

    public XmlBuilder wrapContent() {
        return this.withSize("wrap_content", "wrap_content");
    }

    public XmlBuilder matchParent() {
        return this.withSize("match_parent", "match_parent");
    }

    public XmlBuilder withSize(String width, String height) {
        this.androidAttribute("layout_width", width);
        this.androidAttribute("layout_height", height);
        return this;
    }

    public XmlBuilder characterData(String data) {
        if (this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.stringBuilder.length();
            this.stringBuilder.replace(length - 1, length, ">\n");
        }
        this.indent();
        this.stringBuilder.append(data).append('\n');
        this.lastAppendedConstruct = Construct.CHARACTER_DATA;
        return this;
    }

    public XmlBuilder endTag(String name2) {
        return this.endTagImpl(name2, !name2.endsWith("Layout") && !name2.equals("PreferenceCategory"));
    }

    public XmlBuilder seperateEndTag(String name2) {
        return this.endTagImpl(name2, false);
    }

    private XmlBuilder endTagImpl(String name2, boolean useEmptyElementTag) {
        if (this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.stringBuilder.length();
            if (useEmptyElementTag) {
                this.stringBuilder.deleteCharAt(length - 1);
            } else {
                this.stringBuilder.replace(length - 1, length, ">\n\n");
            }
        }
        --this.indentationLevel;
        if ((this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) && useEmptyElementTag) {
            this.stringBuilder.append(" />\n");
        } else {
            this.indent();
            this.stringBuilder.append("</").append(name2).append(">\n");
        }
        this.lastAppendedConstruct = Construct.END_TAG;
        return this;
    }

    private void indent() {
        for (int i2 = 0; i2 < this.indentationLevel; ++i2) {
            this.stringBuilder.append("    ");
        }
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private static enum Construct {
        NULL,
        START_TAG,
        ATTRIBUTE,
        CHARACTER_DATA,
        END_TAG;

    }
}

