/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.BytesSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class FullFileSource
extends BytesSource {
    public FullFileSource(Path file2, String entryName, int compressionLevel) throws IOException {
        this(file2, entryName, compressionLevel, Symlink.FOLLOW);
    }

    public FullFileSource(Path file2, String entryName, int compressionLevel, Symlink symlinkPolicy) throws IOException {
        super(entryName);
        byte[] bytes2;
        if (Files.isExecutable(file2)) {
            this.externalAttributes |= 0x490000;
        }
        if (!Files.isSymbolicLink(file2) || symlinkPolicy == Symlink.FOLLOW) {
            bytes2 = Files.readAllBytes(file2);
        } else {
            this.externalAttributes |= 0xA0000000;
            compressionLevel = 0;
            Path target = Files.readSymbolicLink(file2);
            bytes2 = target.toString().getBytes(StandardCharsets.US_ASCII);
        }
        this.build(bytes2, bytes2.length, compressionLevel);
    }

    public static enum Symlink {
        FOLLOW,
        DO_NOT_FOLLOW;

    }
}

