/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class Source {
    private final String name;
    private final byte[] nameBytes;
    public static final long NO_ALIGNMENT = 0L;
    private long alignment = 0L;
    protected long compressedSize;
    protected long uncompressedSize;
    protected int crc;
    protected short compressionFlag;
    protected short versionMadeBy;
    public static final short MADE_BY_UNIX = 768;
    public static final int TYPE_FREG = Integer.MIN_VALUE;
    public static final int TYPE_FLNK = -1610612736;
    public static final int TYPE_FDIR = 0x40000000;
    public static final int UNX_IRUSR = 0x1000000;
    public static final int UNX_IWUSR = 0x800000;
    public static final int UNX_IXUSR = 0x400000;
    public static final int UNX_IRGRP = 0x200000;
    public static final int UNX_IWGRP = 0x100000;
    public static final int UNX_IXGRP = 524288;
    public static final int UNX_IROTH = 262144;
    public static final int UNX_IWOTH = 131072;
    public static final int UNX_IXOTH = 65536;
    public static final int UNX_IRALL = 19136512;
    public static final int UNX_IWALL = 0x920000;
    public static final int UNX_IXALL = 0x490000;
    public static final int PERMISSION_USR_RW = 0x1800000;
    public static final int PERMISSION_RW = 28704768;
    public static final int PERMISSION_EXEC = 0x490000;
    public static final int PERMISSION_LINK = -1610612736;
    public static final int PERMISSION_DEFAULT = -2119958528;
    public static final int PERMISSION_DIR_DEFAULT = 1106051072;
    protected int externalAttributes;
    static final String DIRECTORY_MARKER = "/";

    protected Source(String name2) {
        this.name = name2;
        this.nameBytes = name2.getBytes(StandardCharsets.UTF_8);
        this.versionMadeBy = (short)768;
        this.externalAttributes = -2119958528;
    }

    public String getName() {
        return this.name;
    }

    byte[] getNameBytes() {
        return this.nameBytes;
    }

    boolean isAligned() {
        return this.alignment != 0L;
    }

    public void align(long alignment) {
        this.alignment = alignment;
    }

    long getAlignment() {
        return this.alignment;
    }

    int getCrc() {
        return this.crc;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    short getCompressionFlag() {
        return this.compressionFlag;
    }

    public short getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public int getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(int externalAttributes) {
        this.externalAttributes = externalAttributes;
    }

    public abstract void prepare() throws IOException;

    public abstract long writeTo(ZipWriter var1) throws IOException;

    static boolean isNameDirectory(String name2) {
        return name2.endsWith(DIRECTORY_MARKER);
    }

    static String directoryName(String name2) {
        name2 = (String)name2 + DIRECTORY_MARKER;
        return name2;
    }
}

