/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(int bufferSize) {
        this(ByteBuffer.allocate(bufferSize));
        this.flipBuffer(this.byteBuffer);
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes2, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int count2 = Math.min(this.byteBuffer.remaining(), length);
        if (count2 == 0) {
            return -1;
        }
        this.byteBuffer.get(bytes2, offset, count2);
        return count2;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.remaining();
    }

    private void flipBuffer(Buffer buffer) {
        buffer.flip();
    }
}

