/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.KryoBufferUnderflowException;
import com.esotericsoftware.kryo.kryo5.util.Pool;
import java.io.IOException;
import java.io.InputStream;

public class Input
extends InputStream
implements Pool.Poolable {
    protected byte[] buffer;
    protected int position;
    protected int capacity;
    protected int limit;
    protected long total;
    protected char[] chars = new char[32];
    protected InputStream inputStream;
    protected boolean varEncoding = true;

    public Input() {
    }

    public Input(int bufferSize) {
        this.capacity = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Input(byte[] buffer) {
        this.setBuffer(buffer, 0, buffer.length);
    }

    public Input(byte[] buffer, int offset, int count2) {
        this.setBuffer(buffer, offset, count2);
    }

    public Input(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public Input(InputStream inputStream, int bufferSize) {
        this(bufferSize);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public void setBuffer(byte[] bytes2) {
        this.setBuffer(bytes2, 0, bytes2.length);
    }

    public void setBuffer(byte[] bytes2, int offset, int count2) {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.buffer = bytes2;
        this.position = offset;
        this.limit = offset + count2;
        this.capacity = bytes2.length;
        this.total = 0L;
        this.inputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.reset();
    }

    public boolean getVariableLengthEncoding() {
        return this.varEncoding;
    }

    public void setVariableLengthEncoding(boolean varEncoding) {
        this.varEncoding = varEncoding;
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int limit2) {
        this.limit = limit2;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.total = 0L;
    }

    public void skip(int count2) throws KryoException {
        int skipCount = Math.min(this.limit - this.position, count2);
        while (true) {
            this.position += skipCount;
            if ((count2 -= skipCount) == 0) break;
            skipCount = Math.min(count2, this.capacity);
            this.require(skipCount);
        }
    }

    protected int fill(byte[] buffer, int offset, int count2) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            return this.inputStream.read(buffer, offset, count2);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    protected int require(int required) throws KryoException {
        int count2;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count2 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
            if (count2 == -1) {
                throw new KryoBufferUnderflowException("Buffer underflow.");
            }
            if ((remaining += count2) >= required) {
                this.limit += count2;
                return remaining;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count2 = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoBufferUnderflowException("Buffer underflow.");
        } while ((remaining += count2) < required);
        this.limit = remaining;
        return remaining;
    }

    protected int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count2 = this.fill(this.buffer, this.limit, this.capacity - this.limit);
        if (count2 == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count2) >= optional) {
            this.limit += count2;
            return optional;
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        while ((count2 = this.fill(this.buffer, remaining, this.capacity - remaining)) != -1 && (remaining += count2) < optional) {
        }
        this.limit = remaining;
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    public boolean end() {
        return this.optional(1) <= 0;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + (this.inputStream != null ? this.inputStream.available() : 0);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes2) throws KryoException {
        return this.read(bytes2, 0, bytes2.length);
    }

    @Override
    public int read(byte[] bytes2, int offset, int count2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count2;
        int copyCount = Math.min(this.limit - this.position, count2);
        do {
            System.arraycopy(this.buffer, this.position, bytes2, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count2);
            if (copyCount != -1) continue;
            if (startingCount == count2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count2;
    }

    @Override
    public long skip(long count2) throws KryoException {
        int skip;
        for (long remaining = count2; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count2;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++];
    }

    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes2 = new byte[length];
        this.readBytes(bytes2, 0, length);
        return bytes2;
    }

    public void readBytes(byte[] bytes2) throws KryoException {
        this.readBytes(bytes2, 0, bytes2.length);
    }

    public void readBytes(byte[] bytes2, int offset, int count2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            System.arraycopy(this.buffer, this.position, bytes2, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p2 = this.position;
        this.position = p2 + 4;
        return buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16 | (buffer[p2 + 3] & 0xFF) << 24;
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.readVarInt(optimizePositive);
        }
        return this.readInt();
    }

    public boolean canReadInt() throws KryoException {
        if (this.varEncoding) {
            return this.canReadVarInt();
        }
        if (this.limit - this.position >= 4) {
            return true;
        }
        return this.optional(4) == 4;
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 5) {
            return this.readVarInt_slow(optimizePositive);
        }
        byte b2 = this.buffer[this.position++];
        int result2 = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            b2 = buffer[p2++];
            result2 |= (b2 & 0x7F) << 7;
            if ((b2 & 0x80) != 0) {
                b2 = buffer[p2++];
                result2 |= (b2 & 0x7F) << 14;
                if ((b2 & 0x80) != 0) {
                    b2 = buffer[p2++];
                    result2 |= (b2 & 0x7F) << 21;
                    if ((b2 & 0x80) != 0) {
                        b2 = buffer[p2++];
                        result2 |= (b2 & 0x7F) << 28;
                    }
                }
            }
            this.position = p2;
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    private int readVarInt_slow(boolean optimizePositive) {
        byte b2 = this.buffer[this.position++];
        int result2 = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b2 = buffer[this.position++];
            result2 |= (b2 & 0x7F) << 7;
            if ((b2 & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b2 = buffer[this.position++];
                result2 |= (b2 & 0x7F) << 14;
                if ((b2 & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b2 = buffer[this.position++];
                    result2 |= (b2 & 0x7F) << 21;
                    if ((b2 & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b2 = buffer[this.position++];
                        result2 |= (b2 & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    public boolean canReadVarInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p2 = this.position;
        int limit2 = this.limit;
        byte[] buffer = this.buffer;
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        return p2 != limit2;
    }

    public boolean readVarIntFlag() {
        if (this.position == this.limit) {
            this.require(1);
        }
        return (this.buffer[this.position] & 0x80) != 0;
    }

    public int readVarIntFlag(boolean optimizePositive) {
        if (this.require(1) < 5) {
            return this.readVarIntFlag_slow(optimizePositive);
        }
        byte b2 = this.buffer[this.position++];
        int result2 = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            b2 = buffer[p2++];
            result2 |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                b2 = buffer[p2++];
                result2 |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    b2 = buffer[p2++];
                    result2 |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        b2 = buffer[p2++];
                        result2 |= (b2 & 0x7F) << 27;
                    }
                }
            }
            this.position = p2;
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    private int readVarIntFlag_slow(boolean optimizePositive) {
        byte b2 = this.buffer[this.position++];
        int result2 = b2 & 0x3F;
        if ((b2 & 0x40) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b2 = buffer[this.position++];
            result2 |= (b2 & 0x7F) << 6;
            if ((b2 & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b2 = buffer[this.position++];
                result2 |= (b2 & 0x7F) << 13;
                if ((b2 & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b2 = buffer[this.position++];
                    result2 |= (b2 & 0x7F) << 20;
                    if ((b2 & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b2 = buffer[this.position++];
                        result2 |= (b2 & 0x7F) << 27;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    public long readLong() throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p2 = this.position;
        this.position = p2 + 8;
        return (long)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16) | (long)(buffer[p2 + 3] & 0xFF) << 24 | (long)(buffer[p2 + 4] & 0xFF) << 32 | (long)(buffer[p2 + 5] & 0xFF) << 40 | (long)(buffer[p2 + 6] & 0xFF) << 48 | (long)buffer[p2 + 7] << 56;
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.readVarLong(optimizePositive);
        }
        return this.readLong();
    }

    public long readVarLong(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 9) {
            return this.readVarLong_slow(optimizePositive);
        }
        int p2 = this.position;
        byte b2 = this.buffer[p2++];
        long result2 = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            byte[] buffer = this.buffer;
            b2 = buffer[p2++];
            result2 |= (long)((b2 & 0x7F) << 7);
            if ((b2 & 0x80) != 0) {
                b2 = buffer[p2++];
                result2 |= (long)((b2 & 0x7F) << 14);
                if ((b2 & 0x80) != 0) {
                    b2 = buffer[p2++];
                    result2 |= (long)((b2 & 0x7F) << 21);
                    if ((b2 & 0x80) != 0) {
                        b2 = buffer[p2++];
                        result2 |= (long)(b2 & 0x7F) << 28;
                        if ((b2 & 0x80) != 0) {
                            b2 = buffer[p2++];
                            result2 |= (long)(b2 & 0x7F) << 35;
                            if ((b2 & 0x80) != 0) {
                                b2 = buffer[p2++];
                                result2 |= (long)(b2 & 0x7F) << 42;
                                if ((b2 & 0x80) != 0) {
                                    b2 = buffer[p2++];
                                    result2 |= (long)(b2 & 0x7F) << 49;
                                    if ((b2 & 0x80) != 0) {
                                        b2 = buffer[p2++];
                                        result2 |= (long)b2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.position = p2;
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1L);
    }

    private long readVarLong_slow(boolean optimizePositive) {
        byte b2 = this.buffer[this.position++];
        long result2 = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte[] buffer = this.buffer;
            b2 = buffer[this.position++];
            result2 |= (long)((b2 & 0x7F) << 7);
            if ((b2 & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                b2 = buffer[this.position++];
                result2 |= (long)((b2 & 0x7F) << 14);
                if ((b2 & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    b2 = buffer[this.position++];
                    result2 |= (long)((b2 & 0x7F) << 21);
                    if ((b2 & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        b2 = buffer[this.position++];
                        result2 |= (long)(b2 & 0x7F) << 28;
                        if ((b2 & 0x80) != 0) {
                            if (this.position == this.limit) {
                                this.require(1);
                            }
                            b2 = buffer[this.position++];
                            result2 |= (long)(b2 & 0x7F) << 35;
                            if ((b2 & 0x80) != 0) {
                                if (this.position == this.limit) {
                                    this.require(1);
                                }
                                b2 = buffer[this.position++];
                                result2 |= (long)(b2 & 0x7F) << 42;
                                if ((b2 & 0x80) != 0) {
                                    if (this.position == this.limit) {
                                        this.require(1);
                                    }
                                    b2 = buffer[this.position++];
                                    result2 |= (long)(b2 & 0x7F) << 49;
                                    if ((b2 & 0x80) != 0) {
                                        if (this.position == this.limit) {
                                            this.require(1);
                                        }
                                        b2 = buffer[this.position++];
                                        result2 |= (long)b2 << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1L);
    }

    public boolean canReadLong() throws KryoException {
        if (this.varEncoding) {
            return this.canReadVarLong();
        }
        if (this.limit - this.position >= 8) {
            return true;
        }
        return this.optional(8) == 8;
    }

    public boolean canReadVarLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p2 = this.position;
        int limit2 = this.limit;
        byte[] buffer = this.buffer;
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        if (p2 == limit2) {
            return false;
        }
        if ((buffer[p2++] & 0x80) == 0) {
            return true;
        }
        return p2 != limit2;
    }

    public float readFloat() throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p2 = this.position;
        this.position = p2 + 4;
        return Float.intBitsToFloat(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16 | (buffer[p2 + 3] & 0xFF) << 24);
    }

    public float readVarFloat(float precision, boolean optimizePositive) throws KryoException {
        return (float)this.readVarInt(optimizePositive) / precision;
    }

    public double readDouble() throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p2 = this.position;
        this.position = p2 + 8;
        return Double.longBitsToDouble((long)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16) | (long)(buffer[p2 + 3] & 0xFF) << 24 | (long)(buffer[p2 + 4] & 0xFF) << 32 | (long)(buffer[p2 + 5] & 0xFF) << 40 | (long)(buffer[p2 + 6] & 0xFF) << 48 | (long)buffer[p2 + 7] << 56);
    }

    public double readVarDouble(double precision, boolean optimizePositive) throws KryoException {
        return (double)this.readVarLong(optimizePositive) / precision;
    }

    public short readShort() throws KryoException {
        this.require(2);
        int p2 = this.position;
        this.position = p2 + 2;
        return (short)(this.buffer[p2] & 0xFF | (this.buffer[p2 + 1] & 0xFF) << 8);
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        int p2 = this.position;
        this.position = p2 + 2;
        return this.buffer[p2] & 0xFF | (this.buffer[p2 + 1] & 0xFF) << 8;
    }

    public char readChar() throws KryoException {
        this.require(2);
        int p2 = this.position;
        this.position = p2 + 2;
        return (char)(this.buffer[p2] & 0xFF | (this.buffer[p2 + 1] & 0xFF) << 8);
    }

    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        return this.buffer[this.position++] == 1;
    }

    public String readString() {
        if (!this.readVarIntFlag()) {
            return this.readAsciiString();
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        this.readUtf8Chars(--charCount);
        return new String(this.chars, 0, charCount);
    }

    public StringBuilder readStringBuilder() {
        if (!this.readVarIntFlag()) {
            return new StringBuilder(this.readAsciiString());
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder(0);
            }
        }
        this.readUtf8Chars(--charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    private void readUtf8Chars(int charCount) {
        if (this.chars.length < charCount) {
            this.chars = new char[charCount];
        }
        byte[] buffer = this.buffer;
        char[] chars = this.chars;
        int charIndex = 0;
        int count2 = Math.min(this.require(1), charCount);
        int p2 = this.position;
        while (charIndex < count2) {
            byte b2;
            if ((b2 = buffer[p2++]) < 0) {
                --p2;
                break;
            }
            chars[charIndex++] = (char)b2;
        }
        this.position = p2;
        if (charIndex < charCount) {
            this.readUtf8Chars_slow(charCount, charIndex);
        }
    }

    private void readUtf8Chars_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int b2 = buffer[this.position++] & 0xFF;
            switch (b2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b2;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    chars[charIndex] = (char)((b2 & 0x1F) << 6 | buffer[this.position++] & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    int p2 = this.position;
                    this.position = p2 + 2;
                    chars[charIndex] = (char)((b2 & 0xF) << 12 | (buffer[p2] & 0x3F) << 6 | buffer[p2 + 1] & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAsciiString() {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        int p2 = this.position;
        int charCount = 0;
        int n2 = Math.min(chars.length, this.limit - this.position);
        while (charCount < n2) {
            byte b2 = buffer[p2];
            if ((b2 & 0x80) == 128) {
                this.position = p2 + 1;
                chars[charCount] = (char)(b2 & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b2;
            ++charCount;
            ++p2;
        }
        this.position = p2;
        return this.readAscii_slow(charCount);
    }

    private String readAscii_slow(int charCount) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        while (true) {
            if (this.position == this.limit) {
                this.require(1);
            }
            byte b2 = buffer[this.position++];
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b2 & 0x80) == 128) {
                chars[charCount] = (char)(b2 & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount++] = (char)b2;
        }
    }

    public int[] readInts(int length) throws KryoException {
        int[] array2 = new int[length];
        if (this.optional(length << 2) == length << 2) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16 | (buffer[p2 + 3] & 0xFF) << 24;
                ++i2;
                p2 += 4;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readInt();
            }
        }
        return array2;
    }

    public int[] readInts(int length, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            int[] array2 = new int[length];
            for (int i2 = 0; i2 < length; ++i2) {
                array2[i2] = this.readVarInt(optimizePositive);
            }
            return array2;
        }
        return this.readInts(length);
    }

    public long[] readLongs(int length) throws KryoException {
        long[] array2 = new long[length];
        if (this.optional(length << 3) == length << 3) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = (long)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16) | (long)(buffer[p2 + 3] & 0xFF) << 24 | (long)(buffer[p2 + 4] & 0xFF) << 32 | (long)(buffer[p2 + 5] & 0xFF) << 40 | (long)(buffer[p2 + 6] & 0xFF) << 48 | (long)buffer[p2 + 7] << 56;
                ++i2;
                p2 += 8;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readLong();
            }
        }
        return array2;
    }

    public long[] readLongs(int length, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            long[] array2 = new long[length];
            for (int i2 = 0; i2 < length; ++i2) {
                array2[i2] = this.readVarLong(optimizePositive);
            }
            return array2;
        }
        return this.readLongs(length);
    }

    public float[] readFloats(int length) throws KryoException {
        float[] array2 = new float[length];
        if (this.optional(length << 2) == length << 2) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = Float.intBitsToFloat(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16 | (buffer[p2 + 3] & 0xFF) << 24);
                ++i2;
                p2 += 4;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readFloat();
            }
        }
        return array2;
    }

    public double[] readDoubles(int length) throws KryoException {
        double[] array2 = new double[length];
        if (this.optional(length << 3) == length << 3) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = Double.longBitsToDouble((long)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8 | (buffer[p2 + 2] & 0xFF) << 16) | (long)(buffer[p2 + 3] & 0xFF) << 24 | (long)(buffer[p2 + 4] & 0xFF) << 32 | (long)(buffer[p2 + 5] & 0xFF) << 40 | (long)(buffer[p2 + 6] & 0xFF) << 48 | (long)buffer[p2 + 7] << 56);
                ++i2;
                p2 += 8;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readDouble();
            }
        }
        return array2;
    }

    public short[] readShorts(int length) throws KryoException {
        short[] array2 = new short[length];
        if (this.optional(length << 1) == length << 1) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = (short)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8);
                ++i2;
                p2 += 2;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readShort();
            }
        }
        return array2;
    }

    public char[] readChars(int length) throws KryoException {
        char[] array2 = new char[length];
        if (this.optional(length << 1) == length << 1) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = (char)(buffer[p2] & 0xFF | (buffer[p2 + 1] & 0xFF) << 8);
                ++i2;
                p2 += 2;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readChar();
            }
        }
        return array2;
    }

    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array2 = new boolean[length];
        if (this.optional(length) == length) {
            byte[] buffer = this.buffer;
            int p2 = this.position;
            int i2 = 0;
            while (i2 < length) {
                array2[i2] = buffer[p2] != 0;
                ++i2;
                ++p2;
            }
            this.position = p2;
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                array2[i3] = this.readBoolean();
            }
        }
        return array2;
    }
}

