/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.SerializerFactory;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.reflectasm.FieldAccess;
import com.esotericsoftware.kryo.kryo5.serializers.AsmField;
import com.esotericsoftware.kryo.kryo5.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.MapSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.ReflectField;
import com.esotericsoftware.kryo.kryo5.serializers.UnsafeField;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

class CachedFields
implements Comparator<FieldSerializer.CachedField> {
    static final FieldSerializer.CachedField[] emptyCachedFields = new FieldSerializer.CachedField[0];
    private final FieldSerializer serializer;
    FieldSerializer.CachedField[] fields = new FieldSerializer.CachedField[0];
    FieldSerializer.CachedField[] copyFields = new FieldSerializer.CachedField[0];
    private final ArrayList<Field> removedFields = new ArrayList();
    private Object access;

    public CachedFields(FieldSerializer serializer2) {
        this.serializer = serializer2;
    }

    public void rebuild() {
        if (this.serializer.type.isInterface()) {
            this.fields = emptyCachedFields;
            this.copyFields = emptyCachedFields;
            this.serializer.initializeCachedFields();
            return;
        }
        ArrayList<FieldSerializer.CachedField> newFields = new ArrayList<FieldSerializer.CachedField>();
        ArrayList<FieldSerializer.CachedField> newCopyFields = new ArrayList<FieldSerializer.CachedField>();
        boolean asm = !Util.unsafe && !Util.isAndroid && Modifier.isPublic(this.serializer.type.getModifiers());
        for (Class nextClass = this.serializer.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                this.addField(field, asm, newFields, newCopyFields);
            }
        }
        if (this.fields.length != newFields.size()) {
            this.fields = new FieldSerializer.CachedField[newFields.size()];
        }
        newFields.toArray(this.fields);
        Arrays.sort(this.fields, this);
        if (this.copyFields.length != newCopyFields.size()) {
            this.copyFields = new FieldSerializer.CachedField[newCopyFields.size()];
        }
        newCopyFields.toArray(this.copyFields);
        Arrays.sort(this.copyFields, this);
        this.serializer.initializeCachedFields();
    }

    private void addField(Field field, boolean asm, ArrayList<FieldSerializer.CachedField> fields2, ArrayList<FieldSerializer.CachedField> copyFields) {
        FieldSerializer.CachedField cachedField;
        int accessIndex;
        Class fieldClass;
        Generics.GenericType genericType;
        Class<?> declaringClass;
        boolean isTransient;
        FieldSerializer.FieldSerializerConfig config;
        block27: {
            FieldSerializer.Optional optional;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return;
            }
            config = this.serializer.config;
            if (field.isSynthetic() && config.ignoreSyntheticFields) {
                return;
            }
            if (!field.isAccessible()) {
                if (!config.setFieldsAsAccessible) {
                    return;
                }
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    if (Log.DEBUG) {
                        Log.debug("kryo", "Unable to set field as accessible: " + field);
                    }
                    return;
                }
            }
            if ((optional = field.getAnnotation(FieldSerializer.Optional.class)) != null && !this.serializer.kryo.getContext().containsKey(optional.value())) {
                return;
            }
            if (this.removedFields.contains(field)) {
                return;
            }
            isTransient = Modifier.isTransient(modifiers);
            if (isTransient && !config.serializeTransient && !config.copyTransient) {
                return;
            }
            declaringClass = field.getDeclaringClass();
            genericType = new Generics.GenericType(declaringClass, this.serializer.type, field.getGenericType());
            fieldClass = genericType.getType() instanceof Class ? (Class)genericType.getType() : field.getType();
            accessIndex = -1;
            if (asm && !Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(fieldClass.getModifiers())) {
                try {
                    if (this.access == null) {
                        this.access = FieldAccess.get(this.serializer.type);
                    }
                    accessIndex = ((FieldAccess)this.access).getIndex(field);
                }
                catch (LinkageError | RuntimeException ex) {
                    if (!Log.DEBUG) break block27;
                    Log.debug("kryo", "Unable to use ReflectASM.", ex);
                }
            }
        }
        if (Util.unsafe) {
            cachedField = this.newUnsafeField(field, fieldClass, genericType);
        } else if (accessIndex != -1) {
            cachedField = this.newAsmField(field, fieldClass, genericType);
            cachedField.access = (FieldAccess)this.access;
            cachedField.accessIndex = accessIndex;
        } else {
            cachedField = this.newReflectField(field, fieldClass, genericType);
        }
        cachedField.varEncoding = config.varEncoding;
        cachedField.name = config.extendedFieldNames ? declaringClass.getSimpleName() + "." + field.getName() : field.getName();
        if (cachedField instanceof ReflectField) {
            boolean bl2 = cachedField.canBeNull = config.fieldsCanBeNull && !field.isAnnotationPresent(FieldSerializer.NotNull.class);
            if (this.serializer.kryo.isFinal(fieldClass) || config.fixedFieldTypes) {
                cachedField.valueClass = fieldClass;
            }
            if (Log.TRACE) {
                Log.trace("kryo", "Cached " + fieldClass.getSimpleName() + " field: " + field.getName() + " (" + Util.className(declaringClass) + ")");
            }
        } else {
            cachedField.canBeNull = fieldClass == String.class && config.fieldsCanBeNull;
            cachedField.valueClass = fieldClass;
            if (Log.TRACE) {
                Log.trace("kryo", "Cached " + fieldClass.getSimpleName() + " field: " + field.getName() + " (" + Util.className(declaringClass) + ")");
            }
        }
        this.applyAnnotations(cachedField);
        if (isTransient) {
            if (config.serializeTransient) {
                fields2.add(cachedField);
            }
            if (config.copyTransient) {
                copyFields.add(cachedField);
            }
        } else {
            fields2.add(cachedField);
            copyFields.add(cachedField);
        }
    }

    private FieldSerializer.CachedField newUnsafeField(Field field, Class fieldClass, Generics.GenericType genericType) {
        if (fieldClass.isPrimitive()) {
            if (fieldClass == Integer.TYPE) {
                return new UnsafeField.IntUnsafeField(field);
            }
            if (fieldClass == Float.TYPE) {
                return new UnsafeField.FloatUnsafeField(field);
            }
            if (fieldClass == Boolean.TYPE) {
                return new UnsafeField.BooleanUnsafeField(field);
            }
            if (fieldClass == Long.TYPE) {
                return new UnsafeField.LongUnsafeField(field);
            }
            if (fieldClass == Double.TYPE) {
                return new UnsafeField.DoubleUnsafeField(field);
            }
            if (fieldClass == Short.TYPE) {
                return new UnsafeField.ShortUnsafeField(field);
            }
            if (fieldClass == Character.TYPE) {
                return new UnsafeField.CharUnsafeField(field);
            }
            if (fieldClass == Byte.TYPE) {
                return new UnsafeField.ByteUnsafeField(field);
            }
        }
        if (!(fieldClass != String.class || this.serializer.kryo.getReferences() && this.serializer.kryo.getReferenceResolver().useReferences(String.class))) {
            return new UnsafeField.StringUnsafeField(field);
        }
        return new UnsafeField(field, this.serializer, genericType);
    }

    private FieldSerializer.CachedField newAsmField(Field field, Class fieldClass, Generics.GenericType genericType) {
        if (fieldClass.isPrimitive()) {
            if (fieldClass == Integer.TYPE) {
                return new AsmField.IntAsmField(field);
            }
            if (fieldClass == Float.TYPE) {
                return new AsmField.FloatAsmField(field);
            }
            if (fieldClass == Boolean.TYPE) {
                return new AsmField.BooleanAsmField(field);
            }
            if (fieldClass == Long.TYPE) {
                return new AsmField.LongAsmField(field);
            }
            if (fieldClass == Double.TYPE) {
                return new AsmField.DoubleAsmField(field);
            }
            if (fieldClass == Short.TYPE) {
                return new AsmField.ShortAsmField(field);
            }
            if (fieldClass == Character.TYPE) {
                return new AsmField.CharAsmField(field);
            }
            if (fieldClass == Byte.TYPE) {
                return new AsmField.ByteAsmField(field);
            }
        }
        if (!(fieldClass != String.class || this.serializer.kryo.getReferences() && this.serializer.kryo.getReferenceResolver().useReferences(String.class))) {
            return new AsmField.StringAsmField(field);
        }
        return new AsmField(field, this.serializer, genericType);
    }

    private FieldSerializer.CachedField newReflectField(Field field, Class fieldClass, Generics.GenericType genericType) {
        if (fieldClass.isPrimitive()) {
            if (fieldClass == Integer.TYPE) {
                return new ReflectField.IntReflectField(field);
            }
            if (fieldClass == Float.TYPE) {
                return new ReflectField.FloatReflectField(field);
            }
            if (fieldClass == Boolean.TYPE) {
                return new ReflectField.BooleanReflectField(field);
            }
            if (fieldClass == Long.TYPE) {
                return new ReflectField.LongReflectField(field);
            }
            if (fieldClass == Double.TYPE) {
                return new ReflectField.DoubleReflectField(field);
            }
            if (fieldClass == Short.TYPE) {
                return new ReflectField.ShortReflectField(field);
            }
            if (fieldClass == Character.TYPE) {
                return new ReflectField.CharReflectField(field);
            }
            if (fieldClass == Byte.TYPE) {
                return new ReflectField.ByteReflectField(field);
            }
        }
        return new ReflectField(field, this.serializer, genericType);
    }

    @Override
    public int compare(FieldSerializer.CachedField o1, FieldSerializer.CachedField o2) {
        return o1.name.compareTo(o2.name);
    }

    public void removeField(String fieldName) {
        FieldSerializer.CachedField[] newFields;
        FieldSerializer.CachedField cachedField;
        int i2;
        boolean found = false;
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            cachedField = this.fields[i2];
            if (!cachedField.name.equals(fieldName)) continue;
            newFields = new FieldSerializer.CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i2);
            System.arraycopy(this.fields, i2 + 1, newFields, i2, newFields.length - i2);
            this.fields = newFields;
            this.removedFields.add(cachedField.field);
            found = true;
            break;
        }
        for (i2 = 0; i2 < this.copyFields.length; ++i2) {
            cachedField = this.copyFields[i2];
            if (!cachedField.name.equals(fieldName)) continue;
            newFields = new FieldSerializer.CachedField[this.copyFields.length - 1];
            System.arraycopy(this.copyFields, 0, newFields, 0, i2);
            System.arraycopy(this.copyFields, i2 + 1, newFields, i2, newFields.length - i2);
            this.copyFields = newFields;
            this.removedFields.add(cachedField.field);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.serializer.type.getName());
        }
    }

    public void removeField(FieldSerializer.CachedField removeField) {
        FieldSerializer.CachedField[] newFields;
        FieldSerializer.CachedField cachedField;
        int i2;
        boolean found = false;
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            cachedField = this.fields[i2];
            if (cachedField != removeField) continue;
            newFields = new FieldSerializer.CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i2);
            System.arraycopy(this.fields, i2 + 1, newFields, i2, newFields.length - i2);
            this.fields = newFields;
            this.removedFields.add(cachedField.field);
            found = true;
            break;
        }
        for (i2 = 0; i2 < this.copyFields.length; ++i2) {
            cachedField = this.copyFields[i2];
            if (cachedField != removeField) continue;
            newFields = new FieldSerializer.CachedField[this.copyFields.length - 1];
            System.arraycopy(this.copyFields, 0, newFields, 0, i2);
            System.arraycopy(this.copyFields, i2 + 1, newFields, i2, newFields.length - i2);
            this.copyFields = newFields;
            this.removedFields.add(cachedField.field);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Field \"" + removeField + "\" not found on class: " + this.serializer.type.getName());
        }
    }

    private void applyAnnotations(FieldSerializer.CachedField cachedField) {
        Class valueClass;
        Annotation annotation;
        Field field = cachedField.field;
        if (field.isAnnotationPresent(FieldSerializer.Bind.class)) {
            Serializer serializer2;
            if (cachedField.serializer != null) {
                throw new KryoException("@Bind applied to a field that already has a serializer: " + cachedField.field.getDeclaringClass().getName() + "." + cachedField.field.getName());
            }
            annotation = field.getAnnotation(FieldSerializer.Bind.class);
            valueClass = annotation.valueClass();
            if (valueClass == Object.class) {
                valueClass = null;
            }
            if (valueClass != null) {
                cachedField.setValueClass(valueClass);
            }
            if ((serializer2 = this.newSerializer(valueClass, annotation.serializer(), annotation.serializerFactory())) != null) {
                cachedField.setSerializer(serializer2);
            }
            cachedField.setCanBeNull(annotation.canBeNull());
            cachedField.setVariableLengthEncoding(annotation.variableLengthEncoding());
            cachedField.setOptimizePositive(annotation.optimizePositive());
        }
        if (field.isAnnotationPresent(CollectionSerializer.BindCollection.class)) {
            if (cachedField.serializer != null) {
                throw new KryoException("@BindCollection applied to a field that already has a serializer: " + cachedField.field.getDeclaringClass().getName() + "." + cachedField.field.getName());
            }
            if (!Collection.class.isAssignableFrom(field.getType())) {
                throw new KryoException("@BindCollection can only be used with a field implementing Collection: " + Util.className(field.getType()));
            }
            annotation = field.getAnnotation(CollectionSerializer.BindCollection.class);
            Class elementClass = annotation.elementClass();
            if (elementClass == Object.class) {
                elementClass = null;
            }
            Serializer elementSerializer = this.newSerializer(elementClass, annotation.elementSerializer(), annotation.elementSerializerFactory());
            CollectionSerializer serializer3 = new CollectionSerializer();
            serializer3.setElementsCanBeNull(annotation.elementsCanBeNull());
            if (elementClass != null) {
                serializer3.setElementClass(elementClass);
            }
            if (elementSerializer != null) {
                serializer3.setElementSerializer(elementSerializer);
            }
            cachedField.setSerializer(serializer3);
        }
        if (field.isAnnotationPresent(MapSerializer.BindMap.class)) {
            if (cachedField.serializer != null) {
                throw new KryoException("@BindMap applied to a field that already has a serializer: " + cachedField.field.getDeclaringClass().getName() + "." + cachedField.field.getName());
            }
            if (!Map.class.isAssignableFrom(field.getType())) {
                throw new KryoException("@BindMap can only be used with a field implementing Map: " + Util.className(field.getType()));
            }
            annotation = field.getAnnotation(MapSerializer.BindMap.class);
            valueClass = annotation.valueClass();
            if (valueClass == Object.class) {
                valueClass = null;
            }
            Serializer valueSerializer = this.newSerializer(valueClass, annotation.valueSerializer(), annotation.valueSerializerFactory());
            Class keyClass = annotation.keyClass();
            if (keyClass == Object.class) {
                keyClass = null;
            }
            Serializer keySerializer = this.newSerializer(keyClass, annotation.keySerializer(), annotation.keySerializerFactory());
            MapSerializer serializer4 = new MapSerializer();
            serializer4.setKeysCanBeNull(annotation.keysCanBeNull());
            serializer4.setValuesCanBeNull(annotation.valuesCanBeNull());
            if (keyClass != null) {
                serializer4.setKeyClass(keyClass);
            }
            if (keySerializer != null) {
                serializer4.setKeySerializer(keySerializer);
            }
            if (valueClass != null) {
                serializer4.setValueClass(valueClass);
            }
            if (valueSerializer != null) {
                serializer4.setValueSerializer(valueSerializer);
            }
            cachedField.setSerializer(serializer4);
        }
    }

    private Serializer newSerializer(Class valueClass, Class serializerClass, Class factoryClass) {
        if (serializerClass == Serializer.class) {
            serializerClass = null;
        }
        if (factoryClass == SerializerFactory.class) {
            factoryClass = null;
        }
        if (factoryClass == null && serializerClass != null) {
            factoryClass = SerializerFactory.ReflectionSerializerFactory.class;
        }
        if (factoryClass == null) {
            return null;
        }
        return Util.newFactory(factoryClass, serializerClass).newSerializer(this.serializer.kryo, valueClass);
    }
}

