/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Field;

class ReflectField
extends FieldSerializer.CachedField {
    final FieldSerializer fieldSerializer;
    final Generics.GenericType genericType;

    ReflectField(Field field, FieldSerializer fieldSerializer, Generics.GenericType genericType) {
        super(field);
        this.fieldSerializer = fieldSerializer;
        this.genericType = genericType;
    }

    public Object get(Object object) throws IllegalAccessException {
        return this.field.get(object);
    }

    public void set(Object object, Object value) throws IllegalAccessException {
        this.field.set(object, value);
    }

    @Override
    public void write(Output output, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value = this.get(object);
            Serializer serializer2 = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                if (value == null) {
                    kryo.writeClass(output, null);
                    return;
                }
                Registration registration = kryo.writeClass(output, value.getClass());
                if (serializer2 == null) {
                    serializer2 = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                kryo.writeObject(output, value, serializer2);
            } else {
                if (serializer2 == null) {
                    serializer2 = kryo.getSerializer(concreteType);
                    if (this.valueClass != null && this.reuseSerializer) {
                        this.serializer = serializer2;
                    }
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                if (this.canBeNull) {
                    kryo.writeObjectOrNull(output, value, serializer2);
                } else {
                    if (value == null) {
                        throw new KryoException("Field value cannot be null when canBeNull is false: " + this.name + " (" + object.getClass().getName() + ")");
                    }
                    kryo.writeObject(output, value, serializer2);
                }
            }
            kryo.getGenerics().popGenericType();
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + object.getClass().getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex;
        }
        catch (StackOverflowError ex) {
            throw new KryoException("A StackOverflow occurred. The most likely cause is that your data has a circular reference resulting in infinite recursion. Try enabling references with Kryo.setReferences(true). If your data structure is really more than " + kryo.getDepth() + " levels deep then try increasing your Java stack size.", ex);
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex;
        }
    }

    @Override
    public void read(Input input2, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value;
            Serializer serializer2 = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                Registration registration = kryo.readClass(input2);
                if (registration == null) {
                    this.set(object, null);
                    return;
                }
                if (serializer2 == null) {
                    serializer2 = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = kryo.readObject(input2, registration.getType(), serializer2);
            } else {
                if (serializer2 == null) {
                    serializer2 = kryo.getSerializer(concreteType);
                    if (this.valueClass != null && this.reuseSerializer) {
                        this.serializer = serializer2;
                    }
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = this.canBeNull ? kryo.readObjectOrNull(input2, concreteType, serializer2) : kryo.readObject(input2, concreteType, serializer2);
            }
            kryo.getGenerics().popGenericType();
            this.set(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
    }

    Class resolveFieldClass() {
        Class fieldClass;
        if (this.valueClass == null && (fieldClass = this.genericType.resolve(this.fieldSerializer.kryo.getGenerics())) != null && this.fieldSerializer.kryo.isFinal(fieldClass)) {
            return this.field.getType().isArray() ? Util.getArrayType(fieldClass) : fieldClass;
        }
        return this.valueClass;
    }

    @Override
    public void copy(Object original, Object copy2) {
        try {
            this.set(copy2, this.fieldSerializer.kryo.copy(this.get(original)));
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
    }

    static final class DoubleReflectField
    extends FieldSerializer.CachedField {
        public DoubleReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeDouble(this.field.getDouble(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setDouble(object, input2.readDouble());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setDouble(copy2, this.field.getDouble(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }
    }

    static final class LongReflectField
    extends FieldSerializer.CachedField {
        public LongReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varEncoding) {
                    output.writeVarLong(this.field.getLong(object), false);
                } else {
                    output.writeLong(this.field.getLong(object));
                }
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setLong(object, input2.readVarLong(false));
                } else {
                    this.field.setLong(object, input2.readLong());
                }
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setLong(copy2, this.field.getLong(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }
    }

    static final class CharReflectField
    extends FieldSerializer.CachedField {
        public CharReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeChar(this.field.getChar(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setChar(object, input2.readChar());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setChar(copy2, this.field.getChar(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }
    }

    static final class BooleanReflectField
    extends FieldSerializer.CachedField {
        public BooleanReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeBoolean(this.field.getBoolean(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setBoolean(object, input2.readBoolean());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setBoolean(copy2, this.field.getBoolean(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }
    }

    static final class ByteReflectField
    extends FieldSerializer.CachedField {
        public ByteReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeByte(this.field.getByte(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setByte(object, input2.readByte());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setByte(copy2, this.field.getByte(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }
    }

    static final class ShortReflectField
    extends FieldSerializer.CachedField {
        public ShortReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeShort(this.field.getShort(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setShort(object, input2.readShort());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setShort(copy2, this.field.getShort(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }
    }

    static final class FloatReflectField
    extends FieldSerializer.CachedField {
        public FloatReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeFloat(this.field.getFloat(object));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                this.field.setFloat(object, input2.readFloat());
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setFloat(copy2, this.field.getFloat(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }
    }

    static final class IntReflectField
    extends FieldSerializer.CachedField {
        public IntReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varEncoding) {
                    output.writeVarInt(this.field.getInt(object), false);
                } else {
                    output.writeInt(this.field.getInt(object));
                }
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }

        @Override
        public void read(Input input2, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setInt(object, input2.readVarInt(false));
                } else {
                    this.field.setInt(object, input2.readInt());
                }
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            try {
                this.field.setInt(copy2, this.field.getInt(original));
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }
    }
}

