/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.ReflectField;
import com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import java.lang.reflect.Field;

class UnsafeField
extends ReflectField {
    public UnsafeField(Field field, FieldSerializer serializer2, Generics.GenericType genericType) {
        super(field, serializer2, genericType);
        this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
    }

    @Override
    public Object get(Object object) throws IllegalAccessException {
        return UnsafeUtil.unsafe.getObject(object, this.offset);
    }

    @Override
    public void set(Object object, Object value) throws IllegalAccessException {
        UnsafeUtil.unsafe.putObject(object, this.offset, value);
    }

    @Override
    public void copy(Object original, Object copy2) {
        try {
            UnsafeUtil.unsafe.putObject(copy2, this.offset, this.fieldSerializer.kryo.copy(UnsafeUtil.unsafe.getObject(original, this.offset)));
        }
        catch (KryoException ex) {
            ex.addTrace(this + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace(this + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
    }

    static final class StringUnsafeField
    extends FieldSerializer.CachedField {
        public StringUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeString((String)UnsafeUtil.unsafe.getObject(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putObject(object, this.offset, input2.readString());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putObject(copy2, this.offset, UnsafeUtil.unsafe.getObject(original, this.offset));
        }
    }

    static final class DoubleUnsafeField
    extends FieldSerializer.CachedField {
        public DoubleUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeDouble(UnsafeUtil.unsafe.getDouble(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putDouble(object, this.offset, input2.readDouble());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putDouble(copy2, this.offset, UnsafeUtil.unsafe.getDouble(original, this.offset));
        }
    }

    static final class LongUnsafeField
    extends FieldSerializer.CachedField {
        public LongUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varEncoding) {
                output.writeVarLong(UnsafeUtil.unsafe.getLong(object, this.offset), false);
            } else {
                output.writeLong(UnsafeUtil.unsafe.getLong(object, this.offset));
            }
        }

        @Override
        public void read(Input input2, Object object) {
            if (this.varEncoding) {
                UnsafeUtil.unsafe.putLong(object, this.offset, input2.readVarLong(false));
            } else {
                UnsafeUtil.unsafe.putLong(object, this.offset, input2.readLong());
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putLong(copy2, this.offset, UnsafeUtil.unsafe.getLong(original, this.offset));
        }
    }

    static final class CharUnsafeField
    extends FieldSerializer.CachedField {
        public CharUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeChar(UnsafeUtil.unsafe.getChar(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putChar(object, this.offset, input2.readChar());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putChar(copy2, this.offset, UnsafeUtil.unsafe.getChar(original, this.offset));
        }
    }

    static final class BooleanUnsafeField
    extends FieldSerializer.CachedField {
        public BooleanUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeBoolean(UnsafeUtil.unsafe.getBoolean(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putBoolean(object, this.offset, input2.readBoolean());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putBoolean(copy2, this.offset, UnsafeUtil.unsafe.getBoolean(original, this.offset));
        }
    }

    static final class ByteUnsafeField
    extends FieldSerializer.CachedField {
        public ByteUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeByte(UnsafeUtil.unsafe.getByte(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putByte(object, this.offset, input2.readByte());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putByte(copy2, this.offset, UnsafeUtil.unsafe.getByte(original, this.offset));
        }
    }

    static final class ShortUnsafeField
    extends FieldSerializer.CachedField {
        public ShortUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeShort(UnsafeUtil.unsafe.getShort(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putShort(object, this.offset, input2.readShort());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putShort(copy2, this.offset, UnsafeUtil.unsafe.getShort(original, this.offset));
        }
    }

    static final class FloatUnsafeField
    extends FieldSerializer.CachedField {
        public FloatUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            output.writeFloat(UnsafeUtil.unsafe.getFloat(object, this.offset));
        }

        @Override
        public void read(Input input2, Object object) {
            UnsafeUtil.unsafe.putFloat(object, this.offset, input2.readFloat());
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putFloat(copy2, this.offset, UnsafeUtil.unsafe.getFloat(original, this.offset));
        }
    }

    static final class IntUnsafeField
    extends FieldSerializer.CachedField {
        public IntUnsafeField(Field field) {
            super(field);
            this.offset = UnsafeUtil.unsafe.objectFieldOffset(field);
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varEncoding) {
                output.writeVarInt(UnsafeUtil.unsafe.getInt(object, this.offset), false);
            } else {
                output.writeInt(UnsafeUtil.unsafe.getInt(object, this.offset));
            }
        }

        @Override
        public void read(Input input2, Object object) {
            if (this.varEncoding) {
                UnsafeUtil.unsafe.putInt(object, this.offset, input2.readVarInt(false));
            } else {
                UnsafeUtil.unsafe.putInt(object, this.offset, input2.readInt());
            }
        }

        @Override
        public void copy(Object original, Object copy2) {
            UnsafeUtil.unsafe.putInt(copy2, this.offset, UnsafeUtil.unsafe.getInt(original, this.offset));
        }
    }
}

