/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.util.ObjectMap;

public class IdentityMap<K, V>
extends ObjectMap<K, V> {
    public IdentityMap() {
    }

    public IdentityMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityMap(IdentityMap<K, V> map2) {
        super(map2);
    }

    @Override
    protected int place(K item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    public <T extends K> V get(T key) {
        int i2 = this.place(key);
        Object other;
        while ((other = this.keyTable[i2]) != null) {
            if (other == key) {
                return (V)this.valueTable[i2];
            }
            i2 = i2 + 1 & this.mask;
        }
        return null;
    }

    @Override
    public V get(K key, V defaultValue) {
        int i2 = this.place(key);
        Object other;
        while ((other = this.keyTable[i2]) != null) {
            if (other == key) {
                return (V)this.valueTable[i2];
            }
            i2 = i2 + 1 & this.mask;
        }
        return defaultValue;
    }

    @Override
    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] keyTable = this.keyTable;
        int i2 = this.place(key);
        Object other;
        while ((other = keyTable[i2]) != null) {
            if (other == key) {
                return i2;
            }
            i2 = i2 + 1 & this.mask;
        }
        return -(i2 + 1);
    }

    @Override
    public int hashCode() {
        int h2 = this.size;
        Object[] keyTable = this.keyTable;
        Object[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object key = keyTable[i2];
            if (key == null) continue;
            h2 += System.identityHashCode(key);
            Object value = valueTable[i2];
            if (value == null) continue;
            h2 += value.hashCode();
        }
        return h2;
    }
}

