/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends ByteBasedScanner {
    protected InputStream _in;
    protected byte[] _inputBuffer;
    protected final XmlCharTypes _charTypes;
    protected final ByteBasedPNameTable _symbols;
    protected int[] _quadBuffer = new int[32];

    public StreamScanner(ReaderConfig cfg, InputStream in, byte[] buffer, int ptr, int last2) {
        super(cfg);
        this._charTypes = cfg.getCharTypes();
        this._symbols = cfg.getBBSymbols();
        this._in = in;
        this._inputBuffer = buffer;
        this._inputPtr = ptr;
        this._inputEnd = last2;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateBBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullBBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected abstract int handleEntityInText(boolean var1) throws XMLStreamException;

    protected abstract String parsePublicId(byte var1) throws XMLStreamException;

    protected abstract String parseSystemId(byte var1) throws XMLStreamException;

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        byte b2;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            int c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 60) break;
            if (c2 == 32) continue;
            if (c2 == 10) {
                this.markLF();
                continue;
            }
            if (c2 == 13) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c2 == 9) continue;
            this.reportPrologUnexpChar(isProlog, this.decodeCharForError((byte)c2), null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((b2 = this._inputBuffer[this._inputPtr++]) == 33) {
            return this.handlePrologDeclStart(isProlog);
        }
        if (b2 == 63) {
            return this.handlePIStart();
        }
        if (b2 == 47 || !isProlog) {
            this.reportPrologUnexpElement(isProlog, b2);
        }
        return this.handleStartElement(b2);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        byte b2 = this._inputBuffer[this._inputPtr];
        if (b2 == 60) {
            ++this._inputPtr;
            byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (b2 == 33) {
                return this.handleCommentOrCdataStart();
            }
            if (b2 == 63) {
                return this.handlePIStart();
            }
            if (b2 == 47) {
                return this.handleEndElement();
            }
            return this.handleStartElement(b2);
        }
        if (b2 == 38) {
            ++this._inputPtr;
            int i2 = this.handleEntityInText(false);
            if (i2 == 0) {
                this._currToken = 9;
                return 9;
            }
            this._tmpChar = -i2;
        } else {
            this._tmpChar = b2 & 0xFF;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    private final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        byte b2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b2 = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) == 45) {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (b2 == 68 && isProlog) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b2), " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        byte b2 = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(b2);
        b2 = this.skipInternalWs(false, null);
        if (b2 == 80) {
            this.matchAsciiKeyword("PUBLIC");
            b2 = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(b2);
            b2 = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(b2);
            b2 = this.skipInternalWs(false, null);
        } else if (b2 == 83) {
            this.matchAsciiKeyword("SYSTEM");
            b2 = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(b2);
            b2 = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (b2 == 62) {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (b2 != 91) {
            String msg = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(this.decodeCharForError(b2), msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    private final int handleCommentOrCdataStart() throws XMLStreamException {
        byte b2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b2 = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(b2), " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (b2 == 91) {
            this._currToken = 12;
            for (int i2 = 0; i2 < 6; ++i2) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b2 = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i2)) continue;
                int ch = this.decodeCharForError(b2);
                this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(this.decodeCharForError(b2), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private final int handlePIStart() throws XMLStreamException {
        int c2;
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b2 = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(b2);
        String ln = this._tokenName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) {
            while (true) {
                if (c2 == 10) {
                    this.markLF();
                } else if (c2 == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c2 != 32 && c2 != 9) {
                    this.throwInvalidSpace(c2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr] & 0xFF) > 32) break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (c2 != 63) {
                this.reportMissingPISpace(this.decodeCharForError((byte)c2));
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportMissingPISpace(this.decodeCharForError(b2));
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b2 = this._inputBuffer[this._inputPtr++];
        int value = 0;
        if (b2 == 120) {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b2 = this._inputBuffer[this._inputPtr++]) != 59) {
                    value <<= 4;
                    byte c2 = b2;
                    if (c2 <= 57 && c2 >= 48) {
                        value += c2 - 48;
                    } else if (c2 >= 97 && c2 <= 102) {
                        value += 10 + (c2 - 97);
                    } else if (c2 >= 65 && c2 <= 70) {
                        value += 10 + (c2 - 65);
                    } else {
                        this.throwUnexpectedChar(this.decodeCharForError(b2), "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (b2 != 59) {
                byte c3 = b2;
                if (c3 <= 57 && c3 >= 48) {
                    if ((value = value * 10 + (c3 - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(this.decodeCharForError(b2), "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                b2 = this._inputBuffer[this._inputPtr++];
            }
        }
        this.verifyXmlChar(value);
        return value;
    }

    protected abstract int handleStartElement(byte var1) throws XMLStreamException;

    protected final int handleEndElement() throws XMLStreamException {
        int q2;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        int size = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (size << 2) + 1) {
            return this.handleEndElementSlow(size);
        }
        int ptr = this._inputPtr;
        byte[] buf = this._inputBuffer;
        --size;
        for (int qix = 0; qix < size; ++qix) {
            q2 = buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF;
            ptr += 4;
            if (q2 == this._tokenName.getQuad(qix)) continue;
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int lastQ = this._tokenName.getQuad(size);
        if ((q2 = buf[ptr++] & 0xFF) != lastQ && (q2 = q2 << 8 | buf[ptr++] & 0xFF) != lastQ && (q2 = q2 << 8 | buf[ptr++] & 0xFF) != lastQ && (q2 = q2 << 8 | buf[ptr++] & 0xFF) != lastQ) {
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int i2 = this._inputBuffer[ptr] & 0xFF;
        this._inputPtr = ptr + 1;
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b2;
                byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b2 & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    private final int handleEndElementSlow(int size) throws XMLStreamException {
        block14: {
            int i2;
            int q2;
            --size;
            for (int qix = 0; qix < size; ++qix) {
                q2 = 0;
                for (i2 = 0; i2 < 4; ++i2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    q2 = q2 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                }
                if (q2 == this._tokenName.getQuad(qix)) continue;
                this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
            }
            int lastQ = this._tokenName.getQuad(size);
            q2 = 0;
            i2 = 0;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((q2 = q2 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF) == lastQ) break block14;
            } while (++i2 <= 3);
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int i2 = this._inputBuffer[this._inputPtr++];
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b2;
                byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b2 & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    protected final PName parsePName(byte b2) throws XMLStreamException {
        int i2;
        if (this._inputEnd - this._inputPtr < 8) {
            return this.parsePNameSlow(b2);
        }
        int q2 = b2 & 0xFF;
        if (q2 < 65) {
            this.throwUnexpectedChar(q2, "; expected a name start character");
        }
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q2, 1);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q2, 2);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q2, 3);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q2, 4);
        }
        return this.parsePNameMedium(i2, q2);
    }

    protected PName parsePNameMedium(int i2, int q1) throws XMLStreamException {
        int q2 = i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 1);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 2);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 3);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 4);
        }
        int[] quads = this._quadBuffer;
        quads[0] = q1;
        quads[1] = q2;
        return this.parsePNameLong(i2, quads);
    }

    protected final PName parsePNameLong(int q2, int[] quads) throws XMLStreamException {
        int qix = 2;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, quads, qix, 1);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, quads, qix, 2);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, quads, qix, 3);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, quads, qix, 4);
            }
            if (qix >= quads.length) {
                quads = DataUtil.growArrayBy(quads, quads.length);
                this._quadBuffer = quads;
            }
            quads[qix] = q2;
            ++qix;
            q2 = i2;
        }
    }

    protected final PName parsePNameSlow(byte b2) throws XMLStreamException {
        int q2 = b2 & 0xFF;
        if (q2 < 65) {
            this.throwUnexpectedChar(q2, "; expected a name start character");
        }
        int[] quads = this._quadBuffer;
        int qix = 0;
        int firstQuad = 0;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, 1, firstQuad, qix, quads);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, 2, firstQuad, qix, quads);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, 3, firstQuad, qix, quads);
            }
            q2 = q2 << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q2, 4, firstQuad, qix, quads);
            }
            if (qix == 0) {
                firstQuad = q2;
            } else if (qix == 1) {
                quads[0] = firstQuad;
                quads[1] = q2;
            } else {
                if (qix >= quads.length) {
                    this._quadBuffer = quads = DataUtil.growArrayBy(quads, quads.length);
                }
                quads[qix] = q2;
            }
            ++qix;
            q2 = i2;
        }
    }

    private final PName findPName(int onlyQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(onlyQuad);
        PName name2 = this._symbols.findSymbol(hash, onlyQuad, 0);
        if (name2 == null) {
            this._quadBuffer[0] = onlyQuad;
            name2 = this.addPName(hash, this._quadBuffer, 1, lastByteCount);
        }
        return name2;
    }

    private final PName findPName(int firstQuad, int secondQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(firstQuad, secondQuad);
        PName name2 = this._symbols.findSymbol(hash, firstQuad, secondQuad);
        if (name2 == null) {
            this._quadBuffer[0] = firstQuad;
            this._quadBuffer[1] = secondQuad;
            name2 = this.addPName(hash, this._quadBuffer, 2, lastByteCount);
        }
        return name2;
    }

    private final PName findPName(int lastQuad, int[] quads, int qlen, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        if (qlen >= quads.length) {
            quads = DataUtil.growArrayBy(quads, quads.length);
            this._quadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(quads, qlen);
        PName name2 = this._symbols.findSymbol(hash, quads, qlen);
        if (name2 == null) {
            name2 = this.addPName(hash, quads, qlen, lastByteCount);
        }
        return name2;
    }

    private final PName findPName(int lastQuad, int lastByteCount, int firstQuad, int qlen, int[] quads) throws XMLStreamException {
        if (qlen <= 1) {
            if (qlen == 0) {
                return this.findPName(lastQuad, lastByteCount);
            }
            return this.findPName(firstQuad, lastQuad, lastByteCount);
        }
        return this.findPName(lastQuad, quads, qlen, lastByteCount);
    }

    protected final PName addPName(int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        return this.addUTFPName(this._symbols, this._charTypes, hash, quads, qlen, lastQuadBytes);
    }

    protected byte skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        byte b2;
        int c2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = (b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) {
            if (!reqd) {
                return b2;
            }
            this.reportTreeUnexpChar(this.decodeCharForError(b2), " (expected white space " + msg + ")");
        }
        do {
            if (b2 == 10) {
                this.markLF();
            } else if (b2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (b2 != 32 && b2 != 9) {
                this.throwInvalidSpace(b2);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while (((b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
        return b2;
    }

    private final void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i2 = 1; i2 < len; ++i2) {
            byte b2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) == (byte)keyw.charAt(i2)) continue;
            this.reportTreeUnexpChar(this.decodeCharForError(b2), " (expected '" + keyw.charAt(i2) + "' for " + keyw + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(int c2) throws XMLStreamException {
        int count2;
        int max;
        byte b2;
        if (c2 == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b2 = this._inputBuffer[this._inputPtr]) != 32 && b2 != 9) {
            if (b2 == 60 && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != 33) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n2 = max = b2 == 32 ? 32 : 8;
        for (count2 = 1; count2 <= max; ++count2) {
            byte b22;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b22 = this._inputBuffer[this._inputPtr]) != b2) {
                if (b22 != 60 || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == 33) break;
                this._textBuilder.resetWithIndentation(count2, (char)b2);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outBuf = this._textBuilder.resetWithEmpty();
        outBuf[0] = 10;
        char ind = (char)b2;
        for (int i2 = 1; i2 <= count2; ++i2) {
            outBuf[i2] = ind;
        }
        this._textBuilder.setCurrentLength(++count2);
        return count2;
    }

    protected final int checkPrologIndentation(int c2) throws XMLStreamException {
        int max;
        if (c2 == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        byte b2 = this._inputBuffer[this._inputPtr];
        if (b2 != 32 && b2 != 9) {
            if (b2 == 60) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count2 = 1;
        int n2 = max = b2 == 32 ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == b2) {
            ++this._inputPtr;
            if (++count2 < max) continue;
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            char ind = (char)b2;
            for (int i2 = 1; i2 <= count2; ++i2) {
                outBuf[i2] = ind;
            }
            this._textBuilder.setCurrentLength(++count2);
            return count2;
        }
        this._textBuilder.resetWithIndentation(count2, (char)b2);
        return -1;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        try {
            int count2 = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count2 < 1) {
                this._inputEnd = 0;
                if (count2 == 0) {
                    this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count2;
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final byte nextByte(int tt) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(tt));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte nextByte() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne(int type) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(type));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int nrOfChars) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count2;
                if ((count2 = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count2 == 0) {
                        this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count2;
            } while (this._inputEnd < nrOfChars);
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }
}

