/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

public class XmlCharTypes {
    public static final int CT_OK = 0;
    public static final int CT_INVALID = 1;
    public static final int CT_WS_CR = 2;
    public static final int CT_WS_LF = 3;
    public static final int CT_MULTIBYTE_N = 4;
    public static final int CT_MULTIBYTE_2 = 5;
    public static final int CT_MULTIBYTE_3 = 6;
    public static final int CT_MULTIBYTE_4 = 7;
    public static final int CT_WS_TAB = 8;
    public static final int CT_LT = 9;
    public static final int CT_AMP = 10;
    public static final int CT_RBRACKET = 11;
    public static final int CT_QMARK = 12;
    public static final int CT_HYPHEN = 13;
    public static final int CT_ATTR_QUOTE = 14;
    public static final int CT_LBRACKET = 16;
    public static final int CT_GT = 17;
    public static final int CT_DTD_QUOTE = 8;
    public static final int CT_DTD_LT = 9;
    public static final int CT_DTD_GT = 10;
    public static final int CT_DTD_RBRACKET = 11;
    public static final int CT_DTD_PERCENT = 12;
    public static final int CT_NAME_NONE = 0;
    public static final int CT_NAME_COLON = 1;
    public static final int CT_NAME_NONFIRST = 2;
    public static final int CT_NAME_ANY = 3;
    public static final int PUBID_INVALID = 0;
    public static final int PUBID_OK = 1;
    public final int[] TEXT_CHARS;
    public final int[] ATTR_CHARS;
    public final int[] NAME_CHARS;
    public final int[] DTD_CHARS;
    public final int[] OTHER_CHARS;
    public static final int[] PUBID_CHARS;

    public XmlCharTypes() {
        this(256);
    }

    public XmlCharTypes(int size) {
        this.TEXT_CHARS = new int[size];
        this.ATTR_CHARS = new int[size];
        this.NAME_CHARS = new int[size];
        this.DTD_CHARS = new int[size];
        this.OTHER_CHARS = new int[size];
    }

    public static void fillInLatin1Chars(int[] textChars, int[] attrChars, int[] nameChars, int[] dtdChars, int[] otherChars) {
        XmlCharTypes.fillIn8BitTextRange(textChars);
        XmlCharTypes.fillIn8BitAttrRange(attrChars);
        XmlCharTypes.fillIn8BitNameRange(nameChars);
        for (int i2 = 192; i2 <= 255; ++i2) {
            if (i2 == 215 || i2 == 247) continue;
            nameChars[i2] = 3;
        }
        nameChars[183] = 2;
        XmlCharTypes.fillIn8BitDtdRange(dtdChars);
        XmlCharTypes.fillIn8BitTextRange(otherChars);
        otherChars[38] = 0;
        otherChars[60] = 0;
        otherChars[93] = 11;
        otherChars[63] = 12;
        otherChars[45] = 13;
    }

    private static void fillInCommonTextRange(int[] arr) {
        for (int i2 = 0; i2 < 32; ++i2) {
            arr[i2] = 1;
        }
        arr[13] = 2;
        arr[10] = 3;
        arr[9] = 0;
    }

    public static void fillIn8BitNameRange(int[] arr) {
        int i2;
        for (i2 = 97; i2 <= 122; ++i2) {
            arr[i2] = 3;
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            arr[i2] = 3;
        }
        arr[95] = 3;
        arr[58] = 1;
        arr[45] = 2;
        arr[46] = 2;
        for (i2 = 48; i2 <= 57; ++i2) {
            arr[i2] = 2;
        }
    }

    protected static void fillIn8BitTextRange(int[] arr) {
        XmlCharTypes.fillInCommonTextRange(arr);
        arr[60] = 9;
        arr[38] = 10;
        arr[93] = 11;
    }

    protected static void fillIn8BitAttrRange(int[] arr) {
        XmlCharTypes.fillInCommonTextRange(arr);
        arr[9] = 8;
        arr[60] = 9;
        arr[38] = 10;
        arr[39] = 14;
        arr[34] = 14;
    }

    protected static void fillIn8BitDtdRange(int[] arr) {
        XmlCharTypes.fillInCommonTextRange(arr);
        arr[39] = 8;
        arr[34] = 8;
        arr[60] = 9;
        arr[62] = 10;
        arr[93] = 11;
        arr[37] = 12;
    }

    static {
        int i2;
        PUBID_CHARS = new int[256];
        int last2 = 25;
        for (i2 = 0; i2 <= last2; ++i2) {
            XmlCharTypes.PUBID_CHARS[65 + i2] = 1;
            XmlCharTypes.PUBID_CHARS[97 + i2] = 1;
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            XmlCharTypes.PUBID_CHARS[i2] = 1;
        }
        XmlCharTypes.PUBID_CHARS[10] = 1;
        XmlCharTypes.PUBID_CHARS[13] = 1;
        XmlCharTypes.PUBID_CHARS[32] = 1;
        XmlCharTypes.PUBID_CHARS[45] = 1;
        XmlCharTypes.PUBID_CHARS[39] = 1;
        XmlCharTypes.PUBID_CHARS[40] = 1;
        XmlCharTypes.PUBID_CHARS[41] = 1;
        XmlCharTypes.PUBID_CHARS[43] = 1;
        XmlCharTypes.PUBID_CHARS[44] = 1;
        XmlCharTypes.PUBID_CHARS[46] = 1;
        XmlCharTypes.PUBID_CHARS[47] = 1;
        XmlCharTypes.PUBID_CHARS[58] = 1;
        XmlCharTypes.PUBID_CHARS[61] = 1;
        XmlCharTypes.PUBID_CHARS[63] = 1;
        XmlCharTypes.PUBID_CHARS[59] = 1;
        XmlCharTypes.PUBID_CHARS[33] = 1;
        XmlCharTypes.PUBID_CHARS[42] = 1;
        XmlCharTypes.PUBID_CHARS[35] = 1;
        XmlCharTypes.PUBID_CHARS[64] = 1;
        XmlCharTypes.PUBID_CHARS[36] = 1;
        XmlCharTypes.PUBID_CHARS[95] = 1;
        XmlCharTypes.PUBID_CHARS[37] = 1;
    }
}

