/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.FS;
import com.github.benmanes.caffeine.cache.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;

class FSA<K, V>
extends FS<K, V> {
    protected static final VarHandle ACCESS_TIME;
    volatile long accessTime;
    Node<K, V> previousInAccessOrder;
    Node<K, V> nextInAccessOrder;

    FSA() {
    }

    FSA(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        super(k2, referenceQueue, v2, referenceQueue2, n2, l2);
        ACCESS_TIME.set(this, l2);
    }

    FSA(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        super(object, v2, referenceQueue, n2, l2);
        ACCESS_TIME.set(this, l2);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> node) {
        this.previousInAccessOrder = node;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> node) {
        this.nextInAccessOrder = node;
    }

    @Override
    public long getVariableTime() {
        return ACCESS_TIME.getOpaque(this);
    }

    @Override
    public void setVariableTime(long l2) {
        ACCESS_TIME.setOpaque(this, l2);
    }

    @Override
    public boolean casVariableTime(long l2, long l3) {
        return this.accessTime == l2 && ACCESS_TIME.compareAndSet(this, l2, l3);
    }

    @Override
    public final long getAccessTime() {
        return ACCESS_TIME.getOpaque(this);
    }

    @Override
    public final void setAccessTime(long l2) {
        ACCESS_TIME.setOpaque(this, l2);
    }

    @Override
    public final Node<K, V> getPreviousInAccessOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public final void setPreviousInAccessOrder(Node<K, V> node) {
        this.previousInAccessOrder = node;
    }

    @Override
    public final Node<K, V> getNextInAccessOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public final void setNextInAccessOrder(Node<K, V> node) {
        this.nextInAccessOrder = node;
    }

    @Override
    public Node<K, V> newNode(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        return new FSA<K, V>(k2, referenceQueue, v2, referenceQueue2, n2, l2);
    }

    @Override
    public Node<K, V> newNode(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        return new FSA<K, V>(object, v2, referenceQueue, n2, l2);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            ACCESS_TIME = lookup.findVarHandle(FSA.class, "accessTime", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

