/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.checkerframework.checker.index.qual.NonNegative;

final class FrequencySketch<E> {
    static final long RESET_MASK = 0x7777777777777777L;
    static final long ONE_MASK = 0x1111111111111111L;
    int sampleSize;
    int blockMask;
    long[] table;
    int size;

    public void ensureCapacity(@NonNegative long maximumSize) {
        Caffeine.requireArgument(maximumSize >= 0L);
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[Math.max(Caffeine.ceilingPowerOfTwo(maximum), 8)];
        this.sampleSize = maximumSize == 0L ? 10 : 10 * maximum;
        this.blockMask = (this.table.length >>> 3) - 1;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    public boolean isNotInitialized() {
        return this.table == null;
    }

    public @NonNegative int frequency(E e2) {
        if (this.isNotInitialized()) {
            return 0;
        }
        int[] count2 = new int[4];
        int blockHash = FrequencySketch.spread(e2.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        for (int i2 = 0; i2 < 4; ++i2) {
            int h2 = counterHash >>> (i2 << 3);
            int index2 = h2 >>> 1 & 0xF;
            int offset = h2 & 1;
            count2[i2] = (int)(this.table[block + offset + (i2 << 1)] >>> (index2 << 2) & 0xFL);
        }
        return Math.min(Math.min(count2[0], count2[1]), Math.min(count2[2], count2[3]));
    }

    public void increment(E e2) {
        if (this.isNotInitialized()) {
            return;
        }
        int[] index2 = new int[8];
        int blockHash = FrequencySketch.spread(e2.hashCode());
        int counterHash = FrequencySketch.rehash(blockHash);
        int block = (blockHash & this.blockMask) << 3;
        for (int i2 = 0; i2 < 4; ++i2) {
            int h2 = counterHash >>> (i2 << 3);
            index2[i2] = h2 >>> 1 & 0xF;
            int offset = h2 & 1;
            index2[i2 + 4] = block + offset + (i2 << 1);
        }
        boolean added = this.incrementAt(index2[4], index2[0]) | this.incrementAt(index2[5], index2[1]) | this.incrementAt(index2[6], index2[2]) | this.incrementAt(index2[7], index2[3]);
        if (added && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    static int spread(int x2) {
        x2 ^= x2 >>> 17;
        x2 *= -312814405;
        x2 ^= x2 >>> 11;
        x2 *= -1404298415;
        x2 ^= x2 >>> 15;
        return x2;
    }

    static int rehash(int x2) {
        x2 *= 830770091;
        x2 ^= x2 >>> 14;
        return x2;
    }

    boolean incrementAt(int i2, int j2) {
        int offset = j2 << 2;
        long mask = 15L << offset;
        if ((this.table[i2] & mask) != mask) {
            int n2 = i2;
            this.table[n2] = this.table[n2] + (1L << offset);
            return true;
        }
        return false;
    }

    void reset() {
        int count2 = 0;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            count2 += Long.bitCount(this.table[i2] & 0x1111111111111111L);
            this.table[i2] = this.table[i2] >>> 1 & 0x7777777777777777L;
        }
        this.size = this.size - (count2 >>> 2) >>> 1;
    }
}

