/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

class PS<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final VarHandle KEY;
    protected static final VarHandle VALUE;
    volatile K key;
    volatile V value;

    PS() {
    }

    PS(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        this(k2, v2, referenceQueue2, n2, l2);
    }

    PS(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        KEY.set(this, object);
        VALUE.set(this, v2);
    }

    @Override
    public final K getKey() {
        return (K)KEY.get(this);
    }

    @Override
    public final Object getKeyReference() {
        return KEY.get(this);
    }

    @Override
    public final V getValue() {
        return (V)VALUE.get(this);
    }

    @Override
    public final Object getValueReference() {
        return VALUE.get(this);
    }

    @Override
    public final void setValue(V v2, ReferenceQueue<V> referenceQueue) {
        VALUE.setRelease(this, v2);
    }

    @Override
    public final boolean containsValue(Object object) {
        return Objects.equals(object, this.getValue());
    }

    @Override
    public Node<K, V> newNode(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        return new PS<K, V>(k2, referenceQueue, v2, referenceQueue2, n2, l2);
    }

    @Override
    public Node<K, V> newNode(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        return new PS<K, V>(object, v2, referenceQueue, n2, l2);
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_STRONG_KEY && object != DEAD_STRONG_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_STRONG_KEY;
    }

    @Override
    public final void retire() {
        KEY.set(this, RETIRED_STRONG_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_STRONG_KEY;
    }

    @Override
    public final void die() {
        VALUE.set(this, null);
        KEY.set(this, DEAD_STRONG_KEY);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            KEY = lookup.findVarHandle(PS.class, "key", Object.class);
            VALUE = lookup.findVarHandle(PS.class, "value", Object.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

