/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@CheckForNull String string2) {
        return Platform.nullToEmpty(string2);
    }

    @CheckForNull
    public static String emptyToNull(@CheckForNull String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(@CheckForNull String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    @InlineMe(replacement="string.repeat(count)")
    @InlineMeValidationDisabled(value="Java 11+ API only")
    public static String repeat(String string2, int count2) {
        int n2;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array2 = new char[size];
        string2.getChars(0, len, array2, 0);
        for (n2 = len; n2 < size - n2; n2 <<= 1) {
            System.arraycopy(array2, 0, array2, n2, n2);
        }
        System.arraycopy(array2, 0, array2, n2, size - n2);
        return new String(array2);
    }

    public static String commonPrefix(CharSequence a2, CharSequence b2) {
        int p2;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxPrefixLength = Math.min(a2.length(), b2.length());
        for (p2 = 0; p2 < maxPrefixLength && a2.charAt(p2) == b2.charAt(p2); ++p2) {
        }
        if (Strings.validSurrogatePairAt(a2, p2 - 1) || Strings.validSurrogatePairAt(b2, p2 - 1)) {
            --p2;
        }
        return a2.subSequence(0, p2).toString();
    }

    public static String commonSuffix(CharSequence a2, CharSequence b2) {
        int s2;
        Preconditions.checkNotNull(a2);
        Preconditions.checkNotNull(b2);
        int maxSuffixLength = Math.min(a2.length(), b2.length());
        for (s2 = 0; s2 < maxSuffixLength && a2.charAt(a2.length() - s2 - 1) == b2.charAt(b2.length() - s2 - 1); ++s2) {
        }
        if (Strings.validSurrogatePairAt(a2, a2.length() - s2 - 1) || Strings.validSurrogatePairAt(b2, b2.length() - s2 - 1)) {
            --s2;
        }
        return a2.subSequence(a2.length() - s2, a2.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string2, int index2) {
        return index2 >= 0 && index2 <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index2)) && Character.isLowSurrogate(string2.charAt(index2 + 1));
    }

    public static String lenientFormat(@CheckForNull String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                args2[i2] = Strings.lenientToString(args2[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i3 = 0;
        while (i3 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i3++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i3 < args2.length) {
            builder.append(" [");
            builder.append(args2[i3++]);
            while (i3 < args2.length) {
                builder.append(", ");
                builder.append(args2[i3++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@CheckForNull Object o2) {
        if (o2 == null) {
            return "null";
        }
        try {
            return o2.toString();
        }
        catch (Exception e2) {
            String objectToString = o2.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o2));
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e2);
            return "<" + objectToString + " threw " + e2.getClass().getName() + ">";
        }
    }
}

