/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

@Immutable
@ElementTypesAreNonnullByDefault
abstract class AbstractNonStreamingHashFunction
extends AbstractHashFunction {
    AbstractNonStreamingHashFunction() {
    }

    @Override
    public Hasher newHasher() {
        return this.newHasher(32);
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0);
        return new BufferingHasher(expectedInputSize);
    }

    @Override
    public HashCode hashInt(int input2) {
        return this.hashBytes(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(input2).array());
    }

    @Override
    public HashCode hashLong(long input2) {
        return this.hashBytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(input2).array());
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input2) {
        int len = input2.length();
        ByteBuffer buffer = ByteBuffer.allocate(len * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (int i2 = 0; i2 < len; ++i2) {
            buffer.putChar(input2.charAt(i2));
        }
        return this.hashBytes(buffer.array());
    }

    @Override
    public HashCode hashString(CharSequence input2, Charset charset) {
        return this.hashBytes(input2.toString().getBytes(charset));
    }

    @Override
    public abstract HashCode hashBytes(byte[] var1, int var2, int var3);

    @Override
    public HashCode hashBytes(ByteBuffer input2) {
        return this.newHasher(input2.remaining()).putBytes(input2).hash();
    }

    private static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ExposedByteArrayOutputStream(int expectedInputSize) {
            super(expectedInputSize);
        }

        void write(ByteBuffer input2) {
            int remaining = input2.remaining();
            if (this.count + remaining > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.count + remaining);
            }
            input2.get(this.buf, this.count, remaining);
            this.count += remaining;
        }

        byte[] byteArray() {
            return this.buf;
        }

        int length() {
            return this.count;
        }
    }

    private final class BufferingHasher
    extends AbstractHasher {
        final ExposedByteArrayOutputStream stream;

        BufferingHasher(int expectedInputSize) {
            this.stream = new ExposedByteArrayOutputStream(expectedInputSize);
        }

        @Override
        public Hasher putByte(byte b2) {
            this.stream.write(b2);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes2, int off, int len) {
            this.stream.write(bytes2, off, len);
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer bytes2) {
            this.stream.write(bytes2);
            return this;
        }

        @Override
        public HashCode hash() {
            return AbstractNonStreamingHashFunction.this.hashBytes(this.stream.byteArray(), 0, this.stream.length());
        }
    }
}

