/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class MathPreconditions {
    @CanIgnoreReturnValue
    static int checkPositive(String role, int x2) {
        if (x2 <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static long checkPositive(String role, long x2) {
        if (x2 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static BigInteger checkPositive(String role, BigInteger x2) {
        if (x2.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(String role, int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(String role, long x2) {
        if (x2 < 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static BigInteger checkNonNegative(String role, BigInteger x2) {
        if (x2.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    @CanIgnoreReturnValue
    static double checkNonNegative(String role, double x2) {
        if (!(x2 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition2) {
        if (!condition2) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition2, double input2, RoundingMode mode) {
        if (!condition2) {
            throw new ArithmeticException("rounded value is out of range for input " + input2 + " and rounding mode " + (Object)((Object)mode));
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, int a2, int b2) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a2 + ", " + b2 + ")");
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, long a2, long b2) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a2 + ", " + b2 + ")");
        }
    }

    private MathPreconditions() {
    }
}

