/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value) {
        return value ^ Integer.MIN_VALUE;
    }

    public static int compare(int a2, int b2) {
        return Ints.compare(UnsignedInts.flip(a2), UnsignedInts.flip(b2));
    }

    public static long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int checkedCast(long value) {
        Preconditions.checkArgument(value >> 32 == 0L, "out of range: %s", value);
        return (int)value;
    }

    public static int saturatedCast(long value) {
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0x100000000L) {
            return -1;
        }
        return (int)value;
    }

    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = UnsignedInts.flip(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            int next = UnsignedInts.flip(array2[i2]);
            if (next >= min2) continue;
            min2 = next;
        }
        return UnsignedInts.flip(min2);
    }

    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = UnsignedInts.flip(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            int next = UnsignedInts.flip(array2[i2]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedInts.flip(max);
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedInts.toString(array2[0]));
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(UnsignedInts.toString(array2[i2]));
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sort(array2, 0, array2.length);
    }

    public static void sort(int[] array2, int fromIndex, int toIndex) {
        int i2;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedInts.flip(array2[i2]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedInts.flip(array2[i2]);
        }
    }

    public static void sortDescending(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        while (i2 < toIndex) {
            int n2 = i2++;
            array2[n2] = array2[n2] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i2 = fromIndex;
        while (i2 < toIndex) {
            int n3 = i2++;
            array2[n3] = array2[n3] ^ Integer.MAX_VALUE;
        }
    }

    public static int divide(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong(divisor));
    }

    public static int remainder(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong(divisor));
    }

    @CanIgnoreReturnValue
    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e2) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e2);
            throw decodeException;
        }
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String s2) {
        return UnsignedInts.parseUnsignedInt(s2, 10);
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        long result2 = Long.parseLong(string2, radix);
        if ((result2 & 0xFFFFFFFFL) != result2) {
            throw new NumberFormatException("Input " + string2 + " in base " + radix + " is not in the range of an unsigned integer");
        }
        return (int)result2;
    }

    public static String toString(int x2) {
        return UnsignedInts.toString(x2, 10);
    }

    public static String toString(int x2, int radix) {
        long asLong = (long)x2 & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                if (left[i2] == right[i2]) continue;
                return UnsignedInts.compare(left[i2], right[i2]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

