/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.lang.UrlClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private Reference<ResourceBundle> myBundle;
    private Reference<ResourceBundle> myDefaultBundle;
    @NotNull
    private final ClassLoader myBundleClassLoader;
    @NonNls
    private final String myPathToBundle;

    public AbstractBundle(@NotNull Class<?> bundleClass, @NonNls @NotNull String pathToBundle) {
        if (bundleClass == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = bundleClass.getClassLoader();
    }

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        this.myPathToBundle = pathToBundle;
        this.myBundleClassLoader = this.getClass().getClassLoader();
    }

    @ApiStatus.Internal
    @NotNull
    protected final ClassLoader getBundleClassLoader() {
        ClassLoader classLoader2 = this.myBundleClassLoader;
        if (classLoader2 == null) {
            AbstractBundle.$$$reportNull$$$0(3);
        }
        return classLoader2;
    }

    @ApiStatus.Internal
    @NotNull
    public static ResourceBundle.Control getControl() {
        MyResourceControl myResourceControl = MyResourceControl.INSTANCE;
        if (myResourceControl == null) {
            AbstractBundle.$$$reportNull$$$0(4);
        }
        return myResourceControl;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(5);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(6);
        }
        String string2 = BundleBase.messageOrDefault(this.getResourceBundle(), key, null, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getPartialMessage(@NotNull @NonNls String key, int unassignedParams, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(8);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(9);
        }
        String string2 = BundleBase.partialMessage(this.getResourceBundle(), key, unassignedParams, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public @NotNull Supplier<@Nls String> getLazyMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(11);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(12);
        }
        Object[] actualParams = params.length == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : params;
        Supplier<String> supplier = () -> this.getMessage(key, actualParams);
        if (supplier == null) {
            AbstractBundle.$$$reportNull$$$0(13);
        }
        return supplier;
    }

    @Nullable
    @Nls
    public String messageOrNull(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(14);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(15);
        }
        return AbstractBundle.messageOrNull(this.getResourceBundle(), key, params);
    }

    @Nls
    public String messageOrDefault(@NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(16);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(17);
        }
        return AbstractBundle.messageOrDefault(this.getResourceBundle(), key, defaultValue, params);
    }

    @Contract(value="null, _, _, _ -> param3")
    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(18);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(19);
        }
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return BundleBase.postprocessValue(bundle, BundleBase.useDefaultValue(bundle, key, defaultValue), params);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(20);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(21);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(22);
        }
        String string2 = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(23);
        }
        return string2;
    }

    @Nullable
    @Nls
    public static String messageOrNull(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        String value;
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(24);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(25);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(26);
        }
        return key.equals(value = AbstractBundle.messageOrDefault(bundle, key, key, params)) ? null : value;
    }

    public boolean containsKey(@NotNull @NonNls String key) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(27);
        }
        return this.getResourceBundle().containsKey(key);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.myBundleClassLoader);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader2) {
        boolean isDefault;
        ResourceBundle bundle;
        if (classLoader2 == null) {
            AbstractBundle.$$$reportNull$$$0(28);
        }
        if ((bundle = SoftReference.dereference((isDefault = DefaultBundleService.isDefaultBundle()) ? this.myDefaultBundle : this.myBundle)) == null) {
            bundle = this.resolveResourceBundle(this.myPathToBundle, classLoader2);
            java.lang.ref.SoftReference<ResourceBundle> ref = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.myDefaultBundle = ref;
            } else {
                this.myBundle = ref;
            }
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(29);
        }
        return resourceBundle;
    }

    @NotNull
    private ResourceBundle resolveResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader2) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(30);
        }
        if (loader2 == null) {
            AbstractBundle.$$$reportNull$$$0(31);
        }
        return AbstractBundle.resolveResourceBundleWithFallback(() -> this.findBundle(pathToBundle, loader2, MyResourceControl.INSTANCE), loader2, pathToBundle);
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveResourceBundleWithFallback(@NotNull @NotNull Supplier<? extends @NotNull ResourceBundle> firstTry, @NotNull ClassLoader loader2, @NotNull String pathToBundle) {
        ResourceBundle resourceBundle;
        if (firstTry == null) {
            AbstractBundle.$$$reportNull$$$0(32);
        }
        if (loader2 == null) {
            AbstractBundle.$$$reportNull$$$0(33);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(34);
        }
        try {
            resourceBundle = firstTry.get();
        }
        catch (MissingResourceException e2) {
            LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
            ResourceBundle.clearCache(loader2);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader2);
            if (resourceBundle2 == null) {
                AbstractBundle.$$$reportNull$$$0(36);
            }
            return resourceBundle2;
        }
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(35);
        }
        return resourceBundle;
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader2, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(37);
        }
        if (loader2 == null) {
            AbstractBundle.$$$reportNull$$$0(38);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(39);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader2, control);
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(40);
        }
        return resourceBundle;
    }

    @ApiStatus.Internal
    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader2, @NotNull ResourceBundle.Control control, @NotNull Locale locale) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(41);
        }
        if (loader2 == null) {
            AbstractBundle.$$$reportNull$$$0(42);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(43);
        }
        if (locale == null) {
            AbstractBundle.$$$reportNull$$$0(44);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, locale, loader2, control);
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(45);
        }
        return resourceBundle;
    }

    public void clearLocaleCache() {
        if (this.myBundle != null) {
            this.myBundle.clear();
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected static ResourceBundle resolveBundle(@NotNull ClassLoader loader2, @NonNls @NotNull Locale locale, @NonNls @NotNull String pathToBundle) {
        if (loader2 == null) {
            AbstractBundle.$$$reportNull$$$0(46);
        }
        if (locale == null) {
            AbstractBundle.$$$reportNull$$$0(47);
        }
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(48);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, locale, loader2, MyResourceControl.INSTANCE);
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(49);
        }
        return resourceBundle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 49: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 49: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 34: 
            case 37: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/AbstractBundle";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 31: 
            case 33: 
            case 38: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTry";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/AbstractBundle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyMessage";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundleWithFallback";
                break;
            }
            case 40: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findBundle";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBundle";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 49: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPartialMessage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLazyMessage";
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "messageOrNull";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundleWithFallback";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 49: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyResourceControl
    extends ResourceBundle.Control {
        static final MyResourceControl INSTANCE = new MyResourceControl();

        private MyResourceControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader2, boolean reload) throws IOException {
            String resourceName;
            String bundleName = this.toBundleName(baseName, locale);
            String string2 = resourceName = bundleName.contains("://") ? null : this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            if (loader2 instanceof UrlClassLoader) {
                byte[] data = ((UrlClassLoader)loader2).getResourceAsBytes(resourceName, true);
                if (data == null) {
                    return null;
                }
                return new PropertyResourceBundle(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
            }
            InputStream stream = loader2.getResourceAsStream(resourceName);
            if (stream == null) {
                return null;
            }
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                return propertyResourceBundle;
            }
            finally {
                stream.close();
            }
        }
    }
}

