/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiNameValuePair;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> myType;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(1);
        }
        this.myType = type;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) {
        assert (method.getParameterCount() == 0) : Arrays.toString(method.getParameterTypes());
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.myType;
        }
        Pair<Object, String> pair = AnnotationInvocationHandler.attributeValueOrError(this.myAnnotation, this.myType, member);
        Object value = pair.first;
        if (value == null) {
            String error = (String)pair.second;
            String message2 = member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "': " + error + ")";
            throw new IncompleteAnnotationException(this.myType, message2);
        }
        return value;
    }

    @NotNull
    private static Pair<Object, String> attributeValueOrError(@NotNull PsiAnnotation annotation, Class<? extends Annotation> type, @Nullable @NonNls String attributeName) {
        Method method;
        PsiNameValuePair attribute;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(2);
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = (attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName)) == null ? null : attribute.getValue();
        if (value != null) {
            Object result2 = JavaPsiFacade.getInstance(annotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value);
            if (result2 == null) {
                Pair<Object, String> pair = Pair.create(null, "Unable to evaluate annotation value '" + value.getText() + "'");
                if (pair == null) {
                    AnnotationInvocationHandler.$$$reportNull$$$0(3);
                }
                return pair;
            }
            Pair<Object, Object> pair = Pair.create(result2, null);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(4);
            }
            return pair;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        try {
            method = type.getMethod(attributeName, new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            Pair<Object, String> pair = Pair.create(null, "Method not found: " + attributeName);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Object defaultValue = method.getDefaultValue();
        if (defaultValue == null) {
            Pair<Object, String> pair = Pair.create(null, "No default value is specified for method " + attributeName);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(6);
            }
            return pair;
        }
        Pair<Object, Object> pair = Pair.create(defaultValue, null);
        if (pair == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result2 = new StringBuilder(128);
        result2.append('@');
        result2.append(this.myType.getName());
        result2.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e2 : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result2.append(", ");
            }
            result2.append(e2.getName());
            result2.append('=');
            PsiAnnotationMemberValue value = e2.getValue();
            result2.append(value == null ? "null" : value.getText());
        }
        result2.append(')');
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeValueOrError";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attributeValueOrError";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

