/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Helpers;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ThreadLocalRandom;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.jetbrains.annotations.NotNull;

final class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
HashingStrategy<K> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    private final HashingStrategy<? super K> hashingStrategy;
    volatile transient Node<K, V>[] table;
    private volatile transient Node<K, V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    private static final HashingStrategy THIS = new HashingStrategy(){

        public int hashCode(Object object) {
            throw new IncorrectOperationException();
        }

        public boolean equals(Object o1, Object o2) {
            throw new IncorrectOperationException();
        }
    };
    private static final VarHandle SIZECTL;
    private static final VarHandle TRANSFERINDEX;
    private static final VarHandle BASECOUNT;
    private static final VarHandle CELLSBUSY;
    static final VarHandle CELLVALUE;
    private static final VarHandle TAB_ARRAY;

    static final int spread(int h2) {
        return (h2 ^ h2 >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c2) {
        int n2 = -1 >>> Integer.numberOfLeadingZeros(c2 - 1);
        return n2 < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    static Class<?> comparableClassFor(Object x2) {
        if (x2 instanceof Comparable) {
            Class<?> c2 = x2.getClass();
            if (c2 == String.class) {
                return c2;
            }
            Type[] ts = c2.getGenericInterfaces();
            if (ts != null) {
                for (Type t2 : ts) {
                    Type[] as2;
                    ParameterizedType p2;
                    if (!(t2 instanceof ParameterizedType) || (p2 = (ParameterizedType)t2).getRawType() != Comparable.class || (as2 = p2.getActualTypeArguments()) == null || as2.length != 1 || as2[0] != c2) continue;
                    return c2;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k2, Object x2) {
        return x2 == null || x2.getClass() != kc ? 0 : ((Comparable)k2).compareTo(x2);
    }

    static <K, V> Node<K, V> tabAt(Node<K, V>[] tab, int i2) {
        return TAB_ARRAY.getVolatile(tab, i2);
    }

    static <K, V> boolean casTabAt(Node<K, V>[] tab, int i2, Node<K, V> c2, Node<K, V> v2) {
        return TAB_ARRAY.compareAndSet(tab, i2, c2, v2);
    }

    static <K, V> void setTabAt(Node<K, V>[] tab, int i2, Node<K, V> v2) {
        TAB_ARRAY.setVolatile(tab, i2, v2);
    }

    ConcurrentHashMap() {
        this(16, 0.75f);
    }

    ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    ConcurrentHashMap(Map<? extends K, ? extends V> m4) {
        this(16);
        this.putAll(m4);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, THIS);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy2) {
        long size;
        int cap;
        if (hashingStrategy2 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(0);
        }
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMap.tableSizeFor((int)size);
        this.hashingStrategy = hashingStrategy2 == THIS ? this : hashingStrategy2;
    }

    ConcurrentHashMap(@NotNull HashingStrategy<? super K> hashingStrategy2) {
        if (hashingStrategy2 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(1);
        }
        this(16, 0.75f, NCPU, hashingStrategy2);
    }

    @Override
    public int size() {
        long n2 = this.sumCount();
        return n2 < 0L ? 0 : (n2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n2);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e2;
        int n2;
        int h2 = this.hash(key);
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n2 = tab.length) > 0 && (e2 = ConcurrentHashMap.tabAt(tab, n2 - 1 & h2)) != null) {
            Object ek;
            int eh = e2.hash;
            if (eh == h2) {
                ek = e2.key;
                if (ek == key || ek != null && this.isEqual(key, ek)) {
                    return e2.val;
                }
            } else if (eh < 0) {
                Node<K, V> p2 = e2.find(h2, key);
                return p2 != null ? (V)p2.val : null;
            }
            while ((e2 = e2.next) != null) {
                if (e2.hash != h2 || (ek = e2.key) != key && (ek == null || !this.isEqual(key, ek))) continue;
                return e2.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                Object v2 = p2.val;
                if (v2 != value && (v2 == null || !value.equals(v2))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(K key, V value, boolean onlyIfAbsent) {
        int binCount;
        block22: {
            V oldVal;
            int i2;
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            int hash = this.hash(key);
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                Object fv;
                Object fk;
                int n2;
                if (tab == null || (n2 = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n2 - 1 & hash;
                Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
                if (f2 == null) {
                    if (!ConcurrentHashMap.casTabAt(tab, i2, null, new Node<K, V>(hash, key, value, this.hashingStrategy))) continue;
                    break block22;
                }
                int fh = f2.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f2);
                    continue;
                }
                if (onlyIfAbsent && fh == hash && ((fk = f2.key) == key || fk != null && this.isEqual(key, fk)) && (fv = f2.val) != null) {
                    return fv;
                }
                oldVal = null;
                Node<K, V> node = f2;
                synchronized (node) {
                    block23: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e2 = f2;
                                while (true) {
                                    Object ek;
                                    if (e2.hash == hash && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                        oldVal = e2.val;
                                        if (!onlyIfAbsent) {
                                            e2.val = value;
                                        }
                                        break block23;
                                    }
                                    Node<K, V> pred = e2;
                                    e2 = e2.next;
                                    if (e2 == null) {
                                        pred.next = new Node<K, V>(hash, key, value, this.hashingStrategy);
                                        break block23;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f2 instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<K, V> p2 = ((TreeBin)f2).putTreeVal(hash, key, value);
                                if (p2 != null) {
                                    oldVal = p2.val;
                                    if (!onlyIfAbsent) {
                                        p2.val = value;
                                    }
                                }
                            } else if (f2 instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.tryPresize(m4.size());
        for (Map.Entry<K, V> e2 : m4.entrySet()) {
            this.putVal(e2.getKey(), e2.getValue(), false);
        }
    }

    @Override
    public V remove(Object key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(Object key, V value, Object cv) {
        int i2;
        Node<K, V> f2;
        int n2;
        int hash = this.hash(key);
        Node<K, V>[] tab = this.table;
        while (tab != null && (n2 = tab.length) != 0 && (f2 = ConcurrentHashMap.tabAt(tab, i2 = n2 - 1 & hash)) != null) {
            int fh = f2.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f2);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<K, V> node = f2;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                    if (fh >= 0) {
                        validated = true;
                        Node<K, V> e2 = f2;
                        Node<K, V> pred = null;
                        do {
                            Object ek;
                            if (e2.hash == hash && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                Object ev = e2.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e2.val = value;
                                    } else if (pred != null) {
                                        pred.next = e2.next;
                                    } else {
                                        ConcurrentHashMap.setTabAt(tab, i2, e2.next);
                                    }
                                }
                                break;
                            }
                            pred = e2;
                        } while ((e2 = e2.next) != null);
                    } else if (f2 instanceof TreeBin) {
                        TreeNode p2;
                        validated = true;
                        TreeBin t2 = (TreeBin)f2;
                        TreeNode r2 = t2.root;
                        if (r2 != null && (p2 = r2.findTreeNode(hash, key, null)) != null) {
                            Object pv = p2.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p2.val = value;
                                } else if (t2.removeTreeNode(p2)) {
                                    ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t2.first));
                                }
                            }
                        }
                    } else if (f2 instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i2 = 0;
        Node<K, V>[] tab = this.table;
        while (tab != null && i2 < tab.length) {
            Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
            if (f2 == null) {
                ++i2;
                continue;
            }
            int fh = f2.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f2);
                i2 = 0;
                continue;
            }
            Node<K, V> node = f2;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                    Node<K, V> p2;
                    Node<K, V> node2 = fh >= 0 ? f2 : (p2 = f2 instanceof TreeBin ? ((TreeBin)f2).first : null);
                    while (p2 != null) {
                        --delta;
                        p2 = p2.next;
                    }
                    ConcurrentHashMap.setTabAt(tab, i2++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySetView(this, null);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        ValuesView<K, V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new ValuesView(this);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySetView(this);
        return this.entrySet;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                h2 += this.hash(p2.key) ^ p2.val.hashCode();
            }
        }
        return h2;
    }

    @Override
    public String toString() {
        Node<K, V>[] t2 = this.table;
        int f2 = this.table == null ? 0 : t2.length;
        Traverser<K, V> it = new Traverser<K, V>(t2, f2, 0, f2);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<K, V> p2 = it.advance();
        if (p2 != null) {
            while (true) {
                Object k2 = p2.key;
                Object v2 = p2.val;
                sb.append((Object)(k2 == this ? "(this Map)" : k2));
                sb.append('=');
                sb.append((Object)(v2 == this ? "(this Map)" : v2));
                p2 = it.advance();
                if (p2 == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 != this) {
            Node<K, V> p2;
            if (!(o2 instanceof Map)) {
                return false;
            }
            Map m4 = (Map)o2;
            Node<K, V>[] t2 = this.table;
            int f2 = this.table == null ? 0 : t2.length;
            Traverser<K, V> it = new Traverser<K, V>(t2, f2, 0, f2);
            while ((p2 = it.advance()) != null) {
                Object val = p2.val;
                Object v2 = m4.get(p2.key);
                if (v2 != null && (v2 == val || v2.equals(val))) continue;
                return false;
            }
            for (Map.Entry e2 : m4.entrySet()) {
                V v3;
                Object mv;
                Object mk = e2.getKey();
                if (mk != null && (mv = e2.getValue()) != null && (v3 = this.get(mk)) != null && (mv == v3 || mv.equals(v3))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putVal(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.replaceNode(key, null, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, value, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v2 = this.get(key);
        return v2 == null ? defaultValue : v2;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                action2.accept(p2.key, p2.val);
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                V newValue;
                Object oldValue = p2.val;
                Object key = p2.key;
                do {
                    if ((newValue = function.apply(key, oldValue)) != null) continue;
                    throw new NullPointerException();
                } while (this.replaceNode(key, newValue, oldValue) == null && (oldValue = this.get(key)) != null);
            }
        }
    }

    boolean removeEntryIf(Predicate<? super Map.Entry<K, V>> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                Object k2 = p2.key;
                Object v2 = p2.val;
                AbstractMap.SimpleImmutableEntry e2 = new AbstractMap.SimpleImmutableEntry(k2, v2);
                if (!function.test(e2) || this.replaceNode(k2, null, v2) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    boolean removeValueIf(Predicate<? super V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<K, V>[] t2 = this.table;
        if (this.table != null) {
            Node<K, V> p2;
            Traverser<K, V> it = new Traverser<K, V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                Object k2 = p2.key;
                Object v2 = p2.val;
                if (!function.test(v2) || this.replaceNode(k2, null, v2) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        int binCount;
        Object val;
        block34: {
            boolean added;
            int i2;
            if (key == null || mappingFunction == null) {
                throw new NullPointerException();
            }
            int h2 = this.hash(key);
            val = null;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                Object fv;
                Object fk;
                Node node;
                int n2;
                if (tab == null || (n2 = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n2 - 1 & h2;
                Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
                if (f2 == null) {
                    ReservationNode r2;
                    node = r2 = new ReservationNode(this.hashingStrategy);
                    synchronized (node) {
                        if (ConcurrentHashMap.casTabAt(tab, i2, null, r2)) {
                            binCount = 1;
                            Node<? super K, Object> node2 = null;
                            try {
                                V v2 = mappingFunction.apply(key);
                                val = v2;
                                if (v2 != null) {
                                    node2 = new Node<K, Object>(h2, key, val, this.hashingStrategy);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(tab, i2, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block34;
                }
                int fh = f2.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f2);
                    continue;
                }
                if (fh == h2 && ((fk = f2.key) == key || fk != null && this.isEqual(key, fk)) && (fv = f2.val) != null) {
                    return fv;
                }
                added = false;
                node = f2;
                synchronized (node) {
                    block35: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e2 = f2;
                                while (true) {
                                    Object ek;
                                    if (e2.hash == h2 && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = e2.val;
                                        break block35;
                                    }
                                    Node<K, V> pred = e2;
                                    e2 = e2.next;
                                    if (e2 == null) {
                                        V v3 = mappingFunction.apply(key);
                                        val = v3;
                                        if (v3 != null) {
                                            if (pred.next != null) {
                                                throw new IllegalStateException("Recursive update");
                                            }
                                            added = true;
                                            pred.next = new Node<K, Object>(h2, key, val, this.hashingStrategy);
                                        }
                                        break block35;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f2 instanceof TreeBin) {
                                TreeNode p2;
                                binCount = 2;
                                TreeBin t2 = (TreeBin)f2;
                                TreeNode r3 = t2.root;
                                if (r3 != null && (p2 = r3.findTreeNode(h2, key, null)) != null) {
                                    val = p2.val;
                                } else {
                                    V v4 = mappingFunction.apply(key);
                                    val = v4;
                                    if (v4 != null) {
                                        added = true;
                                        t2.putTreeVal(h2, key, val);
                                    }
                                }
                            } else if (f2 instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, binCount);
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        int h2 = this.hash(key);
        V val = null;
        int delta = 0;
        int binCount = 0;
        Node<K, V>[] tab = this.table;
        while (true) {
            int n2;
            if (tab == null || (n2 = tab.length) == 0) {
                tab = this.initTable();
                continue;
            }
            int i2 = n2 - 1 & h2;
            Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
            if (f2 == null) break;
            int fh = f2.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f2);
                continue;
            }
            Node<K, V> node = f2;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                    if (fh >= 0) {
                        binCount = 1;
                        Node<K, V> e2 = f2;
                        Node<K, V> pred = null;
                        while (true) {
                            Object ek;
                            if (e2.hash == h2 && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                val = remappingFunction.apply(key, e2.val);
                                if (val != null) {
                                    e2.val = val;
                                } else {
                                    delta = -1;
                                    Node en = e2.next;
                                    if (pred != null) {
                                        pred.next = en;
                                    } else {
                                        ConcurrentHashMap.setTabAt(tab, i2, en);
                                    }
                                }
                            } else {
                                pred = e2;
                                e2 = e2.next;
                                if (e2 != null) {
                                    ++binCount;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else if (f2 instanceof TreeBin) {
                        TreeNode p2;
                        binCount = 2;
                        TreeBin t2 = (TreeBin)f2;
                        TreeNode r2 = t2.root;
                        if (r2 != null && (p2 = r2.findTreeNode(h2, key, null)) != null) {
                            val = remappingFunction.apply(key, p2.val);
                            if (val != null) {
                                p2.val = val;
                            } else {
                                delta = -1;
                                if (t2.removeTreeNode(p2)) {
                                    ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t2.first));
                                }
                            }
                        }
                    } else if (f2 instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (binCount != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block39: {
            int i2;
            if (key == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h2 = this.hash(key);
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n2;
                if (tab == null || (n2 = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n2 - 1 & h2;
                Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
                if (f2 == null) {
                    ReservationNode r2;
                    ReservationNode reservationNode = r2 = new ReservationNode(this.hashingStrategy);
                    synchronized (reservationNode) {
                        if (ConcurrentHashMap.casTabAt(tab, i2, null, r2)) {
                            binCount = 1;
                            Node<? super K, Object> node = null;
                            try {
                                V v2 = remappingFunction.apply(key, null);
                                val = v2;
                                if (v2 != null) {
                                    delta = 1;
                                    node = new Node<K, Object>(h2, key, val, this.hashingStrategy);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(tab, i2, node);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block39;
                }
                int fh = f2.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f2);
                    continue;
                }
                Node<K, V> node = f2;
                synchronized (node) {
                    block40: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e2 = f2;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e2.hash == h2 && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = remappingFunction.apply(key, e2.val);
                                        if (val != null) {
                                            e2.val = val;
                                        } else {
                                            delta = -1;
                                            Node en = e2.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                ConcurrentHashMap.setTabAt(tab, i2, en);
                                            }
                                        }
                                        break block40;
                                    }
                                    pred = e2;
                                    e2 = e2.next;
                                    if (e2 == null) {
                                        val = remappingFunction.apply(key, null);
                                        if (val != null) {
                                            if (pred.next != null) {
                                                throw new IllegalStateException("Recursive update");
                                            }
                                            delta = 1;
                                            pred.next = new Node<K, Object>(h2, key, val, this.hashingStrategy);
                                        }
                                        break block40;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f2 instanceof TreeBin) {
                                binCount = 1;
                                TreeBin t2 = (TreeBin)f2;
                                TreeNode r3 = t2.root;
                                TreeNode p2 = r3 != null ? r3.findTreeNode(h2, key, null) : null;
                                Object pv = p2 == null ? null : p2.val;
                                val = remappingFunction.apply(key, pv);
                                if (val != null) {
                                    if (p2 != null) {
                                        p2.val = val;
                                    } else {
                                        delta = 1;
                                        t2.putTreeVal(h2, key, val);
                                    }
                                } else if (p2 != null) {
                                    delta = -1;
                                    if (t2.removeTreeNode(p2)) {
                                        ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t2.first));
                                    }
                                }
                            } else if (f2 instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block28: {
            int i2;
            if (key == null || value == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h2 = this.hash(key);
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n2;
                if (tab == null || (n2 = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n2 - 1 & h2;
                Node<K, V> f2 = ConcurrentHashMap.tabAt(tab, i2);
                if (f2 == null) {
                    if (!ConcurrentHashMap.casTabAt(tab, i2, null, new Node<K, V>(h2, key, value, this.hashingStrategy))) continue;
                    delta = 1;
                    val = value;
                    break block28;
                }
                int fh = f2.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f2);
                    continue;
                }
                Node<K, V> node = f2;
                synchronized (node) {
                    block29: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e2 = f2;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e2.hash == h2 && ((ek = e2.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = remappingFunction.apply(e2.val, value);
                                        if (val != null) {
                                            e2.val = val;
                                        } else {
                                            delta = -1;
                                            Node en = e2.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                ConcurrentHashMap.setTabAt(tab, i2, en);
                                            }
                                        }
                                        break block29;
                                    }
                                    pred = e2;
                                    e2 = e2.next;
                                    if (e2 == null) {
                                        delta = 1;
                                        val = value;
                                        pred.next = new Node<K, Object>(h2, key, val, this.hashingStrategy);
                                        break block29;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f2 instanceof TreeBin) {
                                binCount = 2;
                                TreeBin t2 = (TreeBin)f2;
                                TreeNode r2 = t2.root;
                                TreeNode p2 = r2 == null ? null : r2.findTreeNode(h2, key, null);
                                val = p2 == null ? value : remappingFunction.apply(p2.val, value);
                                if (val != null) {
                                    if (p2 != null) {
                                        p2.val = val;
                                    } else {
                                        delta = 1;
                                        t2.putTreeVal(h2, key, val);
                                    }
                                } else if (p2 != null) {
                                    delta = -1;
                                    if (t2.removeTreeNode(p2)) {
                                        ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t2.first));
                                    }
                                }
                            } else if (f2 instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Enumeration<K> keys() {
        Node<K, V>[] t2 = this.table;
        int f2 = this.table == null ? 0 : t2.length;
        return new KeyIterator<K, V>(t2, f2, 0, f2, this);
    }

    public Enumeration<V> elements() {
        Node<K, V>[] t2 = this.table;
        int f2 = this.table == null ? 0 : t2.length;
        return new ValueIterator<K, V>(t2, f2, 0, f2, this);
    }

    public long mappingCount() {
        long n2 = this.sumCount();
        return n2 < 0L ? 0L : n2;
    }

    public static <K> KeySetView<K, Boolean> newKeySet() {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int initialCapacity) {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(initialCapacity), Boolean.TRUE);
    }

    public KeySetView<K, V> keySet(V mappedValue) {
        if (mappedValue == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, mappedValue);
    }

    static final int resizeStamp(int n2) {
        return Integer.numberOfLeadingZeros(n2) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<K, V>[] initTable() {
        Node<K, V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (SIZECTL.compareAndSet(this, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n2 = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n2];
                    tab = nt;
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x2, int check) {
        long s2;
        long b2;
        CounterCell[] as2 = this.counterCells;
        if (this.counterCells != null || !BASECOUNT.compareAndSet(this, b2 = this.baseCount, s2 = b2 + x2)) {
            long v2;
            CounterCell a2;
            int m4;
            boolean uncontended = true;
            if (as2 == null || (m4 = as2.length - 1) < 0 || (a2 = as2[ThreadLocalRandom.getProbe() & m4]) == null || !(uncontended = CELLVALUE.compareAndSet(a2, v2 = a2.value, v2 + x2))) {
                this.fullAddCount(x2, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s2 = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s2 >= (long)(sc = this.sizeCtl)) {
                int n2;
                Node<K, V>[] tab = this.table;
                if (this.table == null || (n2 = tab.length) >= 0x40000000) break;
                int rs = ConcurrentHashMap.resizeStamp(n2) << 16;
                if (sc < 0) {
                    if (sc == rs + 65535 || sc == rs + 1) break;
                    Node<K, V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (SIZECTL.compareAndSet(this, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (SIZECTL.compareAndSet(this, sc, rs + 2)) {
                    this.transfer(tab, null);
                }
                s2 = this.sumCount();
            }
        }
    }

    final Node<K, V>[] helpTransfer(Node<K, V>[] tab, Node<K, V> f2) {
        if (tab != null && f2 instanceof ForwardingNode) {
            Node<K, V>[] nextTab = ((ForwardingNode)f2).nextTable;
            if (((ForwardingNode)f2).nextTable != null) {
                int sc;
                int rs = ConcurrentHashMap.resizeStamp(tab.length) << 16;
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc != rs + 65535 && sc != rs + 1 && this.transferIndex > 0) {
                    if (!SIZECTL.compareAndSet(this, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c2;
        int n2 = c2 = size >= 0x20000000 ? 0x40000000 : ConcurrentHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int rs;
            int n3;
            Node<K, V>[] tab = this.table;
            if (tab == null || (n3 = tab.length) == 0) {
                int n4 = n3 = sc > c2 ? sc : c2;
                if (!SIZECTL.compareAndSet(this, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n3];
                    this.table = nt;
                    sc = n3 - (n3 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c2 <= sc || n3 >= 0x40000000) break;
            if (tab != this.table || !SIZECTL.compareAndSet(this, sc, ((rs = ConcurrentHashMap.resizeStamp(n3)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<K, V>[] tab, Node<K, V>[] nextTab) {
        int n2 = tab.length;
        int stride = NCPU > 1 ? (n2 >>> 3) / NCPU : n2;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n2 << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n2;
        }
        int nextn = nextTab.length;
        ForwardingNode<? super K, V> fwd = new ForwardingNode<K, V>(nextTab, this.hashingStrategy);
        boolean advance = true;
        boolean finishing = false;
        int i2 = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i2 >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i2 = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!TRANSFERINDEX.compareAndSet(this, nextIndex, nextBound)) continue;
                bound = nextBound;
                i2 = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i2 < 0 || i2 >= n2 || i2 + n2 >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n2 << 1) - (n2 >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!SIZECTL.compareAndSet(this, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentHashMap.resizeStamp(n2) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i2 = n2;
                continue;
            }
            TreeBin f2 = ConcurrentHashMap.tabAt(tab, i2);
            if (f2 == null) {
                advance = ConcurrentHashMap.casTabAt(tab, i2, null, fwd);
                continue;
            }
            int fh = f2.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f2;
            synchronized (treeBin) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f2) {
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n2;
                        TreeBin lastRun = f2;
                        Node p2 = f2.next;
                        while (p2 != null) {
                            int b2 = p2.hash & n2;
                            if (b2 != runBit) {
                                runBit = b2;
                                lastRun = p2;
                            }
                            p2 = p2.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p2 = f2;
                        while (p2 != lastRun) {
                            int ph = p2.hash;
                            Object pk = p2.key;
                            Object pv = p2.val;
                            if ((ph & n2) == 0) {
                                ln = new Node(ph, pk, pv, ln, this.hashingStrategy);
                            } else {
                                hn = new Node(ph, pk, pv, hn, this.hashingStrategy);
                            }
                            p2 = p2.next;
                        }
                        ConcurrentHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i2 + n2, hn);
                        ConcurrentHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f2 instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t2 = f2;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e2 = t2.first;
                        while (e2 != null) {
                            int h2 = e2.hash;
                            TreeNode p3 = new TreeNode(h2, e2.key, e2.val, null, null, this.hashingStrategy);
                            if ((h2 & n2) == 0) {
                                p3.prev = loTail;
                                if (p3.prev == null) {
                                    lo = p3;
                                } else {
                                    loTail.next = p3;
                                }
                                loTail = p3;
                                ++lc;
                            } else {
                                p3.prev = hiTail;
                                if (p3.prev == null) {
                                    hi = p3;
                                } else {
                                    hiTail.next = p3;
                                }
                                hiTail = p3;
                                ++hc;
                            }
                            e2 = e2.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo, this.hashingStrategy) : t2);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi, this.hashingStrategy) : t2);
                        ConcurrentHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i2 + n2, hn);
                        ConcurrentHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f2 instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
        }
    }

    final long sumCount() {
        CounterCell[] cs = this.counterCells;
        long sum = this.baseCount;
        if (cs != null) {
            for (CounterCell c2 : cs) {
                if (c2 == null) continue;
                sum += c2.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x2, boolean wasUncontended) {
        int h2 = ThreadLocalRandom.getProbe();
        if (h2 == 0) {
            ThreadLocalRandom.localInit();
            h2 = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v2;
            int n2;
            CounterCell[] cs = this.counterCells;
            if (this.counterCells != null && (n2 = cs.length) > 0) {
                CounterCell c2 = cs[n2 - 1 & h2];
                if (c2 == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r2 = new CounterCell(x2);
                        if (this.cellsBusy == 0 && CELLSBUSY.compareAndSet(this, 0, 1)) {
                            boolean created = false;
                            try {
                                int j2;
                                int m4;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m4 = rs.length) > 0 && rs[j2 = m4 - 1 & h2] == null) {
                                    rs[j2] = r2;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v2 = c2.value;
                    if (CELLVALUE.compareAndSet(c2, v2, v2 + x2)) return;
                    if (this.counterCells != cs || n2 >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && CELLSBUSY.compareAndSet(this, 0, 1)) {
                        try {
                            if (this.counterCells == cs) {
                                this.counterCells = Arrays.copyOf(cs, n2 << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h2 = ThreadLocalRandom.advanceProbe(h2);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == cs && CELLSBUSY.compareAndSet(this, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == cs) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h2 & 1] = new CounterCell(x2);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v2 = this.baseCount;
            if (BASECOUNT.compareAndSet(this, v2, v2 + x2)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<K, V>[] tab, int index2) {
        if (tab != null) {
            int n2 = tab.length;
            if (n2 < 64) {
                this.tryPresize(n2 << 1);
            } else {
                Node<K, V> b2 = ConcurrentHashMap.tabAt(tab, index2);
                if (b2 != null && b2.hash >= 0) {
                    Node<K, V> node = b2;
                    synchronized (node) {
                        if (ConcurrentHashMap.tabAt(tab, index2) == b2) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<K, V> e2 = b2;
                            while (e2 != null) {
                                TreeNode p2 = new TreeNode(e2.hash, e2.key, e2.val, null, null, this.hashingStrategy);
                                p2.prev = tl;
                                if (p2.prev == null) {
                                    hd = p2;
                                } else {
                                    tl.next = p2;
                                }
                                tl = p2;
                                e2 = e2.next;
                            }
                            ConcurrentHashMap.setTabAt(tab, index2, new TreeBin(hd, this.hashingStrategy));
                        }
                    }
                }
            }
        }
    }

    Node<K, V> untreeify(Node<K, V> b2) {
        Node hd = null;
        Node tl = null;
        Node<K, V> q2 = b2;
        while (q2 != null) {
            Node p2 = new Node(q2.hash, q2.key, q2.val, this.hashingStrategy);
            if (tl == null) {
                hd = p2;
            } else {
                tl.next = p2;
            }
            tl = p2;
            q2 = q2.next;
        }
        return hd;
    }

    final int batchFor(long b2) {
        long n2;
        if (b2 == Long.MAX_VALUE || (n2 = this.sumCount()) <= 1L || n2 < b2) {
            return 0;
        }
        int sp = ForkJoinPool.getCommonPoolParallelism() << 2;
        return b2 <= 0L || (n2 /= b2) >= (long)sp ? sp : (int)n2;
    }

    public void forEach(long parallelismThreshold, BiConsumer<? super K, ? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachMappingTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEach(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedMappingTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U search(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public <U> U reduce(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceToDouble(long parallelismThreshold, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceMappingsToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceToLong(long parallelismThreshold, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceMappingsToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceToInt(long parallelismThreshold, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceMappingsToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachKey(long parallelismThreshold, Consumer<? super K> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachKeyTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachKey(long parallelismThreshold, Function<? super K, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedKeyTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchKeys(long parallelismThreshold, Function<? super K, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public K reduceKeys(long parallelismThreshold, BiFunction<? super K, ? super K, ? extends K> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (K)new ReduceKeysTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceKeys(long parallelismThreshold, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceKeysToDouble(long parallelismThreshold, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceKeysToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceKeysToLong(long parallelismThreshold, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceKeysToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceKeysToInt(long parallelismThreshold, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceKeysToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachValue(long parallelismThreshold, Consumer<? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachValueTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachValue(long parallelismThreshold, Function<? super V, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedValueTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchValues(long parallelismThreshold, Function<? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public V reduceValues(long parallelismThreshold, BiFunction<? super V, ? super V, ? extends V> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return new ReduceValuesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceValues(long parallelismThreshold, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceValuesToDouble(long parallelismThreshold, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceValuesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceValuesToLong(long parallelismThreshold, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceValuesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceValuesToInt(long parallelismThreshold, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceValuesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachEntry(long parallelismThreshold, Consumer<? super Map.Entry<K, V>> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachEntryTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachEntry(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedEntryTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public Map.Entry<K, V> reduceEntries(long parallelismThreshold, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (Map.Entry)new ReduceEntriesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceEntriesToDouble(long parallelismThreshold, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceEntriesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceEntriesToLong(long parallelismThreshold, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceEntriesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceEntriesToInt(long parallelismThreshold, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceEntriesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    @Override
    public int hashCode(K object) {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public boolean equals(K o1, K o2) {
        return o1.equals(o2);
    }

    private int hash(K key) {
        return ConcurrentHashMap.spread(this.hashingStrategy.hashCode(key));
    }

    private boolean isEqual(@NotNull K key1, K key2) {
        if (key1 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(2);
        }
        return ConcurrentHashMap.isEqual(key1, key2, this.hashingStrategy);
    }

    private static <K> boolean isEqual(@NotNull K key1, K key2, @NotNull HashingStrategy<? super K> hashingStrategy2) {
        if (key1 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(3);
        }
        if (hashingStrategy2 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(4);
        }
        return key1 == key2 || key2 != null && hashingStrategy2.equals(key1, key2);
    }

    static {
        try {
            SIZECTL = MethodHandles.privateLookupIn(ConcurrentHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentHashMap.class, "sizeCtl", Integer.TYPE);
            TRANSFERINDEX = MethodHandles.privateLookupIn(ConcurrentHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentHashMap.class, "transferIndex", Integer.TYPE);
            BASECOUNT = MethodHandles.privateLookupIn(ConcurrentHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentHashMap.class, "baseCount", Long.TYPE);
            CELLSBUSY = MethodHandles.privateLookupIn(ConcurrentHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentHashMap.class, "cellsBusy", Integer.TYPE);
            CELLVALUE = MethodHandles.privateLookupIn(CounterCell.class, MethodHandles.lookup()).findVarHandle(CounterCell.class, "value", Long.TYPE);
            TAB_ARRAY = MethodHandles.arrayElementVarHandle(Node[].class);
        }
        catch (Throwable e2) {
            throw new Error(e2);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        Class<ReservationNode> clazz = ReservationNode.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key1";
                break;
            }
        }
        objectArray2[1] = "com/intellij/concurrency/ConcurrentHashMap";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        volatile V val;
        @NotNull
        final HashingStrategy<? super K> hashingStrategy;
        volatile Node<K, V> next;

        Node(int hash, K key, V val, @NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.hashingStrategy = hashingStrategy2;
        }

        Node(int hash, K key, V val, Node<K, V> next, @NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            this(hash, (K)key, val, hashingStrategy2);
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.hashingStrategy.hashCode(this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return Helpers.mapEntryToString(this.key, this.val);
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean equals(Object o2) {
            V u2;
            Object v2;
            Map.Entry e2;
            Object k2;
            return !(!(o2 instanceof Map.Entry) || (k2 = (e2 = (Map.Entry)o2).getKey()) == null || (v2 = e2.getValue()) == null || k2 != this.key && !this.hashingStrategy.equals(k2, this.key) || v2 != (u2 = this.val) && !v2.equals(u2));
        }

        Node<K, V> find(int h2, Object k2) {
            Node<K, V> e2 = this;
            if (k2 != null) {
                do {
                    K ek;
                    if (e2.hash != h2 || (ek = e2.key) != k2 && (ek == null || !this.hashingStrategy.equals(k2, ek))) continue;
                    return e2;
                } while ((e2 = e2.next) != null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$Node", "<init>"));
        }
    }

    static class Traverser<K, V> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<K, V>[] tab, int size, int index2, int limit2) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index2;
            this.baseLimit = limit2;
            this.next = null;
        }

        final Node<K, V> advance() {
            Node<K, V> e2 = this.next;
            if (e2 != null) {
                e2 = e2.next;
            }
            while (true) {
                int i2;
                int n2;
                Node<K, V>[] t2;
                block10: {
                    block9: {
                        if (e2 != null) {
                            this.next = e2;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t2 = this.tab;
                        if (this.tab != null && (n2 = t2.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e2 = ConcurrentHashMap.tabAt(t2, i2);
                if (e2 != null && e2.hash < 0) {
                    if (e2 instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e2).nextTable;
                        e2 = null;
                        this.pushState(t2, i2, n2);
                        continue;
                    }
                    e2 = e2 instanceof TreeBin ? ((TreeBin)e2).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n2);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n2) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t2, int i2, int n2) {
            TableStack<K, V> s2 = this.spare;
            if (s2 != null) {
                this.spare = s2.next;
            } else {
                s2 = new TableStack();
            }
            s2.tab = t2;
            s2.length = n2;
            s2.index = i2;
            s2.next = this.stack;
            this.stack = s2;
        }

        private void recoverState(int n2) {
            int len;
            TableStack<K, V> s2;
            while ((s2 = this.stack) != null && (this.index += (len = s2.length)) >= n2) {
                n2 = len;
                this.index = s2.index;
                this.tab = s2.tab;
                s2.tab = null;
                TableStack next = s2.next;
                s2.next = this.spare;
                this.stack = next;
                this.spare = s2;
            }
            if (s2 == null && (this.index += this.baseSize) >= n2) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TreeBin<K, V>
    extends Node<K, V> {
        TreeNode<K, V> root;
        volatile TreeNode<K, V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final VarHandle LOCKSTATE;

        static int tieBreakOrder(Object a2, Object b2) {
            int d2;
            if (a2 == null || b2 == null || (d2 = a2.getClass().getName().compareTo(b2.getClass().getName())) == 0) {
                d2 = System.identityHashCode(a2) <= System.identityHashCode(b2) ? -1 : 1;
            }
            return d2;
        }

        TreeBin(TreeNode<K, V> b2, @NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                TreeBin.$$$reportNull$$$0(0);
            }
            super(-2, null, null, hashingStrategy2);
            this.first = b2;
            TreeNode r2 = null;
            TreeNode x2 = b2;
            while (x2 != null) {
                TreeNode next = (TreeNode)x2.next;
                x2.right = null;
                x2.left = null;
                if (r2 == null) {
                    x2.parent = null;
                    x2.red = false;
                    r2 = x2;
                } else {
                    TreeNode xp;
                    int dir;
                    Object k2 = x2.key;
                    int h2 = x2.hash;
                    Class<?> kc = null;
                    TreeNode p2 = r2;
                    do {
                        Object pk = p2.key;
                        int ph = p2.hash;
                        if (ph > h2) {
                            dir = -1;
                        } else if (ph < h2) {
                            dir = 1;
                        } else if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k2)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k2, pk)) == 0) {
                            dir = TreeBin.tieBreakOrder(k2, pk);
                        }
                        xp = p2;
                    } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
                    x2.parent = xp;
                    if (dir <= 0) {
                        xp.left = x2;
                    } else {
                        xp.right = x2;
                    }
                    r2 = TreeBin.balanceInsertion(r2, x2);
                }
                x2 = next;
            }
            this.root = r2;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!LOCKSTATE.compareAndSet(this, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s2;
                if (((s2 = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!LOCKSTATE.compareAndSet(this, s2, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s2 & 2) == 0) {
                    if (!LOCKSTATE.compareAndSet(this, s2, s2 | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<K, V> find(int h2, Object k2) {
            if (k2 != null) {
                Node e2 = this.first;
                while (e2 != null) {
                    TreeNode<K, V> p2;
                    int s2 = this.lockState;
                    if ((s2 & 3) != 0) {
                        Object ek;
                        if (e2.hash == h2 && ((ek = e2.key) == k2 || ek != null && ConcurrentHashMap.isEqual(k2, ek, this.hashingStrategy))) {
                            return e2;
                        }
                        e2 = e2.next;
                        continue;
                    }
                    if (!LOCKSTATE.compareAndSet(this, s2, s2 + 4)) continue;
                    try {
                        TreeNode<K, V> r2 = this.root;
                        p2 = r2 == null ? null : r2.findTreeNode(h2, k2, null);
                    }
                    finally {
                        Thread w2;
                        if (LOCKSTATE.getAndAdd(this, -4) == 6 && (w2 = this.waiter) != null) {
                            LockSupport.unpark(w2);
                        }
                    }
                    return p2;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final TreeNode<K, V> putTreeVal(int h2, K k2, V v2) {
            block19: {
                TreeNode<K, V> xp;
                int dir;
                Class<?> kc = null;
                boolean searched = false;
                TreeNode<K, V> p2 = this.root;
                do {
                    if (p2 == null) {
                        this.root = new TreeNode<K, V>(h2, k2, v2, null, null, this.hashingStrategy);
                        this.first = this.root;
                        break block19;
                    }
                    int ph = p2.hash;
                    if (ph > h2) {
                        dir = -1;
                    } else if (ph < h2) {
                        dir = 1;
                    } else {
                        Object pk = p2.key;
                        if (pk == k2 || pk != null && ConcurrentHashMap.isEqual(k2, pk, this.hashingStrategy)) {
                            return p2;
                        }
                        if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k2)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k2, pk)) == 0) {
                            if (!searched) {
                                TreeNode q2;
                                searched = true;
                                TreeNode ch = p2.left;
                                if (ch != null && (q2 = ch.findTreeNode(h2, k2, kc)) != null || (ch = p2.right) != null && (q2 = ch.findTreeNode(h2, k2, kc)) != null) {
                                    return q2;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k2, pk);
                        }
                    }
                    xp = p2;
                } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
                TreeNode<K, V> f2 = this.first;
                TreeNode<K, V> x2 = new TreeNode<K, V>(h2, k2, v2, f2, xp, this.hashingStrategy);
                this.first = x2;
                if (f2 != null) {
                    f2.prev = x2;
                }
                if (dir <= 0) {
                    xp.left = x2;
                } else {
                    xp.right = x2;
                }
                if (!xp.red) {
                    x2.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x2);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<K, V> p2) {
            TreeNode rl;
            TreeNode next = (TreeNode)p2.next;
            TreeNode pred = p2.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<K, V> r2 = this.root;
            if (r2 == null || r2.right == null || (rl = r2.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p2.left;
                TreeNode pr = p2.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s2 = pr;
                    while ((sl = s2.left) != null) {
                        s2 = sl;
                    }
                    boolean c2 = s2.red;
                    s2.red = p2.red;
                    p2.red = c2;
                    TreeNode sr = s2.right;
                    TreeNode pp2 = p2.parent;
                    if (s2 == pr) {
                        p2.parent = s2;
                        s2.right = p2;
                    } else {
                        TreeNode sp = s2.parent;
                        p2.parent = sp;
                        if (p2.parent != null) {
                            if (s2 == sp.left) {
                                sp.left = p2;
                            } else {
                                sp.right = p2;
                            }
                        }
                        if ((s2.right = pr) != null) {
                            pr.parent = s2;
                        }
                    }
                    p2.left = null;
                    p2.right = sr;
                    if (p2.right != null) {
                        sr.parent = p2;
                    }
                    if ((s2.left = pl) != null) {
                        pl.parent = s2;
                    }
                    if ((s2.parent = pp2) == null) {
                        r2 = s2;
                    } else if (p2 == pp2.left) {
                        pp2.left = s2;
                    } else {
                        pp2.right = s2;
                    }
                    replacement = sr != null ? sr : p2;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p2);
                }
                if (replacement != p2) {
                    replacement.parent = p2.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r2 = replacement;
                    } else if (p2 == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p2.parent = null;
                    p2.right = null;
                    p2.left = null;
                }
                TreeNode<K, V> treeNode = this.root = p2.red ? r2 : TreeBin.balanceDeletion(r2, replacement);
                if (p2 == replacement && (pp = p2.parent) != null) {
                    if (p2 == pp.left) {
                        pp.left = null;
                    } else if (p2 == pp.right) {
                        pp.right = null;
                    }
                    p2.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p2) {
            TreeNode r2;
            if (p2 != null && (r2 = p2.right) != null) {
                p2.right = r2.left;
                TreeNode rl = p2.right;
                if (p2.right != null) {
                    rl.parent = p2;
                }
                TreeNode pp = r2.parent = p2.parent;
                if (r2.parent == null) {
                    root = r2;
                    r2.red = false;
                } else if (pp.left == p2) {
                    pp.left = r2;
                } else {
                    pp.right = r2;
                }
                r2.left = p2;
                p2.parent = r2;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p2) {
            TreeNode l2;
            if (p2 != null && (l2 = p2.left) != null) {
                p2.left = l2.right;
                TreeNode lr = p2.left;
                if (p2.left != null) {
                    lr.parent = p2;
                }
                TreeNode pp = l2.parent = p2.parent;
                if (l2.parent == null) {
                    root = l2;
                    l2.red = false;
                } else if (pp.right == p2) {
                    pp.right = l2;
                } else {
                    pp.left = l2;
                }
                l2.right = p2;
                p2.parent = l2;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x2) {
            x2.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x2.parent) == null) {
                    x2.red = false;
                    return x2;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x2 = xpp;
                        continue;
                    }
                    if (x2 == xp.right) {
                        x2 = xp;
                        root = TreeBin.rotateLeft(root, x2);
                        xp = x2.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x2 = xpp;
                    continue;
                }
                if (x2 == xp.left) {
                    x2 = xp;
                    root = TreeBin.rotateRight(root, x2);
                    xp = x2.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x2) {
            while (x2 != null && x2 != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x2.parent;
                if (xp == null) {
                    x2.red = false;
                    return x2;
                }
                if (x2.red) {
                    x2.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x2) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x2.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x2 = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x2 = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x2.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x2 = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x2.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x2 = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x2 = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x2.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x2 = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t2) {
            TreeNode tp = t2.parent;
            TreeNode tl = t2.left;
            TreeNode tr = t2.right;
            TreeNode tb = t2.prev;
            TreeNode tn = (TreeNode)t2.next;
            if (tb != null && tb.next != t2) {
                return false;
            }
            if (tn != null && tn.prev != t2) {
                return false;
            }
            if (tp != null && t2 != tp.left && t2 != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t2 || tl.hash > t2.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t2 || tr.hash < t2.hash)) {
                return false;
            }
            if (t2.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                LOCKSTATE = MethodHandles.privateLookupIn(TreeBin.class, MethodHandles.lookup()).findVarHandle(TreeBin.class, "lockState", Integer.TYPE);
            }
            catch (Throwable e2) {
                throw new Error(e2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$TreeBin", "<init>"));
        }
    }

    static final class TreeNode<K, V>
    extends Node<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next, TreeNode<K, V> parent, @NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                TreeNode.$$$reportNull$$$0(0);
            }
            super(hash, key, val, next, hashingStrategy2);
            this.parent = parent;
        }

        @Override
        Node<K, V> find(int h2, Object k2) {
            return this.findTreeNode(h2, k2, null);
        }

        final TreeNode<K, V> findTreeNode(int h2, Object k2, Class<?> kc) {
            if (k2 != null) {
                TreeNode<K, V> p2 = this;
                do {
                    int dir;
                    TreeNode<K, V> pl = p2.left;
                    TreeNode<K, V> pr = p2.right;
                    int ph = p2.hash;
                    if (ph > h2) {
                        p2 = pl;
                        continue;
                    }
                    if (ph < h2) {
                        p2 = pr;
                        continue;
                    }
                    Object pk = p2.key;
                    if (pk == k2 || pk != null && ConcurrentHashMap.isEqual(k2, pk, this.hashingStrategy)) {
                        return p2;
                    }
                    if (pl == null) {
                        p2 = pr;
                        continue;
                    }
                    if (pr == null) {
                        p2 = pl;
                        continue;
                    }
                    if ((kc != null || (kc = ConcurrentHashMap.comparableClassFor(k2)) != null) && (dir = ConcurrentHashMap.compareComparables(kc, k2, pk)) != 0) {
                        p2 = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<K, V> q2 = pr.findTreeNode(h2, k2, kc);
                    if (q2 != null) {
                        return q2;
                    }
                    p2 = pl;
                } while (p2 != null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$TreeNode", "<init>"));
        }
    }

    static final class ReservationNode<K, V>
    extends Node<K, V> {
        ReservationNode(@NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                ReservationNode.$$$reportNull$$$0(0);
            }
            super(-3, null, null, hashingStrategy2);
        }

        @Override
        Node<K, V> find(int h2, Object k2) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$ReservationNode", "<init>"));
        }
    }

    public static class KeySetView<K, V>
    extends CollectionView<K, V, K>
    implements Set<K> {
        private final V value;

        KeySetView(ConcurrentHashMap<K, V> map2, V value) {
            super(map2);
            this.value = value;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object o2) {
            return this.map.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return this.map.remove(o2) != null;
        }

        @Override
        public Iterator<K> iterator() {
            ConcurrentHashMap m4 = this.map;
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new KeyIterator(t2, f2, 0, f2, m4);
        }

        @Override
        public boolean add(K e2) {
            V v2 = this.value;
            if (v2 == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(e2, v2, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> c2) {
            boolean added = false;
            V v2 = this.value;
            if (v2 == null) {
                throw new UnsupportedOperationException();
            }
            for (K e2 : c2) {
                if (this.map.putVal(e2, v2, true) != null) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            for (K e2 : this) {
                h2 += this.map.hash(e2);
            }
            return h2;
        }

        @Override
        public boolean equals(Object o2) {
            Set c2;
            return o2 instanceof Set && ((c2 = (Set)o2) == this || this.containsAll(c2) && c2.containsAll(this));
        }

        @Override
        public Spliterator<K> spliterator() {
            ConcurrentHashMap m4 = this.map;
            long n2 = m4.sumCount();
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new KeySpliterator(t2, f2, 0, f2, n2 < 0L ? 0L : n2);
        }

        @Override
        public void forEach(Consumer<? super K> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    action2.accept(p2.key);
                }
            }
        }
    }

    static final class ValuesView<K, V>
    extends CollectionView<K, V, V>
    implements Collection<V> {
        ValuesView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public final boolean contains(Object o2) {
            return this.map.containsValue(o2);
        }

        @Override
        public final boolean remove(Object o2) {
            if (o2 != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o2.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            ConcurrentHashMap m4 = this.map;
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new ValueIterator(t2, f2, 0, f2, m4);
        }

        @Override
        public final boolean add(V e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<V> it = this.iterator();
            while (it.hasNext()) {
                if (!c2.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter2) {
            return this.map.removeValueIf(filter2);
        }

        @Override
        public Spliterator<V> spliterator() {
            ConcurrentHashMap m4 = this.map;
            long n2 = m4.sumCount();
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new ValueSpliterator(t2, f2, 0, f2, n2 < 0L ? 0L : n2);
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    action2.accept(p2.val);
                }
            }
        }
    }

    static final class EntrySetView<K, V>
    extends CollectionView<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        EntrySetView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o2) {
            Object v2;
            Object r2;
            Map.Entry e2;
            Object k2;
            return o2 instanceof Map.Entry && (k2 = (e2 = (Map.Entry)o2).getKey()) != null && (r2 = this.map.get(k2)) != null && (v2 = e2.getValue()) != null && (v2 == r2 || v2.equals(r2));
        }

        @Override
        public boolean remove(Object o2) {
            Object v2;
            Map.Entry e2;
            Object k2;
            return o2 instanceof Map.Entry && (k2 = (e2 = (Map.Entry)o2).getKey()) != null && (v2 = e2.getValue()) != null && this.map.remove(k2, v2);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            ConcurrentHashMap m4 = this.map;
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new EntryIterator(t2, f2, 0, f2, m4);
        }

        @Override
        public boolean add(Map.Entry<K, V> e2) {
            return this.map.putVal(e2.getKey(), e2.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c2) {
            boolean added = false;
            for (Map.Entry<K, V> e2 : c2) {
                if (!this.add(e2)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter2) {
            return this.map.removeEntryIf(filter2);
        }

        @Override
        public final int hashCode() {
            int h2 = 0;
            Node<K, V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    h2 += p2.hashCode();
                }
            }
            return h2;
        }

        @Override
        public final boolean equals(Object o2) {
            Set c2;
            return o2 instanceof Set && ((c2 = (Set)o2) == this || this.containsAll(c2) && c2.containsAll(this));
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            ConcurrentHashMap m4 = this.map;
            long n2 = m4.sumCount();
            Node<K, V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new EntrySpliterator(t2, f2, 0, f2, n2 < 0L ? 0L : n2, m4);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    action2.accept(new MapEntry(p2.key, p2.val, this.map));
                }
            }
        }
    }

    static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K, V>[] tab, int size, int index2, int limit2, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit2, map2);
        }

        @Override
        public final K next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            Object k2 = p2.key;
            this.lastReturned = p2;
            this.advance();
            return k2;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<K, V>[] tab, int size, int index2, int limit2, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit2, map2);
        }

        @Override
        public final V next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            Object v2 = p2.val;
            this.lastReturned = p2;
            this.advance();
            return v2;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x2) {
            this.value = x2;
        }
    }

    static final class ForwardingNode<K, V>
    extends Node<K, V> {
        final Node<K, V>[] nextTable;

        ForwardingNode(Node<K, V>[] tab, @NotNull HashingStrategy<? super K> hashingStrategy2) {
            if (hashingStrategy2 == null) {
                ForwardingNode.$$$reportNull$$$0(0);
            }
            super(-1, null, null, hashingStrategy2);
            this.nextTable = tab;
        }

        @Override
        Node<K, V> find(int h2, Object k2) {
            Node<K, V>[] tab = this.nextTable;
            block0: while (true) {
                Node<K, V> e2;
                int n2;
                if (k2 == null || tab == null || (n2 = tab.length) == 0 || (e2 = ConcurrentHashMap.tabAt(tab, n2 - 1 & h2)) == null) {
                    return null;
                }
                do {
                    Object ek;
                    int eh;
                    if ((eh = e2.hash) == h2 && ((ek = e2.key) == k2 || ek != null && ConcurrentHashMap.isEqual(k2, ek, this.hashingStrategy))) {
                        return e2;
                    }
                    if (eh >= 0) continue;
                    if (e2 instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e2).nextTable;
                        continue block0;
                    }
                    return e2.find(h2, k2);
                } while ((e2 = e2.next) != null);
                break;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$ForwardingNode", "<init>"));
        }
    }

    static final class ForEachMappingTask<K, V>
    extends BulkTask<K, V, Void> {
        final BiConsumer<? super K, ? super V> action;

        ForEachMappingTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, BiConsumer<? super K, ? super V> action2) {
            super(p2, b2, i2, f2, t2);
            this.action = action2;
        }

        @Override
        public final void compute() {
            BiConsumer<K, V> action2 = this.action;
            if (action2 != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachMappingTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    action2.accept(p2.key, p2.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static abstract class BulkTask<K, V, R>
    extends CountedCompleter<R> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;
        int batch;

        BulkTask(BulkTask<K, V, ?> par, int b2, int i2, int f2, Node<K, V>[] t2) {
            super(par);
            this.batch = b2;
            this.index = this.baseIndex = i2;
            this.tab = t2;
            if (t2 == null) {
                this.baseLimit = 0;
                this.baseSize = 0;
            } else if (par == null) {
                this.baseSize = this.baseLimit = t2.length;
            } else {
                this.baseLimit = f2;
                this.baseSize = par.baseSize;
            }
        }

        final Node<K, V> advance() {
            Node<K, V> e2 = this.next;
            if (e2 != null) {
                e2 = e2.next;
            }
            while (true) {
                int i2;
                int n2;
                Node<K, V>[] t2;
                block10: {
                    block9: {
                        if (e2 != null) {
                            this.next = e2;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t2 = this.tab;
                        if (this.tab != null && (n2 = t2.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e2 = ConcurrentHashMap.tabAt(t2, i2);
                if (e2 != null && e2.hash < 0) {
                    if (e2 instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e2).nextTable;
                        e2 = null;
                        this.pushState(t2, i2, n2);
                        continue;
                    }
                    e2 = e2 instanceof TreeBin ? ((TreeBin)e2).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n2);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n2) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t2, int i2, int n2) {
            TableStack<K, V> s2 = this.spare;
            if (s2 != null) {
                this.spare = s2.next;
            } else {
                s2 = new TableStack();
            }
            s2.tab = t2;
            s2.length = n2;
            s2.index = i2;
            s2.next = this.stack;
            this.stack = s2;
        }

        private void recoverState(int n2) {
            int len;
            TableStack<K, V> s2;
            while ((s2 = this.stack) != null && (this.index += (len = s2.length)) >= n2) {
                n2 = len;
                this.index = s2.index;
                this.tab = s2.tab;
                s2.tab = null;
                TableStack next = s2.next;
                s2.next = this.spare;
                this.stack = next;
                this.spare = s2;
            }
            if (s2 == null && (this.index += this.baseSize) >= n2) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class ForEachTransformedMappingTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedMappingTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action2) {
            super(p2, b2, i2, f2, t2);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            BiFunction transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachTransformedMappingTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, transformer, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.key, p2.val);
                    if (u2 == null) continue;
                    action2.accept(u2);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class SearchMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchMappingsTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, BiFunction<? super K, ? super V, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p2, b2, i2, f2, t2);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            BiFunction searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new SearchMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p2 = this.advance();
                    if (p2 == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u2 = searchFunction.apply(p2.key, p2.val);
                    if (u2 == null) continue;
                    if (!result2.compareAndSet(null, u2)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class MapReduceMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceMappingsTask<K, V, U> rights;
        MapReduceMappingsTask<K, V, U> nextRight;

        MapReduceMappingsTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceMappingsTask<K, V, U> nextRight, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            BiFunction transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.key, p2.val);
                    if (u2 == null) continue;
                    r2 = r2 == null ? u2 : reducer.apply(r2, u2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceMappingsTask t2 = (MapReduceMappingsTask)c2;
                    MapReduceMappingsTask<K, V, U> s2 = t2.rights;
                    while (s2 != null) {
                        U sr = s2.result;
                        if (sr != null) {
                            U tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleBiFunction<? super K, ? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceMappingsToDoubleTask<K, V> rights;
        MapReduceMappingsToDoubleTask<K, V> nextRight;

        MapReduceMappingsToDoubleTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceMappingsToDoubleTask<K, V> nextRight, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                double r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceMappingsToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsDouble(r2, transformer.applyAsDouble(p2.key, p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceMappingsToDoubleTask t2 = (MapReduceMappingsToDoubleTask)c2;
                    MapReduceMappingsToDoubleTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsDouble(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongBiFunction<? super K, ? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceMappingsToLongTask<K, V> rights;
        MapReduceMappingsToLongTask<K, V> nextRight;

        MapReduceMappingsToLongTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceMappingsToLongTask<K, V> nextRight, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                long r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceMappingsToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsLong(r2, transformer.applyAsLong(p2.key, p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceMappingsToLongTask t2 = (MapReduceMappingsToLongTask)c2;
                    MapReduceMappingsToLongTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsLong(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntBiFunction<? super K, ? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceMappingsToIntTask<K, V> rights;
        MapReduceMappingsToIntTask<K, V> nextRight;

        MapReduceMappingsToIntTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceMappingsToIntTask<K, V> nextRight, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceMappingsToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsInt(r2, transformer.applyAsInt(p2.key, p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceMappingsToIntTask t2 = (MapReduceMappingsToIntTask)c2;
                    MapReduceMappingsToIntTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsInt(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class ForEachKeyTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super K> action;

        ForEachKeyTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Consumer<? super K> action2) {
            super(p2, b2, i2, f2, t2);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<K> action2 = this.action;
            if (action2 != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachKeyTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    action2.accept(p2.key);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedKeyTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super K, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedKeyTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<? super K, ? extends U> transformer, Consumer<? super U> action2) {
            super(p2, b2, i2, f2, t2);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachTransformedKeyTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, transformer, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.key);
                    if (u2 == null) continue;
                    action2.accept(u2);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class SearchKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchKeysTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<? super K, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p2, b2, i2, f2, t2);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<K, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new SearchKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p2 = this.advance();
                    if (p2 == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u2 = searchFunction.apply(p2.key);
                    if (u2 == null) continue;
                    if (!result2.compareAndSet(null, u2)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class ReduceKeysTask<K, V>
    extends BulkTask<K, V, K> {
        final BiFunction<? super K, ? super K, ? extends K> reducer;
        K result;
        ReduceKeysTask<K, V> rights;
        ReduceKeysTask<K, V> nextRight;

        ReduceKeysTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, ReduceKeysTask<K, V> nextRight, BiFunction<? super K, ? super K, ? extends K> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final K getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<K, K, K> reducer = this.reducer;
            if (reducer != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new ReduceKeysTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    Object u2 = p2.key;
                    r2 = r2 == null ? u2 : (u2 == null ? r2 : reducer.apply(r2, u2));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    ReduceKeysTask t2 = (ReduceKeysTask)c2;
                    ReduceKeysTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        K sr = s2.result;
                        if (sr != null) {
                            K tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceKeysTask<K, V, U> rights;
        MapReduceKeysTask<K, V, U> nextRight;

        MapReduceKeysTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceKeysTask<K, V, U> nextRight, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.key);
                    if (u2 == null) continue;
                    r2 = r2 == null ? u2 : reducer.apply(r2, u2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceKeysTask t2 = (MapReduceKeysTask)c2;
                    MapReduceKeysTask<K, V, U> s2 = t2.rights;
                    while (s2 != null) {
                        U sr = s2.result;
                        if (sr != null) {
                            U tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super K> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceKeysToDoubleTask<K, V> rights;
        MapReduceKeysToDoubleTask<K, V> nextRight;

        MapReduceKeysToDoubleTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceKeysToDoubleTask<K, V> nextRight, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                double r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceKeysToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsDouble(r2, transformer.applyAsDouble(p2.key));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceKeysToDoubleTask t2 = (MapReduceKeysToDoubleTask)c2;
                    MapReduceKeysToDoubleTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsDouble(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super K> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceKeysToLongTask<K, V> rights;
        MapReduceKeysToLongTask<K, V> nextRight;

        MapReduceKeysToLongTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceKeysToLongTask<K, V> nextRight, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                long r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceKeysToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsLong(r2, transformer.applyAsLong(p2.key));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceKeysToLongTask t2 = (MapReduceKeysToLongTask)c2;
                    MapReduceKeysToLongTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsLong(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super K> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceKeysToIntTask<K, V> rights;
        MapReduceKeysToIntTask<K, V> nextRight;

        MapReduceKeysToIntTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceKeysToIntTask<K, V> nextRight, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceKeysToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsInt(r2, transformer.applyAsInt(p2.key));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceKeysToIntTask t2 = (MapReduceKeysToIntTask)c2;
                    MapReduceKeysToIntTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsInt(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class ForEachValueTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super V> action;

        ForEachValueTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Consumer<? super V> action2) {
            super(p2, b2, i2, f2, t2);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<V> action2 = this.action;
            if (action2 != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachValueTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    action2.accept(p2.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedValueTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedValueTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<? super V, ? extends U> transformer, Consumer<? super U> action2) {
            super(p2, b2, i2, f2, t2);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachTransformedValueTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, transformer, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.val);
                    if (u2 == null) continue;
                    action2.accept(u2);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class SearchValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchValuesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<? super V, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p2, b2, i2, f2, t2);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<V, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new SearchValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p2 = this.advance();
                    if (p2 == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u2 = searchFunction.apply(p2.val);
                    if (u2 == null) continue;
                    if (!result2.compareAndSet(null, u2)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class ReduceValuesTask<K, V>
    extends BulkTask<K, V, V> {
        final BiFunction<? super V, ? super V, ? extends V> reducer;
        V result;
        ReduceValuesTask<K, V> rights;
        ReduceValuesTask<K, V> nextRight;

        ReduceValuesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, ReduceValuesTask<K, V> nextRight, BiFunction<? super V, ? super V, ? extends V> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final V getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<V, V, V> reducer = this.reducer;
            if (reducer != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new ReduceValuesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    Object v2 = p2.val;
                    r2 = r2 == null ? v2 : reducer.apply(r2, v2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    ReduceValuesTask t2 = (ReduceValuesTask)c2;
                    ReduceValuesTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        V sr = s2.result;
                        if (sr != null) {
                            V tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceValuesTask<K, V, U> rights;
        MapReduceValuesTask<K, V, U> nextRight;

        MapReduceValuesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceValuesTask<K, V, U> nextRight, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2.val);
                    if (u2 == null) continue;
                    r2 = r2 == null ? u2 : reducer.apply(r2, u2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceValuesTask t2 = (MapReduceValuesTask)c2;
                    MapReduceValuesTask<K, V, U> s2 = t2.rights;
                    while (s2 != null) {
                        U sr = s2.result;
                        if (sr != null) {
                            U tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceValuesToDoubleTask<K, V> rights;
        MapReduceValuesToDoubleTask<K, V> nextRight;

        MapReduceValuesToDoubleTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceValuesToDoubleTask<K, V> nextRight, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                double r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceValuesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsDouble(r2, transformer.applyAsDouble(p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceValuesToDoubleTask t2 = (MapReduceValuesToDoubleTask)c2;
                    MapReduceValuesToDoubleTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsDouble(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceValuesToLongTask<K, V> rights;
        MapReduceValuesToLongTask<K, V> nextRight;

        MapReduceValuesToLongTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceValuesToLongTask<K, V> nextRight, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                long r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceValuesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsLong(r2, transformer.applyAsLong(p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceValuesToLongTask t2 = (MapReduceValuesToLongTask)c2;
                    MapReduceValuesToLongTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsLong(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceValuesToIntTask<K, V> rights;
        MapReduceValuesToIntTask<K, V> nextRight;

        MapReduceValuesToIntTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceValuesToIntTask<K, V> nextRight, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceValuesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsInt(r2, transformer.applyAsInt(p2.val));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceValuesToIntTask t2 = (MapReduceValuesToIntTask)c2;
                    MapReduceValuesToIntTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsInt(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class ForEachEntryTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super Map.Entry<K, V>> action;

        ForEachEntryTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Consumer<? super Map.Entry<K, V>> action2) {
            super(p2, b2, i2, f2, t2);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<Map.Entry<K, V>> action2 = this.action;
            if (action2 != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachEntryTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    action2.accept(p2);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedEntryTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedEntryTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action2) {
            super(p2, b2, i2, f2, t2);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new ForEachTransformedEntryTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, transformer, action2).fork();
                }
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2);
                    if (u2 == null) continue;
                    action2.accept(u2);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class SearchEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchEntriesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, Function<Map.Entry<K, V>, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p2, b2, i2, f2, t2);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<Map.Entry<K, V>, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    new SearchEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p2 = this.advance();
                    if (p2 == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u2 = searchFunction.apply(p2);
                    if (u2 == null) continue;
                    if (result2.compareAndSet(null, u2)) {
                        this.quietlyCompleteRoot();
                    }
                    return;
                }
            }
        }
    }

    static final class ReduceEntriesTask<K, V>
    extends BulkTask<K, V, Map.Entry<K, V>> {
        final BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer;
        Map.Entry<K, V> result;
        ReduceEntriesTask<K, V> rights;
        ReduceEntriesTask<K, V> nextRight;

        ReduceEntriesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, ReduceEntriesTask<K, V> nextRight, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final Map.Entry<K, V> getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, Map.Entry<K, V>> reducer = this.reducer;
            if (reducer != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new ReduceEntriesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Node r2 = null;
                while ((p2 = this.advance()) != null) {
                    r2 = r2 == null ? p2 : reducer.apply(r2, p2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    ReduceEntriesTask t2 = (ReduceEntriesTask)c2;
                    ReduceEntriesTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        Map.Entry<K, V> sr = s2.result;
                        if (sr != null) {
                            Map.Entry<K, V> tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceEntriesTask<K, V, U> rights;
        MapReduceEntriesTask<K, V, U> nextRight;

        MapReduceEntriesTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceEntriesTask<K, V, U> nextRight, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r2 = null;
                while ((p2 = this.advance()) != null) {
                    U u2 = transformer.apply(p2);
                    if (u2 == null) continue;
                    r2 = r2 == null ? u2 : reducer.apply(r2, u2);
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceEntriesTask t2 = (MapReduceEntriesTask)c2;
                    MapReduceEntriesTask<K, V, U> s2 = t2.rights;
                    while (s2 != null) {
                        U sr = s2.result;
                        if (sr != null) {
                            U tr = t2.result;
                            t2.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<Map.Entry<K, V>> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceEntriesToDoubleTask<K, V> rights;
        MapReduceEntriesToDoubleTask<K, V> nextRight;

        MapReduceEntriesToDoubleTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceEntriesToDoubleTask<K, V> nextRight, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                double r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceEntriesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsDouble(r2, transformer.applyAsDouble(p2));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceEntriesToDoubleTask t2 = (MapReduceEntriesToDoubleTask)c2;
                    MapReduceEntriesToDoubleTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsDouble(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<Map.Entry<K, V>> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceEntriesToLongTask<K, V> rights;
        MapReduceEntriesToLongTask<K, V> nextRight;

        MapReduceEntriesToLongTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceEntriesToLongTask<K, V> nextRight, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                long r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceEntriesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsLong(r2, transformer.applyAsLong(p2));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceEntriesToLongTask t2 = (MapReduceEntriesToLongTask)c2;
                    MapReduceEntriesToLongTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsLong(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<Map.Entry<K, V>> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceEntriesToIntTask<K, V> rights;
        MapReduceEntriesToIntTask<K, V> nextRight;

        MapReduceEntriesToIntTask(BulkTask<K, V, ?> p2, int b2, int i2, int f2, Node<K, V>[] t2, MapReduceEntriesToIntTask<K, V> nextRight, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
            super(p2, b2, i2, f2, t2);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p2;
                int f2;
                int h2;
                int r2 = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h2 = (f2 = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h2;
                    this.rights = new MapReduceEntriesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f2, this.tab, this.rights, transformer, r2, reducer);
                    this.rights.fork();
                }
                while ((p2 = this.advance()) != null) {
                    r2 = reducer.applyAsInt(r2, transformer.applyAsInt(p2));
                }
                this.result = r2;
                for (CountedCompleter<?> c2 = this.firstComplete(); c2 != null; c2 = c2.nextComplete()) {
                    MapReduceEntriesToIntTask t2 = (MapReduceEntriesToIntTask)c2;
                    MapReduceEntriesToIntTask<K, V> s2 = t2.rights;
                    while (s2 != null) {
                        t2.result = reducer.applyAsInt(t2.result, s2.result);
                        s2 = t2.rights = s2.nextRight;
                    }
                }
            }
        }
    }

    static abstract class CollectionView<K, V, E>
    implements Collection<E> {
        final ConcurrentHashMap<K, V> map;
        private static final String OOME_MSG = "Required array size too large";

        CollectionView(ConcurrentHashMap<K, V> map2) {
            this.map = map2;
        }

        public ConcurrentHashMap<K, V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int n2 = (int)sz;
            Object[] r2 = new Object[n2];
            int i2 = 0;
            for (E e2 : this) {
                if (i2 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    r2 = Arrays.copyOf(r2, n2);
                }
                r2[i2++] = e2;
            }
            return i2 == n2 ? r2 : Arrays.copyOf(r2, i2);
        }

        @Override
        public final <T> T[] toArray(T[] a2) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int m4 = (int)sz;
            T[] r2 = a2.length >= m4 ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), m4);
            int n2 = r2.length;
            int i2 = 0;
            for (E e2 : this) {
                if (i2 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    r2 = Arrays.copyOf(r2, n2);
                }
                r2[i2++] = e2;
            }
            if (a2 == r2 && i2 < n2) {
                r2[i2] = null;
                return r2;
            }
            return i2 == n2 ? r2 : Arrays.copyOf(r2, i2);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e2;
                    sb.append((Object)((e2 = it.next()) == this ? "(this Collection)" : e2));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c2) {
            if (c2 != this) {
                for (Object e2 : c2) {
                    if (e2 != null && this.contains(e2)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Node<K, V>[] t2 = this.map.table;
            if (this.map.table == null) {
                return false;
            }
            if (c2 instanceof Set && c2.size() > t2.length) {
                Iterator<E> it = this.iterator();
                while (it.hasNext()) {
                    if (!c2.contains(it.next())) continue;
                    it.remove();
                    modified = true;
                }
            } else {
                for (Object e2 : c2) {
                    modified |= this.remove(e2);
                }
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c2.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final ConcurrentHashMap<K, V> map;
        long est;

        EntrySpliterator(Node<K, V>[] tab, int size, int index2, int limit2, long est, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit2);
            this.map = map2;
            this.est = est;
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int i2 = this.baseIndex;
            int f2 = this.baseLimit;
            int h2 = i2 + f2 >>> 1;
            if (h2 <= i2) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h2;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f2, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action2) {
            Node p2;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action2.accept(new MapEntry(p2.key, p2.val, this.map));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action2.accept(new MapEntry(p2.key, p2.val, this.map));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class ValueSpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<V> {
        long est;

        ValueSpliterator(Node<K, V>[] tab, int size, int index2, int limit2, long est) {
            super(tab, size, index2, limit2);
            this.est = est;
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int i2 = this.baseIndex;
            int f2 = this.baseLimit;
            int h2 = i2 + f2 >>> 1;
            if (h2 <= i2) {
                valueSpliterator = null;
            } else {
                this.baseLimit = h2;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f2, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action2) {
            Node p2;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action2.accept(p2.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action2.accept(p2.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class KeySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<K> {
        long est;

        KeySpliterator(Node<K, V>[] tab, int size, int index2, int limit2, long est) {
            super(tab, size, index2, limit2);
            this.est = est;
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int i2 = this.baseIndex;
            int f2 = this.baseLimit;
            int h2 = i2 + f2 >>> 1;
            if (h2 <= i2) {
                keySpliterator = null;
            } else {
                this.baseLimit = h2;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f2, this.est >>>= 1);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action2) {
            Node p2;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action2.accept(p2.key);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action2.accept(p2.key);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final ConcurrentHashMap<K, V> map;

        MapEntry(K key, V val, ConcurrentHashMap<K, V> map2) {
            this.key = key;
            this.val = val;
            this.map = map2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return this.map.hash(this.key) ^ this.val.hashCode();
        }

        public String toString() {
            return Helpers.mapEntryToString(this.key, this.val);
        }

        @Override
        public boolean equals(Object o2) {
            Object v2;
            Map.Entry e2;
            Object k2;
            return !(!(o2 instanceof Map.Entry) || (k2 = (e2 = (Map.Entry)o2).getKey()) == null || (v2 = e2.getValue()) == null || k2 != this.key && !this.map.isEqual(k2, this.key) || v2 != this.val && !v2.equals(this.val));
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V v2 = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v2;
        }
    }

    static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] tab, int size, int index2, int limit2, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit2, map2);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            Object k2 = p2.key;
            Object v2 = p2.val;
            this.lastReturned = p2;
            this.advance();
            return new MapEntry(k2, v2, this.map);
        }
    }

    static class BaseIterator<K, V>
    extends Traverser<K, V> {
        final ConcurrentHashMap<K, V> map;
        Node<K, V> lastReturned;

        BaseIterator(Node<K, V>[] tab, int size, int index2, int limit2, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit2);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<K, V> p2 = this.lastReturned;
            if (p2 == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p2.key, null, null);
        }
    }

    static final class TableStack<K, V> {
        int length;
        int index;
        Node<K, V>[] tab;
        TableStack<K, V> next;

        TableStack() {
        }
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }
}

