/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ThreadLocalRandom;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class ConcurrentLongObjectHashMap<V>
implements ConcurrentLongObjectMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient ConcurrentHashMap.CounterCell[] counterCells;
    private transient ValuesView<V> values;
    private transient EntrySetView<V> entrySet;
    private static final VarHandle SIZECTL;
    private static final VarHandle TRANSFERINDEX;
    private static final VarHandle BASECOUNT;
    private static final VarHandle CELLSBUSY;
    private static final VarHandle TAB_ARRAY;

    static final int spread(long h2) {
        h2 ^= h2 >>> 32;
        return (int)(h2 ^ h2 >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c2) {
        int n2 = -1 >>> Integer.numberOfLeadingZeros(c2 - 1);
        return n2 < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    static <V> Node<V> tabAt(Node<V>[] tab, int i2) {
        return TAB_ARRAY.getVolatile(tab, i2);
    }

    static <V> boolean casTabAt(Node<V>[] tab, int i2, Node<V> v2) {
        return TAB_ARRAY.compareAndSet(tab, i2, null, v2);
    }

    static <V> void setTabAt(Node<V>[] tab, int i2, Node<V> v2) {
        TAB_ARRAY.setVolatile(tab, i2, v2);
    }

    ConcurrentLongObjectHashMap() {
    }

    ConcurrentLongObjectHashMap(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentLongObjectHashMap.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    @Override
    public int size() {
        long n2 = this.sumCount();
        return n2 < 0L ? 0 : (n2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n2);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(long key) {
        Node<V> e2;
        int n2;
        int h2 = ConcurrentLongObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        if (this.table != null && (n2 = tab.length) > 0 && (e2 = ConcurrentLongObjectHashMap.tabAt(tab, n2 - 1 & h2)) != null) {
            int eh = e2.hash;
            if (eh == h2) {
                if (e2.key == key) {
                    return e2.val;
                }
            } else if (eh < 0) {
                Node<V> p2 = e2.find(h2, key);
                return p2 != null ? (V)p2.val : null;
            }
            while ((e2 = e2.next) != null) {
                if (e2.hash != h2 || e2.key != key) continue;
                return e2.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        if (value == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(0);
        }
        Node<V>[] t2 = this.table;
        if (this.table != null) {
            Node<V> p2;
            Traverser<V> it = new Traverser<V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                Object v2 = p2.val;
                if (v2 != value && (v2 == null || !value.equals(v2))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(long key, @NotNull V v2) {
        void value;
        if (v2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(1);
        }
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(long key, V value, boolean onlyIfAbsent) {
        int binCount;
        block21: {
            V oldVal;
            int i2;
            int hash = ConcurrentLongObjectHashMap.spread(key);
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Object fv;
                long fk;
                int n2;
                if (tab == null || (n2 = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n2 - 1 & hash;
                Node<V> f2 = ConcurrentLongObjectHashMap.tabAt(tab, i2);
                if (f2 == null) {
                    if (!ConcurrentLongObjectHashMap.casTabAt(tab, i2, new Node<V>(hash, key, value, null))) continue;
                    break block21;
                }
                int fh = f2.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f2);
                    continue;
                }
                if (onlyIfAbsent && fh == hash && (fk = f2.key) == key && (fv = f2.val) != null) {
                    return fv;
                }
                oldVal = null;
                Node<V> node = f2;
                synchronized (node) {
                    block22: {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f2) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e2 = f2;
                                while (true) {
                                    long ek;
                                    if (e2.hash == hash && (ek = e2.key) == key) {
                                        oldVal = e2.val;
                                        if (!onlyIfAbsent) {
                                            e2.val = value;
                                        }
                                        break block22;
                                    }
                                    Node<V> pred = e2;
                                    e2 = e2.next;
                                    if (e2 == null) {
                                        pred.next = new Node<V>(hash, key, value, null);
                                        break block22;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f2 instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p2 = ((TreeBin)f2).putTreeVal(hash, key, value);
                                if (p2 != null) {
                                    oldVal = p2.val;
                                    if (!onlyIfAbsent) {
                                        p2.val = value;
                                    }
                                }
                            } else if (f2 instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public V remove(long key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(long key, V value, Object cv) {
        int i2;
        Node<V> f2;
        int n2;
        int hash = ConcurrentLongObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        while (tab != null && (n2 = tab.length) != 0 && (f2 = ConcurrentLongObjectHashMap.tabAt(tab, i2 = n2 - 1 & hash)) != null) {
            int fh = f2.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f2);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node = f2;
            synchronized (node) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f2) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e2 = f2;
                        Node<V> pred = null;
                        do {
                            if (e2.key == key) {
                                Object ev = e2.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e2.val = value;
                                    } else if (pred != null) {
                                        pred.next = e2.next;
                                    } else {
                                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, e2.next);
                                    }
                                }
                                break;
                            }
                            pred = e2;
                        } while ((e2 = e2.next) != null);
                    } else if (f2 instanceof TreeBin) {
                        TreeNode p2;
                        validated = true;
                        TreeBin t2 = (TreeBin)f2;
                        TreeNode r2 = t2.root;
                        if (r2 != null && (p2 = r2.findTreeNode(hash, key)) != null) {
                            Object pv = p2.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p2.val = value;
                                } else if (t2.removeTreeNode(p2)) {
                                    ConcurrentLongObjectHashMap.setTabAt(tab, i2, this.untreeify(t2.first));
                                }
                            }
                        }
                    } else if (f2 instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i2 = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i2 < tab.length) {
            Node<V> f2 = ConcurrentLongObjectHashMap.tabAt(tab, i2);
            if (f2 == null) {
                ++i2;
                continue;
            }
            int fh = f2.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f2);
                i2 = 0;
                continue;
            }
            Node<V> node = f2;
            synchronized (node) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f2) {
                    Node<V> p2;
                    Node<V> node2 = fh >= 0 ? f2 : (p2 = f2 instanceof TreeBin ? ((TreeBin)f2).first : null);
                    while (p2 != null) {
                        --delta;
                        p2 = p2.next;
                    }
                    ConcurrentLongObjectHashMap.setTabAt(tab, i2++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    @Override
    public Collection<V> values() {
        ValuesView<V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new ValuesView(this);
        return this.values;
    }

    public Set<ConcurrentLongObjectMap.LongEntry<V>> entrySet() {
        EntrySetView<V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    public int hashCode() {
        int h2 = 0;
        Node<V>[] t2 = this.table;
        if (this.table != null) {
            Node<V> p2;
            Traverser<V> it = new Traverser<V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                h2 += p2.hashCode();
            }
        }
        return h2;
    }

    public String toString() {
        Node<V>[] t2 = this.table;
        int f2 = this.table == null ? 0 : t2.length;
        Traverser<V> it = new Traverser<V>(t2, f2, 0, f2);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p2 = it.advance();
        if (p2 != null) {
            while (true) {
                long k2 = p2.key;
                Object v2 = p2.val;
                sb.append(k2);
                sb.append('=');
                sb.append((Object)(v2 == this ? "(this Map)" : v2));
                p2 = it.advance();
                if (p2 == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    public boolean equals(Object o2) {
        if (o2 != this) {
            Node<V> p2;
            if (!(o2 instanceof ConcurrentLongObjectMap)) {
                return false;
            }
            ConcurrentLongObjectMap m4 = (ConcurrentLongObjectMap)o2;
            Node<V>[] t2 = this.table;
            int f2 = this.table == null ? 0 : t2.length;
            Traverser<V> it = new Traverser<V>(t2, f2, 0, f2);
            while ((p2 = it.advance()) != null) {
                Object val = p2.val;
                Object v2 = m4.get(p2.key);
                if (v2 != null && (v2 == val || v2.equals(val))) continue;
                return false;
            }
            for (ConcurrentLongObjectMap.LongEntry e2 : m4.entries()) {
                long mk = e2.getKey();
                Object mv = e2.getValue();
                V v3 = this.get(mk);
                if (v3 != null && (mv == v3 || mv.equals(v3))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(long key, @NotNull V v2) {
        void value;
        if (v2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(2);
        }
        return this.putVal(key, value, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(long key, @NotNull Object object) {
        void value;
        if (object == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(3);
        }
        return this.replaceNode(key, null, value) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(long key, @NotNull V oldValue, @NotNull V v2) {
        void newValue;
        if (oldValue == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(4);
        }
        if (v2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(5);
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(long key, @NotNull V v2) {
        void value;
        if (v2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(6);
        }
        return this.replaceNode(key, value, null);
    }

    public V getOrDefault(long key, V defaultValue) {
        V v2 = this.get(key);
        return v2 == null ? defaultValue : v2;
    }

    boolean removeValueIf(Predicate<? super V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<V>[] t2 = this.table;
        if (this.table != null) {
            Node<V> p2;
            Traverser<V> it = new Traverser<V>(t2, t2.length, 0, t2.length);
            while ((p2 = it.advance()) != null) {
                long k2 = p2.key;
                Object v2 = p2.val;
                if (!function.test(v2) || this.replaceNode(k2, null, v2) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public long @NotNull [] keys() {
        Object[] entries2 = new EntrySetView(this).toArray();
        long[] result2 = new long[entries2.length];
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            ConcurrentLongObjectMap.LongEntry entry = (ConcurrentLongObjectMap.LongEntry)entries2[i2];
            result2[i2] = entry.getKey();
        }
        if (result2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(7);
        }
        return result2;
    }

    @Override
    @NotNull
    public Iterator<V> elements() {
        Node<V>[] t2 = this.table;
        int f2 = this.table == null ? 0 : t2.length;
        return new ValueIterator<V>(t2, f2, 0, f2, this);
    }

    public long mappingCount() {
        long n2 = this.sumCount();
        return n2 < 0L ? 0L : n2;
    }

    static final int resizeStamp(int n2) {
        return Integer.numberOfLeadingZeros(n2) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (SIZECTL.compareAndSet(this, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n2 = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n2];
                    tab = nt;
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x2, int check) {
        long s2;
        long b2;
        ConcurrentHashMap.CounterCell[] as2 = this.counterCells;
        if (this.counterCells != null || !BASECOUNT.compareAndSet(this, b2 = this.baseCount, s2 = b2 + x2)) {
            long v2;
            ConcurrentHashMap.CounterCell a2;
            int m4;
            boolean uncontended = true;
            if (as2 == null || (m4 = as2.length - 1) < 0 || (a2 = as2[ThreadLocalRandom.getProbe() & m4]) == null || !(uncontended = ConcurrentHashMap.CELLVALUE.compareAndSet(a2, v2 = a2.value, v2 + x2))) {
                this.fullAddCount(x2, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s2 = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s2 >= (long)(sc = this.sizeCtl)) {
                int n2;
                Node<V>[] tab = this.table;
                if (this.table == null || (n2 = tab.length) >= 0x40000000) break;
                int rs = ConcurrentLongObjectHashMap.resizeStamp(n2) << 16;
                if (sc < 0) {
                    if (sc == rs + 65535 || sc == rs + 1) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (SIZECTL.compareAndSet(this, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (SIZECTL.compareAndSet(this, sc, rs + 2)) {
                    this.transfer(tab, null);
                }
                s2 = this.sumCount();
            }
        }
    }

    final Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f2) {
        if (tab != null && f2 instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f2).nextTable;
            if (((ForwardingNode)f2).nextTable != null) {
                int sc;
                int rs = ConcurrentLongObjectHashMap.resizeStamp(tab.length) << 16;
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc != rs + 65535 && sc != rs + 1 && this.transferIndex > 0) {
                    if (!SIZECTL.compareAndSet(this, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c2;
        int n2 = c2 = size >= 0x20000000 ? 0x40000000 : ConcurrentLongObjectHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int rs;
            int n3;
            Node<V>[] tab = this.table;
            if (tab == null || (n3 = tab.length) == 0) {
                int n4 = n3 = sc > c2 ? sc : c2;
                if (!SIZECTL.compareAndSet(this, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n3];
                    this.table = nt;
                    sc = n3 - (n3 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c2 <= sc || n3 >= 0x40000000) break;
            if (tab != this.table || !SIZECTL.compareAndSet(this, sc, ((rs = ConcurrentLongObjectHashMap.resizeStamp(n3)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n2 = tab.length;
        int stride = NCPU > 1 ? (n2 >>> 3) / NCPU : n2;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n2 << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n2;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i2 = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i2 >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i2 = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!TRANSFERINDEX.compareAndSet(this, nextIndex, nextBound)) continue;
                bound = nextBound;
                i2 = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i2 < 0 || i2 >= n2 || i2 + n2 >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n2 << 1) - (n2 >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!SIZECTL.compareAndSet(this, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentLongObjectHashMap.resizeStamp(n2) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i2 = n2;
                continue;
            }
            TreeBin f2 = ConcurrentLongObjectHashMap.tabAt(tab, i2);
            if (f2 == null) {
                advance = ConcurrentLongObjectHashMap.casTabAt(tab, i2, fwd);
                continue;
            }
            int fh = f2.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f2;
            synchronized (treeBin) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f2) {
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n2;
                        TreeBin lastRun = f2;
                        Node p2 = f2.next;
                        while (p2 != null) {
                            int b2 = p2.hash & n2;
                            if (b2 != runBit) {
                                runBit = b2;
                                lastRun = p2;
                            }
                            p2 = p2.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p2 = f2;
                        while (p2 != lastRun) {
                            int ph = p2.hash;
                            long pk = p2.key;
                            Object pv = p2.val;
                            if ((ph & n2) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p2 = p2.next;
                        }
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2 + n2, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f2 instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t2 = f2;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e2 = t2.first;
                        while (e2 != null) {
                            int h2 = e2.hash;
                            TreeNode p3 = new TreeNode(h2, e2.key, e2.val, null, null);
                            if ((h2 & n2) == 0) {
                                p3.prev = loTail;
                                if (p3.prev == null) {
                                    lo = p3;
                                } else {
                                    loTail.next = p3;
                                }
                                loTail = p3;
                                ++lc;
                            } else {
                                p3.prev = hiTail;
                                if (p3.prev == null) {
                                    hi = p3;
                                } else {
                                    hiTail.next = p3;
                                }
                                hiTail = p3;
                                ++hc;
                            }
                            e2 = e2.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t2);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t2);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2 + n2, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f2 instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
        }
    }

    final long sumCount() {
        ConcurrentHashMap.CounterCell[] cs = this.counterCells;
        long sum = this.baseCount;
        if (cs != null) {
            for (ConcurrentHashMap.CounterCell c2 : cs) {
                if (c2 == null) continue;
                sum += c2.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x2, boolean wasUncontended) {
        int h2 = ThreadLocalRandom.getProbe();
        if (h2 == 0) {
            ThreadLocalRandom.localInit();
            h2 = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v2;
            int n2;
            ConcurrentHashMap.CounterCell[] cs = this.counterCells;
            if (this.counterCells != null && (n2 = cs.length) > 0) {
                ConcurrentHashMap.CounterCell c2 = cs[n2 - 1 & h2];
                if (c2 == null) {
                    if (this.cellsBusy == 0) {
                        ConcurrentHashMap.CounterCell r2 = new ConcurrentHashMap.CounterCell(x2);
                        if (this.cellsBusy == 0 && CELLSBUSY.compareAndSet(this, 0, 1)) {
                            boolean created = false;
                            try {
                                int j2;
                                int m4;
                                ConcurrentHashMap.CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m4 = rs.length) > 0 && rs[j2 = m4 - 1 & h2] == null) {
                                    rs[j2] = r2;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v2 = c2.value;
                    if (ConcurrentHashMap.CELLVALUE.compareAndSet(c2, v2, v2 + x2)) return;
                    if (this.counterCells != cs || n2 >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && CELLSBUSY.compareAndSet(this, 0, 1)) {
                        try {
                            if (this.counterCells == cs) {
                                this.counterCells = Arrays.copyOf(cs, n2 << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h2 = ThreadLocalRandom.advanceProbe(h2);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == cs && CELLSBUSY.compareAndSet(this, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == cs) {
                        ConcurrentHashMap.CounterCell[] rs = new ConcurrentHashMap.CounterCell[2];
                        rs[h2 & 1] = new ConcurrentHashMap.CounterCell(x2);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v2 = this.baseCount;
            if (BASECOUNT.compareAndSet(this, v2, v2 + x2)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<V>[] tab, int index2) {
        if (tab != null) {
            int n2 = tab.length;
            if (n2 < 64) {
                this.tryPresize(n2 << 1);
            } else {
                Node<V> b2 = ConcurrentLongObjectHashMap.tabAt(tab, index2);
                if (b2 != null && b2.hash >= 0) {
                    Node<V> node = b2;
                    synchronized (node) {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, index2) == b2) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e2 = b2;
                            while (e2 != null) {
                                TreeNode p2 = new TreeNode(e2.hash, e2.key, e2.val, null, null);
                                p2.prev = tl;
                                if (p2.prev == null) {
                                    hd = p2;
                                } else {
                                    tl.next = p2;
                                }
                                tl = p2;
                                e2 = e2.next;
                            }
                            ConcurrentLongObjectHashMap.setTabAt(tab, index2, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    Node<V> untreeify(Node<V> b2) {
        Node hd = null;
        Node tl = null;
        Node<V> q2 = b2;
        while (q2 != null) {
            Node p2 = new Node(q2.hash, q2.key, q2.val, null);
            if (tl == null) {
                hd = p2;
            } else {
                tl.next = p2;
            }
            tl = p2;
            q2 = q2.next;
        }
        return hd;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentLongObjectMap.LongEntry<V>> entries() {
        return new EntrySetView(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V cacheOrGet(long key, @NotNull V v2) {
        void defaultValue;
        V v3;
        if (v2 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(8);
        }
        if ((v3 = this.get(key)) != null) {
            V v4 = v3;
            if (v4 == null) {
                ConcurrentLongObjectHashMap.$$$reportNull$$$0(9);
            }
            return v4;
        }
        void prev = this.putIfAbsent(key, defaultValue);
        void v1 = prev == null ? defaultValue : prev;
        if (v1 == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(10);
        }
        return v1;
    }

    static {
        try {
            SIZECTL = MethodHandles.privateLookupIn(ConcurrentLongObjectHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentLongObjectHashMap.class, "sizeCtl", Integer.TYPE);
            TRANSFERINDEX = MethodHandles.privateLookupIn(ConcurrentLongObjectHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentLongObjectHashMap.class, "transferIndex", Integer.TYPE);
            BASECOUNT = MethodHandles.privateLookupIn(ConcurrentLongObjectHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentLongObjectHashMap.class, "baseCount", Long.TYPE);
            CELLSBUSY = MethodHandles.privateLookupIn(ConcurrentLongObjectHashMap.class, MethodHandles.lookup()).findVarHandle(ConcurrentLongObjectHashMap.class, "cellsBusy", Integer.TYPE);
            TAB_ARRAY = MethodHandles.arrayElementVarHandle(Node[].class);
        }
        catch (Throwable e2) {
            throw new Error(e2);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        Class<ReservationNode> clazz = ReservationNode.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 7, 9, 10 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ConcurrentLongObjectHashMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ConcurrentLongObjectHashMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string2);
            case 7, 9, 10 -> new IllegalStateException(string2);
        };
    }

    static class Node<V>
    implements ConcurrentLongObjectMap.LongEntry<V> {
        final int hash;
        final long key;
        volatile V val;
        volatile Node<V> next;

        Node(int hash, long key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        @Override
        public final long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public final V getValue() {
            V v2 = this.val;
            if (v2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            return v2;
        }

        public final int hashCode() {
            return ConcurrentLongObjectHashMap.spread(this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        public final boolean equals(Object o2) {
            V u2;
            if (!(o2 instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e2 = (ConcurrentLongObjectMap.LongEntry)o2;
            if (e2.getKey() != this.key) {
                return false;
            }
            Object v2 = e2.getValue();
            return v2 == (u2 = this.val) || v2.equals(u2);
        }

        Node<V> find(int h2, long k2) {
            Node<V> e2 = this;
            do {
                if (e2.key != k2) continue;
                return e2;
            } while ((e2 = e2.next) != null);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/ConcurrentLongObjectHashMap$Node", "getValue"));
        }
    }

    static class Traverser<V> {
        Node<V>[] tab;
        Node<V> next;
        TableStack<V> stack;
        TableStack<V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<V>[] tab, int size, int index2, int limit2) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index2;
            this.baseLimit = limit2;
            this.next = null;
        }

        final Node<V> advance() {
            Node<V> e2 = this.next;
            if (e2 != null) {
                e2 = e2.next;
            }
            while (true) {
                int i2;
                int n2;
                Node<V>[] t2;
                block10: {
                    block9: {
                        if (e2 != null) {
                            this.next = e2;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t2 = this.tab;
                        if (this.tab != null && (n2 = t2.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e2 = ConcurrentLongObjectHashMap.tabAt(t2, i2);
                if (e2 != null && e2.hash < 0) {
                    if (e2 instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e2).nextTable;
                        e2 = null;
                        this.pushState(t2, i2, n2);
                        continue;
                    }
                    e2 = e2 instanceof TreeBin ? ((TreeBin)e2).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n2);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n2) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<V>[] t2, int i2, int n2) {
            TableStack<V> s2 = this.spare;
            if (s2 != null) {
                this.spare = s2.next;
            } else {
                s2 = new TableStack();
            }
            s2.tab = t2;
            s2.length = n2;
            s2.index = i2;
            s2.next = this.stack;
            this.stack = s2;
        }

        private void recoverState(int n2) {
            int len;
            TableStack<V> s2;
            while ((s2 = this.stack) != null && (this.index += (len = s2.length)) >= n2) {
                n2 = len;
                this.index = s2.index;
                this.tab = s2.tab;
                s2.tab = null;
                TableStack next = s2.next;
                s2.next = this.spare;
                this.stack = next;
                this.spare = s2;
            }
            if (s2 == null && (this.index += this.baseSize) >= n2) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TreeBin<V>
    extends Node<V> {
        TreeNode<V> root;
        volatile TreeNode<V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final VarHandle LOCKSTATE;

        TreeBin(TreeNode<V> b2) {
            super(-2, 0L, null, null);
            this.first = b2;
            TreeNode r2 = null;
            TreeNode x2 = b2;
            while (x2 != null) {
                TreeNode next = (TreeNode)x2.next;
                x2.right = null;
                x2.left = null;
                if (r2 == null) {
                    x2.parent = null;
                    x2.red = false;
                    r2 = x2;
                } else {
                    TreeNode xp;
                    int dir;
                    int h2 = x2.hash;
                    TreeNode p2 = r2;
                    do {
                        int ph;
                        dir = (ph = p2.hash) > h2 ? -1 : (ph < h2 ? 1 : 0);
                        xp = p2;
                    } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
                    x2.parent = xp;
                    if (dir <= 0) {
                        xp.left = x2;
                    } else {
                        xp.right = x2;
                    }
                    r2 = TreeBin.balanceInsertion(r2, x2);
                }
                x2 = next;
            }
            this.root = r2;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!LOCKSTATE.compareAndSet(this, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s2;
                if (((s2 = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!LOCKSTATE.compareAndSet(this, s2, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s2 & 2) == 0) {
                    if (!LOCKSTATE.compareAndSet(this, s2, s2 | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<V> find(int h2, long k2) {
            Node e2 = this.first;
            while (e2 != null) {
                TreeNode<V> p2;
                int s2 = this.lockState;
                if ((s2 & 3) != 0) {
                    if (e2.key == k2) {
                        return e2;
                    }
                    e2 = e2.next;
                    continue;
                }
                if (!LOCKSTATE.compareAndSet(this, s2, s2 + 4)) continue;
                try {
                    TreeNode<V> r2 = this.root;
                    p2 = r2 == null ? null : r2.findTreeNode(h2, k2);
                }
                finally {
                    Thread w2;
                    if (LOCKSTATE.getAndAdd(this, -4) == 6 && (w2 = this.waiter) != null) {
                        LockSupport.unpark(w2);
                    }
                }
                return p2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<V> putTreeVal(int h2, long k2, V v2) {
            block18: {
                TreeNode<V> xp;
                int dir;
                boolean searched = false;
                TreeNode<V> p2 = this.root;
                do {
                    if (p2 == null) {
                        this.root = new TreeNode<V>(h2, k2, v2, null, null);
                        this.first = this.root;
                        break block18;
                    }
                    int ph = p2.hash;
                    if (ph > h2) {
                        dir = -1;
                    } else if (ph < h2) {
                        dir = 1;
                    } else {
                        if (p2.key == k2) {
                            return p2;
                        }
                        if (!searched) {
                            TreeNode q2;
                            searched = true;
                            TreeNode ch = p2.left;
                            if (ch != null && (q2 = ch.findTreeNode(h2, k2)) != null || (ch = p2.right) != null && (q2 = ch.findTreeNode(h2, k2)) != null) {
                                return q2;
                            }
                        }
                        dir = 0;
                    }
                    xp = p2;
                } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
                TreeNode<V> f2 = this.first;
                TreeNode<V> x2 = new TreeNode<V>(h2, k2, v2, f2, xp);
                this.first = x2;
                if (f2 != null) {
                    f2.prev = x2;
                }
                if (dir <= 0) {
                    xp.left = x2;
                } else {
                    xp.right = x2;
                }
                if (!xp.red) {
                    x2.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x2);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<V> p2) {
            TreeNode rl;
            TreeNode next = (TreeNode)p2.next;
            TreeNode pred = p2.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r2 = this.root;
            if (r2 == null || r2.right == null || (rl = r2.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p2.left;
                TreeNode pr = p2.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s2 = pr;
                    while ((sl = s2.left) != null) {
                        s2 = sl;
                    }
                    boolean c2 = s2.red;
                    s2.red = p2.red;
                    p2.red = c2;
                    TreeNode sr = s2.right;
                    TreeNode pp2 = p2.parent;
                    if (s2 == pr) {
                        p2.parent = s2;
                        s2.right = p2;
                    } else {
                        TreeNode sp = s2.parent;
                        p2.parent = sp;
                        if (p2.parent != null) {
                            if (s2 == sp.left) {
                                sp.left = p2;
                            } else {
                                sp.right = p2;
                            }
                        }
                        if ((s2.right = pr) != null) {
                            pr.parent = s2;
                        }
                    }
                    p2.left = null;
                    p2.right = sr;
                    if (p2.right != null) {
                        sr.parent = p2;
                    }
                    if ((s2.left = pl) != null) {
                        pl.parent = s2;
                    }
                    if ((s2.parent = pp2) == null) {
                        r2 = s2;
                    } else if (p2 == pp2.left) {
                        pp2.left = s2;
                    } else {
                        pp2.right = s2;
                    }
                    replacement = sr != null ? sr : p2;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p2);
                }
                if (replacement != p2) {
                    replacement.parent = p2.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r2 = replacement;
                    } else if (p2 == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p2.parent = null;
                    p2.right = null;
                    p2.left = null;
                }
                TreeNode<V> treeNode = this.root = p2.red ? r2 : TreeBin.balanceDeletion(r2, replacement);
                if (p2 == replacement && (pp = p2.parent) != null) {
                    if (p2 == pp.left) {
                        pp.left = null;
                    } else if (p2 == pp.right) {
                        pp.right = null;
                    }
                    p2.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p2) {
            TreeNode r2;
            if (p2 != null && (r2 = p2.right) != null) {
                p2.right = r2.left;
                TreeNode rl = p2.right;
                if (p2.right != null) {
                    rl.parent = p2;
                }
                TreeNode pp = r2.parent = p2.parent;
                if (r2.parent == null) {
                    root = r2;
                    r2.red = false;
                } else if (pp.left == p2) {
                    pp.left = r2;
                } else {
                    pp.right = r2;
                }
                r2.left = p2;
                p2.parent = r2;
            }
            return root;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p2) {
            TreeNode l2;
            if (p2 != null && (l2 = p2.left) != null) {
                p2.left = l2.right;
                TreeNode lr = p2.left;
                if (p2.left != null) {
                    lr.parent = p2;
                }
                TreeNode pp = l2.parent = p2.parent;
                if (l2.parent == null) {
                    root = l2;
                    l2.red = false;
                } else if (pp.right == p2) {
                    pp.right = l2;
                } else {
                    pp.left = l2;
                }
                l2.right = p2;
                p2.parent = l2;
            }
            return root;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x2) {
            x2.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x2.parent) == null) {
                    x2.red = false;
                    return x2;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x2 = xpp;
                        continue;
                    }
                    if (x2 == xp.right) {
                        x2 = xp;
                        root = TreeBin.rotateLeft(root, x2);
                        xp = x2.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x2 = xpp;
                    continue;
                }
                if (x2 == xp.left) {
                    x2 = xp;
                    root = TreeBin.rotateRight(root, x2);
                    xp = x2.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x2) {
            while (x2 != null && x2 != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x2.parent;
                if (xp == null) {
                    x2.red = false;
                    return x2;
                }
                if (x2.red) {
                    x2.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x2) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x2.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x2 = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x2 = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x2.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x2 = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x2.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x2 = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x2 = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x2.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x2 = root;
            }
            return root;
        }

        static <V> boolean checkInvariants(TreeNode<V> t2) {
            TreeNode tp = t2.parent;
            TreeNode tl = t2.left;
            TreeNode tr = t2.right;
            TreeNode tb = t2.prev;
            TreeNode tn = (TreeNode)t2.next;
            if (tb != null && tb.next != t2) {
                return false;
            }
            if (tn != null && tn.prev != t2) {
                return false;
            }
            if (tp != null && t2 != tp.left && t2 != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t2 || tl.hash > t2.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t2 || tr.hash < t2.hash)) {
                return false;
            }
            if (t2.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                LOCKSTATE = MethodHandles.privateLookupIn(TreeBin.class, MethodHandles.lookup()).findVarHandle(TreeBin.class, "lockState", Integer.TYPE);
            }
            catch (Throwable e2) {
                throw new Error(e2);
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, long key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        @Override
        Node<V> find(int h2, long k2) {
            return this.findTreeNode(h2, k2);
        }

        final TreeNode<V> findTreeNode(int h2, long k2) {
            TreeNode<V> p2 = this;
            do {
                TreeNode<V> pl = p2.left;
                TreeNode<V> pr = p2.right;
                int ph = p2.hash;
                if (ph > h2) {
                    p2 = pl;
                    continue;
                }
                if (ph < h2) {
                    p2 = pr;
                    continue;
                }
                if (p2.key == k2) {
                    return p2;
                }
                if (pl == null) {
                    p2 = pr;
                    continue;
                }
                if (pr == null) {
                    p2 = pl;
                    continue;
                }
                TreeNode<V> q2 = pr.findTreeNode(h2, k2);
                if (q2 != null) {
                    return q2;
                }
                p2 = pl;
            } while (p2 != null);
            return null;
        }
    }

    static final class ReservationNode<V>
    extends Node<V> {
        ReservationNode() {
            super(-3, 0L, null, null);
        }

        Node<V> find(int h2, Object k2) {
            return null;
        }
    }

    static final class ValuesView<V>
    extends CollectionView<V, V>
    implements Collection<V> {
        ValuesView(ConcurrentLongObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public final boolean contains(Object o2) {
            return this.map.containsValue(o2);
        }

        @Override
        public final boolean remove(Object o2) {
            if (o2 != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o2.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            ConcurrentLongObjectHashMap m4 = this.map;
            Node<V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new ValueIterator(t2, f2, 0, f2, m4);
        }

        @Override
        public final boolean add(V e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<V> it = this.iterator();
            while (it.hasNext()) {
                if (!c2.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter2) {
            return this.map.removeValueIf(filter2);
        }

        @Override
        public Spliterator<V> spliterator() {
            ConcurrentLongObjectHashMap m4 = this.map;
            long n2 = m4.sumCount();
            Node<V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new ValueSpliterator(t2, f2, 0, f2, n2 < 0L ? 0L : n2);
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    action2.accept(p2.val);
                }
            }
        }
    }

    static final class EntrySetView<V>
    extends CollectionView<V, ConcurrentLongObjectMap.LongEntry<V>>
    implements Set<ConcurrentLongObjectMap.LongEntry<V>> {
        EntrySetView(ConcurrentLongObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e2 = (ConcurrentLongObjectMap.LongEntry)o2;
            Object r2 = this.map.get(e2.getKey());
            if (r2 == null) {
                return false;
            }
            Object v2 = e2.getValue();
            return v2 == r2 || v2.equals(r2);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e2 = (ConcurrentLongObjectMap.LongEntry)o2;
            Object v2 = e2.getValue();
            return this.map.remove(e2.getKey(), v2);
        }

        @Override
        @NotNull
        public Iterator<ConcurrentLongObjectMap.LongEntry<V>> iterator() {
            ConcurrentLongObjectHashMap m4 = this.map;
            Node<V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new EntryIterator(t2, f2, 0, f2, m4);
        }

        @Override
        public boolean add(ConcurrentLongObjectMap.LongEntry<V> e2) {
            return this.map.putVal(e2.getKey(), e2.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends ConcurrentLongObjectMap.LongEntry<V>> c2) {
            boolean added = false;
            for (ConcurrentLongObjectMap.LongEntry<V> e2 : c2) {
                if (!this.add(e2)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            Node<V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    h2 += p2.hashCode();
                }
            }
            return h2;
        }

        @Override
        public final boolean equals(Object o2) {
            Set c2;
            return o2 instanceof Set && ((c2 = (Set)o2) == this || this.containsAll(c2) && c2.containsAll(this));
        }

        @Override
        public Spliterator<ConcurrentLongObjectMap.LongEntry<V>> spliterator() {
            ConcurrentLongObjectHashMap m4 = this.map;
            long n2 = m4.sumCount();
            Node<V>[] t2 = m4.table;
            int f2 = m4.table == null ? 0 : t2.length;
            return new EntrySpliterator(t2, f2, 0, f2, n2 < 0L ? 0L : n2, m4);
        }

        @Override
        public void forEach(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p2 = it.advance()) != null) {
                    action2.accept(new SimpleLongEntry(p2.key, p2.val));
                }
            }
        }
    }

    static final class ValueIterator<V>
    extends BaseIterator<V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<V>[] tab, int size, int index2, int limit2, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index2, limit2, map2);
        }

        @Override
        public final V next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            Object v2 = p2.val;
            this.lastReturned = p2;
            this.advance();
            return v2;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class ForwardingNode<V>
    extends Node<V> {
        final Node<V>[] nextTable;

        ForwardingNode(Node<V>[] tab) {
            super(-1, 0L, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h2, long k2) {
            Node<V>[] tab = this.nextTable;
            block0: while (true) {
                Node<V> e2;
                int n2;
                if (tab == null || (n2 = tab.length) == 0 || (e2 = ConcurrentLongObjectHashMap.tabAt(tab, n2 - 1 & h2)) == null) {
                    return null;
                }
                do {
                    if (e2.key == k2) {
                        return e2;
                    }
                    if (e2.hash >= 0) continue;
                    if (e2 instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e2).nextTable;
                        continue block0;
                    }
                    return e2.find(h2, k2);
                } while ((e2 = e2.next) != null);
                break;
            }
            return null;
        }
    }

    private static class SimpleLongEntry<V>
    implements ConcurrentLongObjectMap.LongEntry<V> {
        private final long key;
        private final V value;

        /*
         * WARNING - void declaration
         */
        private SimpleLongEntry(long key, @NotNull V v2) {
            void value;
            if (v2 == null) {
                SimpleLongEntry.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.value = value;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public V getValue() {
            V v2 = this.value;
            if (v2 == null) {
                SimpleLongEntry.$$$reportNull$$$0(1);
            }
            return v2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/concurrency/ConcurrentLongObjectHashMap$SimpleLongEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/concurrency/ConcurrentLongObjectHashMap$SimpleLongEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    static abstract class CollectionView<V, E>
    implements Collection<E> {
        final ConcurrentLongObjectHashMap<V> map;
        private static final String OOME_MSG = "Required array size too large";

        CollectionView(ConcurrentLongObjectHashMap<V> map2) {
            this.map = map2;
        }

        public ConcurrentLongObjectHashMap<V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int n2 = (int)sz;
            Object[] r2 = new Object[n2];
            int i2 = 0;
            for (E e2 : this) {
                if (i2 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    r2 = Arrays.copyOf(r2, n2);
                }
                r2[i2++] = e2;
            }
            return i2 == n2 ? r2 : Arrays.copyOf(r2, i2);
        }

        @Override
        public final <T> T[] toArray(T[] a2) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int m4 = (int)sz;
            T[] r2 = a2.length >= m4 ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), m4);
            int n2 = r2.length;
            int i2 = 0;
            for (E e2 : this) {
                if (i2 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    r2 = Arrays.copyOf(r2, n2);
                }
                r2[i2++] = e2;
            }
            if (a2 == r2 && i2 < n2) {
                r2[i2] = null;
                return r2;
            }
            return i2 == n2 ? r2 : Arrays.copyOf(r2, i2);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e2;
                    sb.append((Object)((e2 = it.next()) == this ? "(this Collection)" : e2));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c2) {
            if (c2 != this) {
                for (Object e2 : c2) {
                    if (e2 != null && this.contains(e2)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Node<V>[] t2 = this.map.table;
            if (this.map.table == null) {
                return false;
            }
            if (c2 instanceof Set && c2.size() > t2.length) {
                Iterator<E> it = this.iterator();
                while (it.hasNext()) {
                    if (!c2.contains(it.next())) continue;
                    it.remove();
                    modified = true;
                }
            } else {
                for (Object e2 : c2) {
                    modified |= this.remove(e2);
                }
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c2.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<V>
    extends Traverser<V>
    implements Spliterator<ConcurrentLongObjectMap.LongEntry<V>> {
        final ConcurrentLongObjectHashMap<V> map;
        long est;

        EntrySpliterator(Node<V>[] tab, int size, int index2, int limit2, long est, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index2, limit2);
            this.map = map2;
            this.est = est;
        }

        @Override
        public EntrySpliterator<V> trySplit() {
            EntrySpliterator<V> entrySpliterator;
            int i2 = this.baseIndex;
            int f2 = this.baseLimit;
            int h2 = i2 + f2 >>> 1;
            if (h2 <= i2) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h2;
                EntrySpliterator<V> entrySpliterator2 = new EntrySpliterator<V>(this.tab, this.baseSize, this.baseLimit, f2, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action2) {
            Node p2;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action2.accept(new SimpleLongEntry(p2.key, p2.val));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action2.accept(new SimpleLongEntry(p2.key, p2.val));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class ValueSpliterator<V>
    extends Traverser<V>
    implements Spliterator<V> {
        long est;

        ValueSpliterator(Node<V>[] tab, int size, int index2, int limit2, long est) {
            super(tab, size, index2, limit2);
            this.est = est;
        }

        @Override
        public ValueSpliterator<V> trySplit() {
            ValueSpliterator<V> valueSpliterator;
            int i2 = this.baseIndex;
            int f2 = this.baseLimit;
            int h2 = i2 + f2 >>> 1;
            if (h2 <= i2) {
                valueSpliterator = null;
            } else {
                this.baseLimit = h2;
                ValueSpliterator<V> valueSpliterator2 = new ValueSpliterator<V>(this.tab, this.baseSize, this.baseLimit, f2, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action2) {
            Node p2;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action2.accept(p2.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action2.accept(p2.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<ConcurrentLongObjectMap.LongEntry<V>> {
        EntryIterator(Node<V>[] tab, int size, int index2, int limit2, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index2, limit2, map2);
        }

        @Override
        public final ConcurrentLongObjectMap.LongEntry<V> next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            long k2 = p2.key;
            Object v2 = p2.val;
            this.lastReturned = p2;
            this.advance();
            return new SimpleLongEntry(k2, v2);
        }
    }

    static class BaseIterator<V>
    extends Traverser<V> {
        final ConcurrentLongObjectHashMap<V> map;
        Node<V> lastReturned;

        BaseIterator(Node<V>[] tab, int size, int index2, int limit2, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index2, limit2);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p2 = this.lastReturned;
            if (p2 == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p2.key, null, null);
        }
    }

    static final class TableStack<V> {
        int length;
        int index;
        Node<V>[] tab;
        TableStack<V> next;

        TableStack() {
        }
    }
}

