/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartUpMeasurer {
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static long startTimeUnixNanoDiff = System.currentTimeMillis() * 1000000L - startTime;
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object2LongOpenHashMap<String>> pluginCostMap = new ConcurrentHashMap<String, Object2LongOpenHashMap<String>>();

    public static void stopPluginCostMeasurement() {
        measuringPluginStartupCosts = false;
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    @ApiStatus.Internal
    public static long getStartTimeUnixNanoDiff() {
        return startTimeUnixNanoDiff;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @TestOnly
    public static void disable() {
        isEnabled = false;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    public static long getCurrentTimeIfEnabled() {
        return isEnabled ? System.nanoTime() : -1L;
    }

    public static void addInstantEvent(@NonNls @NotNull String name2) {
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(0);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl activity = new ActivityImpl(name2, System.nanoTime(), null, null);
        activity.setEnd(-1L);
        items.add(activity);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name2, @NotNull ActivityCategory category) {
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        return new ActivityImpl(name2, System.nanoTime(), null, null, category);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name2) {
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return new ActivityImpl(name2, System.nanoTime(), null, null, ActivityCategory.DEFAULT);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name2, @Nullable Activity parent) {
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        return new ActivityImpl(name2, System.nanoTime(), (ActivityImpl)parent, null, ActivityCategory.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String string2) {
        void pluginId;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(6);
        }
        return StartUpMeasurer.addCompletedActivity(start, clazz, category, (String)pluginId, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, @NonNls @NotNull String name2, @Nullable Activity activity) {
        void parent;
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(7);
        }
        if (!isEnabled) {
            return;
        }
        long end = System.nanoTime();
        long duration = end - start;
        if (duration <= MEASURE_THRESHOLD) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name2, start, (ActivityImpl)parent, null, ActivityCategory.DEFAULT);
        item.setEnd(end);
        items.add(item);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l2) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(8);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = System.nanoTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NonNls @NotNull String name2, @NotNull ActivityCategory category, String string2) {
        void pluginId;
        long end;
        long duration;
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(11);
        }
        if ((duration = (end = System.nanoTime()) - start) <= MEASURE_THRESHOLD) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, name2, category, (String)pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NonNls @NotNull String name2, @NotNull ActivityCategory activityCategory, String string2) {
        void category;
        void pluginId;
        if (name2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(12);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name2, start, null, (String)pluginId, (ActivityCategory)category);
        item.setEnd(end);
        items.add(item);
    }

    @ApiStatus.Internal
    public static void processAndClear(boolean isContinueToCollect, @NotNull Consumer<? super ActivityImpl> consumer2) {
        ActivityImpl item;
        if (consumer2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        isEnabled = isContinueToCollect;
        while ((item = items.poll()) != null) {
            consumer2.accept(item);
        }
    }

    public static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(15);
        }
        if (isEnabled) {
            items.add(activity);
        }
    }

    @ApiStatus.Internal
    public static void addTimings(List<Object> timings, String parentName, long startTimeUnixNano) {
        if (!items.isEmpty()) {
            throw new IllegalStateException("addTimings must be not called if some events were already added using API");
        }
        if (timings.isEmpty()) {
            return;
        }
        ActivityImpl parent = new ActivityImpl(parentName, (Long)timings.get(1), null, null);
        parent.setEnd(System.nanoTime());
        for (int i2 = 0; i2 < timings.size(); i2 += 2) {
            long start = (Long)timings.get(i2 + 1);
            if (start < startTime) {
                startTime = start;
                startTimeUnixNanoDiff = startTimeUnixNano - start;
            }
            ActivityImpl activity = new ActivityImpl((String)timings.get(i2), start, parent, null);
            activity.setEnd(i2 == timings.size() - 2 ? parent.getEnd() : ((Long)timings.get(i2 + 3)).longValue());
            items.add(activity);
        }
        items.add(parent);
    }

    @ApiStatus.Internal
    public static void addPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time) {
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(16);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(17);
        }
        if (StartUpMeasurer.isMeasuringPluginStartupCosts()) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, time, pluginCostMap);
        }
    }

    public static boolean isMeasuringPluginStartupCosts() {
        return measuringPluginStartupCosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time, @NotNull Map<String, Object2LongOpenHashMap<String>> map2) {
        void pluginCostMap;
        Object2LongMap costPerPhaseMap;
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(18);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(19);
        }
        if (map2 == null) {
            StartUpMeasurer.$$$reportNull$$$0(20);
        }
        Object2LongMap object2LongMap = costPerPhaseMap = (Object2LongMap)pluginCostMap.computeIfAbsent(pluginId, __ -> new Object2LongOpenHashMap());
        synchronized (object2LongMap) {
            costPerPhaseMap.mergeLong(phase, time, Math::addExact);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startActivity";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedActivity";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndClear";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addActivity";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addPluginCost";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddPluginCost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Activities {
        public static final String REGISTER_COMPONENTS_SUFFIX = "component registration";
        public static final String CREATE_COMPONENTS_SUFFIX = "component creation";
        public static final String PROJECT_DUMB_POST_START_UP_ACTIVITIES = "project post-startup dumb-aware activities";
        public static final String EDITOR_RESTORING_TILL_PAINT = "editor restoring till paint";
    }
}

