/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputType
extends Key<Object> {
    public static final ProcessOutputType SYSTEM = new ProcessOutputType("system");
    public static final ProcessOutputType STDOUT = new ProcessOutputType("stdout");
    public static final ProcessOutputType STDERR = new ProcessOutputType("stderr");
    @Nullable
    private final String myEscapeSequence;
    @NotNull
    private final ProcessOutputType myStreamType;

    public ProcessOutputType(@NotNull String name2, @NotNull ProcessOutputType streamType) {
        if (name2 == null) {
            ProcessOutputType.$$$reportNull$$$0(0);
        }
        if (streamType == null) {
            ProcessOutputType.$$$reportNull$$$0(1);
        }
        super(name2);
        this.myEscapeSequence = name2;
        this.myStreamType = streamType.getBaseOutputType();
    }

    private ProcessOutputType(@NotNull String name2) {
        if (name2 == null) {
            ProcessOutputType.$$$reportNull$$$0(2);
        }
        super(name2);
        this.myEscapeSequence = null;
        this.myStreamType = this;
    }

    @NotNull
    public ProcessOutputType getBaseOutputType() {
        ProcessOutputType processOutputType = this.myStreamType;
        if (processOutputType == null) {
            ProcessOutputType.$$$reportNull$$$0(3);
        }
        return processOutputType;
    }

    public boolean isStdout() {
        return this.getBaseOutputType() == STDOUT;
    }

    public boolean isStderr() {
        return this.getBaseOutputType() == STDERR;
    }

    public static boolean isStderr(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(4);
        }
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStderr();
    }

    public static boolean isStdout(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(5);
        }
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStdout();
    }

    @Nullable
    public String getEscapeSequence() {
        return this.myEscapeSequence;
    }

    @Override
    public String toString() {
        if (this.myEscapeSequence != null) {
            return "[" + this.getBaseOutputType() + "] " + ProcessOutputType.toHumanReadableEscapeSequence(this.myEscapeSequence);
        }
        return super.toString();
    }

    @NotNull
    private static String toHumanReadableEscapeSequence(@NotNull String escapeSequence) {
        if (escapeSequence == null) {
            ProcessOutputType.$$$reportNull$$$0(6);
        }
        String string2 = escapeSequence.replace("\u001b", "ESC").replace("\u0007", "BEL").replace("\n", "\\n").replace("\r", "\\r").replace("\b", "\\b");
        if (string2 == null) {
            ProcessOutputType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Nullable
    public static ProcessOutputType tryCast(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(8);
        }
        return key instanceof ProcessOutputType ? (ProcessOutputType)key : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessOutputType";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapeSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessOutputType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseOutputType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toHumanReadableEscapeSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStderr";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStdout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toHumanReadableEscapeSequence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

